#include <GUIConstantsEx.au3>
#include <MsgBoxConstants.au3>
#include <StaticConstants.au3>
#include <TreeViewConstants.au3>
#include <WindowsStylesConstants.au3>

Example()

Func Example()
	GUICreate("My GUI with treeview", 350, 215)

	Local $idTreeview = GUICtrlCreateTreeView(6, 6, 100, 150, BitOR($TVS_HASBUTTONS, $TVS_HASLINES, $TVS_LINESATROOT, $TVS_DISABLEDRAGDROP, $TVS_SHOWSELALWAYS), $WS_EX_CLIENTEDGE)
	Local $idTVi_General = GUICtrlCreateTreeViewItem("General", $idTreeview)
	GUICtrlSetColor(-1, 0x0000C0)
	Local $idTVi_Display = GUICtrlCreateTreeViewItem("Display", $idTreeview)
	GUICtrlSetColor(-1, 0x0000C0)
	Local $idTVi_About = GUICtrlCreateTreeViewItem("About", $idTVi_General)
	Local $idTVi_Comp = GUICtrlCreateTreeViewItem("Computer", $idTVi_General)
	GUICtrlCreateTreeViewItem("User", $idTVi_General)
	GUICtrlCreateTreeViewItem("Resolution", $idTVi_Display)
	GUICtrlCreateTreeViewItem("Other", $idTVi_Display)

	Local $idLbl_Start = GUICtrlCreateLabel("TreeView Demo", 190, 90, 100, 20)
	Local $idLbl_About = GUICtrlCreateLabel("This little scripts demonstates the using of a treeview-control.", 190, 70, 100, 60)
	GUICtrlSetState(-1, $GUI_HIDE) ; Hides the "aboutlabel"-text during initialization
	Local $idLbl_Compinfo = GUICtrlCreateLabel("Name:" & @TAB & @ComputerName & @CRLF & "OS:" & @TAB & @OSVersion & @CRLF & "SP:" & @TAB & @OSServicePack, 120, 30, 200, 80)
	GUICtrlSetState(-1, $GUI_HIDE) ; Hides the "compinfo"-text during initialization

	GUICtrlCreateLabel("", 0, 170, 350, 2, $SS_SUNKEN)
	Local $idBtn_Toggle = GUICtrlCreateButton("&Toggle", 35, 185, 70, 20)
	Local $idBtn_Info = GUICtrlCreateButton("&Info", 105, 185, 70, 20)
	Local $idBtn_State = GUICtrlCreateButton("Col./Exp.", 175, 185, 70, 20)
	Local $idBtn_Cancel = GUICtrlCreateButton("&Cancel", 245, 185, 70, 20)

	GUICtrlSetState($idTVi_General, BitOR($GUI_EXPAND, $GUI_DEFBUTTON)) ; Expand the "General"-item and paint in bold
	GUICtrlSetState($idTVi_Display, BitOR($GUI_EXPAND, $GUI_DEFBUTTON)) ; Expand the "Display"-item and paint in bold

	GUISetState(@SW_SHOW)

	Local $idMsg, $idItem, $hItem, $sText
	; Loop until the user exits.
	While 1
		$idMsg = GUIGetMsg()
		Select
			Case $idMsg = $idBtn_Cancel Or $idMsg = $GUI_EVENT_CLOSE
				ExitLoop

			Case $idMsg = $idBtn_Toggle ; Toggle the bold painting
				If BitAND(GUICtrlRead($idTVi_General), $GUI_DEFBUTTON) Then
					GUICtrlSetState($idTVi_General, 0)
					GUICtrlSetState($idTVi_Display, 0)
				Else
					GUICtrlSetState($idTVi_General, $GUI_DEFBUTTON)
					GUICtrlSetState($idTVi_Display, $GUI_DEFBUTTON)
				EndIf

			Case $idMsg = $idBtn_Info
				$idItem = GUICtrlRead($idTreeview) ; Get the controlID of the current selected treeview item
				If $idItem = 0 Then
					MsgBox($MB_SYSTEMMODAL, "TreeView Demo", "No item currently selected")
				Else
					$sText = GUICtrlRead($idItem, 1) ; Get the text of the treeview item
					If $sText == "" Then
						MsgBox($MB_SYSTEMMODAL, "Error", "Error while retrieving infos about item")
					Else
						MsgBox($MB_SYSTEMMODAL, "TreeView Demo", "Current item selected is: " & $sText)
					EndIf
				EndIf

			Case $idMsg = $idBtn_State
				$idItem = GUICtrlRead($idTreeview)
				If $idItem > 0 Then
					$hItem = GUICtrlGetHandle($idItem)
					GUICtrlSendMsg($idTreeview, $TVM_EXPAND, $TVE_TOGGLE, $hItem)
				EndIf

				; The following items will hide the other labels (1st and 2nd parameter) and then show the 'own' labels (3rd and 4th parameter)
			Case $idMsg = $idTVi_General
				GUIChangeItems($idLbl_About, $idLbl_Compinfo, $idLbl_Start, $idLbl_Start)

			Case $idMsg = $idTVi_About
				GUICtrlSetState($idLbl_Compinfo, $GUI_HIDE)
				GUIChangeItems($idLbl_Start, $idLbl_Start, $idLbl_About, $idLbl_About)

			Case $idMsg = $idTVi_Comp
				GUIChangeItems($idLbl_Start, $idLbl_About, $idLbl_Compinfo, $idLbl_Compinfo)
		EndSelect
	WEnd

	GUIDelete()
EndFunc   ;==>Example

Func GUIChangeItems($idHidestart, $idHideend, $idShowstart, $idShowend)
	Local $idX

	For $idX = $idHidestart To $idHideend
		GUICtrlSetState($idX, $GUI_HIDE)
	Next
	For $idX = $idShowstart To $idShowend
		GUICtrlSetState($idX, $GUI_SHOW)
	Next
EndFunc   ;==>GUIChangeItems
