#include <GUIConstantsEx.au3>
#include <GuiImageList.au3>
#include <GuiListView.au3>

Example()

Func Example()
	Local $idListview, $hImage

	GUICreate("ImageList AddMasked", 400, 300)
	$idListview = GUICtrlCreateListView("", 2, 2, 394, 268, BitOR($LVS_SHOWSELALWAYS, $LVS_NOSORTHEADER, $LVS_REPORT))
	GUISetState(@SW_SHOW)

	; Load images
	$hImage = _GUIImageList_Create(11, 11)
	_GUIImageList_AddMasked($hImage, _GUICtrlListView_CreateSolidBitMap($idListview, 0xFF0000, 11, 11))
	_GUIImageList_AddMasked($hImage, _GUICtrlListView_CreateSolidBitMap($idListview, 0x00FF00, 11, 11))
	_GUIImageList_AddMasked($hImage, _GUICtrlListView_CreateSolidBitMap($idListview, 0x0000FF, 11, 11))
	_GUICtrlListView_SetImageList($idListview, $hImage, 1)

	; Add columns
	_GUICtrlListView_AddColumn($idListview, "Items", 120)

	; Add items
	_GUICtrlListView_AddItem($idListview, "Item 1", 0)
	_GUICtrlListView_AddItem($idListview, "Item 2", 1)
	_GUICtrlListView_AddItem($idListview, "Item 3", 2)

	; Loop until the user exits.
	Do
	Until GUIGetMsg() = $GUI_EVENT_CLOSE
	GUIDelete()
EndFunc   ;==>Example
