#include <AutoItConstants.au3>
#include <MsgBoxConstants.au3>

Example()

Func Example()
	; Run Notepad
	Run("notepad.exe")

	Local $hWnd = WinWaitActive("[CLASS:Notepad]", "")

	; Retrieve the state of the Notepad window using the handle returned by WinWaitActive.
	Local $iState = WinGetState($hWnd)

	; Check if the Notepad window is minimized and display the appropriate message box.
	If BitAND($iState, $WIN_STATE_MINIMIZED) Then
		MsgBox($MB_SYSTEMMODAL, "", "Notepad is minimized and the state returned by WinGetState was - " & $iState)
	Else
		MsgBox($MB_SYSTEMMODAL, "", "Notepad isn't minimized and the state returned by WinGetState was - " & $iState)
	EndIf

	; Close the Notepad window using the handle returned by WinWaitActive.
	WinClose($hWnd)
EndFunc   ;==>Example
