#include <Array.au3>
#include <MsgBoxConstants.au3>
#include <WinAPISysWin.au3>

Example()

Func Example()
	Local $aWindows = _WinAPI_EnumWindowsTop()

	Local $aResult[$aWindows[0][0] + 1][5]
	For $i = 1 To $aWindows[0][0]
		$aResult[$i][0] = $aWindows[$i][0]
		$aResult[$i][1] = $aWindows[$i][1]
		$aResult[$i][2] = WinGetTitle($aWindows[$i][0])
		$aResult[$i][3] = ExtractFirstNonBlankLine(WinGetText($aWindows[$i][0]))
		$aResult[$i][4] = WinGetProcess($aWindows[$i][0])
	Next

	_ArrayDisplay($aResult, "_WinAPI_EnumWindowsTop() - v" & @AutoItVersion, "1:", Default, Default, "Handle|Windows Class                                               |Windows Title                                                         |Windows Text |Process ID")
EndFunc   ;==>Example

Func ExtractFirstNonBlankLine($sText)
	Local $aText = StringSplit($sText, @LF)

	For $i = 1 To $aText[0]
		If $aText[$i] Then Return $aText[$i]
	Next

	Return ""
EndFunc   ;==>ExtractFirstNonBlankLine
