#include <Constants.au3>

;
; AutoIt Version: 3.0
; Language:       English
; Platform:       Win9x/NT
; Author:         Jonathan Bennett (jon at autoitscript dot com)
; Modified:       mLipok
;
; Script Function:
;   Opens Notepad, types in some text and then quits.
;   The text typed shows two ways of Sending special
;   characters
;

_Example()
Exit
; Finished!

Func _Example()
	; Prompt the user to run the script - use a Yes/No prompt with the flag parameter set at 4 (see the help file for more details)
	Local $iAnswer = MsgBox(BitOR($MB_YESNO, $MB_SYSTEMMODAL), "AutoIt Example (English Only)", "This script will run Notepad type in some text and then quit.  Do you want to run it?")

	; Check the user's answer to the prompt (see the help file for MsgBox return values)
	; If "No" was clicked ($IDNO = 7) then exit the example function
	If $iAnswer = $IDNO Then
		MsgBox($MB_SYSTEMMODAL, "AutoIt", "OK.  Bye!")
		Return
	EndIf

	; Run Notepad
	Run("notepad.exe")

	; Wait for the Notepad to become active. The classname "Notepad" is monitored instead of the window title
	WinWaitActive("[CLASS:Notepad]")

	; Now that the Notepad window is active type some special characters
	Send("Sending some special characters:{ENTER 2}")

	; Do it the first way
	Send("First way: ")
	Send("{!}{^}{+}{#}")
	Send("{ENTER}")

	; Do it the second way (RAW mode, notice the second parameter of Send is 1)
	Send("Second way: ")
	Send("!^+#", 1)

	Send("{ENTER}{ENTER}Finished")

EndFunc   ;==>_Example
