Global $g_sFileVersion = "2.1.0.4"

#cs ----------------------------------------------------------------------------
	 AutoIt Version: 3.3.18.0
	 Author:         YDY (Lazycat)
	 Modified:       Jon, Jpm, Wakillon
	 Script Function:
	    Show all icons in the given file
#ce ----------------------------------------------------------------------------

#Region ### Version History
#cs ----------------------------------------------------------------------------
	 Version History
	 	2.1.0.4 (2025/10/25)
	        Updated: simplification by wakillon
	    2.1.0.0 (2021/12/06)
	        Added: Scrollbar and optimisation of by name
	    2.0.1.0 (2007/11/14)
	        Updated: simplification by Jon
	    2.0.0.0 (2007/08/02)
	        Updated:  use DllCallback.au3
	    1.0.0.0 (2006/06/20)
	        Added: Initial version
#ce ----------------------------------------------------------------------------
#EndRegion ### Version History

#Region    ;************ Includes ************
#include <ButtonConstants.au3>
#include <GUIConstantsEx.au3>
#include <StaticConstants.au3>
#include <WinAPIGdi.au3>
#include <WinAPIRes.au3>
#include <WinAPIShellEx.au3>
#include <WinAPITheme.au3>
#include <WindowsStylesConstants.au3>
#EndRegion ;************ Includes ************

#Region ------ Global Variables ------------------------------
Global $g_sGuiTitle = 'Icon Selector by Name value - v' & $g_sFileVersion
Global $g_aidRdo_Icons[30], $g_aidLabels[30], $g_aIconsNames
Global $g_hGui, $g_idBtn_Prev, $g_idBtn_Next, $g_idBtn_FileSelect, $g_idBtn_Toggle, $g_idCbo_Dll
Global $g_idLbl_IconsCount, $g_idLbl_Path, $g_idCbo_IconSize, $g_idChk_BkColor
Global $g_sFilePath = @SystemDir & '\shell32.dll'
Global $g_iStartIndex = 1, $g_bOrdinal = True, $g_iIconsCount
#EndRegion ------ Global Variables ------------------------------

_GuiCreate()

#Region ------ Main Loop ------------------------------
Local $aCtrl ;, $aCtrlPos
Local $iMsg, $sNewFilePath, $sDefaultName, $sFullSavePath, $iDefaultSize, $sDefaultIndex
While 1
	$iMsg = GUIGetMsg()
	Switch $iMsg
		Case $g_idBtn_FileSelect
			$sNewFilePath = FileOpenDialog('Select file:', @WorkingDir, 'File (*.exe;*.dll;*.ocx;*.icl;*.ico)', 0, '', $g_hGui)
			If @error Then ContinueLoop
			If $sNewFilePath <> $g_sFilePath Then
				$g_iStartIndex = 1
				$g_sFilePath = $sNewFilePath
				GUICtrlSetData($g_idLbl_Path, _WinAPI_PathCompactPath($g_hGui, $g_sFilePath, 440))
				$g_iIconsCount = _IconsGetCount($g_sFilePath)
				GUICtrlSetData($g_idLbl_IconsCount, $g_iIconsCount)
				If $g_iIconsCount < UBound($g_aidRdo_Icons) + 1 Then
					GUICtrlSetState($g_idBtn_Next, $GUI_DISABLE)
					GUICtrlSetState($g_idBtn_Prev, $GUI_DISABLE)
				Else
					GUICtrlSetState($g_idBtn_Next, $GUI_ENABLE)
				EndIf
				$g_aIconsNames = _WinAPI_EnumResourceNames($g_sFilePath, $RT_GROUP_ICON)
				_GuiUpdate()
			EndIf
		Case $g_idBtn_Prev
			$g_iStartIndex -= UBound($g_aidRdo_Icons)
			_GuiUpdate()
		Case $g_idBtn_Next
			$g_iStartIndex += UBound($g_aidRdo_Icons)
			_GuiUpdate()
		Case $g_idBtn_Toggle
			If $g_bOrdinal = False Then
				$g_bOrdinal = True
				GUICtrlSetData($g_idBtn_Toggle, 'by Name')
				WinSetTitle($g_hGui, "", "Icon Selector by Name value - v" & $g_sFileVersion)
				If $g_iStartIndex > $g_iIconsCount Then $g_iStartIndex = 1
			Else
				$g_bOrdinal = False
				GUICtrlSetData($g_idBtn_Toggle, 'by Ordinal')
				WinSetTitle($g_hGui, "", "Icon Selector by Ordinal value - v" & $g_sFileVersion)
				If $g_iStartIndex > $g_iIconsCount Then $g_iStartIndex = 1
			EndIf
			_GuiUpdate()
		Case $g_idCbo_Dll
			$sNewFilePath = @SystemDir & '\' & GUICtrlRead($g_idCbo_Dll)
			If $sNewFilePath <> $g_sFilePath Then
				$g_iStartIndex = 1
				$g_sFilePath = $sNewFilePath
				GUICtrlSetData($g_idLbl_Path, _WinAPI_PathCompactPath($g_hGui, $g_sFilePath, 440))
				$g_iIconsCount = _IconsGetCount($g_sFilePath)
				GUICtrlSetData($g_idLbl_IconsCount, $g_iIconsCount)
				If $g_iIconsCount < 31 Then
					GUICtrlSetState($g_idBtn_Next, $GUI_DISABLE)
					GUICtrlSetState($g_idBtn_Prev, $GUI_DISABLE)
				Else
					GUICtrlSetState($g_idBtn_Next, $GUI_ENABLE)
				EndIf
				$g_aIconsNames = _WinAPI_EnumResourceNames($g_sFilePath, $RT_GROUP_ICON)
				_GuiUpdate()
			EndIf
		Case $GUI_EVENT_DROPPED
			$sNewFilePath = @GUI_DragFile
			If $sNewFilePath <> $g_sFilePath Then
				$g_iStartIndex = 1
				$g_sFilePath = $sNewFilePath
				GUICtrlSetData($g_idLbl_Path, _WinAPI_PathCompactPath($g_hGui, $g_sFilePath, 440))
				$g_iIconsCount = _IconsGetCount($g_sFilePath)
				GUICtrlSetData($g_idLbl_IconsCount, $g_iIconsCount)
				If $g_iIconsCount < UBound($g_aidRdo_Icons) + 1 Then
					GUICtrlSetState($g_idBtn_Next, $GUI_DISABLE)
					GUICtrlSetState($g_idBtn_Prev, $GUI_DISABLE)
				Else
					GUICtrlSetState($g_idBtn_Next, $GUI_ENABLE)
				EndIf
				$g_aIconsNames = _WinAPI_EnumResourceNames($g_sFilePath, $RT_GROUP_ICON)
				_GuiUpdate()
			EndIf
		Case $GUI_EVENT_CLOSE
			Exit
		Case $g_aidRdo_Icons[0] To $g_aidRdo_Icons[29] + 1
			$aCtrl = GUIGetCursorInfo($g_hGui)
			If Not @error Then
				If Mod($aCtrl[4], 2) Then
					$aCtrl[4] = $aCtrl[4] - 1
					GUICtrlSetState($aCtrl[4], $GUI_CHECKED)
				EndIf
				$iDefaultSize = GUICtrlRead($g_idCbo_IconSize)
;~                 $aCtrlPos = ControlGetPos($g_hGui, '', $aCtrl[4]) ; jpm
;~ 				Sleep(500)
				$sDefaultName = StringReplace(_FileGetName($g_sFilePath), '.', '')
				$sDefaultIndex = $g_iStartIndex + ($aCtrl[4] / 2) - 6
				If $g_bOrdinal = True Then
					$sDefaultName &= '.' & StringFormat('%04i', StringReplace($sDefaultIndex, '"', '')) & '-' & $iDefaultSize & 'x' & $iDefaultSize & '.ico'
				Else
					If IsNumber($g_aIconsNames[$sDefaultIndex]) Then
						$sDefaultName &= '.' & StringFormat('%04i', $g_aIconsNames[$sDefaultIndex]) & '-' & $iDefaultSize & 'x' & $iDefaultSize & '.ico'
					Else
						$sDefaultName &= '.' & StringReplace($g_aIconsNames[$sDefaultIndex], '"', '') & '-' & $iDefaultSize & 'x' & $iDefaultSize & '.ico'
					EndIf
				EndIf
				$sFullSavePath = FileSaveDialog('Save Icon', @WorkingDir, '(*.ico)', 2 + 16, $sDefaultName, $g_hGui)
				If Not @error Then
					_IconSaveFromFile($g_sFilePath, $sDefaultIndex - 2, $sFullSavePath, $iDefaultSize)
					If @error Then MsgBox(262144 + 16, 'Error _IconSaveFromFile', 'Sorry an error ' & @error & ' occurred when saving icon', 5)
				EndIf
				GUICtrlSetState($aCtrl[4], $GUI_UNCHECKED)
			EndIf
		Case $g_idChk_BkColor
			If BitAND(GUICtrlRead($g_idChk_BkColor), $GUI_CHECKED) = $GUI_CHECKED Then
				_WinAPI_SetThemeAppProperties($STAP_ALLOW_NONCLIENT)
			Else
				_WinAPI_SetThemeAppProperties($STAP_ALLOW_CONTROLS)
			EndIf
			For $i = 0 To UBound($g_aidRdo_Icons) - 1
				GUICtrlSendMsg($g_aidRdo_Icons[$i], $WM_THEMECHANGED, 0, 0)
			Next
	EndSwitch
	Sleep(10)
WEnd
#EndRegion ------ Main Loop ------------------------------

Func _FileGetName($sFilePath)
	Local $aFileName = StringSplit($sFilePath, '\')
	If Not @error Then Return $aFileName[$aFileName[0]]
	Return $sFilePath
EndFunc   ;==>_FileGetName

Func _GuiCreate()
	$g_hGui = GUICreate($g_sGuiTitle, 395, 465, @DesktopWidth / 2 - 192, @DesktopHeight / 2 - 235, $GUI_SS_DEFAULT_GUI, $WS_EX_ACCEPTFILES)
	GUICtrlCreateGroup('', 5, 1, 240, 40)
	$g_idCbo_Dll = GUICtrlCreateCombo('shell32.dll', 12, 14, 112, 16)
	Local $sDllString = 'user32.dll|imageres.dll|netshell.dll|wmploc.dll|ddores.dll|mmcndmgr.dll|moricons.dll|ieframe.dll|compstui.dll|' & _
			'setupapi.dll|synccenter.dll|pifmgr.dll|dsuiext.dll|msihnd.dll|stobject.dll|rasgcw.dll|msctf.dll|mshtml.dll|msutb.dll|cryptui.dll|' & _
			'wiashext.dll|twinui.dll|rasdlg.dll|accessibilitycpl.dll|wpdshext.dll|sensorscpl.dll|ipsmsnap.dll|networkexplorer.dll|comres.dll|' & _
			'comdlg32.dll'
	Local $aDllString = StringSplit($sDllString, '|')
	For $i = 1 To UBound($aDllString) - 1
		If Not FileExists(@SystemDir & '\' & $aDllString[$i]) Then $sDllString = StringReplace($sDllString, $aDllString[$i], '') ; remove dll not existing
	Next
	GUICtrlSetData($g_idCbo_Dll, $sDllString, 'shell32.dll')
	$g_iIconsCount = _IconsGetCount($g_sFilePath)
	GUICtrlCreateLabel('NbIcons', 130, 19, 50, 16)
	$g_idLbl_IconsCount = GUICtrlCreateLabel($g_iIconsCount, 180, 19, 50, 16)
	GUICtrlSetColor(-1, 0xFF0000)
	GUICtrlSetState(-1, $GUI_DROPACCEPTED)
	$g_idBtn_FileSelect = GUICtrlCreateButton('...', 205, 12, 36, 24)
	GUICtrlSetFont(-1, 14)
	GUICtrlSetTip(-1, 'or Click for Select ', 'Drag a file', 1, 1)

	GUICtrlCreateGroup('', 250, 1, 140, 40)
	GUICtrlCreateLabel('Size', 255, 18, 25, 16)
	$g_idCbo_IconSize = GUICtrlCreateCombo('32', 280, 14, 43, 16)
	GUICtrlSetData($g_idCbo_IconSize, '16|32|48|64|128', '32')
	GUICtrlSetTip(-1, 'when saving icon', 'Size used', 1, 1)
	$g_idChk_BkColor = GUICtrlCreateCheckbox('BkColor', 330, 18, 58, 16)
	GUICtrlSetTip(-1, 'Background Color', "Change Icon's", 1, 1)

	GUICtrlCreateGroup('', 5, 50, 385, 380)
	$g_idBtn_Prev = GUICtrlCreateButton('Previous', 10, 45, 60, 24, $BS_FLAT)
	GUICtrlSetState(-1, $GUI_DISABLE)
	$g_idBtn_Next = GUICtrlCreateButton('Next', 75, 45, 60, 24, $BS_FLAT)
	$g_idBtn_Toggle = GUICtrlCreateButton('by Name', 300, 45, 60, 24, $BS_FLAT)
	Local $iCurrentIndex, $iRowCount, $iColomnCount
	$g_aIconsNames = _WinAPI_EnumResourceNames($g_sFilePath, $RT_GROUP_ICON)
	For $iRowCount = 0 To 4
		For $iColomnCount = 0 To 5
			$iCurrentIndex = $iRowCount * 6 + $iColomnCount
			$g_aidRdo_Icons[$iCurrentIndex] = GUICtrlCreateRadio('', 60 * $iColomnCount + 25, 70 * $iRowCount + 80, 48, 48, BitOR($BS_ICON, $BS_PUSHLIKE, $BS_FLAT, $BS_CENTER))
			GUICtrlSetImage(-1, $g_sFilePath, -($iCurrentIndex + 1), 1)
			$g_aidLabels[$iCurrentIndex] = GUICtrlCreateLabel(-($iCurrentIndex + 1), 60 * $iColomnCount + 17, 70 * $iRowCount + 129, 60, 16, $SS_CENTER)
		Next
	Next

	GUICtrlCreateGroup('', 5, 430, 385, 30)
	$g_idLbl_Path = GUICtrlCreateLabel($g_sFilePath, 10, 440, 375, 16)
	GUICtrlSetColor(-1, 0x0094FF)
	GUISetState()
EndFunc   ;==>_GuiCreate

Func _GuiUpdate()
	GUISetState(@SW_DISABLE, $g_hGui)
	If $g_iIconsCount - $g_iStartIndex < UBound($g_aidRdo_Icons) Then
		GUICtrlSetState($g_idBtn_Next, $GUI_DISABLE)
		For $i = UBound($g_aidRdo_Icons) - 1 To $g_iIconsCount - $g_iStartIndex Step -1
			If $i < 0 Then ExitLoop
			GUICtrlSetState($g_aidRdo_Icons[$i], $GUI_HIDE)
			GUICtrlSetState($g_aidRdo_Icons[$i], $GUI_DISABLE)
			GUICtrlSetData($g_aidLabels[$i], '')
			GUICtrlSetState($g_aidLabels[$i], $GUI_DISABLE)
		Next
	Else
		GUICtrlSetState($g_idBtn_Next, $GUI_ENABLE)
	EndIf
	If $g_iIconsCount Then
		Local $j = 0
		For $i = $g_iStartIndex To $g_iStartIndex + UBound($g_aidRdo_Icons) - 1
			GUICtrlSetState($g_aidRdo_Icons[$j], $GUI_SHOW)
			GUICtrlSetState($g_aidRdo_Icons[$j], $GUI_ENABLE)
			GUICtrlSetImage($g_aidRdo_Icons[$j], $g_sFilePath, -$i)
			If Not $g_bOrdinal Then
				If IsNumber($g_aIconsNames[$g_iStartIndex + $j]) Then
					GUICtrlSetFont($g_aidLabels[$j], 8.5)
					GUICtrlSetTip($g_aidLabels[$j], '')
				Else
					If StringLen($g_aIconsNames[$g_iStartIndex + $j]) > 1 Then
						GUICtrlSetFont($g_aidLabels[$j], 6)
						GUICtrlSetTip($g_aidLabels[$j], $g_aIconsNames[$g_iStartIndex + $j], 'Icon Name', 1, 1)
					EndIf
				EndIf
				GUICtrlSetData($g_aidLabels[$j], '"' & $g_aIconsNames[$g_iStartIndex + $j] & '"')
				GUICtrlSetState($g_aidLabels[$j], $GUI_ENABLE)
			Else
				GUICtrlSetData($g_aidLabels[$j], -($g_iStartIndex + $j))
				GUICtrlSetFont($g_aidLabels[$j], 8.5)
				GUICtrlSetTip($g_aidLabels[$j], '')
				GUICtrlSetState($g_aidLabels[$j], $GUI_ENABLE)
			EndIf
			$j += 1
			If $j > $g_iIconsCount - $g_iStartIndex Then ExitLoop
		Next
	EndIf
	If $g_iStartIndex = 1 Then
		GUICtrlSetState($g_idBtn_Prev, $GUI_DISABLE)
	Else
		GUICtrlSetState($g_idBtn_Prev, $GUI_ENABLE)
	EndIf
	GUISetState(@SW_ENABLE, $g_hGui)
EndFunc   ;==>_GuiUpdate

Func _IconSaveFromFile($sPath, $iIndex, $sIconSavePath, $iIconSize = 32)
	Local $iTotal = _WinAPI_ExtractIconEx($sPath, -1, 0, 0, 0)
	If @error Or Abs($iIndex + 1) > $iTotal Then Return SetError(1)
	$iIndex = Abs($iIndex + 1)
	Local $hIco = _WinAPI_ShellExtractIcon($sPath, $iIndex, $iIconSize, $iIconSize)
	If @error Or Not $hIco Then Return SetError(2)
	Local $hIcon = _WinAPI_Create32BitHICON($hIco, False)
	If @error Then Return SetError(3)
	_WinAPI_SaveHICONToFile($sIconSavePath, $hIcon, 0, 0, -1)
	If @error Then Return SetError(4)
	If $hIco Then _WinAPI_DestroyIcon($hIco)
	If $hIcon Then _WinAPI_DestroyIcon($hIcon)
	Return FileExists($sIconSavePath)
EndFunc   ;==>_IconSaveFromFile

Func _IconsGetCount($sFilePath)
	Local $aRet = DllCall('shell32.dll', 'uint', 'ExtractIconExW', 'wstr', $sFilePath, 'int', -1, 'struct*', 0, 'struct*', 0, 'uint', 0)
	If @error Then Return SetError(@error, @extended, 0)
	Local $hIcoTest
	; Remove empty icons (or false icons) from count
	For $i = -$aRet[0] To -1 Step 1
		$hIcoTest = _WinAPI_ShellExtractIcon($sFilePath, Abs($i + 1), 32, 32)
		If @error Or Not $hIcoTest Then $aRet[0] -= 1
		If $hIcoTest Then _WinAPI_DestroyIcon($hIcoTest)
	Next
	Return $aRet[0]
EndFunc   ;==>_IconsGetCount
