#include "Extras\HelpFileInternals.au3"

#include <GUIConstantsEx.au3>
#include <GuiDateTimePicker.au3>

Global $g_aRange[14] = [True, @YEAR, 1, 1, 21, 45, 32, True, @YEAR, 12, 31, 23, 59, 59]

Example()

Func Example()
	; Create GUI
	GUICreate("DateTimePick Get/Set Range (v" & @AutoItVersion & ")", 400, 300)
	Local $hDTP = GUICtrlGetHandle(GUICtrlCreateDate("", 2, 6, 190))
	_MemoCreate(2, 32, 396, 266, 0)
	GUISetState(@SW_SHOW)

	; Set the display format
	_GUICtrlDTP_SetFormat($hDTP, "ddd MMM dd, yyyy hh:mm ttt")

	; Set date range
	_GUICtrlDTP_SetRange($hDTP, $g_aRange)

	; Display date range
	$g_aRange = _GUICtrlDTP_GetRange($hDTP)
	_MemoWrite("Minimum date: " & GetDateStr(0))
	_MemoWrite("Maximum date: " & GetDateStr(7))
	_MemoWrite("Minimum time: " & GetTimeStr(4))
	_MemoWrite("Maximum time: " & GetTimeStr(11))

	; Loop until the user exits.
	Do
	Until GUIGetMsg() = $GUI_EVENT_CLOSE
	GUIDelete()
EndFunc   ;==>Example

; Returns the date portion
Func GetDateStr($iOff = 0)
	Return StringFormat("%02d/%02d/%04d", $g_aRange[$iOff + 2], $g_aRange[$iOff + 3], $g_aRange[$iOff + 1])
EndFunc   ;==>GetDateStr

; Returns the time portion
Func GetTimeStr($iOff = 0)
	Return StringFormat("%02d:%02d:%02d", $g_aRange[$iOff], $g_aRange[$iOff + 1], $g_aRange[$iOff + 2])
EndFunc   ;==>GetTimeStr
