#include <WinAPIMem.au3>
#include <WinAPISys.au3>

; Create compressed and uncompressed buffers
Local $a_pBuffer[2]
For $i = 0 To 1
	$a_pBuffer[$i] = _WinAPI_CreateBuffer(1024)
Next

Local $iCompressFormat = $COMPRESSION_FORMAT_XPRESS_HUFF
;~ Local $iCompressFormat = $COMPRESSION_FORMAT_XPRESS
;~ Local $iCompressFormat = $COMPRESSION_FORMAT_LZNT1

; Compress binary data
Local $dData = Binary('0x00112233445566778899AABBCCDDEEFF00112233445566778899AABBCCDDEEFF00112233445566778899AABBCCDDEEFF00112233445566778899AABBCCDDEEFF')

If $iCompressFormat = $COMPRESSION_FORMAT_XPRESS_HUFF Then
	$dData &= $dData ;XPRESS_HUFF looks to struggle with short data
	$dData &= $dData
	$dData &= $dData
	$dData &= $dData
EndIf

Local $iSize = BinaryLen($dData)
DllStructSetData(DllStructCreate('byte[' & $iSize & ']', $a_pBuffer[0]), 1, $dData)
ConsoleWrite('Initial:      $iSize = ' & $iSize & @CRLF)

$iSize = _WinAPI_CompressBuffer($a_pBuffer[0], $iSize, $a_pBuffer[1], 1024, BitOR($iCompressFormat, $COMPRESSION_ENGINE_MAXIMUM))
If Not @error Then
	ConsoleWrite('Compressed:   $iSize = ' & $iSize & ' : ' & DllStructGetData(DllStructCreate('byte[' & $iSize & ']', $a_pBuffer[1]), 1) & @CRLF)
Else
	ConsoleWrite('Uncompressed: $iSize = ' & $iSize & ' : ' & ' Error code: ' & @error & '    Extended code: ' & @extended & ' (0x' & Hex(@extended) & ')' & @CRLF)
EndIf

; Decompress data
$iSize = _WinAPI_DecompressBuffer($a_pBuffer[0], 1024, $a_pBuffer[1], $iSize, BitOR($iCompressFormat, $COMPRESSION_ENGINE_MAXIMUM))
If Not @error Then
	ConsoleWrite('Uncompressed: $iSize = ' & $iSize & ' : ' & DllStructGetData(DllStructCreate('byte[' & $iSize & ']', $a_pBuffer[0]), 1) & @CRLF)
Else
	ConsoleWrite('Uncompressed: $iSize = ' & $iSize & ' : ' & ' Error code: ' & @error & '    Extended code: ' & @extended & ' (0x' & Hex(@extended) & ')' & @CRLF)
EndIf

; Free memory
For $i = 0 To 1
	_WinAPI_FreeMemory($a_pBuffer[$i])
Next
