#include <GuiListView.au3>
#include <WinAPICom.au3>
#include <WinAPIProc.au3>
#include <WinAPIShellEx.au3>

_Example()

Func _Example()
	_WinAPI_CoInitialize()

	Local $iStylesEx = BitOR($LVS_EX_GRIDLINES, $LVS_EX_FULLROWSELECT, $LVS_EX_SUBITEMIMAGES)

	Local $hGUI = GUICreate("test", 500, 500)
	Local $idListView = _GUICtrlListView_Create($hGUI, "Process Name|PID", 0, 0, 500, 500, BitOR($LVS_SHOWSELALWAYS, $LVS_NOSORTHEADER, $LVS_REPORT))
	_GUICtrlListView_SetExtendedListViewStyle($idListView, $iStylesEx)
	GUISetState(@SW_SHOW)

	Local $aProcess = ProcessList()
	Local $hImage = GetSystemImageList()
	_GUICtrlListView_SetImageList($idListView, $hImage, 1)

	;create an image list to pick images from, fill none icon images with an icon from some where else to make shure the images in the image list match the processlist, or images will be wrongly asignet(srry my english xD)
	Local $sProcessFileName, $iImage
	For $i = 0 To $aProcess[0][0]
		$sProcessFileName = _WinAPI_GetProcessFileName($aProcess[$i][1])
		$iImage = GetIconIndex($sProcessFileName)

		; if exe does not have an icon extract an icon from shell32 or some where else
		; if $iImage = -1 then  _GUIImageList_AddIcon($hImage, @SystemDir & "\shell32.dll", 0);using 0 but  2 is exe icon probably not the right one, you will need to correct this one
		_GUICtrlListView_AddItem($idListView, $aProcess[$i][0], $iImage) ; add items and pick the image position (in $hImage) to show for the exe with $i
		_GUICtrlListView_AddSubItem($idListView, $i, $aProcess[$i][1], 1)
	Next

	GUISetState()
	While 1
		Switch GUIGetMsg()
			Case -3
				Exit
		EndSwitch
	WEnd

	_WinAPI_CoUninitialize()

EndFunc   ;==>_Example

Func GetSystemImageList($bLargeIcons = False)
	Local $tSHFILEINFO = DllStructCreate($tagSHFILEINFO)
	Local $iFlags = BitOR($SHGFI_USEFILEATTRIBUTES, $SHGFI_SYSICONINDEX)
	If Not $bLargeIcons Then $iFlags = BitOR($iFlags, $SHGFI_SMALLICON)
	Local $hImageList = _WinAPI_ShellGetFileInfo(".txt", $iFlags, $FILE_ATTRIBUTE_NORMAL, $tSHFILEINFO)
	If @error Then Return SetError(@error, 0, 0)
	Return $hImageList
EndFunc   ;==>GetSystemImageList

Func GetIconIndex($sFileName)
	Local $pPIDL = _WinAPI_ShellILCreateFromPath($sFileName)
	Local $tSHFILEINFO = DllStructCreate($tagSHFILEINFO)
	Local $iFlags = BitOR($SHGFI_PIDL, $SHGFI_SYSICONINDEX)
	ShellGetFileInfo($pPIDL, $iFlags, 0, $tSHFILEINFO)
	Local $iIcon = DllStructGetData($tSHFILEINFO, "iIcon")
	_WinAPI_CoTaskMemFree($pPIDL)
	Return $iIcon
EndFunc   ;==>GetIconIndex

Func ShellGetFileInfo($pPIDL, $iFlags, $iAttributes, ByRef $tSHFILEINFO)
	Local $aRet = DllCall('shell32.dll', 'dword_ptr', 'SHGetFileInfoW', 'ptr', $pPIDL, 'dword', $iAttributes, 'struct*', $tSHFILEINFO, 'uint', DllStructGetSize($tSHFILEINFO), 'uint', $iFlags)
	If @error Then Return SetError(@error, @extended, 0)
	Return $aRet[0]
EndFunc   ;==>ShellGetFileInfo
