;==========================================================================================
; Description:      Brain Pain
; Author(s):        MrBond007 (Baki G)
; Comments:			The Brain Training Game that will fry your brain :)
;
;					Thanks to Valuater for advice & testing
;					Remember if you like This game and AutoIt Donate to the AutoIt Project:
;					http://www.autoitscript.com/donate.php
;==========================================================================================
#include <GUIConstants.au3>
#NoTrayIcon

If WinExists("Brain Pain") Then Exit
Global $Path = @ScriptDir & "\Resources\Main\"
Global $SPath = @ScriptDir & "\Resources\Sounds\"
Global $MuzPath = @ScriptDir & "\Resources\Music\"
Global $Ctrls[120], $Labels[5], $Label[30], $Arrow, $Pic00, $bassdll, $Init[1]
Global $Ctrl1[38], $Ctrl2[38], $Ctrl3[38], $Ctrl4[38], $Ctrl5[38], $Ctrl6[5], $Age[4], $Waray[7]
Global $Text_yPos[2][7] = [["Quick Thinking", "Count And Calculate", "Super Memory", "Speed Analyzing", _
					"Identify", "Brain Testing", "Give Up"], ["5", "53", "101", "149", "197", "245", "293"]]
Global $Names[124] = ["AGame1L1.au3", "AGame1L2.au3", "AGame1L3.au3", "AGame1L4.au3", "AGame2L1.au3", _
					"AGame2L2.au3", "AGame2L3.au3", "AGame2L4.au3", "AGame3L1.au3", "AGame3L2.au3", _
					"AGame3L3.au3", "AGame3L4.au3", "AGame4L1.au3", "AGame4L2.au3", "AGame4L3.au3", _
					"AGame4L4.au3", "AGame5L1.au3", "AGame5L2.au3", "AGame5L3.au3", "AGame5L4.au3", _
					"AGame6L1.au3", "AGame6L2.au3", "AGame6L3.au3", "AGame6L4.au3", "BGame1L1.au3", _
					"BGame1L2.au3", "BGame1L3.au3", "BGame1L4.au3", "BGame2L1.au3", "BGame2L2.au3", _
					"BGame2L3.au3", "BGame2L4.au3", "BGame3L1.au3", "BGame3L2.au3", "BGame3L3.au3", _
					"BGame3L4.au3", "BGame4L1.au3", "BGame4L2.au3", "BGame4L3.au3", "BGame4L4.au3", _
					"BGame5L1.au3", "BGame5L2.au3", "BGame5L3.au3", "BGame5L4.au3", "BGame6L1.au3", _
					"BGame6L2.au3", "BGame6L3.au3", "BGame6L4.au3", "CGame1L1.au3", "CGame1L2.au3", _
					"CGame1L3.au3", "CGame1L4.au3", "CGame2L1.au3", "CGame2L2.au3", "CGame2L3.au3", _
					"CGame2L4.au3", "CGame3L1.au3", "CGame3L2.au3", "CGame3L3.au3", "CGame3L4.au3", _
					"CGame4L1.au3", "CGame4L2.au3", "CGame4L3.au3", "CGame4L4.au3", "CGame5L1.au3", _
					"CGame5L2.au3", "CGame5L3.au3", "CGame5L4.au3", "CGame6L1.au3", "CGame6L2.au3", _
					"CGame6L3.au3", "CGame6L4.au3", "DGame1L1.au3", "DGame1L2.au3", "DGame1L3.au3", _
					"DGame1L4.au3", "DGame2L1.au3", "DGame2L2.au3", "DGame2L3.au3", "DGame2L4.au3", _
					"DGame3L1.au3", "DGame3L2.au3", "DGame3L3.au3", "DGame3L4.au3", "DGame4L1.au3", _
					"DGame4L2.au3", "DGame4L3.au3", "DGame4L4.au3", "DGame5L1.au3", "DGame5L2.au3", _
					"DGame5L3.au3", "DGame5L4.au3", "DGame6L1.au3", "DGame6L2.au3", "DGame6L3.au3", _
					"DGame6L4.au3", "EGame1L1.au3", "EGame1L2.au3", "EGame1L3.au3", "EGame1L4.au3", _
					"EGame2L1.au3", "EGame2L2.au3", "EGame2L3.au3", "EGame2L4.au3", "EGame3L1.au3", _
					"EGame3L2.au3", "EGame3L3.au3", "EGame3L4.au3", "EGame4L1.au3", "EGame4L2.au3", _
					"EGame4L3.au3", "EGame4L4.au3", "EGame5L1.au3", "EGame5L2.au3", "EGame5L3.au3", _
					"EGame5L4.au3", "EGame6L1.au3", "EGame6L2.au3", "EGame6L3.au3", "EGame6L4.au3", _
					"FGameL1.au3", "FGameL2.au3", "FGameL3.au3", "FGameL4.au3"]
Global $Reslt[120] = ["G1-L1", "G1-L2", "G1-L3", "G1-L4", "G2-L1", "G2-L2", "G2-L3", "G2-L4", _
					"G3-L1", "G3-L2", "G3-L3", "G3-L4", "G4-L1", "G4-L2", "G4-L3", "G4-L4", _
					"G5-L1", "G5-L2", "G5-L3", "G5-L4", "G6-L1", "G6-L2", "G6-L3", "G6-L4", _
					"G7-L1", "G7-L2", "G7-L3", "G7-L4", "G8-L1", "G8-L2", "G8-L3", "G8-L4", _
					"G9-L1", "G9-L2", "G9-L3", "G9-L4", "G10-L1", "G10-L2", "G10-L3", "G10-L4", _
					"G11-L1", "G11-L2", "G11-L3", "G11-L4", "G12-L1", "G12-L2", "G12-L3", "G12-L4", _
					"G13-L1", "G13-L2", "G13-L3", "G13-L4", "G14-L1", "G14-L2", "G14-L3", "G14-L4", _
					"G15-L1", "G15-L2", "G15-L3", "G15-L4", "G16-L1", "G16-L2", "G16-L3", "G16-L4", _
					"G17-L1", "G17-L2", "G17-L3", "G17-L4", "G18-L1", "G18-L2", "G18-L3", "G18-L4", _
					"G19-L1", "G19-L2", "G19-L3", "G19-L4", "G20-L1", "G20-L2", "G20-L3", "G20-L4", _
					"G21-L1", "G21-L2", "G21-L3", "G21-L4", "G22-L1", "G22-L2", "G22-L3", "G22-L4", _
					"G23-L1", "G23-L2", "G23-L3", "G23-L4", "G24-L1", "G24-L2", "G24-L3", "G24-L4", _
					"G25-L1", "G25-L2", "G25-L3", "G25-L4", "G26-L1", "G26-L2", "G26-L3", "G26-L4", _
					"G27-L1", "G27-L2", "G27-L3", "G27-L4", "G28-L1", "G28-L2", "G28-L3", "G28-L4", _
					"G29-L1", "G29-L2", "G29-L3", "G29-L4", "G30-L1", "G30-L2", "G30-L3", "G30-L4"]

Opt("GUIOnEventMode", 1)
Opt("GUICloseOnESC", 0)
$GuiH = GUICreate("Brain Pain", 515, 450, -1, -1, $WS_POPUP+$WS_BORDER)
GUISetOnEvent(-3, "Close")
GUISetBkColor(0xFFD046, $GuiH)
GUICtrlCreatePic($Path & "pain.jpg", 0, 400, 515, 50)
GUICtrlSetState(-1, $GUI_DISABLE)
$Edit = GUICtrlCreateEdit("", 15, 10, 480, 37, BitOR($ES_NOHIDESEL,$ES_READONLY))
GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
GUICtrlSetBkColor(-1, 0xFFFFFF)
GUICtrlSetState(-1, $GUI_DISABLE)

$ChildG = GUICreate("Brain Pain", 510, 338, 0, 30, $WS_POPUP,$WS_EX_MDICHILD,$GuiH)
GUISetBkColor(0xFFD046, $ChildG)
GUISetOnEvent(-3, "Close")

For $i = 0 To UBound($Waray)-1
	If $i = 6 Then
		$Waray[$i] = GUICtrlCreateLabel($Text_yPos[0][$i], 15, $Text_yPos[1][$i], 480, 30, $SS_CENTER)
		GUICtrlSetOnEvent($Waray[$i], "ManualClose")
	Else
		$Waray[$i] = GUICtrlCreateLabel($Text_yPos[0][$i], 15, $Text_yPos[1][$i], 480, 30)
		GUICtrlSetOnEvent($Waray[$i], "ShowGames")
	EndIf
	GUICtrlSetBkColor($Waray[$i], 0xFFBF00)
	GUICtrlSetColor($Waray[$i], 0xFFFFFF)
	GUICtrlSetFont($Waray[$i], 20, -1, 2)
	GUICtrlSetCursor($Waray[$i], 0)
Next

_PlaySong()
_BuildCtrls()
GUISetState(@SW_SHOW, $GuiH)

$Data = "Welcome To Brain Pain" & @CRLF & "Please select the category that you want to practice."
$Spit = StringSplit($Data, "")
For $i = 1 To $Spit[0]
	$Left = StringLeft($Data, $i)
	ControlSetText($GuiH, "", $Edit, $Left)
	Sleep(15)
Next

EnterG($ChildG)
GUISetState(@SW_SHOW, $ChildG)
GUISetState(@SW_RESTORE, $GuiH)

While 1
	Sleep(100)
WEnd

Func EnterG($hWnd)
	DllCall("user32.dll", "int", "AnimateWindow", "hwnd", $hWnd, "int", 400, "long", 0x00080000)
EndFunc

Func ExitG($hWnd)
	DllCall("user32.dll", "int", "AnimateWindow", "hwnd", $hWnd, "int", 100, "long", 0x00090000)
EndFunc

Func _BuildCtrls()
	Global $LabPos[6] = ["50", "94", "136", "178", "221", "263"], $a = 0, $b = 0, $c = 0
	Global $LabArr[30] = ["Color Guess", "Find The Pair", "Unmatched", "Highest Number", _
							"Lowest Number", "Count Circles", "Rich Side", "The Total", _
							"Counting", "Counting 2", "Black Circles", "More Counting", _
							"The Order", "Memory Picking", "Memory Counting", "Mixed Order", _
							"Hide n Seek", "Sequence", "The Most", "Quick Counting", "Cubes", _
							"Wrong Sort", "Complete Circle", "Colors", "Twister", "Boy Visit", _
							"Scramble", "Scramble 2", "Numbers", "Colors Swap"]
	Global $PosLab[2][5] = [["Difficulty", "Easy", "Normal", "Hard", "Extreme"], _
							["18", "195", "270", "357", "430"]]
	Global $LabCol[5] = ["0x00B000", "0x62CEE8", "0xB56BE8", "0xFF6F6F", "0xDEE75A"]
	Global $PosArr[24] = ["205,53", "280,53", "360,53", "445,53", "205,96", "280,96", _
							"360,96", "445,96", "205,138", "280,138", "360,138", _
							"445,138", "205,180", "280,180", "360,180", "445,180", _
							"205,222", "280,222", "360,222", "445,222", "205,264", _
							"280,264", "360,264", "445,264"]

	$Pic00 = GUICtrlCreatePic($Path & "border.jpg", 15, 5, 480, 32)
	GUICtrlSetState(-1, $GUI_HIDE)
	For $i = 0 To UBound($Labels)-1
		$Labels[$i] = GUICtrlCreateLabel($PosLab[0][$i], $PosLab[1][$i], 12, 100, 20)
		GUICtrlSetBkColor($labels[$i], $GUI_BKCOLOR_TRANSPARENT)
		GUICtrlSetColor($labels[$i], 0x000000)
		GUICtrlSetFont($labels[$i], 10)
		GUICtrlSetState($labels[$i], $GUI_HIDE)
	Next
	GUICtrlSetFont($labels[0], 14)
	$Arrow = GUICtrlCreatePic($Path & "arrow.gif", 15, 310, 16, 17)
	GUICtrlSetOnEvent($Arrow, "ShowOrig")
	GUICtrlSetState(-1, $GUI_HIDE)
	GUICtrlSetCursor(-1, 0)

	For $i = 0 To UBound($LabArr)-1
		If $b = 6 Then $b = 0
		If $c = 5 Then $c = 0
		$Label[$i] = GUICtrlCreateLabel($LabArr[$i], 15, $LabPos[$b], 155, 30, BitOr($SS_LEFT,$SS_CENTERIMAGE))
		GUICtrlSetBkColor($label[$i], $LabCol[$c])
		GUICtrlSetColor($label[$i], 0xFFFFFF)
		GUICtrlSetFont($label[$i], 14)
		GUICtrlSetState($label[$i], $GUI_HIDE)
		$b += 1
		If Mod($i, 6) = 5 Then $c += 1
	Next

	For $i = 0 To UBound($Ctrls)-1
		If $a = 24 Then $a = 0
		$Split = StringSplit($PosArr[$a], ",")
		$Ctrls[$i] = GUICtrlCreatePic($Path & "nog.gif", $Split[1], $Split[2], 25, 25)
		GUICtrlSetCursor($Ctrls[$i], 0)
		GUICtrlSetState($Ctrls[$i], $GUI_HIDE)
		GUICtrlSetOnEvent($Ctrls[$i], "PlayTime")
		$a += 1
	Next

	For $i = 0 to UBound($Reslt)-1
		$IniR = IniRead("Save.ini", "Games", $Reslt[$i], "@@@")
		If $IniR <> "@@@" Then
			If $IniR >= 90 And $IniR <= 100 Then
				GUICtrlSetImage($Ctrls[$i], $Path & "3.gif")
			ElseIf $IniR >= 75 And $IniR < 90 Then
				GUICtrlSetImage($Ctrls[$i], $Path & "2.gif")
			ElseIf $IniR >= 50 And $IniR < 75 Then
				GUICtrlSetImage($Ctrls[$i], $Path & "1.gif")
			EndIf
		EndIf
	Next

	$Age[0] = GUICtrlCreateLabel("Brain Age", 15, 5, 475, 55, BitOr($SS_CENTER,$SS_CENTERIMAGE))
	$Age[1] = GUICtrlCreateLabel("Brain Activation and Alterness", 15, 80, 475, 55, BitOr($SS_CENTER,$SS_CENTERIMAGE))
	$Age[2] = GUICtrlCreateLabel("Brain Utilization", 15, 155, 475, 55, BitOr($SS_CENTER,$SS_CENTERIMAGE))
	$Age[3] = GUICtrlCreateLabel("Brain Flexibility and Stress Degree", 15, 230, 475, 55, BitOr($SS_CENTER,$SS_CENTERIMAGE))
	For $i = 0 To UBound($Age)-1
		GUICtrlSetBkColor($Age[$i], 0x62A0E8)
		GUICtrlSetColor($Age[$i], 0xFFFFFF)
		GUICtrlSetFont($Age[$i], 19)
		GUICtrlSetCursor($Age[$i], 0)
		GUICtrlSetOnEvent($Age[$i], "PlayTime")
		GUICtrlSetState($Age[$i], $GUI_HIDE)
	Next

	Global $Ctrl1[38] = [$Arrow, $Pic00, $Label[0], $Label[1], $Label[2], $Label[3], $Label[4], _
							$Label[5], $Labels[0], $Labels[1], $Labels[2], $Labels[3], $Labels[4], _
							$Ctrls[0], $Ctrls[1], $Ctrls[2], $Ctrls[3], $Ctrls[4], $Ctrls[5], _
							$Ctrls[6], $Ctrls[7], $Ctrls[8], $Ctrls[9], $Ctrls[10], $Ctrls[11], _
							$Ctrls[12], $Ctrls[13], $Ctrls[14], $Ctrls[15], $Ctrls[16], $Ctrls[17], _
							$Ctrls[18], $Ctrls[19], $Ctrls[20], $Ctrls[21], $Ctrls[22], $Ctrls[23]]
	Global $Ctrl2[38] = [$Arrow, $Pic00, $Label[6], $Label[7], $Label[8], $Label[9], $Label[10], _
							$Label[11], $Labels[0], $Labels[1], $Labels[2], $Labels[3], $Labels[4], _
							$Ctrls[24], $Ctrls[25], $Ctrls[26], $Ctrls[27], $Ctrls[28], $Ctrls[29], _
							$Ctrls[30], $Ctrls[31], $Ctrls[32], $Ctrls[33], $Ctrls[34], $Ctrls[35], _
							$Ctrls[36], $Ctrls[37], $Ctrls[38], $Ctrls[39], $Ctrls[40], $Ctrls[41], _
							$Ctrls[42], $Ctrls[43], $Ctrls[44], $Ctrls[45], $Ctrls[46], $Ctrls[47]]
	Global $Ctrl3[38] = [$Arrow, $Pic00, $Label[12], $Label[13], $Label[14], $Label[15], $Label[16], _
							$Label[17], $Labels[0], $Labels[1], $Labels[2], $Labels[3], $Labels[4], _
							$Ctrls[48], $Ctrls[49], $Ctrls[50], $Ctrls[51], $Ctrls[52], $Ctrls[53], _
							$Ctrls[54], $Ctrls[55], $Ctrls[56], $Ctrls[57], $Ctrls[58], $Ctrls[59], _
							$Ctrls[60], $Ctrls[61], $Ctrls[62], $Ctrls[63], $Ctrls[64], $Ctrls[65], _
							$Ctrls[66], $Ctrls[67], $Ctrls[68], $Ctrls[69], $Ctrls[70], $Ctrls[71]]
	Global $Ctrl4[38] = [$Arrow, $Pic00, $Label[18], $Label[19], $Label[20], $Label[21], $Label[22], _
							$Label[23], $Labels[0], $Labels[1], $Labels[2], $Labels[3], $Labels[4], _
							$Ctrls[72], $Ctrls[73], $Ctrls[74], $Ctrls[75], $Ctrls[76], $Ctrls[77], _
							$Ctrls[78], $Ctrls[79], $Ctrls[80], $Ctrls[81], $Ctrls[82], $Ctrls[83], _
							$Ctrls[84], $Ctrls[85], $Ctrls[86], $Ctrls[87], $Ctrls[88], $Ctrls[89], _
							$Ctrls[90], $Ctrls[91], $Ctrls[92], $Ctrls[93], $Ctrls[94], $Ctrls[95]]
	Global $Ctrl5[38] = [$Arrow, $Pic00, $Label[24], $Label[25], $Label[26], $Label[27], $Label[28], _
							$Label[29], $Labels[0], $Labels[1], $Labels[2], $Labels[3], $Labels[4], _
							$Ctrls[96], $Ctrls[97], $Ctrls[98], $Ctrls[99], $Ctrls[100], $Ctrls[101], _
							$Ctrls[102], $Ctrls[103], $Ctrls[104], $Ctrls[105], $Ctrls[106], $Ctrls[107], _
							$Ctrls[108], $Ctrls[109], $Ctrls[110], $Ctrls[111], $Ctrls[112], $Ctrls[113], _
							$Ctrls[114], $Ctrls[115], $Ctrls[116], $Ctrls[117], $Ctrls[118], $Ctrls[119]]
	Global $Ctrl6[5] = [$Arrow, $Age[0], $Age[1], $Age[2], $Age[3]]
EndFunc

Func ShowGames()
	SoundPlay($SPath & "S1.wav")
	ExitG($ChildG)
	For $i = 0 To UBound($Waray)-1
		GUICtrlSetState($Waray[$i], $GUI_HIDE)
		If @GUI_CtrlHandle = ControlGetHandle($ChildG, "", $Waray[$i]) Then _
			$RHandle = Eval("Ctrl" & ($i + 1))
	Next
	For $i = 0 To UBound($RHandle)-1
		GUICtrlSetState($RHandle[$i], $GUI_SHOW)
	Next
	EnterG($ChildG)
EndFunc

Func ShowOrig()
	SoundPlay($SPath & "S2.wav")
	ExitG($ChildG)
	GUICtrlSetState($Arrow, $GUI_HIDE)
	GUICtrlSetState($Pic00, $GUI_HIDE)
	For $i = 0 To UBound($Label)-1
		GUICtrlSetState($Label[$i], $GUI_HIDE)
	Next
	For $i = 0 To UBound($Ctrls)-1
		GUICtrlSetState($Ctrls[$i], $GUI_HIDE)
	Next
	For $i = 0 To UBound($Labels)-1
		GUICtrlSetState($Labels[$i], $GUI_HIDE)
	Next
	For $i = 0 To UBound($Age)-1
		GUICtrlSetState($Age[$i], $GUI_HIDE)
	Next
	For $i = 0 To UBound($Waray)-1
		GUICtrlSetState($Waray[$i], $GUI_SHOW)
	Next
	EnterG($ChildG)
EndFunc

Func PlayTime()
	For $i = 0 To UBound($Ctrls)-1
		If @GUI_CtrlHandle = ControlGetHandle($ChildG, "", $Ctrls[$i]) Then
			Run(@AutoItExe & " /AutoIt3ExecuteScript " & _
			FileGetShortName(@ScriptDir & "\Games\" & $Names[$i]))
			ExitLoop
		EndIf
	Next
	If @GUI_CtrlHandle = ControlGetHandle($ChildG, "", $Age[0]) Then
		Run(@AutoItExe & " /AutoIt3ExecuteScript " & _
			FileGetShortName(@ScriptDir & "\Games\" & $Names[120]))
	ElseIf @GUI_CtrlHandle = ControlGetHandle($ChildG, "", $Age[1]) Then
		Run(@AutoItExe & " /AutoIt3ExecuteScript " & _
			FileGetShortName(@ScriptDir & "\Games\" & $Names[121]))
	ElseIf @GUI_CtrlHandle = ControlGetHandle($ChildG, "", $Age[2]) Then
		Run(@AutoItExe & " /AutoIt3ExecuteScript " & _
			FileGetShortName(@ScriptDir & "\Games\" & $Names[122]))
	ElseIf @GUI_CtrlHandle = ControlGetHandle($ChildG, "", $Age[3]) Then
		Run(@AutoItExe & " /AutoIt3ExecuteScript " & _
			FileGetShortName(@ScriptDir & "\Games\" & $Names[123]))
	EndIf
	Exit
EndFunc

Func _PlaySong()
	If FileExists($MuzPath & "\BASSMOD.dll") Then
		Global $Music[2] = ["Track9.mod", "Track5.xm"]
		$R_Music = Random(0, UBound($Music)-1, 1)
		$bassdll = DllOpen($MuzPath & "\BASSMOD.dll")
		$Init = DllCall($bassdll, "int", "BASSMOD_Init", "int", -1, "int", 44100, "int", 0)
		$Name_H = DllStructCreate("char[255]")
		DllStructSetData($Name_H, 1, $MuzPath & $Music[$R_Music])
		$Lod = DllCall($bassdll, "int", "BASSMOD_MusicLoad", "int", 0, _
				"ptr", DllStructGetPtr($Name_H), _
				"int", 0, _
				"int", 0, _
				"int", 1028)
		DllCall($bassdll, "int:cdecl", "BASSMOD_MusicPlay", "int", $Init[0])
	EndIf
EndFunc

Func ManualClose()
	SoundPlay($SPath & "S2.wav")
	Close()
EndFunc

Func Close()
	GUICtrlSetData($Edit, "")
	$Data = "Giving up already ?" & @CRLF & "Ok maybe you need a break :)"
	$Spit = StringSplit($Data, "")
	For $i = 1 To $Spit[0]
		$Left = StringLeft($Data, $i)
		ControlSetText($GuiH, "", $Edit, $Left)
		Sleep(15)
	Next
	Sleep(1500)
	If FileExists($MuzPath & "\BASSMOD.dll") Then
		DllCall($bassdll, "int:cdecl", "BASSMOD_MusicFree", "int", $Init[0])
		DllClose($bassdll)
	EndIf
	Exit
EndFunc