;==========================================================================================
; Description:      Brain Pain - Game 1 Level 3
; Author(s):        MrBond007 (Baki G)
;
;					Remember if you like This game and AutoIt Donate to the AutoIt Project:
;					http://www.autoitscript.com/donate.php
;==========================================================================================
#include <GUIConstants.au3>
#include <Bass.au3>
#NoTrayIcon

If WinExists("Brain Pain") Then Exit
Local $xPos = -15, $yPos = 5, $RandLab = 1, $PicT[5], $Labels[4], $Gr0
Local $SetC, $Count, $Score
Local $Array[2][4] = [["Yellow", "Green", "Red", "Blue"], ["0xFFFF00", "0x00FF00", "0xFF0000", "0x0000FF"]]
Local $PicPath = "Resources\Pictures\"
Local $SoundPath = "Resources\Sounds\"

Opt("GUIOnEventMode", 1)
Opt("GUICloseOnESC", 0)
$Hui = GUICreate("Brain Pain", 600, 410, -1, -1, BitOR($WS_POPUP, $WS_BORDER))
GUISetBkColor(0xFFD046)
RandomColour()

$Gr0 = GUICtrlCreateGraphic(0, 46, 600, 335)
GUICtrlSetBkColor(-1, 0xFFFFFF)
GUICtrlSetState(-1, $GUI_DISABLE)
GUICtrlCreateGraphic(0, 45, 610, 1)
GUICtrlSetColor(-1, 0x000000)
GUICtrlCreateGraphic(510, 5, 85, 35)
GUICtrlSetColor(-1, 0x4A66FA)
GUICtrlCreateGraphic(0, 380, 610, 1)
GUICtrlSetColor(-1, 0x000000)
GUICtrlCreateLabel("What's the color of the word on the left", 5, 390, 600, 15)
GUICtrlSetColor(-1, 0x4A66FA)
$Time = GUICtrlCreateLabel("02:00", 520, 7, 65, 25, $SS_CENTER)
GUICtrlSetFont(-1, 20)
GUICtrlSetColor(-1, 0x4A66FA)
GUISetState()

_PrePare(260, 135, 0x4A66FA)

GUISetOnEvent(-3, "Close")

$PicT[0] = GUICtrlCreateGraphic(330, 240, 100, 80)
$PicT[1] = GUICtrlCreateGraphic(490, 240, 100, 80)
$PicT[2] = GUICtrlCreateGraphic(330, 100, 100, 80)
$PicT[3] = GUICtrlCreateGraphic(490, 100, 100, 80)
$PicT[4] = GUICtrlCreateGraphic(10, 150, 200, 120)
For $i = 0 To UBound($PicT) - 1
	GUICtrlSetBkColor($PicT[$i], 0xCFCFCF)
Next
For $i = 0 To UBound($PicT) - 2
	GUICtrlSetCursor($PicT[$i], 0)
Next

$Labels[0] = GUICtrlCreateLabel("Yellow", 340, 265, 75, 50, $SS_CENTER)
$Labels[1] = GUICtrlCreateLabel("Green", 500, 265, 75, 50, $SS_CENTER)
$Labels[2] = GUICtrlCreateLabel("Blue", 340, 125, 75, 50, $SS_CENTER)
$Labels[3] = GUICtrlCreateLabel("Red", 500, 125, 75, 50, $SS_CENTER)
For $i = 0 To UBound($Labels) - 1
	GUICtrlSetColor($Labels[$i], 0xFFFFFF)
	GUICtrlSetBkColor($Labels[$i], $GUI_BKCOLOR_TRANSPARENT)
	GUICtrlSetFont($Labels[$i], 20)
Next

$RandLab = GUICtrlCreateLabel("", 45, 185, 120, 50, $SS_CENTER)
GUICtrlSetColor(-1, 0x000000)
GUICtrlSetBkColor(-1, $GUI_BKCOLOR_TRANSPARENT)
GUICtrlSetFont(-1, 30)
_PlayLabel()

$Label2 = GUICtrlCreateLabel("", 260, 10, 175, 25, $SS_CENTER)
GUICtrlSetFont(-1, 15, 500)
GUICtrlSetColor(-1, 0x4A66FA)
_PlaySong()

For $i = 1 To 20
	RandomColour()
	_PlayLabel()
	Timer()
Next

_Results($Label2, $Score, 3, "G1-L3")
_FlashControl($Label2, 400)
Sleep(1000)
Close()

Func _PlayLabel()
	For $i = 0 To UBound($PicT) - 2
		GUICtrlSetOnEvent($PicT[$i], "WrongAnW")
	Next
	$SetC = 0
	$Ran_D = Random(0, 3, 1)
	$Ran_Y = Random(0, 3, 1)
	GUICtrlSetData($RandLab, $Array[0][$Ran_D])
	GUICtrlSetColor($RandLab, $Array[1][$Ran_Y])
	If $Ran_Y = 0 Then
		GUICtrlSetOnEvent($PicT[0], "CorrectAnW")
	ElseIf $Ran_Y = 1 Then
		GUICtrlSetOnEvent($PicT[1], "CorrectAnW")
	ElseIf $Ran_Y = 2 Then
		GUICtrlSetOnEvent($PicT[3], "CorrectAnW")
	ElseIf $Ran_Y = 3 Then
		GUICtrlSetOnEvent($PicT[2], "CorrectAnW")
	EndIf
	TurnON()
EndFunc

Func Timer()
	$Count = 1
	While $Count > 0
		For $z = 0 To $Count
			If $SetC = 1 Then $Count = 0
			For $i = 99 To 0 Step - 1
				If $SetC = 1 Then ExitLoop
				If $i < 10 Then $i = "0" & $i
				ControlSetText($Hui, "", $Time, $Count & ":" & $i)
				Sleep(10)
			Next
			$Count -= 1
		Next
	WEnd
	If $SetC <> 1 Then WrongAnW()
EndFunc

Func CorrectAnW()
	$SetC = 1
	TurnOFF()
	If $xPos = 185 Then
		$xPos = -15
		$yPos += 20
	EndIf
	$xPos += 20
	$AddPic = GUICtrlCreatePic($PicPath & "Correct.bmp", $xPos, $yPos, 16, 16)
	SoundPlay($SoundPath & "Correct.wav")
	_FlashControl($AddPic, 300)
	$Score += 1
EndFunc

Func WrongAnW()
	$SetC = 1
	TurnOFF()
	If $xPos = 185 Then
		$xPos = -15
		$yPos += 20
	EndIf
	$xPos += 20
	$AddPic = GUICtrlCreatePic($PicPath & "False.bmp", $xPos, $yPos, 16, 16)
	SoundPlay($SoundPath & "False.wav")
	_FlashControl($AddPic, 300)
EndFunc

Func TurnON()
	For $i = 0 To UBound($PicT) - 2
		GUICtrlSetState($PicT[$i], $GUI_ENABLE)
	Next
EndFunc

Func TurnOFF()
	GUICtrlSetData($Time, "02:00")
	For $i = 0 To UBound($PicT) - 2
		GUICtrlSetState($PicT[$i], $GUI_DISABLE)
	Next
EndFunc

Func RandomColour()
	$M_ran = Random(0, 9, 1)
	Local $CArr[10] = ["0x48C4FF", "0xEFEFEF", "0xF0F000", "0xAE0000", "0x00B000", _
			"0xFFB366", "0xFF80FF", "0xDAB6B6", "0x80FFFF", "0xFFFFFF"]
	GUICtrlSetBkColor($Gr0, $CArr[$M_ran])
EndFunc