;==========================================================================================
; Description:      Brain Pain - Game 6 Level 3
; Author(s):        MrBond007 (Baki G)
;					Credits also goes to the authors of Array.au3
;
;					Remember if you like This game and AutoIt Donate to the AutoIt Project:
;					http://www.autoitscript.com/donate.php
;==========================================================================================
#include <GUIConstants.au3>
#include <Array.au3>
#include <Bass.au3>
#NoTrayIcon

If WinExists("Brain Pain") Then Exit
Local $xPos = -15, $yPos = 5, $Labels[4], $Gra[12]
Local $SetC, $Count, $Score
Local $PicPath = "Resources\Pictures\"
Local $SoundPath = "Resources\Sounds\"

Opt("GUIOnEventMode", 1)
Opt("GUICloseOnESC", 0)
$Hui = GUICreate("", 540, 410, -1, -1, BitOR($WS_POPUP, $WS_BORDER))
GUISetBkColor(0xFFD046)

GUICtrlCreateGraphic(0, 46, 540, 335)
GUICtrlSetBkColor(-1, 0x000000)
GUICtrlSetState(-1, $GUI_DISABLE)
GUICtrlCreateGraphic(0, 45, 550, 1)
GUICtrlSetColor(-1, 0x000000)
GUICtrlCreateGraphic(450, 5, 85, 35)
GUICtrlSetColor(-1, 0x4A66FA)
GUICtrlCreateGraphic(0, 380, 550, 1)
GUICtrlSetColor(-1, 0x000000)
GUICtrlCreateLabel("Count the circles", 5, 390, 600, 15)
GUICtrlSetColor(-1, 0x4A66FA)
$Time = GUICtrlCreateLabel("05:00", 460, 7, 65, 25, $SS_CENTER)
GUICtrlSetFont(-1, 20)
GUICtrlSetColor(-1, 0x4A66FA)
$Label2 = GUICtrlCreateLabel("", 260, 10, 175, 25, $SS_CENTER)
GUICtrlSetFont(-1, 15, 500)
GUICtrlSetColor(-1, 0x4A66FA)
GUISetState()

_PrePare(220, 135, 0xFFFFFF)

GUISetOnEvent(-3, "Close")

$Labels[0] = GUICtrlCreateLabel("", 360, 150, 50, 50, BitOR($SS_CENTER, $SS_CENTERIMAGE))
$Labels[1] = GUICtrlCreateLabel("", 460, 150, 50, 50, BitOR($SS_CENTER, $SS_CENTERIMAGE))
$Labels[2] = GUICtrlCreateLabel("", 360, 240, 50, 50, BitOR($SS_CENTER, $SS_CENTERIMAGE))
$Labels[3] = GUICtrlCreateLabel("", 460, 240, 50, 50, BitOR($SS_CENTER, $SS_CENTERIMAGE))
For $i = 0 To UBound($Labels) - 1
	GUICtrlSetFont($Labels[$i], 22)
	GUICtrlSetBkColor($Labels[$i], 0xFFD046)
	GUICtrlSetCursor($Labels[$i], 0)
Next

_PlaySong()

For $i = 1 To 20
	PlayTime()
	Timer()
Next

_Results($Label2, $Score, 3, "G6-L3")
_FlashControl($Label2, 400)
Sleep(1000)
Close()

While 1
	Sleep(100)
WEnd

Func Timer()
	$Count = 4
	While $Count > 0
		For $z = 0 To $Count
			If $SetC = 1 Then $Count = 0
			For $i = 99 To 0 Step - 1
				If $SetC = 1 Then ExitLoop
				If $i < 10 Then $i = "0" & $i
				ControlSetText($Hui, "", $Time, $Count & ":" & $i)
				Sleep(10)
			Next
			$Count -= 1
		Next
	WEnd
	If $SetC <> 1 Then WrongAnW()
EndFunc

Func PlayTime()
	$SetC = 0
	For $i = 0 To UBound($Gra) - 1
		GUICtrlDelete($Gra[$i])
	Next
	For $b = 0 To UBound($Labels) - 1
		GUICtrlSetData($Labels[$b], "")
	Next

	$Ran_Y = Random(6, 11, 1)
	Local $Array[25] = ["5,57", "70,57", "135,57", "200,57", "265,57", _
			"5,122", "70,122", "135,122", "200,122", "265,122", _
			"5,187", "70,187", "135,187", "200,187", "265,187", _
			"5,252", "70,252", "135,252", "200,252", "265,252", _
			"5,317", "70,317", "135,317", "200,317", "265,317"]
	Local $RanLab[4] = [$Labels[0], $Labels[1], $Labels[2], $Labels[3]]
	Local $Results[3] = [$Ran_Y + 1, $Ran_Y + 2, $Ran_Y - 1]

	For $i = 1 To $Ran_Y
		$Ran_D = Random(0, UBound($Array) - 1, 1)
		$Split = StringSplit($Array[$Ran_D], ",")
		$Gra[$i - 1] = GUICtrlCreateGraphic($Split[1], $Split[2], 50, 50)
		GUICtrlSetGraphic($Gra[$i - 1], $GUI_GR_COLOR, 0xADBB00, 0xADBB00)
		GUICtrlSetGraphic($Gra[$i - 1], $GUI_GR_ELLIPSE, 0, 0, 50, 50)
		GUICtrlSetBkColor($Gra[$i - 1], 0x000000)
		_ArrayDelete($Array, $Ran_D)
	Next

	For $i = 0 To 2
		$Ran_E = Random(0, UBound($RanLab) - 1, 1)
		$Ran_N = Random(0, UBound($Results) - 1, 1)
		GUICtrlSetData($RanLab[$Ran_E], $Results[$Ran_N])
		GUICtrlSetOnEvent($RanLab[$Ran_E], "WrongAnW")
		_ArrayDelete($RanLab, $Ran_E)
		_ArrayDelete($Results, $Ran_N)
	Next

	GUICtrlSetData($RanLab[0], $Ran_Y)
	GUICtrlSetOnEvent($RanLab[0], "CorrectAnW")

	Local $CArr[10] = ["0x48C4FF", "0xEFEFEF", "0xF0F000", "0xAE0000", "0x00B000", _
			"0xFFB366", "0xFF80FF", "0xDAB6B6", "0x80FFFF", "0xFFFFFF"]
	For $b = 0 To UBound($Labels) - 1
		$M_ran = Random(0, 9, 1)
		GUICtrlSetBkColor($Labels[$b], $CArr[$M_ran])
	Next

	AdlibEnable("SwapPos", 1500)
EndFunc

Func SwapPos()
	Local $Array[25] = ["5,57", "70,57", "135,57", "200,57", "265,57", _
			"5,122", "70,122", "135,122", "200,122", "265,122", _
			"5,187", "70,187", "135,187", "200,187", "265,187", _
			"5,252", "70,252", "135,252", "200,252", "265,252", _
			"5,317", "70,317", "135,317", "200,317", "265,317"]
	For $i = 0 To UBound($Gra) - 1
		$Ran_D = Random(0, UBound($Array) - 1, 1)
		$Split = StringSplit($Array[$Ran_D], ",")
		GUICtrlSetPos($Gra[$i], $Split[1], $Split[2])
		_ArrayDelete($Array, $Ran_D)
	Next
	$Array = ""
EndFunc

Func CorrectAnW()
	$SetC = 1
	TurnOFF()
	If $xPos = 185 Then
		$xPos = -15
		$yPos += 20
	EndIf
	$xPos += 20
	$AddPic = GUICtrlCreatePic($PicPath & "Correct.bmp", $xPos, $yPos, 16, 16)
	SoundPlay($SoundPath & "Correct.wav")
	_FlashControl($AddPic, 300)
	$Score += 1
EndFunc

Func WrongAnW()
	$SetC = 1
	TurnOFF()
	If $xPos = 185 Then
		$xPos = -15
		$yPos += 20
	EndIf
	$xPos += 20
	$AddPic = GUICtrlCreatePic($PicPath & "False.bmp", $xPos, $yPos, 16, 16)
	SoundPlay($SoundPath & "False.wav")
	_FlashControl($AddPic, 300)
EndFunc

Func TurnOFF()
	GUICtrlSetData($Time, "05:00")
	AdlibDisable()
	For $b = 0 To UBound($Labels) - 1
		GUICtrlSetOnEvent($Labels[$b], "")
	Next
EndFunc