;==========================================================================================
; Description:      Brain Pain - Game 11 Level 2
; Author(s):        MrBond007 (Baki G)
;					Credits also goes to the authors of Array.au3
;
;					Remember if you like This game and AutoIt Donate to the AutoIt Project:
;					http://www.autoitscript.com/donate.php
;==========================================================================================
#include <GUIConstants.au3>
#include <Array.au3>
#include <Bass.au3>
#NoTrayIcon

If WinExists("Brain Pain") Then Exit
Local $xPos = -15, $yPos = 5, $Labels[4], $Gra[15]
Local $SetC, $Count, $Score
Local $PicPath = "Resources\Pictures\"
Local $SoundPath = "Resources\Sounds\"

Opt("GUIOnEventMode", 1)
Opt("GUICloseOnESC", 0)
$Hui = GUICreate("", 600, 410, -1, -1, BitOR($WS_POPUP, $WS_BORDER))
GUISetBkColor(0xFFD046)

GUICtrlCreateGraphic(0, 46, 600, 335)
GUICtrlSetBkColor(-1, 0x000000)
GUICtrlSetState(-1, $GUI_DISABLE)
GUICtrlCreateGraphic(0, 45, 610, 1)
GUICtrlSetColor(-1, 0x000000)
GUICtrlCreateGraphic(510, 5, 85, 35)
GUICtrlSetColor(-1, 0x4A66FA)
GUICtrlCreateGraphic(0, 380, 610, 1)
GUICtrlSetColor(-1, 0x000000)
GUICtrlCreateLabel("How many black circles do you see?", 5, 390, 600, 15)
GUICtrlSetColor(-1, 0x4A66FA)
$Time = GUICtrlCreateLabel("07:00", 520, 7, 65, 25, $SS_CENTER)
GUICtrlSetFont(-1, 20)
GUICtrlSetColor(-1, 0x4A66FA)
$Label2 = GUICtrlCreateLabel("", 260, 10, 175, 25, $SS_CENTER)
GUICtrlSetFont(-1, 15, 500)
GUICtrlSetColor(-1, 0x4A66FA)
GUISetState()

_PrePare(260, 135, 0xFFFFFF)
_CreateGraf()

GUISetOnEvent(-3, "Close")

$Labels[0] = GUICtrlCreateLabel("", 435, 150, 50, 50, BitOR($SS_CENTER, $SS_CENTERIMAGE))
$Labels[1] = GUICtrlCreateLabel("", 530, 150, 50, 50, BitOR($SS_CENTER, $SS_CENTERIMAGE))
$Labels[2] = GUICtrlCreateLabel("", 435, 240, 50, 50, BitOR($SS_CENTER, $SS_CENTERIMAGE))
$Labels[3] = GUICtrlCreateLabel("", 530, 240, 50, 50, BitOR($SS_CENTER, $SS_CENTERIMAGE))
For $i = 0 To UBound($Labels) - 1
	GUICtrlSetFont($Labels[$i], 22)
	GUICtrlSetBkColor($Labels[$i], 0xFFD046)
	GUICtrlSetCursor($Labels[$i], 0)
Next

_PlaySong()

For $i = 1 To 15
	PlayTime()
	Timer()
Next

_Results($Label2, $Score, 2, "G11-L2")
_FlashControl($Label2, 400)
Sleep(1000)
Close()

While 1
	Sleep(100)
WEnd

Func Timer()
	$Count = 6
	While $Count > 0
		For $z = 0 To $Count
			If $SetC = 1 Then $Count = 0
			For $i = 99 To 0 Step - 1
				If $SetC = 1 Then ExitLoop
				If $i < 10 Then $i = "0" & $i
				ControlSetText($Hui, "", $Time, $Count & ":" & $i)
				Sleep(10)
			Next
			$Count -= 1
		Next
	WEnd
	If $SetC <> 1 Then WrongAnW()
EndFunc

Func PlayTime()
	$SetC = 0
	For $a = 0 To UBound($Gra) - 1
		GUICtrlDelete($Gra[$a])
	Next
	$Ran_D = Random(6, 14, 1)
	Local $Dots[20] = ["40,100", "115,100", "190,100", "265,100", "340,100", _
			"40,170", "115,170", "190,170", "265,170", "340,170", _
			"40,240", "115,240", "190,240", "265,240", "340,240", _
			"40,310", "115,310", "190,310", "265,310", "340,310"]
	Local $ArrPos[4] = [$Labels[0], $Labels[1], $Labels[2], $Labels[3]]
	Local $data[4] = [$Ran_D, $Ran_D + 1, $Ran_D + 2, $Ran_D - 1]

	For $a = 0 To $Ran_D
		$Ran_Y = Random(0, UBound($Dots) - 1, 1)
		$Split = StringSplit($Dots[$Ran_Y], ",")
		$Gra[$a] = GUICtrlCreateGraphic($Split[1], $Split[2], 15, 15)
		GUICtrlSetGraphic(-1, $GUI_GR_COLOR, 0x000000, 0x000000)
		GUICtrlSetGraphic(-1, $GUI_GR_ELLIPSE, 0, 0, 15, 15)
		GUICtrlSetBkColor(-1, 0xFFFFFF)
		_ArrayDelete($Dots, $Ran_Y)
	Next

	For $b = 0 To 3
		$Ran_E = Random(0, UBound($ArrPos) - 1, 1)
		$Ran_N = Random(0, UBound($data) - 1, 1)
		GUICtrlSetData($ArrPos[$Ran_E], $data[$Ran_N])
		If $data[$Ran_N] == $Ran_D + 1 Then
			GUICtrlSetOnEvent($ArrPos[$Ran_E], "CorrectAnw")
		Else
			GUICtrlSetOnEvent($ArrPos[$Ran_E], "WrongAnw")
		EndIf
		_ArrayDelete($ArrPos, $Ran_E)
		_ArrayDelete($data, $Ran_N)
	Next
EndFunc

Func _CreateGraf()
	GUICtrlCreateGraphic(10, 100, 380, 15)
	GUICtrlSetBkColor(-1, 0xFFFFFF)
	GUICtrlCreateGraphic(10, 170, 380, 15)
	GUICtrlSetBkColor(-1, 0xFFFFFF)
	GUICtrlCreateGraphic(10, 240, 380, 15)
	GUICtrlSetBkColor(-1, 0xFFFFFF)
	GUICtrlCreateGraphic(10, 310, 380, 15)
	GUICtrlSetBkColor(-1, 0xFFFFFF)

	GUICtrlCreateGraphic(40, 60, 15, 300)
	GUICtrlSetBkColor(-1, 0xFFFFFF)
	GUICtrlCreateGraphic(115, 60, 15, 300)
	GUICtrlSetBkColor(-1, 0xFFFFFF)
	GUICtrlCreateGraphic(190, 60, 15, 300)
	GUICtrlSetBkColor(-1, 0xFFFFFF)
	GUICtrlCreateGraphic(265, 60, 15, 300)
	GUICtrlSetBkColor(-1, 0xFFFFFF)
	GUICtrlCreateGraphic(340, 60, 15, 300)
	GUICtrlSetBkColor(-1, 0xFFFFFF)
EndFunc

Func CorrectAnW()
	$SetC = 1
	TurnOFF()
	If $xPos = 185 Then
		$xPos = -15
		$yPos += 20
	EndIf
	$xPos += 20
	$AddPic = GUICtrlCreatePic($PicPath & "Correct.bmp", $xPos, $yPos, 16, 16)
	SoundPlay($SoundPath & "Correct.wav")
	_FlashControl($AddPic, 300)
	$Score += 1
EndFunc

Func WrongAnW()
	$SetC = 1
	TurnOFF()
	If $xPos = 185 Then
		$xPos = -15
		$yPos += 20
	EndIf
	$xPos += 20
	$AddPic = GUICtrlCreatePic($PicPath & "False.bmp", $xPos, $yPos, 16, 16)
	SoundPlay($SoundPath & "False.wav")
	_FlashControl($AddPic, 300)
EndFunc

Func TurnOFF()
	GUICtrlSetData($Time, "07:00")
	For $b = 0 To UBound($Labels) - 1
		GUICtrlSetOnEvent($Labels[$b], "")
	Next
EndFunc