;==========================================================================================
; Description:      Brain Pain - BassMod Play Function
; Author(s):        MrBond007 (Baki G)
;					Credits also goes to un4seen for BassMod.dll
;
;					Remember if you like This game and AutoIt Donate to the AutoIt Project:
;					http://www.autoitscript.com/donate.php
;==========================================================================================
Local $SoundsPath = "Resources\Sounds\"
Local $MusicsPath = "Resources\Music\"
Local $bassdll, $Init[1], $Result, $Amount, $ToType

Func _PlaySong()
	If FileExists($MusicsPath & "BASSMOD.dll") Then
		Global $MusicArray[8] = ["Track1.xm", "Track2.xm", "Track3.mod", "Track4.xm", _
				"Track5.xm", "Track6.xm", "Track7.mod", "Track8.mod"]
		$R_Music = Random(0, UBound($MusicArray) - 1, 1)
		$bassdll = DllOpen($MusicsPath & "BASSMOD.dll")
		$Init = DllCall($bassdll, "int", "BASSMOD_Init", "int", -1, "int", 44100, "int", 0)
		$Name_H = DllStructCreate("char[255]")
		DllStructSetData($Name_H, 1, $MusicsPath & $MusicArray[$R_Music])
		$Lod = DllCall($bassdll, "int", "BASSMOD_MusicLoad", "int", 0, _
				"ptr", DllStructGetPtr($Name_H), _
				"int", 0, _
				"int", 0, _
				"int", 1028)
		$nay = DllCall($bassdll, "int:cdecl", "BASSMOD_MusicPlay", "int", $Init[0])
	EndIf
EndFunc

Func _PrePare($x_Pos, $y_Pos, $ColorId)
	Local $Numb[3] = ["3", "2", "1"], $Fake
	$Fake = GUICtrlCreateLabel("", $x_Pos, $y_Pos, 80, 150)
	GUICtrlSetFont(-1, 100, 900)
	GUICtrlSetColor(-1, $ColorId)
	GUICtrlSetBkColor(-1, -2)
	For $m = 0 To 2
		GUICtrlSetData($Fake, $Numb[$m])
		SoundPlay($SoundsPath & "time.wav")
		Sleep(1000)
	Next
	GUICtrlDelete($Fake)
EndFunc

Func _FlashControl($CtrlId, $Duration)
	For $i = 1 To 2
		GUICtrlSetState($CtrlId, 32)
		Sleep($Duration)
		GUICtrlSetState($CtrlId, 16)
		Sleep($Duration)
	Next
EndFunc

Func _Results($CtrlId, $Amount, $Mt, $Game_Sec)
	If Not FileExists("Save.ini") Then FileWrite("Save.ini", "")
	If $Mt = 1 Then
		If $Amount = 10 Then
			$Result = "(Perfect)"
		ElseIf $Amount = 9 Then
			$Result = "(Excellent)"
		ElseIf $Amount = 8 Or $Amount = 7 Then
			$Result = "(Pretty Good)"
		ElseIf $Amount = 6 Or $Amount = 5 Then
			$Result = "(Not Bad)"
		ElseIf $Amount <= 4 Then
			$Result = "(Try Again)"
		EndIf
		$ToType = $Amount * 10 
	ElseIf $Mt = 2 Then
		If $Amount = 15 Then
			$Result = "(Perfect)"
		ElseIf $Amount = 14 Or $Amount = 13 Then
			$Result = "(Excellent)"
		ElseIf $Amount = 12 Or $Amount = 11 Then
			$Result = "(Pretty Good)"
		ElseIf $Amount = 10 Then
			$Result = "(Not Bad)"
		ElseIf $Amount = 9 Then
			$Result = "(Not Bad)"
		ElseIf $Amount = 8 Or $Amount = 7 Then
			$Result = "(Not Bad)"
		ElseIf $Amount <= 6 Then
			$Result = "(Try Again)"
		EndIf
		$ToType = Round(($Amount * 100) / 15)
	ElseIf $Mt = 3 Then
		If $Amount = 20 Then
			$Result = "(Perfect)"
		ElseIf $Amount = 19 Or $Amount = 18 Then
			$Result = "(Excellent)"
		ElseIf $Amount = 17 Or $Amount = 16 Then
			$Result = "(Pretty Good)"
		ElseIf $Amount = 15 Or $Amount = 14 Then
			$Result = "(Not Bad)"
		ElseIf $Amount = 13 Or $Amount = 12 Then
			$Result = "(Not Bad)"
		ElseIf $Amount = 11 Or $Amount = 10 Then
			$Result = "(Not Bad)"
		ElseIf $Amount <= 9 Then
			$Result = "(Try Again)"
		EndIf
		$ToType = ($Amount * 100) / 20
	EndIf
	$IniR = IniRead("Save.ini", "Games", $Game_Sec, "")
	If $IniR = "" Or $IniR < $ToType Then IniWrite("Save.ini", "Games", $Game_Sec, $ToType)
	SoundPlay($SoundsPath & "Result.wav")
	GUICtrlSetData($CtrlId, $ToType & "% " & $Result)
EndFunc

Func Close()
	If FileExists($MusicsPath & "BASSMOD.dll") Then
		DllCall($bassdll, "int:cdecl", "BASSMOD_MusicFree", "int", $Init[0])
		DllClose($bassdll)
	EndIf
	Run(@AutoItExe & " /AutoIt3ExecuteScript " & _
			FileGetShortName("BrainPain.au3"))
	Exit
EndFunc