;==========================================================================================
; Description:      Brain Pain - Game 21 Level 3
; Author(s):        MrBond007 (Baki G)
;					Credits also goes to the authors of Array.au3
;
;					Remember if you like This game and AutoIt Donate to the AutoIt Project:
;					http://www.autoitscript.com/donate.php
;==========================================================================================
#include <GUIConstants.au3>
#include <Array.au3>
#include <Bass.au3>
#NoTrayIcon

If WinExists("Brain Pain") Then Exit
Local $xPos = -15, $yPos = 5, $SetC, $Count, $Score, $PcA[37], $Labels[4]
Local $PicPath = "Resources\Pictures\"
Local $SoundPath = "Resources\Sounds\"

Opt("GUIOnEventMode", 1)
Opt("GUICloseOnESC", 0)
$Hui = GUICreate("Brain Pain", 515, 410, -1, -1, BitOR($WS_POPUP, $WS_BORDER))
GUISetBkColor(0xFFD046)

$Gr0 = GUICtrlCreateGraphic(425, 5, 85, 35)
GUICtrlSetColor($Gr0, 0x000000)
$Gr1 = GUICtrlCreateGraphic(0, 45, 515, 1)
GUICtrlSetColor($Gr1, 0x000000)
$Gr2 = GUICtrlCreateGraphic(0, 380, 515, 1)
GUICtrlSetColor($Gr2, 0x000000)
$Label1 = GUICtrlCreateLabel("How many Cubes do you see ?", 5, 390, 600, 15)
GUICtrlSetColor($Label1, 0x4A66FA)
$Time = GUICtrlCreateLabel("05:00", 435, 7, 65, 25, $SS_CENTER)
GUICtrlSetColor($Time, 0x4A66FA)
GUICtrlSetFont(-1, 20)
$Label2 = GUICtrlCreateLabel("", 225, 10, 175, 25, $SS_CENTER)
GUICtrlSetColor($Label2, 0x4A66FA)
GUICtrlSetFont(-1, 15, 500)

GUICtrlCreateGraphic(0, 46, 515, 334)
GUICtrlSetBkColor(-1, 0xFFFFFF)
GUICtrlSetState(-1, $GUI_DISABLE)
GUISetState()

_PrePare(215, 135, 0x4A66FA)

GUISetOnEvent(-3, "Close")

$Gr3 = GUICtrlCreateGraphic(300, 45, 1, 335)
GUICtrlSetColor($Gr3, 0x000000)

$Labels[0] = GUICtrlCreateLabel("", 340, 150, 50, 35, $SS_CENTER)
$Labels[1] = GUICtrlCreateLabel("", 430, 150, 50, 35, $SS_CENTER)
$Labels[2] = GUICtrlCreateLabel("", 340, 240, 50, 35, $SS_CENTER)
$Labels[3] = GUICtrlCreateLabel("", 430, 240, 50, 35, $SS_CENTER)
For $i = 0 To UBound($Labels) - 1
	GUICtrlSetBkColor($Labels[$i], 0x4A66FA)
	GUICtrlSetFont($Labels[$i], 23)
	GUICtrlSetCursor($Labels[$i], 0)
Next

_PlaySong()

For $z = 1 To 20
	PlayTime()
	Timer()
Next

_Results($Label2, $Score, 3, "G21-L3")
_FlashControl($Label2, 400)
Sleep(1000)
Close()

Func Timer()
	$Count = 4
	While $Count > 0
		For $z = 0 To $Count
			If $SetC = 1 Then $Count = 0
			For $i = 99 To 0 Step - 1
				If $SetC = 1 Then ExitLoop
				If $i < 10 Then $i = "0" & $i
				ControlSetText($Hui, "", $Time, $Count & ":" & $i)
				Sleep(10)
			Next
			$Count -= 1
		Next
	WEnd
	If $SetC <> 1 Then WrongAnW()
EndFunc

Func PlayTime()
	$SetC = 0
	Global $Level1[37] = ["51,235", "70,235", "89,235", "108,235", "127,235", "146,235", "165,235", _
			"184,235", "203,235", "58,215", "80,215", "102,215", "124,215", "146,215", _
			"168,215", "190,215", "65,195", "87,195", "109,195", "131,195", "153,195", _
			"175,195", "72,175", "94,175", "116,175", "138,175", "160,175", "79,155", _
			"101,155", "123,155", "145,155", "86,135", "108,135", "130,135", "93,115", _
			"115,115", "100,95"]
	$Value = Random(12, 17, 1)
	Global $RandmArr[4] = [$Labels[0], $Labels[1], $Labels[2], $Labels[3]]
	Global $RandmVal[3] = [$Value + 3, $Value - 2, $Value - 1]
	For $i = 0 To $Value
		$Rrr = Random(0, UBound($Level1) - 1, 1)
		$Split = StringSplit($Level1[$Rrr], ",")
		$PcA[$i] = GUICtrlCreatePic($PicPath & "block.gif", _
				$Split[1], $Split[2], 24, 25)
		GUICtrlSetState(-1, $GUI_DISABLE)
		_ArrayDelete($Level1, $Rrr)
	Next

	$Ran_D = Random(0, 3, 1)
	GUICtrlSetData($RandmArr[$Ran_D], $Value + 1)
	GUICtrlSetOnEvent($RandmArr[$Ran_D], "CorrectAnW")
	_ArrayDelete($RandmArr, $Ran_D)
	For $i = 0 To 2
		$Ran_D = Random(0, UBound($RandmArr) - 1, 1)
		$Ran_Y = Random(0, UBound($RandmVal) - 1, 1)
		GUICtrlSetData($RandmArr[$Ran_D], $RandmVal[$Ran_Y])
		GUICtrlSetOnEvent($RandmArr[$Ran_D], "WrongAnW")
		_ArrayDelete($RandmArr, $Ran_D)
		_ArrayDelete($RandmVal, $Ran_Y)
	Next
EndFunc

Func CorrectAnW()
	For $a = 0 To UBound($Labels) - 1
		GUICtrlSetOnEvent($Labels[$a], "")
	Next
	$SetC = 1
	If $xPos = 185 Then
		$xPos = -15
		$yPos += 20
	EndIf
	$xPos += 20
	$AddPic = GUICtrlCreatePic($PicPath & "Correct.bmp", $xPos, $yPos, 16, 16)
	SoundPlay($SoundPath & "Correct.wav")
	GUICtrlSetData($Time, "05:00")
	_FlashControl($AddPic, 300)
	$Score += 1
	For $a = 0 To UBound($PcA) - 1
		GUICtrlDelete($PcA[$a])
	Next
EndFunc

Func WrongAnW()
	For $a = 0 To UBound($Labels) - 1
		GUICtrlSetOnEvent($Labels[$a], "")
	Next
	$SetC = 1
	If $xPos = 185 Then
		$xPos = -15
		$yPos += 20
	EndIf
	$xPos += 20
	$AddPic = GUICtrlCreatePic($PicPath & "False.bmp", $xPos, $yPos, 16, 16)
	SoundPlay($SoundPath & "False.wav")
	GUICtrlSetData($Time, "05:00")
	_FlashControl($AddPic, 300)
	For $a = 0 To UBound($PcA) - 1
		GUICtrlDelete($PcA[$a])
	Next
EndFunc