;==========================================================================================
; Description:      Brain Pain - Game 23 Level 4
; Author(s):        MrBond007 (Baki G)
;					Credits also goes to the authors of Array.au3
;					Remember if you like This game and AutoIt Donate to the AutoIt Project:
;					http://www.autoitscript.com/donate.php
;==========================================================================================
#include <GUIConstants.au3>
#include <Array.au3>
#include <Bass.au3>
#NoTrayIcon

If WinExists("Brain Pain") Then Exit
Local $xPos = -15, $yPos = 5, $Pictures[25]
Local $SetC, $Count, $Score
Local $PicPaths = "Resources\Pictures\Circles\"
Local $PicPath = "Resources\Pictures\"
Local $SoundPath = "Resources\Sounds\"

Opt("GUIOnEventMode", 1)
Opt("GUICloseOnESC", 0)
$Hui = GUICreate("", 600, 410, -1, -1, BitOR($WS_POPUP, $WS_BORDER))
GUISetBkColor(0xFFD046)

GUICtrlCreateGraphic(0, 46, 600, 335)
GUICtrlSetBkColor(-1, 0x784F0A)
GUICtrlSetState(-1, $GUI_DISABLE)

GUICtrlCreateGraphic(0, 45, 610, 1)
GUICtrlSetColor(-1, 0x000000)
GUICtrlCreateGraphic(510, 5, 85, 35)
GUICtrlSetColor(-1, 0x4A66FA)
GUICtrlCreateGraphic(0, 380, 610, 1)
GUICtrlSetColor(-1, 0x000000)
GUICtrlCreateLabel("Find the complete circle", 5, 390, 600, 15)
GUICtrlSetColor(-1, 0x4A66FA)
$Time = GUICtrlCreateLabel("03:00", 520, 7, 65, 25, $SS_CENTER)
GUICtrlSetFont(-1, 20)
GUICtrlSetColor(-1, 0x4A66FA)
$Label2 = GUICtrlCreateLabel("", 260, 10, 175, 25, $SS_CENTER)
GUICtrlSetFont(-1, 15, 500)
GUICtrlSetColor(-1, 0x4A66FA)
GUISetState()

_PrePare(260, 135, 0x4A66FA)

GUISetOnEvent(-3, "Close")

_PlaySong()

For $i = 1 To 20
	PlayTime()
	Timer()
Next

_Results($Label2, $Score, 3, "G23-L4")
_FlashControl($Label2, 400)
Sleep(1000)
Close()

While 1
	Sleep(100)
WEnd

Func Timer()
	$Count = 2
	While $Count > 0
		For $z = 0 To $Count
			If $SetC = 1 Then $Count = 0
			For $i = 99 To 0 Step - 1
				If $SetC = 1 Then ExitLoop
				If $i < 10 Then $i = "0" & $i
				ControlSetText($Hui, "", $Time, $Count & ":" & $i)
				Sleep(10)
			Next
			$Count -= 1
		Next
	WEnd
	If $SetC <> 1 Then WrongAnW()
EndFunc

Func PlayTime()
	For $a = 0 To UBound($Pictures) - 1
		GUICtrlDelete($Pictures[$a])
	Next
	$SetC = 0
	Local $Array[32] = ["60,80", "125,80", "185,80", "245,80", "305,80", "365,80", _
			"425,80", "490,80", "60,150", "125,150", "185,150", "245,150", _
			"305,150", "365,150", "425,150", "490,150", "60,220", "125,220", _
			"185,220", "245,220", "305,220", "365,220", "425,220", "490,220", _
			"60,290", "125,290", "185,290", "245,290", "305,290", "365,290", _
			"425,290", "490,290"]
	Local $TrA[8] = ["2", "3", "4", "5", "6", "7", "8", "9"]
	$Ran_D = Random(17, 22, 1)
	For $a = 0 To $Ran_D
		$Ran_Y = Random(0, UBound($Array) - 1, 1)
		$Ran_E = Random(0, UBound($TrA) - 1, 1)
		$Split = StringSplit($Array[$Ran_Y], ",")
		$Pictures[$a] = GUICtrlCreatePic($PicPaths & _
				$TrA[$Ran_E] & ".bmp", $Split[1], $Split[2], 46, 46)
		GUICtrlSetCursor($Pictures[$a], 0)
		GUICtrlSetOnEvent($Pictures[$a], "WrongAnW")
		_ArrayDelete($Array, $Ran_Y)
	Next

	$Ran_Y = Random(0, UBound($Array) - 1, 1)
	$Ran_E = Random(0, UBound($TrA) - 1, 1)
	$Split = StringSplit($Array[$Ran_Y], ",")
	$Pictures[$a + 1] = GUICtrlCreatePic($PicPaths & "1.bmp", $Split[1], $Split[2], 46, 46)
	GUICtrlSetCursor($Pictures[$a + 1], 0)
	GUICtrlSetOnEvent($Pictures[$a + 1], "CorrectAnW")
EndFunc

Func CorrectAnW()
	$SetC = 1
	TurnOFF()
	If $xPos = 185 Then
		$xPos = -15
		$yPos += 20
	EndIf
	$xPos += 20
	$AddPic = GUICtrlCreatePic($PicPath & "Correct.bmp", $xPos, $yPos, 16, 16)
	SoundPlay($SoundPath & "Correct.wav")
	_FlashControl($AddPic, 300)
	$Score += 1
EndFunc

Func WrongAnW()
	$SetC = 1
	TurnOFF()
	If $xPos = 185 Then
		$xPos = -15
		$yPos += 20
	EndIf
	$xPos += 20
	$AddPic = GUICtrlCreatePic($PicPath & "False.bmp", $xPos, $yPos, 16, 16)
	SoundPlay($SoundPath & "False.wav")
	_FlashControl($AddPic, 300)
EndFunc

Func TurnOFF()
	GUICtrlSetData($Time, "03:00")
	For $b = 0 To UBound($Pictures) - 1
		GUICtrlSetOnEvent($Pictures[$b], "")
	Next
EndFunc