;==========================================================================================
; Description:      Brain Pain - Game 24 Level 3
; Author(s):        MrBond007 (Baki G)
;					Credits also goes to the authors of Array.au3
;
;					Remember if you like This game and AutoIt Donate to the AutoIt Project:
;					http://www.autoitscript.com/donate.php
;==========================================================================================
#include <GUIConstants.au3>
#include <Array.au3>
#include <Bass.au3>
#NoTrayIcon

If WinExists("Brain Pain") Then Exit
Local $xPos = -15, $yPos = 5, $Labels[4], $Gra[25]
Local $SetC, $Count, $Score
Local $PicPath = "Resources\Pictures\"
Local $SoundPath = "Resources\Sounds\"

Opt("GUIOnEventMode", 1)
Opt("GUICloseOnESC", 0)
$Hui = GUICreate("", 540, 410, -1, -1, BitOR($WS_POPUP, $WS_BORDER))
GUISetBkColor(0xFFD046)

GUICtrlCreateGraphic(0, 46, 540, 335)
GUICtrlSetBkColor(-1, 0x000000)
GUICtrlSetState(-1, $GUI_DISABLE)
GUICtrlCreateGraphic(0, 45, 550, 1)
GUICtrlSetColor(-1, 0x000000)
GUICtrlCreateGraphic(450, 5, 85, 35)
GUICtrlSetColor(-1, 0x4A66FA)
GUICtrlCreateGraphic(0, 380, 550, 1)
GUICtrlSetColor(-1, 0x000000)
GUICtrlCreateLabel("Which color appears the most?", 5, 390, 600, 15)
GUICtrlSetColor(-1, 0x4A66FA)
$Time = GUICtrlCreateLabel("03:00", 460, 7, 65, 25, $SS_CENTER)
GUICtrlSetFont(-1, 20)
GUICtrlSetColor(-1, 0x4A66FA)
$Label2 = GUICtrlCreateLabel("", 260, 10, 175, 25, $SS_CENTER)
GUICtrlSetFont(-1, 15, 500)
GUICtrlSetColor(-1, 0x4A66FA)
GUISetState()

_PrePare(220, 135, 0xFFFFFF)

GUISetOnEvent(-3, "Close")

$Labels[0] = GUICtrlCreateLabel("Red", 420, 75, 100, 50, BitOR($SS_CENTER, $SS_CENTERIMAGE))
GUICtrlSetColor($Labels[0], 0xFF0000)
$Labels[1] = GUICtrlCreateLabel("Yellow", 420, 150, 100, 50, BitOR($SS_CENTER, $SS_CENTERIMAGE))
GUICtrlSetColor($Labels[1], 0xFFFF00)
$Labels[2] = GUICtrlCreateLabel("Green", 420, 225, 100, 50, BitOR($SS_CENTER, $SS_CENTERIMAGE))
GUICtrlSetColor($Labels[2], 0x00FF00)
$Labels[3] = GUICtrlCreateLabel("Blue", 420, 300, 100, 50, BitOR($SS_CENTER, $SS_CENTERIMAGE))
GUICtrlSetColor($Labels[3], 0x0000FF)
For $i = 0 To UBound($Labels) - 1
	GUICtrlSetFont($Labels[$i], 22)
	GUICtrlSetBkColor($Labels[$i], 0xFFD046)
	GUICtrlSetCursor($Labels[$i], 0)
Next

_PlaySong ()

For $i = 1 To 20
	PlayTime()
	Timer()
Next

_Results($Label2, $Score, 3, "G24-L3")
_FlashControl($Label2, 400)
Sleep(1000)
Close()

While 1
	Sleep(100)
WEnd

Func Timer()
	$Count = 2
	While $Count > 0
		For $z = 0 To $Count
			If $SetC = 1 Then $Count = 0
			For $i = 99 To 0 Step - 1
				If $SetC = 1 Then ExitLoop
				If $i < 10 Then $i = "0" & $i
				ControlSetText($Hui, "", $Time, $Count & ":" & $i)
				Sleep(10)
			Next
			$Count -= 1
		Next
	WEnd
	If $SetC <> 1 Then WrongAnW()
EndFunc

Func PlayTime()
	$SetC = 0
	For $i = 0 To UBound($Gra) - 1
		GUICtrlDelete($Gra[$i])
	Next
	For $i = 0 To UBound($Labels) - 1
		GUICtrlSetOnEvent($Labels[$i], "WrongAnW")
	Next

	$Ran_Y = Random(6, 8, 1)
	Local $Array[25] = ["5,57", "70,57", "135,57", "200,57", "265,57", _
			"5,122", "70,122", "135,122", "200,122", "265,122", _
			"5,187", "70,187", "135,187", "200,187", "265,187", _
			"5,252", "70,252", "135,252", "200,252", "265,252", _
			"5,317", "70,317", "135,317", "200,317", "265,317"]
	Local $Colors[4] = ["0xFF0000", "0xFFFF00", "0x00FF00", "0x0000FF"]

	$Ran_E = Random(0, UBound($Colors) - 1, 1)
	If $Colors[$Ran_E] = "0xFF0000"  Then
		GUICtrlSetOnEvent($Labels[0], "CorrectAnW")
	ElseIf $Colors[$Ran_E] = "0xFFFF00"  Then
		GUICtrlSetOnEvent($Labels[1], "CorrectAnW")
	ElseIf $Colors[$Ran_E] = "0x00FF00"  Then
		GUICtrlSetOnEvent($Labels[2], "CorrectAnW")
	ElseIf $Colors[$Ran_E] = "0x0000FF"  Then
		GUICtrlSetOnEvent($Labels[3], "CorrectAnW")
	EndIf
	For $i = 0 To $Ran_Y
		$Ran_D = Random(0, UBound($Array) - 1, 1)
		$Split = StringSplit($Array[$Ran_D], ",")
		$Gra[$i] = GUICtrlCreateGraphic($Split[1], $Split[2], 50, 50)
		GUICtrlSetGraphic($Gra[$i], $GUI_GR_COLOR, $Colors[$Ran_E], $Colors[$Ran_E])
		GUICtrlSetGraphic($Gra[$i], $GUI_GR_ELLIPSE, 0, 0, 50, 50)
		GUICtrlSetBkColor($Gra[$i], 0x000000)
		_ArrayDelete($Array, $Ran_D)
	Next
	_ArrayDelete($Colors, $Ran_E)

	$Ran_E = Random(0, UBound($Colors) - 1, 1)
	For $a = $i + 1 To $Ran_Y + ($i - 2)
		$Ran_D = Random(0, UBound($Array) - 1, 1)
		$Split = StringSplit($Array[$Ran_D], ",")
		$Gra[$a] = GUICtrlCreateGraphic($Split[1], $Split[2], 50, 50)
		GUICtrlSetGraphic($Gra[$a], $GUI_GR_COLOR, $Colors[$Ran_E], $Colors[$Ran_E])
		GUICtrlSetGraphic($Gra[$a], $GUI_GR_ELLIPSE, 0, 0, 50, 50)
		GUICtrlSetBkColor($Gra[$a], 0x000000)
		_ArrayDelete($Array, $Ran_D)
	Next
	_ArrayDelete($Colors, $Ran_E)

	$Ran_E = Random(0, UBound($Colors) - 1, 1)
	For $b = $a + 1 To $Ran_Y + ($a - 2)
		$Ran_D = Random(0, UBound($Array) - 1, 1)
		$Split = StringSplit($Array[$Ran_D], ",")
		$Gra[$b] = GUICtrlCreateGraphic($Split[1], $Split[2], 50, 50)
		GUICtrlSetGraphic($Gra[$b], $GUI_GR_COLOR, $Colors[$Ran_E], $Colors[$Ran_E])
		GUICtrlSetGraphic($Gra[$b], $GUI_GR_ELLIPSE, 0, 0, 50, 50)
		GUICtrlSetBkColor($Gra[$b], 0x000000)
		_ArrayDelete($Array, $Ran_D)
	Next
EndFunc

Func CorrectAnW()
	$SetC = 1
	TurnOFF()
	If $xPos = 185 Then
		$xPos = -15
		$yPos += 20
	EndIf
	$xPos += 20
	$AddPic = GUICtrlCreatePic($PicPath & "Correct.bmp", $xPos, $yPos, 16, 16)
	SoundPlay($SoundPath & "Correct.wav")
	_FlashControl($AddPic, 300)
	$Score += 1
EndFunc

Func WrongAnW()
	$SetC = 1
	TurnOFF()
	If $xPos = 185 Then
		$xPos = -15
		$yPos += 20
	EndIf
	$xPos += 20
	$AddPic = GUICtrlCreatePic($PicPath & "False.bmp", $xPos, $yPos, 16, 16)
	SoundPlay($SoundPath & "False.wav")
	_FlashControl($AddPic, 300)
EndFunc

Func TurnOFF()
	GUICtrlSetData($Time, "03:00")
	For $b = 0 To UBound($Labels) - 1
		GUICtrlSetOnEvent($Labels[$b], "")
	Next
EndFunc