;==========================================================================================
; Description:      Brain Pain - Brain Flexibility and Stress Degree Test
; Author(s):        MrBond007 (Baki G)
;					Credits also goes to the authors of Array.au3
;
;					Remember if you like This game and AutoIt Donate to the AutoIt Project:
;					http://www.autoitscript.com/donate.php
;==========================================================================================
#include <GUIConstants.au3>
#include <Array.au3>
#include <Bass.au3>
#NoTrayIcon

If WinExists("Brain Pain") Then Exit
Local $bassdll, $Init[1]
Local $MusicPath = "Resources\Music\"
Local $SoundPath = "Resources\Sounds\"
Local $PicPath = "Resources\Pictures\Beta\"
Local $PicPath2 = "Resources\Pictures\Gamma\"
Local $PkA[12], $PcA[12], $Alfa[12], $Omega[12], $a = 0, $c = 0, $d = 0, $e = 0, $m = 0
Local $add = 0, $amm = "00", $enable = 1
Local $Alfa2[12] = ["13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"]
Local $Omega2[12] = ["13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23"]

Opt("GUIOnEventMode", 1)
Opt("GUICloseOnESC", 0)
$Hui = GUICreate("Brain Pain", 500, 390, -1, -1, BitOR($WS_POPUP, $WS_BORDER))
GUISetBkColor(0xFFFFFF)

$Gra1 = GUICtrlCreateGraphic(0, 45, 500, 1)
GUICtrlSetBkColor(-1, 0x000000)
$Gra2 = GUICtrlCreateGraphic(410, 5, 85, 35)
GUICtrlSetColor(-1, 0x4A66FA)
$Time = GUICtrlCreateLabel("00:00", 420, 7, 65, 25, $SS_CENTER)
GUICtrlSetFont(-1, 20)
GUICtrlSetColor(-1, 0x4A66FA)
GUISetState()

_PrePare(200, 135, 0x4A66FA)

GUISetOnEvent(-3, "Close")

$Label = GUICtrlCreateLabel("Click on", 10, 7, 100, 30)
GUICtrlSetFont(-1, 20)
GUICtrlSetColor(-1, 0x4A66FA)
$Image = GUICtrlCreatePic($PicPath & "1.jpg", 120, 0, 45, 45)
GUICtrlSetState(-1, $GUI_DISABLE)

_CreateAlfa()

_PlaySong()
AdlibEnable("_Timer", 1000)

While 1
	Sleep(100)
WEnd

Func _Timer()
	$add += 1
	If $add < 10 Then
		$add = "0" & $add
	ElseIf $add > 59 Then
		$add = "00"
		$amm += 1
		If $amm < 10 Then
			$amm = "0" & $amm
		ElseIf $amm = 99 Then
			AdlibDisable()
			_Result()
		EndIf
	EndIf
	ControlSetText($Hui, "", $Time, $amm & ":" & $add)
EndFunc

Func _Define()
	Global $PkA[12], $PcA[12], $Alfa[12], $Omega[12]
	For $i = 0 To 11
		$PkA[$i] = $i + 1
		$PcA[$i] = $i + 1
	Next
	For $i = 0 To 11
		$Alfa[$i] = $i + 1
		$Omega[$i] = $i + 1
	Next
EndFunc

Func _CreateAlfa()
	_Define()
	Global $Array[54] = ["10,60", "60,60", "115,60", "170,60", "225,60", "280,60", "335,60", _
			"390,60", "445,60", "10,115", "60,115", "115,115", "170,115", "225,115", _
			"280,115", "335,115", "390,115", "445,115", "10,170", "60,170", "115,170", _
			"170,170", "225,170", "280,170", "335,170", "390,170", "445,170", "10,225", _
			"60,225", "115,225", "170,225", "225,225", "280,225", "335,225", "390,225", _
			"445,225", "10,280", "60,280", "115,280", "170,280", "225,280", "280,280", _
			"335,280", "390,280", "445,280", "10,335", "60,335", "115,335", "170,335", _
			"225,335", "280,335", "335,335", "390,335", "445,335"]
	For $i = 0 To UBound($PkA)-1
		$Ran_D = Random(0, UBound($Array) - 1, 1)
		$Split = StringSplit($Array[$Ran_D], ",")
		$PkA[$i] = GUICtrlCreatePic($PicPath & $Alfa[$i] & ".jpg", $Split[1], $Split[2], 45, 45)
		GUICtrlSetCursor($PkA[$i], 0)
		_ArrayDelete($Array, $Ran_D)
	Next
	For $i = 0 To UBound($PcA)-1
		$Ran_D = Random(0, UBound($Array) - 1, 1)
		$Split = StringSplit($Array[$Ran_D], ",")
		$PcA[$i] = GUICtrlCreatePic($PicPath2 & "Gamma" & $Omega[$i] & ".jpg", $Split[1], $Split[2], 45, 45)
		GUICtrlSetCursor($PcA[$i], 0)
		_ArrayDelete($Array, $Ran_D)
	Next
	GUICtrlSetOnEvent($PkA[0], "_PlayTime")
	GUICtrlSetState($Image, $GUI_HIDE)
	GUICtrlSetState($Label, $GUI_HIDE)
	$Array = ""
EndFunc

Func _PlayTime()
	Global $ray[54] = ["10,60", "60,60", "115,60", "170,60", "225,60", "280,60", "335,60", _
			"390,60", "445,60", "10,115", "60,115", "115,115", "170,115", "225,115", _
			"280,115", "335,115", "390,115", "445,115", "10,170", "60,170", "115,170", _
			"170,170", "225,170", "280,170", "335,170", "390,170", "445,170", "10,225", _
			"60,225", "115,225", "170,225", "225,225", "280,225", "335,225", "390,225", _
			"445,225", "10,280", "60,280", "115,280", "170,280", "225,280", "280,280", _
			"335,280", "390,280", "445,280", "10,335", "60,335", "115,335", "170,335", _
			"225,335", "280,335", "335,335", "390,335", "445,335"]
	For $i = 0 To UBound($PkA) - 1
		$Ran_Y = Random(0, UBound($ray) - 1, 1)
		$Split = StringSplit($ray[$Ran_Y], ",")
		GUICtrlSetPos($PkA[$i], $Split[1], $Split[2])
		_ArrayDelete($ray, $Ran_Y)
		$Ran_Y = Random(0, UBound($ray) - 1, 1)
		$Split = StringSplit($ray[$Ran_Y], ",")
		GUICtrlSetPos($PcA[$i], $Split[1], $Split[2])
		_ArrayDelete($ray, $Ran_Y)
	Next

	For $i = 0 To UBound($PkA) - 1
		GUICtrlSetOnEvent($PkA[$i], "_HideIt")
		GUICtrlSetOnEvent($PcA[$i], "_HideIt")
	Next

	If $a = 1 Then
		GUICtrlSetImage($Image, $PicPath & $Alfa[$c] & ".jpg")
		GUICtrlSetOnEvent($PkA[$c], "_PlayTime")
		$a = 0
		$d += 1
	ElseIf $a = 0 Then
		GUICtrlSetImage($Image, $PicPath2 & "Gamma" & $Omega[$d] & ".jpg")
		GUICtrlSetOnEvent($PcA[$c], "_PlayTime")
		$a = 1
		$c += 1
	EndIf
	If $d = 11 Then _Result()

	If $a = 1 Then
		GUICtrlSetImage($PkA[$e], $PicPath & $Alfa2[$m] & ".jpg")
		$m += 1
	ElseIf $a = 0 Then
		GUICtrlSetImage($PcA[$e], $PicPath2 & "Gamma" & $Omega2[$m] & ".jpg")
		$e += 1
	EndIf
	GUICtrlSetState($Image, $GUI_HIDE)
	GUICtrlSetState($Label, $GUI_HIDE)
EndFunc

Func _HideIt()
	If $enable = 1 Then
		GUICtrlSetState($Image, $GUI_SHOW)
		GUICtrlSetState($Label, $GUI_SHOW)
		$enable = 0
	EndIf
	$enable += 1
EndFunc

Func _Result()
	For $i = 0 To UBound($PkA)-1
		GUICtrlDelete($PkA[$i])
		GUICtrlDelete($PcA[$i])
	Next
	GUICtrlDelete($Gra1)
	GUICtrlDelete($Gra2)
	GUICtrlDelete($Time)
	GUICtrlDelete($Label)
	GUICtrlDelete($Image)
	$Label = GUICtrlCreateLabel("Brain Flexibility : ", 15, 105, 250, 35)
	GUICtrlSetFont(-1, 20, 900)
	GUICtrlSetColor(-1, 0x000000)
	$Label2 = GUICtrlCreateLabel("", 255, 55, 235, 150)
	GUICtrlSetFont(-1, 80, 700)
	GUICtrlSetColor(-1, 0x000000)
	$Label3 = GUICtrlCreateLabel("Stress Level : ", 15, 255, 250, 35)
	GUICtrlSetFont(-1, 20, 900)
	GUICtrlSetColor(-1, 0x000000)
	$Label4 = GUICtrlCreateLabel("", 255, 205, 235, 150)
	GUICtrlSetFont(-1, 80, 700)
	GUICtrlSetColor(-1, 0x000000)
	AdlibDisable()
	For $i = 1 To 80
		$Ran_E = Random(10, 99, 1)
		$Ran_Y = Random(10, 99, 1)
		ControlSetText($Hui, "", $Label2, $Ran_E)
		ControlSetText($Hui, "", $Label4, $Ran_Y)
		Sleep(35)
	Next
	If $amm > 0 Then $amm = $amm * 60
	$Calc = $amm + $add
	$Calc2 = $Calc
	Select
		Case $Calc < 42
			$Calc = 20
		Case $Calc >= 42 And $Calc <= 50
			$val1 = $Calc / 20
			$val2 = ($val1 / 2) / 10
			$Calc = Round(($val1 + $val2) * 10)
		Case $Calc > 50 And $Calc <= 65
			$val1 = $Calc / 20
			$val2 = $val1 / 10
			$Calc = Round(($val1 + $val2) * 10)
		Case $Calc > 65 And $Calc <= 70
			$Calc = Round($Calc / 1.75)
		Case $Calc > 70 And $Calc <= 89
			$Calc = Round($Calc / 1.7)
		Case $Calc > 90
			$Calc = 60
	EndSelect
	$Flex = Round(($Calc*90)/60)
	If $Flex > 99 Then $Flex = 99
	$Stress = _CalcuateStress($Calc2)
	ControlSetText($Hui, "", $Label2, $Flex & "%")
	ControlSetText($Hui, "", $Label4, $Stress & "%")
	Sleep(5000)
	Close()
EndFunc

Func _CalcuateStress($Value)
	If $Value > 20 And $Value < 30 Then
		Return Round(75-($Value/85))
	ElseIf $Value >= 30 And $Value < 40 Then
		Return Round(55-($Value/65))
	ElseIf $Value >= 40 And $Value < 50 Then
		Return Round(35-($Value/45))
	ElseIf $Value >= 50 And $Value <= 60 Or $Value > 60 And $Value <= 99 Then
		Return Round(15-($Value/25))
	ElseIf $Value > 99 Then
		Return 10
	EndIf
EndFunc