#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=CDCOVERS.ico
#AutoIt3Wrapper_outfile=CDCOVERS.exe
#AutoIt3Wrapper_Res_Description=This is a website wrapper for CDCOVERS.CC that allows you to easily search for and save covers.
#AutoIt3Wrapper_Res_Fileversion=1.1.4.1
#AutoIt3Wrapper_Res_Fileversion_AutoIncrement=p
#AutoIt3Wrapper_Res_LegalCopyright=Big_Daddy Scripting
#AutoIt3Wrapper_Res_Language=1033
#AutoIt3Wrapper_Run_AU3Check=n
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
;
#comments-start
	CDCOVERS.CC Downloader.au3 v1.1.4.1 Dec. 18, 2007
	Bob Anthony (big_daddy)
#comments-end
#include <IE.au3>
#include <GuiListView.au3>
#include <GuiListBox.au3>
#include <GuiComboBox.au3>
#include <GUIStatusBar.au3>
#include <GUIConstants.au3>

Opt("GUIOnEventMode", True)

#region Global Variables
Global _
		$sImgName = "", _
		$iMaxWidth = 400, _
		$iMaxHeight = 335, _
		$TempDir = @AppDataDir & "\Big_Daddy Scripting\CDCOVERS\", _
		$aStatusParts[2] = [420, -1], _
		$aTempStatus[2] = ["", ""]
#endregion
#region Prereq
#comments-start
	Clean-up temp directory from previous versions.
#comments-end
DirRemove(@TempDir & "\CDCOVERS", 1)
#comments-start
	Register the IE Error Handler to avoid script termination.
#comments-end
_IEErrorHandlerRegister()
#comments-start
	Check to see if the images have already been downloaded.
	If not, download them and store them for later use.
#comments-end
DirCreate($TempDir)
If Not FileExists($TempDir & "hdr_logo.jpg") Then
	InetGet("http://www.cdcovers.cc/images/hdr_logo.jpg", $TempDir & "hdr_logo.jpg")
EndIf
If Not FileExists($TempDir & "favicon.ico") Then
	InetGet("http://www.cdcovers.cc/favicon.ico", $TempDir & "favicon.ico")
EndIf
#comments-start
	Toggle IE Images off to save on load times.
	Create our hidden browser window.
	Toggle IE Images back on for any user opened browser windows.
#comments-end
_ToggleImages(False)
$oIE = _IECreate("about:blank", 0, 0, 0)
_ToggleImages(True)
#endregion
#region GUI
$GUI = GUICreate("CDCOVERS.CC Downloader -=Big_Daddy Style=-", 681, 441)
GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit")
GUISetIcon($TempDir & "favicon.ico")
$Pic1 = GUICtrlCreatePic($TempDir & "hdr_logo.jpg", 10, 9, 400, 60, BitOR($SS_NOTIFY, $WS_GROUP))
GUICtrlSetOnEvent(-1, "_VisitWebpage")
GUICtrlSetTip(-1, "Visit the CDCOVERS.CC Homepage")
$Pic2 = GUICtrlCreatePic("", 10, 75, 400, 335, BitOR($SS_NOTIFY, $SS_CENTERIMAGE, $SS_SUNKEN, $WS_GROUP))
GUICtrlSetOnEvent(-1, "_OpenPicture")
$StatusBar1 = _GUICtrlStatusBar_Create($GUI, $aStatusParts, $aTempStatus, $SBARS_SIZEGRIP)
_GUICtrlStatusBar_SetMinHeight($StatusBar1, 20)
_GUICtrlStatusBar_SetText($StatusBar1, "Select your search criteria.")
GUICtrlSetFont(-1, 10, 800, 0, "Verdana")
GUICtrlSetColor(-1, 0x585768)
$Combo1 = GUICtrlCreateCombo("Select cover type...", 420, 10, 145, 25)
GUICtrlSetOnEvent(-1, "_SelectCoverType")
GUICtrlSetData(-1, "Audio|Blu-ray|Bollywood|CDi|Dreamcast|DS|DVD|GameCube|Gameboy Advance|" & _
		"HD DVD|Karaoke|PC|PSP|Playstation|Playstation 2|Playstation 3|VCD|VHS|Wii|Xbox|Xbox 360")
$Combo2 = GUICtrlCreateCombo("...", 420, 40, 145, 25)
GUICtrlSetOnEvent(-1, "_SelectCoverLetter")
GUICtrlSetState(-1, $GUI_DISABLE)
$Combo3 = GUICtrlCreateCombo("...", 420, 70, 145, 25)
GUICtrlSetOnEvent(-1, "_SelectCoverPart")
GUICtrlSetState(-1, $GUI_DISABLE)
$Input1 = GUICtrlCreateInput("...", 420, 100, 145, 20)
GUICtrlSetOnEvent(-1, "_SearchTitles")
GUICtrlSetState(-1, $GUI_DISABLE)
$Button1 = GUICtrlCreateButton("New Search", 595, 10, 75, 25, 0)
GUICtrlSetOnEvent(-1, "_NewSearch")
$Button2 = GUICtrlCreateButton("Search", 595, 40, 75, 25, 0)
GUICtrlSetOnEvent(-1, "_Search")
GUICtrlSetState(-1, $GUI_DISABLE)
$Button3 = GUICtrlCreateButton("Preview", 595, 70, 75, 25, 0)
GUICtrlSetOnEvent(-1, "_Preview")
GUICtrlSetState(-1, $GUI_DISABLE)
$Button4 = GUICtrlCreateButton("Save", 595, 100, 75, 25, 0)
GUICtrlSetOnEvent(-1, "_Save")
GUICtrlSetState(-1, $GUI_DISABLE)
$List1 = GUICtrlCreateList("", 420, 135, 250, 230, BitOR($LBS_NOTIFY, $WS_VSCROLL, $WS_BORDER))
GUICtrlSetOnEvent(-1, "_SelectTitle")
$Button5 = GUICtrlCreateButton("<<", 455, 365, 20, 25, 0)
GUICtrlSetOnEvent(-1, "_ChangePage")
GUICtrlSetState(-1, $GUI_DISABLE)
$Button6 = GUICtrlCreateButton("<", 480, 365, 20, 25, 0)
GUICtrlSetOnEvent(-1, "_ChangePage")
GUICtrlSetState(-1, $GUI_DISABLE)
$Button7 = GUICtrlCreateButton(">", 590, 365, 20, 25, 0)
GUICtrlSetOnEvent(-1, "_ChangePage")
GUICtrlSetState(-1, $GUI_DISABLE)
$Button8 = GUICtrlCreateButton(">>", 615, 365, 20, 25, 0)
GUICtrlSetOnEvent(-1, "_ChangePage")
GUICtrlSetState(-1, $GUI_DISABLE)
$Button9 = GUICtrlCreateButton("GO", 590, 395, 25, 22, 0)
GUICtrlSetOnEvent(-1, "_Go")
GUICtrlSetState(-1, $GUI_DISABLE)
$Label1 = GUICtrlCreateLabel("Jump to:", 505, 395, 44, 20, $SS_CENTERIMAGE)
$Input2 = GUICtrlCreateInput("1", 550, 395, 36, 21)
GUICtrlSetState(-1, $GUI_DISABLE)
$Updown1 = GUICtrlCreateUpdown($Input2)
$Label2 = GUICtrlCreateLabel("...", 505, 365, 80, 25, BitOR($SS_CENTER, $SS_CENTERIMAGE, $SS_SUNKEN))
GUISetState(@SW_SHOW)
#endregion

While 1
	Sleep(50)
WEnd

Func _Save()
	;
	Local $sSavePath

	If $sImgName <> "" Then
		$sSavePath = FileSaveDialog("Save Image", @MyDocumentsDir, "JPEG Image (*.jpg)", 18, $sImgName)
		If Not @error Then
			FileCopy($TempDir & $sImgName, $sSavePath, 1)
			If Not @error Then
				_GUICtrlStatusBar_SetText($StatusBar1, "The image file was saved successfully.")
			Else
				_GUICtrlStatusBar_SetText($StatusBar1, "There was a problem while trying to save the image file.")
			EndIf
		EndIf
	Else
		_GUICtrlStatusBar_SetText($StatusBar1, "You must first preview the image.")
	EndIf
EndFunc   ;==>_Save

Func _Go()
	$aURL = StringRegExp(_IEPropertyGet($oIE, "locationurl"), "(http://www.cdcovers.cc/list/.*/.*/)", 1)
	If Not @error Then
		_IENavigate($oIE, $aURL[0] & GUICtrlRead($Input2))
		_UpdatePageInfo()
		_PopulateList()
	EndIf
EndFunc   ;==>_Go

Func _Preview()

	_ResetGUI()
	;
	Local $sPart, $sStatus, $iPart, $oForm, $oButton, $oDiv, $oLink, $URL, _
			$oImg, $sSRC, $aImageDims, $iWidth, $iHeight, $iAspect = 1

	$sPart = GUICtrlRead($Combo3)
	; If a part has not been selected then we won't proceed
	If StringInStr($sPart, "...") Then
		_GUICtrlStatusBar_SetText($StatusBar1, "You must first select the part you want to preview.")
		Return
	EndIf
	
	; Disable other options so they don't interfer with the current process
	GUICtrlSetState($Button1, $GUI_DISABLE)
	GUICtrlSetState($Button2, $GUI_DISABLE)
	GUICtrlSetState($Button3, $GUI_DISABLE)
	GUICtrlSetState($Button4, $GUI_DISABLE)

	_GUICtrlStatusBar_SetText($StatusBar1, "Please wait while the preview is loaded.")
	; Store the current URL so we can make sure we get back there
	$sURL = _IEPropertyGet($oIE, "locationurl")
	; Get the selected index that refers to the part link
	$iPart = _GUICtrlComboBox_GetCurSel($Combo3) - 1
	; Get reference to the div that contains the part links
	$oDiv = _IEGetObjByName($oIE, "titleParts")
	; Get reference to the specific part link
	$oLink = _IETagNameGetCollection($oDiv, "a", $iPart)
	; Click the link which then fires a javascript command
	_IEAction($oLink, "click")
	_IELoadWait($oIE)
	$oImgs = _IEImgGetCollection($oIE)
	For $oImg In $oImgs
		If StringInStr(String($oImg.src), "http://static.cdcovers.cc/") And Not _
				StringInStr(String($oImg.src), "http://static.cdcovers.cc/thumbs/") Then
			$sSRC = String($oImg.src)
			$sImgName = String($oImg.nameProp)
			ExitLoop
		EndIf
	Next
	; Make sure we actually matched an image
	If $sSRC = "" Or $sImgName = "" Then
		_GUICtrlStatusBar_SetText($StatusBar1, "There was an error while loading the preview.")
		Return
	EndIf
	; Replace the escaped html characters
	$sImgName = StringReplace($sImgName, "%5B", "[")
	$sImgName = StringReplace($sImgName, "%5D", "]")
	; Go back to the previous search page
	_IENavigate($oIE, $sURL, 0)
	; Check whether the image is in cache or not
	If Not FileExists($TempDir & $sImgName) Then
		; Attempt to get the file size of the image
		$iImageSize = InetGetSize($sSRC)
		If @error Then
			$iImageSize = "Unknown"
		EndIf
		; Allow the download process to be aborted, so images are extremly large
		HotKeySet("{Esc}", "_AbortDownload")
		_GUICtrlStatusBar_SetText($StatusBar1, "You may press 'Esc' to cancel the download.")
		; Start downloading the image
		$bImageSuccess = InetGet($sSRC, $TempDir & $sImgName, 1, 1)
		; Update the statusbar with the current progress
		While @InetGetActive
			_GUICtrlStatusBar_SetText($StatusBar1, "Downloading: " & _
					Round(@InetGetBytesRead / 1024) & "KB of " & Round($iImageSize / 1024) & "KB", 1)
			Sleep(100)
		WEnd
		HotKeySet("{Esc}")
		; If the local file size doesn't match the remote then something went wrong
		If FileGetSize($TempDir & $sImgName) < $iImageSize Then
			FileDelete($TempDir & $sImgName)
			$bImageSuccess = False
		EndIf
	Else
		$iImageSize = FileGetSize($TempDir & $sImgName)
		$bImageSuccess = True
	EndIf

	If $bImageSuccess Then
		; Return the dimensions of the image to an array
		$aImageDims = _GetImageDims($TempDir & $sImgName)
		If Not @error Then
			; Figure the maximum size the image can be viewed, but still display with the correct aspect ratio
			If $aImageDims[0] > $iMaxWidth Then $iAspect = $iMaxWidth / $aImageDims[0]
			$iWidth = $iAspect * $aImageDims[0]
			$iHeight = $iAspect * $aImageDims[1]
			If $iHeight > $iMaxHeight Then
				$iWidth = $iWidth * ($iMaxHeight / $iHeight)
				$iHeight = $iMaxHeight
			EndIf
			; Ajust the image control size
			GUICtrlSetPos($Pic2, 10, 75, $iWidth, $iHeight)
			; Display some useful information when the mouse is over the image
			GUICtrlSetTip($Pic2, "Image Information - (Click image to open in default image viewer.)" & @CRLF & @CRLF & _
					"Name - " & $sImgName & @CRLF & _
					"Dimensions - " & $aImageDims[0] & "x" & $aImageDims[1] & @CRLF & _
					"Size - " & Round($iImageSize / 1024) & "KB")
		EndIf
		; Display the image in the GUI
		GUICtrlSetImage($Pic2, $TempDir & $sImgName)
		_GUICtrlStatusBar_SetText($StatusBar1, "The image was downloaded successfully.")
		GUICtrlSetState($Button4, $GUI_ENABLE)
	Else
		_GUICtrlStatusBar_SetText($StatusBar1, "There was a problem downloading the image.")
	EndIf
	_GUICtrlStatusBar_SetText($StatusBar1, "", 1)
	_IELoadWait($oIE)
	$iTitle = _GUICtrlListBox_GetCurSel($List1)
	$oSelect = _IEGetObjByName($oIE, "titleList")
	_IEFormElementOptionSelect($oSelect, $iTitle, 1, "byIndex")
	GUICtrlSetState($Button1, $GUI_ENABLE)
	GUICtrlSetState($Button3, $GUI_ENABLE)
EndFunc   ;==>_Preview

Func _QuickPreview()

	Local $sPart, $sStatus, $iPart, $oForm, $oButton, $oDiv, $oLink, $URL, _
			$oImg, $sSRC, $aImageDims, $iWidth, $iHeight, $iAspect = 1

	$sImgName = ""
	GUICtrlSetTip($Pic2, "")
	GUICtrlSetImage($Pic2, "")
	GUICtrlSetPos($Pic2, 10, 75, $iMaxWidth, $iMaxHeight)
	
	$sPart = GUICtrlRead($Combo3)
	; If a part has not been selected then we won't proceed
	If StringInStr($sPart, "...") Then Return
	
	_GUICtrlStatusBar_SetText($StatusBar1, "Please wait while the thumbnail is loaded.")
	_IELoadWait($oIE)
	; Get the selected index that refers to the part link
	$iPart = _GUICtrlComboBox_GetCurSel($Combo3) - 1
	; Get reference to the div that contains the part links
	$oDiv = _IEGetObjByName($oIE, "titleParts")
	; Get reference to the specific part link
	$oLink = _IETagNameGetCollection($oDiv, "a", $iPart)
	$oLink.fireEvent("onmouseover")
	While Not IsObj($oImg)
		$oImg = _IEGetObjById($oIE, "thumbnailMOImg")
		Sleep(10)
	WEnd
	_IELoadWait($oImg)
;~ 	$oImg = _IEImgGetCollection($oThumb, 0)
;~ 	If @error Then
;~ 		_GUICtrlStatusBarSetText($StatusBar1, "There was an error while loading the thumbnail.")
;~ 		Return
;~ 	EndIf
	$sSRC = String($oImg.src)
	If $sSRC = "" Then
		_GUICtrlStatusBar_SetText($StatusBar1, "There was an error while loading the thumbnail.")
		Return
	EndIf
	
	$oLink.fireEvent("onmouseout")
	
	; Start downloading the thumbnail
	$bImageSuccess = InetGet($sSRC, $TempDir & "thumb.jpg")
	
	If $bImageSuccess Then
		; Return the dimensions of the image to an array
		$aImageDims = _GetImageDims($TempDir & "thumb.jpg")
		If Not @error Then
			; Figure the maximum size the image can be viewed, but still display with the correct aspect ratio
			If $aImageDims[0] > $iMaxWidth Then $iAspect = $iMaxWidth / $aImageDims[0]
			$iWidth = $iAspect * $aImageDims[0]
			$iHeight = $iAspect * $aImageDims[1]
			If $iHeight > $iMaxHeight Then
				$iWidth = $iWidth * ($iMaxHeight / $iHeight)
				$iHeight = $iMaxHeight
			EndIf
			; Ajust the image control size
			GUICtrlSetPos($Pic2, 10, 75, $iWidth, $iHeight)
			; Display some useful information when the mouse is over the image
			GUICtrlSetTip($Pic2, "Click preview to view the full size image.")
		EndIf
		; Display the image in the GUI
		GUICtrlSetImage($Pic2, $TempDir & "thumb.jpg")
		_GUICtrlStatusBar_SetText($StatusBar1, "Click preview to view the full size image.")
		GUICtrlSetState($Button4, $GUI_ENABLE)
	Else
		_GUICtrlStatusBar_SetText($StatusBar1, "There was a problem downloading the thumbnail.")
	EndIf
EndFunc   ;==>_QuickPreview

Func _NewSearch()
	;
	_ResetGUI()

	GUICtrlSetState($Combo2, $GUI_DISABLE)
	GUICtrlSetState($Combo3, $GUI_DISABLE)
	GUICtrlSetState($Button2, $GUI_DISABLE)
	GUICtrlSetState($Button3, $GUI_DISABLE)
	GUICtrlSetState($Button4, $GUI_DISABLE)
	GUICtrlSetState($Button5, $GUI_DISABLE)
	GUICtrlSetState($Button6, $GUI_DISABLE)
	GUICtrlSetState($Button7, $GUI_DISABLE)
	GUICtrlSetState($Button8, $GUI_DISABLE)
	GUICtrlSetState($Button9, $GUI_DISABLE)
	GUICtrlSetState($Input1, $GUI_DISABLE)
	GUICtrlSetState($Input2, $GUI_DISABLE)

	_GUICtrlComboBox_SetCurSel($Combo1, 0)
	GUICtrlSetData($Combo2, "")
	GUICtrlSetData($Combo2, "...", "...")
	GUICtrlSetData($Combo3, "")
	GUICtrlSetData($Combo3, "...", "...")
	_GUICtrlListBox_ResetContent($List1)
	_GUICtrlStatusBar_SetText($StatusBar1, "Select your search criteria.")
	_GUICtrlStatusBar_SetText($StatusBar1, "", 1)
EndFunc   ;==>_NewSearch

Func _Search()
	;
	_ResetGUI()

	Local $sType, $sLetter

	GUICtrlSetState($Combo3, $GUI_DISABLE)
	GUICtrlSetState($Button1, $GUI_DISABLE)
	GUICtrlSetState($Button2, $GUI_DISABLE)
	GUICtrlSetState($Button3, $GUI_DISABLE)
	GUICtrlSetState($Button4, $GUI_DISABLE)
	GUICtrlSetState($Button5, $GUI_DISABLE)
	GUICtrlSetState($Button6, $GUI_DISABLE)
	GUICtrlSetState($Button7, $GUI_DISABLE)
	GUICtrlSetState($Button8, $GUI_DISABLE)
	GUICtrlSetState($Button9, $GUI_DISABLE)
	GUICtrlSetState($Input1, $GUI_DISABLE)
	GUICtrlSetState($Input2, $GUI_DISABLE)

	GUICtrlSetData($Combo3, "")
	GUICtrlSetData($Combo3, "...", "...")
	$sType = StringLower(GUICtrlRead($Combo1))
	$sLetter = StringLower(GUICtrlRead($Combo2))
	If StringInStr($sType, "...") Or StringInStr($sLetter, "...") Then
		_GUICtrlStatusBar_SetText($StatusBar1, "You must first select your search criteria.")
		Return 0
	EndIf
	Switch $sType
		Case "Blu-ray"
			$sType = "bluray"
		Case "Gameboy Advance"
			$sType = "gba"
		Case "HD DVD"
			$sType = "hddvd"
		Case "Playstation"
			$sType = "psx"
		Case "Playstation 2"
			$sType = "ps2"
		Case "Playstation 3"
			$sType = "ps3"
		Case "Xbox 360"
			$sType = "xbox360"
	EndSwitch
	If $sLetter = "#"  Then $sLetter = "0"
	_GUICtrlStatusBar_SetText($StatusBar1, "Please wait while your search is conducted.")
	_IENavigate($oIE, "http://www.cdcovers.cc/list/" & $sType & "/" & $sLetter & "/")

	_PopulateList()

	WinActivate($GUI)
	GUICtrlSetData($Input1, "Type search here...")
	_GUICtrlStatusBar_SetText($StatusBar1, "Select your title and then one of the available cover parts.")

	_UpdatePageInfo()
	If Not @error Then
		GUICtrlSetState($Input2, $GUI_ENABLE)
		GUICtrlSetState($Button5, $GUI_ENABLE)
		GUICtrlSetState($Button6, $GUI_ENABLE)
		GUICtrlSetState($Button7, $GUI_ENABLE)
		GUICtrlSetState($Button8, $GUI_ENABLE)
		GUICtrlSetState($Button9, $GUI_ENABLE)
	EndIf

	GUICtrlSetState($Button1, $GUI_ENABLE)
	GUICtrlSetState($Input1, $GUI_ENABLE)
	GUICtrlSetState($Input1, $GUI_FOCUS)
EndFunc   ;==>_Search

Func _ChangePage()
	$hID = @GUI_CtrlId
	Switch $hID
		Case $Button5
			_IELinkClickByText($oIE, "")
			$error = @error
		Case $Button6
			_IELinkClickByText($oIE, "")
			$error = @error
		Case $Button7
			_IELinkClickByText($oIE, "")
			$error = @error
		Case $Button8
			_IELinkClickByText($oIE, "")
			$error = @error
	EndSwitch
	If $error Then
		_UpdatePageInfo()
		_PopulateList()
	EndIf
EndFunc   ;==>_ChangePage

Func _PopulateList()
	Local $i = 0, $oSelect, $oItems, $iLength

	_GUICtrlListBox_ResetContent($List1)
	$oSelect = _IEGetObjByName($oIE, "titleList")
	If @error Then
		_GUICtrlStatusBar_SetText($StatusBar1, "An error occured while processing the list.")
		Return 0
	EndIf
	$oItems = $oSelect.Options
	$iLength = ($oItems.Length)
	For $oItem In $oItems
		$i += 1
		_GUICtrlListBox_AddString($List1, $oItem.text)
		_GUICtrlStatusBar_SetText($StatusBar1, "Processing " & $i & " of " & $iLength, 1)
	Next
	_GUICtrlStatusBar_SetText($StatusBar1, "Total titles: " & $iLength, 1)
EndFunc   ;==>_PopulateList

Func _UpdatePageInfo()
	;
	Local $oDivs, $oPageDiv, $oAnchors, $sText, $sCurrent, $aLast, $sLast = "", $sOut

	$oDivs = _IETagNameGetCollection($oIE, "DIV")
	For $oDiv In $oDivs
		If String($oDiv.className) = "pagerBox"  Then
			$oPageDiv = $oDiv
			ExitLoop
		EndIf
	Next
	If Not IsObj($oPageDiv) Then Return SetError(1, 0, 0)
	$oAnchors = _IETagNameGetCollection($oDiv, "A")
	If @extended > 1 Then
		For $oAnchor In $oAnchors
			$sText = String($oAnchor.outerText)
			If String($oAnchor.className) = "currentPage"  Then
				$sCurrent = $sText
			ElseIf $sText = ""  Then
				$aLast = StringRegExp($oAnchor.href, "http://www.cdcovers.cc/list/\w*/\w*/(.\w*)", 1)
				If Not @error Then $sLast = $aLast[0]
			EndIf
		Next
	Else
		Return SetError(1, 0, 0)
	EndIf
	If $sLast = "" Then $sLast = $sCurrent
	$sOut = "Page " & $sCurrent & " of " & $sLast
	GUICtrlSetData($Label2, $sOut)
	GUICtrlSetData($Input2, 1)
	GUICtrlSetLimit($Updown1, $sLast, 1)
EndFunc   ;==>_UpdatePageInfo

Func _SelectCoverType()
	;
	Local $sText

	GUICtrlSetData($Combo2, "")
	GUICtrlSetData($Combo2, "Select cover letter...")
	GUICtrlSetData($Combo3, "")
	GUICtrlSetData($Combo3, "...", "...")
	$sText = "#|"
	For $i = 65 To 90
		$sText &= Chr($i) & "|"
	Next
	GUICtrlSetData($Combo2, $sText, "Select cover letter...")
	GUICtrlSetState($Combo2, $GUI_ENABLE)
EndFunc   ;==>_SelectCoverType

Func _SelectCoverPart()
	_QuickPreview()
	GUICtrlSetState($Button3, $GUI_ENABLE)
EndFunc   ;==>_SelectCoverPart

Func _SelectTitle()
	;
	Local $iTitle, $oForm, $oSelect, $oDiv, $oParts, $sText, $sParts = ""

	GUICtrlSetState($Button3, $GUI_DISABLE)

	$iTitle = _GUICtrlListBox_GetCurSel($List1)
	$oSelect = _IEGetObjByName($oIE, "titleList")
	_IEFormElementOptionSelect($oSelect, $iTitle, 1, "byIndex")
	While Not IsObj($oDiv)
		$oDiv = _IEGetObjByName($oIE, "titleParts")
	WEnd
	$oParts = _IETagNameGetCollection($oDiv, "a")
	For $oPart In $oParts
		$sText = $oPart.outerText
		$sClassName = String($oPart.className)
		If $sClassName <> "titleCover"  Then
			ExitLoop
		EndIf
		$sParts &= $sText & "|"
	Next
	GUICtrlSetData($Combo3, "")
	GUICtrlSetData($Combo3, "Select cover part...")
	GUICtrlSetData($Combo3, $sParts, "Select cover part...")
	GUICtrlSetState($Combo3, $GUI_ENABLE)
EndFunc   ;==>_SelectTitle

Func _SelectCoverLetter()
	GUICtrlSetData($Combo3, "")
	GUICtrlSetData($Combo3, "...", "...")
	If Not StringInStr(GUICtrlRead($Combo2), "...") Then
		_GUICtrlStatusBar_SetText($StatusBar1, "To search using the selected criteria click the 'Search' button.")
	EndIf

	GUICtrlSetState($Button2, $GUI_ENABLE)
EndFunc   ;==>_SelectCoverLetter

Func _SearchTitles()
	;
	Local $s_search, $i_index

	$s_search = GUICtrlRead($Input1)
	$i_index = _GUICtrlListBox_FindString($List1, $s_search)
	If $i_index <> $LB_ERR Then
		_GUICtrlListBox_SetCurSel($List1, $i_index)
		_SelectTitle()
	EndIf
EndFunc   ;==>_SearchTitles

Func _OpenPicture()
	ShellExecute($TempDir & $sImgName)
EndFunc   ;==>_OpenPicture

Func _VisitWebpage()
	ShellExecute("http://www.cdcovers.cc")
EndFunc   ;==>_VisitWebpage

Func _AbortDownload()
	InetGet("abort")
EndFunc   ;==>_AbortDownload

Func _ResetGUI()
	$sImgName = ""
	GUICtrlSetTip($Pic2, "")
	GUICtrlSetImage($Pic2, "")
	GUICtrlSetPos($Pic2, 10, 75, $iMaxWidth, $iMaxHeight)
	GUICtrlSetData($Input1, "...")
EndFunc   ;==>_ResetGUI

Func _GetImageDims($s_FilePath)
	;
	Local $size[2], $fs, $pos = 3, $marker

	$marker = _FileReadAtOffsetHEX($s_FilePath, 1, 2)

	If $marker = "424D"  Then
		$size[0] = _Dec(_FileReadAtOffsetHEX($s_FilePath, 19, 2))
		$size[1] = _Dec(_FileReadAtOffsetHEX($s_FilePath, 23, 2))
		Return ($size)
	EndIf

	If $marker = "FFD8"  Then
		$fs = FileGetSize($s_FilePath)
		While $pos < $fs
			$data = _FileReadAtOffsetHEX($s_FilePath, $pos, 4)
			If StringLeft($data, 2) = "FF"  Then
				If StringInStr("C0 C2 CA C1 C3 C5 C6 C7 C9 CB CD CE CF", StringMid($data, 3, 2)) Then
					$seg = _FileReadAtOffsetHEX($s_FilePath, $pos + 5, 4)
					$size[1] = Dec(StringLeft($seg, 4))
					$size[0] = Dec(StringRight($seg, 4))
					Return ($size)
				Else
					$pos = $pos + Dec(StringRight($data, 4)) + 2
				EndIf
			Else
				ExitLoop
			EndIf
		WEnd
		SetError(2)
		Return ("")
	EndIf
	SetError(1)
	Return ("")
EndFunc   ;==>_GetImageDims

Func _FileReadAtOffsetHEX($s_FilePath, $offset, $bytes)
	;
	Local $tstr = "", $tfile = FileOpen($s_FilePath, 0)

	FileRead($tfile, $offset - 1)
	For $i = $offset To $offset + $bytes - 1
		$tstr = $tstr & Hex(Asc(FileRead($tfile, 1)), 2)
	Next
	FileClose($tfile)
	Return ($tstr)
EndFunc   ;==>_FileReadAtOffsetHEX

Func _Dec($input)
	;
	Local $tstr = ""

	While StringLen($input) > 0
		$tstr = $tstr & StringRight($input, 2)
		$input = StringTrimRight($input, 2)
	WEnd
	Return (Dec($tstr))
EndFunc   ;==>_Dec

;===============================================================================
;
; Function Name:   _ToggleImages
; Description::    Toggles images on/off for IE.
; Parameter(s):    $f_State - Specifies whether images are turned on (Ture) or off (False).
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _ToggleImages($f_State = True)
	If $f_State Then
		$s_Status = "yes"
	Else
		$s_Status = "no"
	EndIf
	RegWrite("HKEY_CURRENT_USER\Software\Microsoft\Internet Explorer\Main", _
			"Display Inline Images", "REG_SZ", $s_Status)
EndFunc   ;==>_ToggleImages

Func _Exit()
	_IEQuit($oIE)
	Exit
EndFunc   ;==>_Exit