;========================================================================================
; Description:      Arkanoid Sports Edition
; Author(s):        mrbond007 (Baki G)
;					Northwind (Frank Abbing)
;					JPAM (JPAM van der Ouderaa)
;
;					Remember if you like AutoIt Donate to the AutoIt Project:
;					http://www.autoitscript.com/donate.php
;========================================================================================
If _Singleton("Arkanoid Sports Edition") = 0 Then Exit

#include "Plugins\ProSpeed.au3"
#include "Plugins\BassMod.au3"
#include "Plugins\Misc.au3"
#include "Plugins\Array.au3"
Opt("GUIOnEventMode", 1)
Opt("MouseCoordMode", 2)
HotKeySet("{Esc}", "Close")

Global $MainGui, $GTitle = "Arkanoid Sports Edition"
Global $ResourcePath = @ScriptDir & "\Arkanoid\"
Global $MPath = $ResourcePath & "Music\"
Global $PPath = $ResourcePath & "Pictures\"
Global $Trigger = 0, $XToAdd = -22, $OneUpCount = 5, $Count = -1
Global $SpriteX, $SpriteY, $Background, $MaskPic, $WinGetPos, $Dies = 0
Global $Ball, $BallX, $BallY, $Paddle, $PaddleX, $Equation, $EquationX, $EquationY
Global $Add = 5, $Number = 0, $LevelsCount = 0, $LoArr = 0, $HiArr = 0, $GameRunning = 1
Global $BlockID[10], $Sprites[1], $Cur_Info[1], $Goal_Info[1], $Add_Info[1], $Level[2], $OneUp[5]
Global $Sprite1 = $PPath & "ball" & Random(1, 5, 1) & ".gif", _
		$Sprite2 = $PPath & "stick.png", _
		$Sprite3 = $PPath & "level.png", _
		$Sprite4 = $PPath & "numbers.png", _
		$Sprite5 = $PPath & "get.png", _
		$Sprite6 = $PPath & "ready.png", _
		$Sprite7 = $PPath & "game.png", _
		$Sprite8 = $PPath & "over.png", _
		$BlockHit = $MPath & "001-System01.wav", _
		$PaddleHit = $MPath & "001-System02.wav", _
		$LoseHit = $MPath & "001-System03.wav"

;level 1
Global $Array1[10] = ["0","49","98","147","196","245","294","343","392","441"]
Global $Array2[3] = ["43","81","119"]

;level 2
Global $Array3[10] = ["0","49","98","147","196","245","294","343","392","441"]
Global $Array4[4] = ["43","62","81","100"]

;level 3
Global $Array5[8] = ["49","98","147","196","245","294","343","392"]
Global $Array6[6] = ["24","43","62","81","100","119"]

;level 4
Global $Array7[6] = ["0","49","147","294","392","441"]
Global $Array8[6] = ["24","43","62","81","100","119"]

;level 5
Global $Array9[10] = ["0","49","98","147","196","245","294","343","392","441"]
Global $Array10[6] = ["24","43","62","81","100","119"]

;level 6
Global $NewArray1[30] = ["0,24","49,24","98,24","147,24","196,24","245,24","294,24","343,24","392,24","441,24", _
						"49,43","98,43","147,43","196,43","245,43","294,43","343,43","392,43","98,62","147,62", _
						"196,62","245,62","294,62","343,62","147,81","196,81","245,81","294,81","196,100","245,100"]

;level 7
Global $NewArray2[30] = ["196,24","245,24","147,43","196,43","245,43","294,43","98,62","147,62","196,62","245,62", _
						"294,62","343,62","49,81","98,81","147,81","196,81","245,81","294,81","343,81","392,81", _
						"0,100","49,100","98,100","147,100","196,100","245,100","294,100","343,100","392,100","441,100"]

;level 8
Global $NewArray3[42] = ["0,24","49,24","98,24","196,24","245,24","343,24","392,24","441,24","0,43","49,43","147,43", _
						"196,43","245,43","294,43","392,43","441,43","0,62","98,62","147,62","196,62","245,62","294,62", _
						"343,62","441,62","49,81","98,81","147,81","196,81","245,81","294,81","343,81","392,81","0,100", _
						"49,100","98,100","147,100","196,100","245,100","294,100","343,100","392,100","441,100"]

;level 9
Global $NewArray4[40] = ["49,24","98,24","147,24","196,24","245,24","294,24","343,24","392,24","0,43","98,43","147,43", _
						"196,43","245,43","294,43","343,43","441,43","0,62","49,62","147,62","196,62","245,62","294,62", _
						"392,62","441,62","0,81","49,81","98,81","196,81","245,81","343,81","392,81","441,81","0,100", _
						"49,100","98,100","147,100","294,100","343,100","392,100","441,100"]

;level 10
Global $NewArray5[44] = ["0,24","49,24","98,24","147,24","294,24","343,24","392,24","441,24","0,43","49,43","98,43","147,43", _
						"196,43","245,43","294,43","343,43","392,43","441,43","0,62","49,62","147,62","196,62","245,62","294,62", _
						"392,62","441,62","0,81","49,81","98,81","147,81","196,81","245,81","294,81","343,81","392,81","441,81", _
						"0,100","49,100","98,100","147,100","294,100","343,100","392,100","441,100"]

$MainGui = GUICreate($GTitle, 491, 400)
GUISetOnEvent(-3, "Close")
GUISetState()
GUISetCursor(16)

DSoundInit()
$BlocksHit = DSoundLoad($BlockHit)
$PaddlesHit = DSoundLoad($PaddleHit)
$LosesHit = DSoundLoad($LoseHit)
$Background = Background($PPath & "fake.png", 0, 0, 491, 400)
$MaskPic = LoadImage($PPath & "mask.png", 0, 0, 491, 400, 4)
For $i = 0 To UBound($BlockID)-1
	$BlockID[$i] = LoadSprite($PPath & "block" & $i+1 & ".png")
Next

$Load_Spr1 = LoadSprite($Sprite1)
$Load_Spr2 = LoadSprite($Sprite2)
$LevelSprite = LoadSprite($Sprite3)
$NumbersSprite = loadsprite($Sprite4)
$GetSprite = loadsprite($Sprite5)
$ReadySprite = loadsprite($Sprite6)
$GameSprite = loadsprite($Sprite7)
$OverSprite = loadsprite($Sprite8)
$Ball = Sprite($Load_Spr1, 0, 0, 20, 20, 4, 1, 0, 220, 300)
$Paddle = Sprite($Load_Spr2, 0, 0, 68, 19, 5, 1, 0, 200, 360)
SetSpriteSpeed($Ball, 3, 3)
SetSpriteSpeed($Paddle, 50, 50)
SetBackAutoCollision($Ball, $MaskPic, 2, 491, 400, "")

For $i = 0 To UBound($OneUp)-1
	$XToAdd += 22
	$OneUp[$i] = Sprite($Load_Spr1, 0, 0, 20, 20, 1, 1, 0, $XToAdd, 0)
Next

WinSetState($MainGui, "", @SW_SHOW)
_Create_Level()
_PrepareTrack($MPath & "Track1.xm")
_BassVolume(25)

While 1
	Sleep(50)
	$Pos = MouseGetPos()
	MoveSprite($Paddle, $Pos[0], 360) ;move the paddle same as you move the mouse
	Select
		Case $GameRunning = 0
			FreezeGame()
		Case Collide($Ball, $Paddle) <> 0 ;how the ball bounces off the paddle
			$BallX = GetSpriteX($Ball)
			$PaddleX = GetSpriteX($Paddle)
			$Equation = $BallX - $PaddleX
			If $Equation <= 5 Then
				_Sprite_Speed_And_Move($Ball, 10, 10, 4, 3)
			ElseIf $Equation > 6 And $Equation <= 17 Then
				_Sprite_Speed_And_Move($Ball, 10, 10, 3, 3)
			ElseIf $Equation > 17 And $Equation < 29 Then
				_Sprite_Speed_And_Move($Ball, 10, 10, 1, 3)
			ElseIf $Equation >= 29 And $Equation <= 41 Then
				_Sprite_Speed_And_Move($Ball, 480, 10, 1, 3)
			ElseIf $Equation > 41 And $Equation <= 50 Then
				_Sprite_Speed_And_Move($Ball, 480, 10, 3, 3)
			Else
				_Sprite_Speed_And_Move($Ball, 480, 10, 4, 3)
			EndIf
			DSoundPlay($PaddlesHit, 0, 0)
			SetBackAutoCollision($Ball, $MaskPic, 2, 491, 400, "") ;set the ball to bounce off the walls
	EndSelect
WEnd

Func _Create_Level() ;create new level
	Local $Dim, $Resize = -1
	$Count += 1
	$LevelsCount += 1
	If $LevelsCount > 10 Then GameOver() ;when you reach 10 levels the game ends

	MoveSprite($Paddle, 200, 360)
	If $LevelsCount <= 5 Then ;the first 5 levels
		$LoArr += 1
		$TargetArr1 = Eval("Array" & $LoArr)
		$LoArr += 1
		$TargetArr2 = Eval("Array" & $LoArr)
		For $b = 0 To UBound($TargetArr2)-1
			For $a = 0 To UBound($TargetArr1)-1
				$Dim += 1
				$Resize += 1
				ReDim $Sprites[$Dim]
				$Sprites[$Resize] = Sprite($BlockID[$Count], 0, 0, 50, 20, 1, 1, 0, $TargetArr1[$a], $TargetArr2[$b])
			Next
		Next
	Else
		$HiArr += 1 ;the next 5 levels
		$TargetArr3 = Eval("NewArray" & $HiArr)
		For $i = 0 To UBound($TargetArr3)-1
			$Split = StringSplit($TargetArr3[$i], ",")
			$Dim += 1
			$Resize += 1
			ReDim $Sprites[$Dim]
			$Sprites[$Resize] = Sprite($BlockID[$Count], 0, 0, 50, 20, 1, 1, 0, $Split[1], $Split[2])
		Next
	EndIf

	_ShowLevel_Info()
	New_Ball_Pos()
	AdlibEnable("_Control_Blocks", 50)
EndFunc

Func _ShowLevel_Info() ;shows information about the level
	Local $TargetX, $TargetY
	HotKeySet("z")

	If $Dies = 0 Then
		$Number += 1
		$Level[0] = sprite($LevelSprite, 0, 0, 60, 21, 1, 1, 0, -110, 200) ;shows level information
		$Level[1] = sprite($NumbersSprite, 0, 0, 25, 21, 15, $Number, 0, 500, 200)
		$TargetX = 180
		$TargetY = 260
	Else
		$Level[0] = sprite($GetSprite, 0, 0, 43, 21, 1, 1, 0, -115, 200) ;shows get ready
		$Level[1] = sprite($ReadySprite, 0, 0, 70, 21, 1, 1, 0, 490, 200)
		$TargetX = 180
		$TargetY = 240
	EndIf

	SetSpriteSpeed($Level[0], 5, 5)
	SetSpriteSpeed($Level[1], 4, 4)
	MoveSprite($Level[0], $TargetX, 200)
	MoveSprite($Level[1], $TargetY, 200)
	Sleep(3500)
	DeleteSprite($Level[0])
	DeleteSprite($Level[1])
	HotKeySet("z", "Pause")
EndFunc

Func New_Ball_Pos() ;the new ball will go left or right
	Local $Rand = Random(0, 3, 1)
	SetSpriteAnim($Ball, 0, 0, 20, 20, 4, 1, 15)
	If $Rand = 0 Or $Rand = 2 Then
		MoveSprite($Ball, 10, 10)
	Else
		MoveSprite($Ball, 490, 10)
	EndIf
EndFunc

Func _Sprite_Speed_And_Move($Sprite_Ids, $MoveToX, $MoveToY, $SprSpdX, $SprSpdY)
	SetSpriteSpeed($Sprite_Ids, $SprSpdX, $SprSpdY)
	MoveSprite($Sprite_Ids, $MoveToX, $MoveToY)
EndFunc

Func _SleepLoop($sValue)
	For $i = 1 To $sValue
		Sleep(10)
	Next
EndFunc

Func _Control_Blocks() ;when the ball hit the blocks
	$WinGetPos = WinGetPos($MainGui)
	SetMouseRect($WinGetPos[0] + 5, ($WinGetPos[1] * 2) - GetSpriteY($Paddle) + 350, ($WinGetPos[0] + $WinGetPos[2]) - 75, ($WinGetPos[1] + $WinGetPos[3]) - 20)

	$Add_Info = GetSpriteInfos($Ball)
	If $Add_Info[1] >= 385 Then Lost()
	For $i = 0 To UBound($Sprites)-1
		If Collide($Ball, $Sprites[$i]) <> 0 Then
			$BallX = GetSpriteX($Ball)
			$BallY = GetSpriteY($Ball)
			$SpriteX = GetSpriteX($Sprites[$i])
			$SpriteY = GetSpriteY($Sprites[$i])
			$EquationX = $BallX - $SpriteX
			$EquationY = $BallY - $SpriteY
			Select
				Case $EquationX <= 25 And $EquationY > 5
					MoveSprite($Ball, 10, 400)
				Case $EquationX <= 25 And $EquationY <= 5
					MoveSprite($Ball, 10, 10)
				Case $EquationX > 25 And $EquationY > 5
					MoveSprite($Ball, 480, 400)
				Case $EquationX > 25 And $EquationY <= 5
					MoveSprite($Ball, 480, 10)
			EndSelect
			DSoundPlay($BlocksHit, 0, 0)
			SetSpriteSpeed($Ball, 3, 3)
			DeleteSprite($Sprites[$i])
			If UBound($Sprites) > 1 Then ;checks to see if there are still blocks around
				_ArrayDelete($Sprites, $i)
			Else ;no more blocks, level ends
				DeleteSprite($Ball)
				HotKeySet("z")
				_SleepLoop(100)
				$Ball = Sprite($Load_Spr1, 0, 0, 20, 20, 1, 1, 0, 220, 300)
				SetSpriteSpeed($Ball, 3, 3)
				SetBackAutoCollision($Ball, $MaskPic, 2, 491, 400, "")
				_Create_Level()
			EndIf
			Return 0
		EndIf
	Next
EndFunc

Func Pause() ;prepares the game to be paused
	If WinActive($MainGui) Then
		$Trigger += 1
		If $Trigger = 1 Then
			$GameRunning = 0
			_PauseMusic()
			$Cur_Info = GetSpriteInfos($Ball)
			$Goal_Info = GetSpriteInfos($Ball)
			MoveSprite($Ball, $Cur_Info[0], $Cur_Info[1])
			SetBackAutoCollision($Ball, $MaskPic, 1, 491, 400, "")
			AdlibDisable()
			WinSetTitle($MainGui, "", "Paused")
			GUISetCursor(2)
			SetMouseRect(0, 0, @DesktopWidth, @DesktopHeight) ;release the mouse trap
		ElseIf $Trigger = 2 Then
			$GameRunning = 1
			_PlayMusic()
			$Trigger = 0
			MoveSprite($Ball, $Goal_Info[2], $Goal_Info[3])
			SetBackAutoCollision($Ball, $MaskPic, 2, 491, 400, "")
			AdlibEnable("_Control_Blocks", 50)
			WinSetTitle($MainGui, "", $GTitle)
			GUISetCursor(16)
		EndIf
	EndIf
EndFunc

Func FreezeGame() ;pause the game
	Do
		Sleep(50)
	Until $GameRunning = 1
EndFunc

Func Lost()
	HotKeySet("z")
	$Add -= 1
	$OneUpCount -= 1
	If $OneUpCount = -1 Then GameOver() ;lost all lives
	If $Add = -1 Then $Add = 0
	DSoundPlay($LosesHit, 0, 0)

	ChangeSpritePara($Paddle, 4, 68) ;sets paddle death animation
	_SleepLoop(25)
	ChangeSpritePara($Paddle, 4, 136)
	_SleepLoop(25)
	ChangeSpritePara($Paddle, 4, 204)
	_SleepLoop(25)
	ChangeSpritePara($Paddle, 4, 272)
	_SleepLoop(25)
	ChangeSpritePara($Paddle, 4, 350)
	_SleepLoop(100)

	If $Add >= 0 Then DeleteSprite($OneUp[$Add])
	DeleteSprite($Ball)
	$Ball = Sprite($Load_Spr1, 0, 0, 20, 20, 1, 1, 0, 220, 300)
	SetSpriteSpeed($Ball, 3, 3)
	SetBackAutoCollision($Ball, $MaskPic, 2, 491, 400, "")
	MoveSprite($Paddle, 200, 360)
	ChangeSpritePara($Paddle, 4, 0)
	_SleepLoop(25)

	$Dies = 1
	_ShowLevel_Info()
	$Dies = 0
	New_Ball_Pos()
EndFunc

Func GameOver() ;shows game over
	HotKeySet("z")
	$Level[0] = sprite($GameSprite, 0, 0, 60, 21, 1, 1, 0, -100, 200)
	$Level[1] = sprite($OverSprite, 0, 0, 56, 21, 1, 1, 0, 450, 200)
	SetSpriteSpeed($Level[0], 6, 4)
	SetSpriteSpeed($Level[1], 4, 4)
	MoveSprite($Level[0], 175, 200)
	MoveSprite($Level[1], 250, 200)
	_SleepLoop(300)
	DeleteSprite($Level[0])
	DeleteSprite($Level[1])
	Close()
EndFunc

Func Close() ;closes the game and releases the allocated resources
	AdlibDisable()
	FreeExtBmp($Background)
	DeleteAllSprites()
	_StopMusic()
	_FreeBass()
	GUIDelete($MainGui)
	Exit
EndFunc