;========================================================================================
; Description:      Magic Show
; Author(s):        mrbond007 (Baki G)
;					Northwind (Frank Abbing)
;					JPAM (JPAM van der Ouderaa)
;
; Comments:			It's magic time with AutoIt :P
;
;					Remember if you like AutoIt Donate to the AutoIt Project:
;					http://www.autoitscript.com/donate.php
;========================================================================================
If _Singleton("Magic Show") = 0 Then Exit

#include "Plugins\ProSpeed.au3"
#include "Plugins\BassMod.au3"
#include "Plugins\Misc.au3"
#include "Plugins\Array.au3"
Opt("GUIOnEventMode", 1)
HotKeySet("{Esc}", "Close")

Global $MainGui, $Loaded[12], $Cards[12], $Backup[12], $Marked, $Marked2
Global $Dim = -1, $Data = @CR & @CR & "Press the z key when you are ready."
Global $PosX[6] = ["10","90","170","250","330","410"], $PosY[2] = ["10","115"]
Global $YOffSet[12] = ["0","96","192","288","384","480","576","672","768","864","960","1056"]
Global $Text[16] = ["Welcome, allow me to turn these 12 cards face down.", _
					"Now i will shuffle them well!", _
					"Now i will choose 5 random cards.", _
					"Let's take a look at the 5 cards.", _
					"Now, think of one of these cards and picture it in your mind.", _
					"Ha! I know which card you thought of! Allow me to make it vanish.", _
					"Keep picturing the card in your mind.", _
					"Ready?", _
					"One", _
					"Two", _
					"Three", _
					"Let's take a look at the 4 remaining cards.", _
					"Well? the card you thought of is no longer present, correct?", _
					"Yes, rumour has it that AutoIt can sense brain waves...", _
					"What do you think?", _
					"I hope you enjoyed this trick! Farewell!"]

$Sprite = @ScriptDir & "\Magic\Pictures\CardsDeck.png"
For $i = 0 To UBound($Loaded)-1
	$Loaded[$i] = LoadSprite($Sprite)
Next

$MainGui = GUICreate("Magic Show", 490, 400)
GUISetOnEvent(-3, "Close")
GUISetState()

$Back = Background("Fake.png", 0, 0, 490, 400)
For $a = 0 To UBound($PosY)-1
	For $b = 0 To UBound($PosX)-1
		$Dim += 1
		$Backup[$Dim] = $YOffSet[$Dim]
		$Cards[$Dim] = Sprite($Loaded[$Dim], 0, 0, 71, 96, 13, 1, 0, $PosX[$b], $PosY[$a])
		ChangeSpritePara($Cards[$Dim], 8, $YOffSet[$Dim])
		SetSpriteSpeed($Cards[$Dim], 5, 5)
	Next
Next
$CopyArray = $Backup

$Label = GUICtrlCreateLabel("", 10, 290, 470, 100)
GUICtrlSetFont(-1, 15)
GUICtrlSetData($Label, $Text[0])
_PrepareTrack(@ScriptDir & "\Magic\Music\Track.mod")
_BassVolume(50)

Sleep(4000)
For $i = 0 To UBound($Cards)-1
	ChangeSpritePara($Cards[$i], 8, 1152)
	Sleep(100)
Next
Sleep(2000)
GUICtrlSetData($Label, $Text[1])

Sleep(2000)
For $i = 0 To 4
	Shufflex()
	Sleep(1000)
Next
Sleep(2000)
GUICtrlSetData($Label, $Text[2])

Sleep(2000)
ChooseCardsx()
Sleep(2000)
GUICtrlSetData($Label, $Text[4] & $Data)
HotKeySet("z", "Hocus_Pocus")

While 1
	Sleep(100)
WEnd

Func Shufflex()
	Local $Xarray[12], $bb = -1
	For $a = 0 To UBound($PosY)-1
		For $b = 0 To UBound($PosX)-1
			$bb += 1
			$Xarray[$bb] = $PosX[$b] & "," & $PosY[$a]
		Next
	Next

	For $i = 0 To UBound($Cards)-1
		$Ran_R = Random(0, UBound($Xarray)-1, 1)
		$Split = StringSplit($Xarray[$Ran_R], ",")
		Movesprite($Cards[$i], $Split[1], $Split[2])
		_ArrayDelete($Xarray, $Ran_R)
	Next
EndFunc

Func ChooseCardsx()
	Local $Yarray[12]
	For $i = 0 To UBound($Yarray)-1
		$Yarray[$i] = $i + 1
	Next

	For $i = 0 To 6
		$Ran_S = Random(0, UBound($Cards)-1, 1)
		DeleteSprite($Cards[$Ran_S])
		_ArrayDelete($Cards, $Ran_S)
		_ArrayDelete($Backup, $Ran_S)
		Sleep(100)
	Next

	Sleep(2000)
	GUICtrlSetData($Label, $Text[3])
	Sleep(2000)

	For $i = 0 To 4
		ChangeSpritePara($Cards[$i], 8, $Backup[$i])
		Sleep(100)
	Next
	Sleep(1500)

	For $i = 0 To 4
		Movesprite($Cards[$i], $PosX[$i], $PosY[0])
	Next
EndFunc

Func Shuffle()
	Local $Xarray[12], $bb = -1

	For $a = 0 To UBound($PosY)-1
		For $b = 0 To UBound($PosX)-1
			$bb += 1
			$Xarray[$bb] = $PosX[$b] & "," & $PosY[$a]
		Next
	Next

	For $i = 0 To UBound($Cards)-1
		$Ran_R = Random(0, UBound($Xarray)-1, 1)
		$Split = StringSplit($Xarray[$Ran_R], ",")
		Movesprite($Cards[$i], $Split[1], $Split[2])
		_ArrayDelete($Xarray, $Ran_R)
	Next
EndFunc

Func Hocus_Pocus()
	HotKeySet("z")
	Local $NewArray[4]

	For $i = 0 To UBound($NewArray)-1
		$NewArray[$i] = $i + 1
	Next

	For $a = 0 To UBound($Backup)-1
		$Marked &= $Backup[$a] & "*"
	Next
	$Backup = ""

	For $i = 0 To UBound($Cards)-1
		ChangeSpritePara($Cards[$i], 8, 1152)
	Next

	Sleep(1500)
	GUICtrlSetData($Label, $Text[5])
	Sleep(4000)
	GUICtrlSetData($Label, $Text[6])
	Sleep(3000)
	GUICtrlSetData($Label, $Text[7])
	Sleep(1500)
	GUICtrlSetData($Label, $Text[8])
	Sleep(1500)
	GUICtrlSetData($Label, $Text[9])
	Sleep(1500)
	GUICtrlSetData($Label, $Text[10])
	Sleep(1500)
	DeleteSprite($Cards[4])
	_ArrayDelete($Cards, 4)
	Sleep(1500)
	GUICtrlSetData($Label, $Text[11])
	Sleep(2500)

	For $b = 0 To UBound($CopyArray)-1
		If Not StringInStr($Marked, $CopyArray[$b]) Then $Marked2 &= $CopyArray[$b] & "*"
	Next

	$Result = StringSplit(StringTrimRight($Marked2, 1), "*")
	For $i = 0 To UBound($Cards)-1
		$Random = Random(0, UBound($NewArray)-1, 1)
		ChangeSpritePara($Cards[$i], 8, $Result[$NewArray[$Random]])
		_ArrayDelete($NewArray, $Random)
	Next

	GUICtrlSetData($Label, $Text[12])
	Sleep(5000)
	GUICtrlSetData($Label, $Text[13])
	Sleep(4000)
	GUICtrlSetData($Label, $Text[14])
	Sleep(4000)
	GUICtrlSetData($Label, $Text[15])
	Sleep(3000)
	Close()
EndFunc

Func Close()
	FreeExtBmp($Back)
	DeleteAllSprites()
	_StopMusic()
	_FreeBass()
	GUIDelete($MainGui)
	Exit
EndFunc