#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Version=Beta
#AutoIt3Wrapper_icon=.\images\cards2.ico
#AutoIt3Wrapper_Compression=4
#AutoIt3Wrapper_Res_Description=BlackJack
#AutoIt3Wrapper_Res_Fileversion=2.2.0.0
#AutoIt3Wrapper_Res_LegalCopyright=UDF Maniac
#AutoIt3Wrapper_Res_Field=OriginalFilename|BlackJack.exe
#AutoIt3Wrapper_Res_Field=Created Date|10/01/2006
#AutoIt3Wrapper_Res_Field=Update Date|10/09/2006
#AutoIt3Wrapper_Res_Field=Internal Name|BlackJack.exe
#AutoIt3Wrapper_AU3Check_Parameters=-q -d -w 1 -w 2 -w 3 -w- 4 -w 5 -w 6 -w 7
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
;========================================================================
;http://www.audiosparx.com/sa/display/sounds.cfm/sound_group_iid.2374
;http://www.freewarefiles.com/program_1_11_12439.html
;========================================================================
Opt("MustDeclareVars", 1)
#include <GuiConstants.au3>
#include <GuiStatusBar.au3>
#include <GuiHyperLink.au3>
#include <Events.au3>
#include <File.au3>

Opt("GUIResizeMode", $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKHEIGHT + $GUI_DOCKWIDTH)

Global $Cards_Folder = @ScriptDir & "\cards"
Global $Shuffle_Wav = @ScriptDir & "\sounds\shuffle.wav"
Global $card_back_image, $Shuffel_Sound = False

Global $g_szVersion = "Black Jack v2.2"
If WinExists($g_szVersion) Then Exit ; It's already running
AutoItWinSetTitle($g_szVersion)

_Main()

Func _Main()
	Local $width, $height, $user_cards_pic[13], $dealer_cards_pic[13], $bwidth, $bheight, $shoe_card
	Local $btn_split, $btn_hit, $btn_stand, $msg, $StatusBar, $GUI, $hit_left, $btn_DoubleDown
	Local $deck, $a_cards, $btn_deal, $gui_width = 450, $gui_height = 420, $is_split = 0
	Local $a_UserHandL[7], $a_UserHandR[7], $a_DealerHand[11]
	Local $UserHandTotalLeft = 0, $UserHandTotalRight = 0, $DealerHandTotal = 0
	Local $panelWidth = Int($gui_width / 6)
	Local $a_PartsRightEdge[6] = [$panelWidth / 2, ($panelWidth / 2) + $panelWidth, ($panelWidth / 2) + ($panelWidth * 2) , ($panelWidth / 2) + ($panelWidth * 3) , ($panelWidth * 4) + ($panelWidth / 3), -1]
	Local $Win, $Lose, $Push, $Cards_Remaining = 52, $Money, $num_decks, $num_cards
	Local $menu_File, $menu_File_deck, $menu_Exit, $menuHelp, $menuItemHelpAbout, $menuItemResetStats
	Local $menu_Config, $menu_NumDecks, $menuItemDeck[9], $menuItemShuffelSound
	Local $menu_Bet, $menuItemBet[6]
	Local $szDrive, $szDir, $szFName, $szExt, $bet, $current_bet
	Local $Image_Folder = @ScriptDir & "\images"
	Local $Shoe_Card_Image_Folder = @ScriptDir & "\cards\backs"
	
	$card_back_image = IniRead(@ScriptDir & "\BlackJack.ini", "Deck", "Color", $Shoe_Card_Image_Folder & "\02bfv.GIF")
	_PathSplit($card_back_image, $szDrive, $szDir, $szFName, $szExt)
	$szFName = StringReplace($szFName, "bfv", "bpl") & ".gif"
	$num_decks = Int(IniRead(@ScriptDir & "\BlackJack.ini", "Deck", "num", 1))
	$num_cards = 52 * $num_decks
	$Cards_Remaining = $num_cards
	$Win = Int(IniRead(@ScriptDir & "\BlackJack.ini", "Stats", "Win", 0))
	$Lose = Int(IniRead(@ScriptDir & "\BlackJack.ini", "Stats", "Lose", 0))
	$Push = Int(IniRead(@ScriptDir & "\BlackJack.ini", "Stats", "Push", 0))
	$Money = Int(IniRead(@ScriptDir & "\BlackJack.ini", "Money", "Total", 10000))
	$bet = Int(IniRead(@ScriptDir & "\BlackJack.ini", "Money", "Bet", 100))
	$Shuffel_Sound = IniRead(@ScriptDir & "\BlackJack.ini", "Sound", "Shuffel", False)
	If $Shuffel_Sound = "False" Then
		$Shuffel_Sound = False
	Else
		$Shuffel_Sound = True
	EndIf
	Local $a_PartsText[6] = ["", "", "", $Win & "/" & $Lose & "/" & $Push, "$" & $bet, "$" & $Money]
	
	$GUI = GUICreate($g_szVersion, $gui_width, $gui_height)
	
	GUICtrlCreatePic($Image_Folder & "\Blackjack-icon.jpg", 0, 0, $gui_width, $gui_height)
	GUICtrlSetState(-1, $GUI_DISABLE)
	
	$menu_File = GUICtrlCreateMenu("&File")
	$menu_Exit = GUICtrlCreateMenuitem("E&xit", $menu_File)

	$menu_Config = GUICtrlCreateMenu("&Config")
	$menu_File_deck = GUICtrlCreateMenuitem("Deck Back", $menu_Config)
	GUICtrlCreateMenuitem("", $menu_Config)
	$menu_NumDecks = GUICtrlCreateMenu("# of Decks", $menu_Config)
	For $i = 1 To 8
		$menuItemDeck[$i] = GUICtrlCreateMenuitem($i, $menu_NumDecks, $i, 1)
		If $i = $num_decks Then GUICtrlSetState($menuItemDeck[$i], $GUI_CHECKED)
	Next
	GUICtrlCreateMenuitem("", $menu_Config)
	$menuItemShuffelSound = GUICtrlCreateMenuitem("Sound", $menu_Config, $i + 1, 1)
	If $Shuffel_Sound Then GUICtrlSetState($menuItemShuffelSound, $GUI_CHECKED)
	GUICtrlCreateMenuitem("", $menu_Config)
	$menuItemResetStats = GUICtrlCreateMenuitem("Reset Stats", $menu_Config)

	$menu_Bet = GUICtrlCreateMenu("&Bets")
	$menuItemBet[0] = GUICtrlCreateMenuitem("$1 bets", $menu_Bet, 0, 1)
	If $bet = 1 Then GUICtrlSetState($menuItemBet[0], $GUI_CHECKED)
	$menuItemBet[1] = GUICtrlCreateMenuitem("$5 bets", $menu_Bet, 1, 1)
	If $bet = 5 Then GUICtrlSetState($menuItemBet[1], $GUI_CHECKED)
	$menuItemBet[2] = GUICtrlCreateMenuitem("$10 bets", $menu_Bet, 2, 1)
	If $bet = 10 Then GUICtrlSetState($menuItemBet[2], $GUI_CHECKED)
	$menuItemBet[3] = GUICtrlCreateMenuitem("$50 bets", $menu_Bet, 3, 1)
	If $bet = 50 Then GUICtrlSetState($menuItemBet[3], $GUI_CHECKED)
	$menuItemBet[4] = GUICtrlCreateMenuitem("$100 bets", $menu_Bet, 4, 1)
	If $bet = 100 Then GUICtrlSetState($menuItemBet[4], $GUI_CHECKED)
	$menuItemBet[5] = GUICtrlCreateMenuitem("$1000 bets", $menu_Bet, 5, 1)
	If $bet = 1000 Then GUICtrlSetState($menuItemBet[5], $GUI_CHECKED)
	$current_bet = $bet

	$menuHelp = GUICtrlCreateMenu("&Help")
	$menuItemHelpAbout = GUICtrlCreateMenuitem('&About...', $menuHelp)
	
	_GetGifPixWidth_Height($Cards_Folder & "\01c.gif", $width, $height)
	$width -= 12
	$height -= 12
	
	$deck = _InitDeck($num_cards, $num_decks)
	
	_CardLayOut($dealer_cards_pic, 10, 10, $width, $height, 20)
	
	GUICtrlCreateLabel("", $gui_width - 20, (($gui_height / 2) - (($height + 60) / 2)) - 4, 10, $height + 8, $SS_SUNKEN)
	GUICtrlSetBkColor(-1, 0x000000)
	
	_GetGifPixWidth_Height($Shoe_Card_Image_Folder & "\" & $szFName, $bwidth, $bheight)
	$bheight -= 12
	$shoe_card = GUICtrlCreatePic($Shoe_Card_Image_Folder & "\" & $szFName, $gui_width - ($bwidth + 15) , ($gui_height / 2) - (($bheight + 60) / 2), $bwidth, $bheight)
	GUICtrlSetState($shoe_card, $GUI_HIDE)

	_CardLayOut($user_cards_pic, 10, $gui_height - ($height + 80), $width, $height, -20)

	$btn_split = GUICtrlCreateButton("Split", 140, $gui_height - 70, 40, 19)
	GUICtrlSetState($btn_split, $GUI_DISABLE)
	
	$btn_hit = GUICtrlCreateButton("Hit", 185, $gui_height - 90, 40, 19)
	GUICtrlSetState($btn_hit, $GUI_DISABLE)
	
	$btn_stand = GUICtrlCreateButton("Stand", 230, $gui_height - 90, 40, 19)
	GUICtrlSetState($btn_stand, $GUI_DISABLE)
	
	$btn_DoubleDown = GUICtrlCreateButton("Double Down", 185, $gui_height - 70, 85, 19)
	GUICtrlSetState($btn_DoubleDown, $GUI_DISABLE)
	
	$btn_deal = GUICtrlCreateButton("Deal", 275, $gui_height - 70, 40, 19)

	If $Money <= 0 Then GUICtrlSetState($btn_deal, $GUI_DISABLE)
	
	$StatusBar = _GUICtrlStatusBarCreate($GUI, $a_PartsRightEdge, $a_PartsText)
	
	GUISetState()

	If @OSTYPE <> 'WIN32_WINDOWS' Then
		_ReduceMemory()
		AdlibEnable("_ReduceMemory", 60000)
	EndIf

	While 1
		$msg = GUIGetMsg()
		Select
			;========================================================================
			; save information and exit
			;========================================================================
			Case $msg = $GUI_EVENT_CLOSE Or $msg = $menu_Exit
				IniWrite(@ScriptDir & "\BlackJack.ini", "Stats", "Win", $Win)
				IniWrite(@ScriptDir & "\BlackJack.ini", "Stats", "Lose", $Lose)
				IniWrite(@ScriptDir & "\BlackJack.ini", "Stats", "Push", $Push)
				IniWrite(@ScriptDir & "\BlackJack.ini", "Money", "Total", $Money)
				Exit
				
				;========================================================================
				; Turn On/Off shuffel sound
				;========================================================================
			Case $msg = $menuItemShuffelSound
				$Shuffel_Sound = Not $Shuffel_Sound
				If $Shuffel_Sound Then
					GUICtrlSetState($menuItemShuffelSound, $GUI_CHECKED)
				Else
					GUICtrlSetState($menuItemShuffelSound, $GUI_UNCHECKED)
				EndIf
				IniWrite(@ScriptDir & "\BlackJack.ini", "Sound", "Shuffel", $Shuffel_Sound)

				;========================================================================
				; reset stats
				;========================================================================
			Case $msg = $menuItemResetStats
				$Win = 0
				$Lose = 0
				$Push = 0
				$Money = 10000
				IniWrite(@ScriptDir & "\BlackJack.ini", "Stats", "Win", $Win)
				IniWrite(@ScriptDir & "\BlackJack.ini", "Stats", "Lose", $Lose)
				IniWrite(@ScriptDir & "\BlackJack.ini", "Stats", "Push", $Push)
				IniWrite(@ScriptDir & "\BlackJack.ini", "Money", "Total", $Money)
				_GUICtrlStatusBarSetText($StatusBar, StringFormat("%d/%d/%d", $Win, $Lose, $Push), 3)
				_GUICtrlStatusBarSetText($StatusBar, "$" & $Money, 5)
				GUICtrlSetState($btn_DoubleDown, $GUI_DISABLE)
				GUICtrlSetState($btn_split, $GUI_DISABLE)
				GUICtrlSetState($btn_hit, $GUI_DISABLE)
				GUICtrlSetState($btn_stand, $GUI_DISABLE)
				GUICtrlSetState($shoe_card, $GUI_HIDE)
				GUICtrlSetState($menu_Bet, $GUI_ENABLE)
				$Cards_Remaining = 0
				$current_bet = $bet
				$a_cards = _Shuffel($user_cards_pic, $dealer_cards_pic, $Cards_Remaining, $a_UserHandL, $a_UserHandR, $a_DealerHand, $num_cards, 1)
				$is_split = 0
				_GUICtrlStatusBarSetText($StatusBar, "", 0)
				$hit_left = 0
				GUICtrlSetState($btn_deal, $GUI_ENABLE)

				;========================================================================
				; About BlackJack
				;========================================================================
			Case $msg = $menuItemHelpAbout
				GUIRegisterMsg($WM_NOTIFY, "WM_Notify_Events")
				_About("About BlackJack", $GUI, $Image_Folder)
				GUIRegisterMsg($WM_NOTIFY, "")
				WinSetOnTop($GUI, "", 0)

				;========================================================================
				; User Selected Split
				;========================================================================
			Case $msg = $btn_split
				GUICtrlSetState($btn_DoubleDown, $GUI_DISABLE)
				If Not $Cards_Remaining Then $a_cards = _Shuffel($user_cards_pic, $dealer_cards_pic, $Cards_Remaining, $a_UserHandL, $a_UserHandR, $a_DealerHand, $num_cards)
				$Cards_Remaining -= _Split($btn_split, $btn_hit, $btn_stand, $StatusBar, $hit_left, $is_split, $a_UserHandL, $a_UserHandR, $UserHandTotalLeft, $deck, $a_cards, $user_cards_pic, $shoe_card)

				;========================================================================
				; User Selected Double Down
				;========================================================================
			Case $msg = $btn_DoubleDown
				GUICtrlSetState($btn_DoubleDown, $GUI_DISABLE)
				GUICtrlSetState($btn_split, $GUI_DISABLE)
				GUICtrlSetState($btn_hit, $GUI_DISABLE)
				GUICtrlSetState($btn_stand, $GUI_DISABLE)
				$current_bet = $bet * 2
				If Not $Cards_Remaining Then $a_cards = _Shuffel($user_cards_pic, $dealer_cards_pic, $Cards_Remaining, $a_UserHandL, $a_UserHandR, $a_DealerHand, $num_cards)
				$Cards_Remaining -= _Hit($a_UserHandR, $UserHandTotalRight, $deck, $a_cards, $user_cards_pic, $shoe_card, "R")
				If $UserHandTotalRight <= 21 Then
					_GUICtrlStatusBarSetText($StatusBar, $UserHandTotalRight, 2)
					_DealerPlay($a_DealerHand, $DealerHandTotal, $dealer_cards_pic, $UserHandTotalLeft, $UserHandTotalRight, _
							$deck, $shoe_card, $a_cards, $is_split, $StatusBar, $btn_split, $btn_hit, $btn_stand, $btn_deal, _
							$Win, $Lose, $Push, $Cards_Remaining, $num_cards, $a_UserHandL, $a_UserHandR, $user_cards_pic, $current_bet, $Money, "D")
				Else
					_GUICtrlStatusBarSetText($StatusBar, "Busted: " & $UserHandTotalRight, 2)
					GUICtrlSetState($btn_deal, $GUI_ENABLE)
					GUICtrlSetState($btn_hit, $GUI_DISABLE)
					GUICtrlSetState($btn_stand, $GUI_DISABLE)
					$UserHandTotalRight = 0
					$Lose += 1
					_GUICtrlStatusBarSetText($StatusBar, StringFormat("%d/%d/%d", $Win, $Lose, $Push), 3)
					$Money -= $current_bet
					_GUICtrlStatusBarSetText($StatusBar, "$" & $Money, 5)
				EndIf
				If $Money = 0 Then GUICtrlSetState($btn_deal, $GUI_DISABLE)
				GUICtrlSetState($menu_Bet, $GUI_ENABLE)
				
				;========================================================================
				; User Selected Hit
				;========================================================================
			Case $msg = $btn_hit
				GUICtrlSetState($btn_split, $GUI_DISABLE)
				GUICtrlSetState($btn_DoubleDown, $GUI_DISABLE)
				If Not $Cards_Remaining Then $a_cards = _Shuffel($user_cards_pic, $dealer_cards_pic, $Cards_Remaining, $a_UserHandL, $a_UserHandR, $a_DealerHand, $num_cards)
				If $hit_left Then
					$Cards_Remaining -= _Hit($a_UserHandL, $UserHandTotalLeft, $deck, $a_cards, $user_cards_pic, $shoe_card, "L")
					If $UserHandTotalLeft <= 21 Then
						If _CheckCardCount($a_UserHandL, $a_UserHandR, "L") = 6 Then
							$Win += 1
							_GUICtrlStatusBarSetText($StatusBar, "You Win: " & $UserHandTotalLeft, 2)
							$Money += $current_bet
							_GUICtrlStatusBarSetText($StatusBar, "$" & $Money, 5)
							$is_split = 0
							$hit_left = 0
						Else
							_GUICtrlStatusBarSetText($StatusBar, $UserHandTotalLeft, 1)
						EndIf
					Else
						_GUICtrlStatusBarSetText($StatusBar, "Busted: " & $UserHandTotalLeft, 1)
						$hit_left = 0
					EndIf
				Else
					If Not $Cards_Remaining Then $a_cards = _Shuffel($user_cards_pic, $dealer_cards_pic, $Cards_Remaining, $a_UserHandL, $a_UserHandR, $a_DealerHand, $num_cards)
					$Cards_Remaining -= _Hit($a_UserHandR, $UserHandTotalRight, $deck, $a_cards, $user_cards_pic, $shoe_card, "R")
					If $UserHandTotalRight <= 21 Then
						If _CheckCardCount($a_UserHandL, $a_UserHandR, "R") = 6 Then
							$Win += 1
							_GUICtrlStatusBarSetText($StatusBar, "You Win: " & $UserHandTotalRight, 2)
							$Money += $current_bet
							_GUICtrlStatusBarSetText($StatusBar, "$" & $Money, 5)
							GUICtrlSetState($btn_deal, $GUI_ENABLE)
							GUICtrlSetState($btn_hit, $GUI_DISABLE)
							GUICtrlSetState($btn_stand, $GUI_DISABLE)
						Else
							_GUICtrlStatusBarSetText($StatusBar, $UserHandTotalRight, 2)
						EndIf
					ElseIf $is_split Then
						_GUICtrlStatusBarSetText($StatusBar, "Busted: " & $UserHandTotalRight, 2)
						GUICtrlSetState($btn_hit, $GUI_DISABLE)
						GUICtrlSetState($btn_stand, $GUI_DISABLE)
						_DealerPlay($a_DealerHand, $DealerHandTotal, $dealer_cards_pic, $UserHandTotalLeft, $UserHandTotalRight, _
								$deck, $shoe_card, $a_cards, $is_split, $StatusBar, $btn_split, $btn_hit, $btn_stand, $btn_deal, _
								$Win, $Lose, $Push, $Cards_Remaining, $num_cards, $a_UserHandL, $a_UserHandR, $user_cards_pic, $current_bet, $Money)
					Else
						GUICtrlSetImage($dealer_cards_pic[7], @ScriptDir & "\cards\" & $deck[$a_DealerHand[2]])
						_GUICtrlStatusBarSetText($StatusBar, "Busted: " & $UserHandTotalRight, 2)
						GUICtrlSetState($btn_deal, $GUI_ENABLE)
						GUICtrlSetState($btn_hit, $GUI_DISABLE)
						GUICtrlSetState($btn_stand, $GUI_DISABLE)
						GUICtrlSetState($menu_Bet, $GUI_ENABLE)
						$UserHandTotalRight = 0
						$Lose += 1
						$Money -= $current_bet
						_GUICtrlStatusBarSetText($StatusBar, "$" & $Money, 5)
					EndIf
					_GUICtrlStatusBarSetText($StatusBar, StringFormat("%d/%d/%d", $Win, $Lose, $Push), 3)
				EndIf
				GUICtrlSetState($menu_Bet, $GUI_ENABLE)
				If $Money = 0 Then GUICtrlSetState($btn_deal, $GUI_DISABLE)
				
				;========================================================================
				; User Selected Stand, Dealer's turn if not split
				;========================================================================
			Case $msg = $btn_stand
				GUICtrlSetState($btn_DoubleDown, $GUI_DISABLE)
				If $hit_left Then
					$hit_left = 0
					$UserHandTotalRight = 0
					If Not $Cards_Remaining Then $a_cards = _Shuffel($user_cards_pic, $dealer_cards_pic, $Cards_Remaining, $a_UserHandL, $a_UserHandR, $a_DealerHand, $num_cards)
					$Cards_Remaining -= _Hit($a_UserHandR, $UserHandTotalRight, $deck, $a_cards, $user_cards_pic, $shoe_card, "R")
					_GUICtrlStatusBarSetText($StatusBar, $UserHandTotalRight, 2)
				Else
					_DealerPlay($a_DealerHand, $DealerHandTotal, $dealer_cards_pic, $UserHandTotalLeft, $UserHandTotalRight, _
							$deck, $shoe_card, $a_cards, $is_split, $StatusBar, $btn_split, $btn_hit, $btn_stand, $btn_deal, _
							$Win, $Lose, $Push, $Cards_Remaining, $num_cards, $a_UserHandL, $a_UserHandR, $user_cards_pic, $current_bet, $Money)
				EndIf
				GUICtrlSetState($menu_Bet, $GUI_ENABLE)
				If $Money = 0 Then GUICtrlSetState($btn_deal, $GUI_DISABLE)

				;========================================================================
				; User changing the file back picture
				;========================================================================
			Case $msg = $menu_File_deck
				Local $tfile = FileOpenDialog("Select Deck", $Shoe_Card_Image_Folder, "Deck (??bfv.gif)", 3, "02bfv.gif")
				If Not @error Then
					GUICtrlSetState($btn_DoubleDown, $GUI_DISABLE)
					GUICtrlSetState($btn_split, $GUI_DISABLE)
					GUICtrlSetState($btn_hit, $GUI_DISABLE)
					GUICtrlSetState($btn_stand, $GUI_DISABLE)
					GUICtrlSetState($shoe_card, $GUI_HIDE)
					GUICtrlSetState($menu_Bet, $GUI_ENABLE)
					$card_back_image = $tfile
					_PathSplit($card_back_image, $szDrive, $szDir, $szFName, $szExt)
					$szFName = StringReplace($szFName, "bfv", "bpl") & ".gif"
					GUICtrlSetImage($shoe_card, $Shoe_Card_Image_Folder & "\" & $szFName)
					IniWrite(@ScriptDir & "\BlackJack.ini", "Deck", "Color", $card_back_image)
					$Cards_Remaining = 0
					$current_bet = $bet
					$a_cards = _Shuffel($user_cards_pic, $dealer_cards_pic, $Cards_Remaining, $a_UserHandL, $a_UserHandR, $a_DealerHand, $num_cards, 1)
					$is_split = 0
					_GUICtrlStatusBarSetText($StatusBar, "", 0)
					$hit_left = 0
					GUICtrlSetState($btn_deal, $GUI_ENABLE)
				EndIf
				GUICtrlSetState($menu_Bet, $GUI_ENABLE)
				If $Money = 0 Then GUICtrlSetState($btn_deal, $GUI_DISABLE)

				;========================================================================
				; User Selected Deal
				;========================================================================
			Case $msg = $btn_deal
				GUICtrlSetState($btn_deal, $GUI_DISABLE)
				GUICtrlSetState($btn_DoubleDown, $GUI_DISABLE)
				GUICtrlSetState($menu_Bet, $GUI_DISABLE)
				_GUICtrlStatusBarSetText($StatusBar, "", 0)
				_GUICtrlStatusBarSetText($StatusBar, "", 1)
				_GUICtrlStatusBarSetText($StatusBar, "", 2)
				$is_split = 0
				$current_bet = $bet
				_GUICtrlStatusBarSetText($StatusBar, "", 0)
				If Not IsArray($a_cards) Or $Cards_Remaining < 4 Then $a_cards = _Shuffel($user_cards_pic, $dealer_cards_pic, $Cards_Remaining, $a_UserHandL, $a_UserHandR, $a_DealerHand, $num_cards, 1)
				$hit_left = 0
				$Cards_Remaining -= _Deal($a_UserHandR, $user_cards_pic, $UserHandTotalRight, _
						$a_DealerHand, $dealer_cards_pic, $DealerHandTotal, $a_cards, $deck, $shoe_card, $btn_split)
				GUICtrlSetState($btn_deal, $GUI_ENABLE)
				If $DealerHandTotal = 21 And $UserHandTotalRight = 21 Then
					GUICtrlSetImage($dealer_cards_pic[7], @ScriptDir & "\cards\" & $deck[$a_DealerHand[2]])
					_GUICtrlStatusBarSetText($StatusBar, $DealerHandTotal, 0)
					_GUICtrlStatusBarSetText($StatusBar, "Push: " & $UserHandTotalRight, 2)
					$Push += 1
					_GUICtrlStatusBarSetText($StatusBar, StringFormat("%d/%d/%d", $Win, $Lose, $Push), 3)
				ElseIf $DealerHandTotal = 21 Then
					GUICtrlSetImage($dealer_cards_pic[7], @ScriptDir & "\cards\" & $deck[$a_DealerHand[2]])
					_GUICtrlStatusBarSetText($StatusBar, $DealerHandTotal, 0)
					_GUICtrlStatusBarSetText($StatusBar, "Lose: " & $UserHandTotalRight, 2)
					$Lose += 1
					_GUICtrlStatusBarSetText($StatusBar, StringFormat("%d/%d/%d", $Win, $Lose, $Push), 3)
					$Money -= $current_bet
					_GUICtrlStatusBarSetText($StatusBar, "$" & $Money, 5)
					GUICtrlSetState($btn_split, $GUI_DISABLE)
					GUICtrlSetState($btn_DoubleDown, $GUI_DISABLE)
				ElseIf $UserHandTotalRight = 21 Then
					_DealerPlay($a_DealerHand, $DealerHandTotal, $dealer_cards_pic, $UserHandTotalLeft, $UserHandTotalRight, _
							$deck, $shoe_card, $a_cards, $is_split, $StatusBar, $btn_split, $btn_hit, $btn_stand, $btn_deal, _
							$Win, $Lose, $Push, $Cards_Remaining, $num_cards, $a_UserHandL, $a_UserHandR, $user_cards_pic, $current_bet, $Money)
				Else
					GUICtrlSetState($btn_deal, $GUI_DISABLE)
					_GUICtrlStatusBarSetText($StatusBar, $UserHandTotalRight, 2)
					GUICtrlSetState($btn_hit, $GUI_ENABLE)
					GUICtrlSetState($btn_stand, $GUI_ENABLE)
					If $bet * 2 <= $Money Then GUICtrlSetState($btn_DoubleDown, $GUI_ENABLE)
					$is_split = 0
					For $x = 1 To UBound($a_UserHandL) - 1
						$a_UserHandL[$x] = ""
					Next
				EndIf
				GUICtrlSetState($menu_Bet, $GUI_ENABLE)
				If $Money < $bet * 2 Then GUICtrlSetState($btn_split, $GUI_DISABLE)
				If $Money = 0 Then GUICtrlSetState($btn_deal, $GUI_DISABLE)


			Case Else
				;========================================================================
				; User Selected number of decks to use
				;========================================================================
				For $i = 1 To 8
					If $msg = $menuItemDeck[$i] Then
						GUICtrlSetState($btn_DoubleDown, $GUI_DISABLE)
						GUICtrlSetState($btn_split, $GUI_DISABLE)
						GUICtrlSetState($btn_hit, $GUI_DISABLE)
						GUICtrlSetState($btn_stand, $GUI_DISABLE)
						GUICtrlSetState($shoe_card, $GUI_HIDE)
						GUICtrlSetState($menu_Bet, $GUI_ENABLE)
						IniWrite(@ScriptDir & "\BlackJack.ini", "Deck", "num", GUICtrlRead($menuItemDeck[$i], 1))
						$num_decks = Int(GUICtrlRead($menuItemDeck[$i], 1))
						$num_cards = 52 * $num_decks
						$deck = _InitDeck($num_cards, $num_decks)
						$Cards_Remaining = 0
						$a_cards = _Shuffel($user_cards_pic, $dealer_cards_pic, $Cards_Remaining, $a_UserHandL, $a_UserHandR, $a_DealerHand, $num_cards, 1)
						$is_split = 0
						_GUICtrlStatusBarSetText($StatusBar, "", 0)
						$hit_left = 0
						GUICtrlSetState($btn_deal, $GUI_ENABLE)
						ExitLoop
					EndIf
				Next
				;========================================================================
				; User Selected amount to bet
				;========================================================================
				For $i = 0 To UBound($menuItemBet) - 1
					If $msg = $menuItemBet[$i] Then
						Local $hold_bet = $bet
						$bet = Int(StringReplace(StringReplace(GUICtrlRead($menuItemBet[$i], 1), "$", ""), " bets", ""))
						If $bet > $Money Then
							; put message about exceeding limit available
							$bet = $hold_bet
						Else
							IniWrite(@ScriptDir & "\BlackJack.ini", "Money", "Bet", $bet)
						EndIf
						$current_bet = $bet
						_GUICtrlStatusBarSetText($StatusBar, "$" & $bet, 4)
						ExitLoop
					EndIf
				Next
		EndSelect
	WEnd
EndFunc   ;==>_Main

;========================================================================
; Retrieve # of cards played on hand
;========================================================================
Func _CheckCardCount(ByRef $a_UserHandL, ByRef $a_UserHandR, $side)
	Local $card_count = 0, $i
	If $side = "L" Then
		For $i = 1 To UBound($a_UserHandL) - 1
			If StringLen($a_UserHandL[$i]) Then $card_count += 1
		Next
	Else
		For $i = 1 To UBound($a_UserHandR) - 1
			If StringLen($a_UserHandR[$i]) Then $card_count += 1
		Next
	EndIf
	Return $card_count
EndFunc   ;==>_CheckCardCount

;========================================================================
; Dealer is playing
;========================================================================
Func _DealerPlay(ByRef $a_DealerHand, ByRef $DealerHandTotal, ByRef $dealer_cards_pic, _
		ByRef $UserHandTotalLeft, ByRef $UserHandTotalRight, ByRef $deck, ByRef $shoe_card, _
		ByRef $a_cards, ByRef $is_split, ByRef $StatusBar, ByRef $btn_split, ByRef $btn_hit, _
		ByRef $btn_stand, ByRef $btn_deal, ByRef $Win, ByRef $Lose, ByRef $Push, ByRef $Cards_Remaining, $num_cards, _
		ByRef $a_UserHandL, ByRef $a_UserHandR, ByRef $user_cards_pic, ByRef $current_bet, ByRef $Money, $Dbl_Down = "")
	GUICtrlSetState($btn_split, $GUI_DISABLE)
	GUICtrlSetState($btn_hit, $GUI_DISABLE)
	GUICtrlSetState($btn_stand, $GUI_DISABLE)
	GUICtrlSetState($btn_deal, $GUI_DISABLE)
	GUICtrlSetImage($dealer_cards_pic[7], @ScriptDir & "\cards\" & $deck[$a_DealerHand[2]])
	_GUICtrlStatusBarSetText($StatusBar, $DealerHandTotal, 0)
	Local $dnum_cards = 2
	While $DealerHandTotal < 16 And $dnum_cards < 6
		If Not $Cards_Remaining Then $a_cards = _Shuffel($user_cards_pic, $dealer_cards_pic, $Cards_Remaining, $a_UserHandL, $a_UserHandR, $a_DealerHand, $num_cards)
		$Cards_Remaining -= _Hit($a_DealerHand, $DealerHandTotal, $deck, $a_cards, $dealer_cards_pic, $shoe_card, "R", 1)
		_GUICtrlStatusBarSetText($StatusBar, $DealerHandTotal, 0)
		$dnum_cards += 1
		If $Dbl_Down = "D" Then Sleep(500)
	WEnd
	If $is_split Then
		_ShowStatus($DealerHandTotal, $UserHandTotalLeft, $StatusBar, $Win, $Lose, $Push, $current_bet, $Money, 1)
		_ShowStatus($DealerHandTotal, $UserHandTotalRight, $StatusBar, $Win, $Lose, $Push, $current_bet, $Money, 2)
	Else
		If $Dbl_Down = "D" Then
			_ShowStatusDblDown($DealerHandTotal, $UserHandTotalRight, $StatusBar, $Win, $Lose, $Push, $a_UserHandR, $deck, $user_cards_pic, $current_bet, $Money)
		Else
			_ShowStatus($DealerHandTotal, $UserHandTotalRight, $StatusBar, $Win, $Lose, $Push, $current_bet, $Money, 2)
		EndIf
	EndIf
	GUICtrlSetState($btn_deal, $GUI_ENABLE)
;~ 	GUICtrlSetState($shoe_card, $GUI_SHOW)
	$is_split = 0
EndFunc   ;==>_DealerPlay

;========================================================================
; Shows status after dealer is done when double down is selected
;========================================================================
Func _ShowStatusDblDown(ByRef $DealerHandTotal, ByRef $UserHandTotalRight, ByRef $StatusBar, ByRef $Win, ByRef $Lose, ByRef $Push, ByRef $a_UserHandR, ByRef $deck, ByRef $user_cards_pic, ByRef $current_bet, ByRef $Money)
	Local $i
	For $i = 1 To UBound($a_UserHandR) - 1
		If Not StringLen($a_UserHandR[$i]) Then ExitLoop
	Next
	$i -= 1
	If $DealerHandTotal > 21 Then
		_GUICtrlStatusBarSetText($StatusBar, $DealerHandTotal, 0)
		_GUICtrlStatusBarSetText($StatusBar, "Win", 2)
		$Win += 1
		$Money += $current_bet
		_GUICtrlStatusBarSetText($StatusBar, "$" & $Money, 5)
	ElseIf $UserHandTotalRight > 21 Then
		GUICtrlSetImage($user_cards_pic[8], $Cards_Folder & "\" & $deck[$a_UserHandR[$i]])
		_GUICtrlStatusBarSetText($StatusBar, $DealerHandTotal, 0)
		_GUICtrlStatusBarSetText($StatusBar, "Busted: " & $UserHandTotalRight, 2)
		$Lose += 1
		$Money -= $current_bet
		_GUICtrlStatusBarSetText($StatusBar, "$" & $Money, 5)
	ElseIf $DealerHandTotal > $UserHandTotalRight Then
		GUICtrlSetImage($user_cards_pic[8], $Cards_Folder & "\" & $deck[$a_UserHandR[$i]])
		$Lose += 1
		_GUICtrlStatusBarSetText($StatusBar, $DealerHandTotal, 0)
		_GUICtrlStatusBarSetText($StatusBar, "Lose: " & $UserHandTotalRight, 2)
		$Money -= $current_bet
		_GUICtrlStatusBarSetText($StatusBar, "$" & $Money, 5)
	ElseIf $DealerHandTotal < $UserHandTotalRight And $UserHandTotalRight <= 21 Then
		GUICtrlSetImage($user_cards_pic[8], $Cards_Folder & "\" & $deck[$a_UserHandR[$i]])
		_GUICtrlStatusBarSetText($StatusBar, $DealerHandTotal, 0)
		_GUICtrlStatusBarSetText($StatusBar, "Win: " & $UserHandTotalRight, 2)
		$Win += 1
		$Money += $current_bet
		_GUICtrlStatusBarSetText($StatusBar, "$" & $Money, 5)
	ElseIf $UserHandTotalRight <= 21 Then
		GUICtrlSetImage($user_cards_pic[8], $Cards_Folder & "\" & $deck[$a_UserHandR[$i]])
		_GUICtrlStatusBarSetText($StatusBar, $DealerHandTotal, 0)
		_GUICtrlStatusBarSetText($StatusBar, "Push: " & $UserHandTotalRight, 2)
		$Push += 1
	EndIf
	_GUICtrlStatusBarSetText($StatusBar, StringFormat("%d/%d/%d", $Win, $Lose, $Push), 3)
EndFunc   ;==>_ShowStatusDblDown

;========================================================================
; Shows status after dealer is done
;========================================================================
Func _ShowStatus(ByRef $DealerHandTotal, ByRef $UserHandTotal, ByRef $StatusBar, ByRef $Win, ByRef $Lose, ByRef $Push, ByRef $current_bet, ByRef $Money, $panel)
	If $DealerHandTotal > 21 Then
		_GUICtrlStatusBarSetText($StatusBar, $DealerHandTotal, 0)
		If $UserHandTotal And $UserHandTotal <= 21 Then
			_GUICtrlStatusBarSetText($StatusBar, "Win: " & $UserHandTotal, $panel)
			$Win += 1
			$Money += $current_bet
			_GUICtrlStatusBarSetText($StatusBar, "$" & $Money, 5)
		EndIf
	ElseIf $UserHandTotal > 21 Then
		_GUICtrlStatusBarSetText($StatusBar, $DealerHandTotal, 0)
		_GUICtrlStatusBarSetText($StatusBar, "Busted: " & $UserHandTotal, $panel)
		$Lose += 1
		$Money -= $current_bet
		_GUICtrlStatusBarSetText($StatusBar, "$" & $Money, 5)
	ElseIf $DealerHandTotal > $UserHandTotal Then
		$Lose += 1
		_GUICtrlStatusBarSetText($StatusBar, $DealerHandTotal, 0)
		_GUICtrlStatusBarSetText($StatusBar, "Lose: " & $UserHandTotal, $panel)
		$Money -= $current_bet
		_GUICtrlStatusBarSetText($StatusBar, "$" & $Money, 5)
	ElseIf $DealerHandTotal < $UserHandTotal And $UserHandTotal <= 21 Then
		_GUICtrlStatusBarSetText($StatusBar, $DealerHandTotal, 0)
		_GUICtrlStatusBarSetText($StatusBar, "Win: " & $UserHandTotal, $panel)
		$Win += 1
		$Money += $current_bet
		_GUICtrlStatusBarSetText($StatusBar, "$" & $Money, 5)
	ElseIf $UserHandTotal <= 21 Then
		_GUICtrlStatusBarSetText($StatusBar, $DealerHandTotal, 0)
		_GUICtrlStatusBarSetText($StatusBar, "Push: " & $UserHandTotal, $panel)
		$Push += 1
	EndIf
	_GUICtrlStatusBarSetText($StatusBar, StringFormat("%d/%d/%d", $Win, $Lose, $Push), 3)
EndFunc   ;==>_ShowStatus

;========================================================================
; Split the hand
;========================================================================
Func _Split(ByRef $btn_split, ByRef $btn_hit, ByRef $btn_stand, ByRef $StatusBar, ByRef $hit_left, ByRef $is_split, _
		ByRef $a_UserHandL, ByRef $a_UserHandR, ByRef $UserHandTotalLeft, _
		ByRef $deck, ByRef $a_cards, ByRef $user_cards_pic, ByRef $shoe_card)
	$hit_left = 1
	$is_split = 1
	$a_UserHandL[1] = $a_UserHandR[1]
	$a_UserHandR[1] = $a_UserHandR[2]
	$a_UserHandR[2] = ""
	_Hit($a_UserHandL, $UserHandTotalLeft, $deck, $a_cards, $user_cards_pic, $shoe_card, "L")
	_GUICtrlStatusBarSetText($StatusBar, "Hand: " & $UserHandTotalLeft, 1)
	_GUICtrlStatusBarSetText($StatusBar, "", 2)
	GUICtrlSetState($btn_split, $GUI_DISABLE)
	GUICtrlSetState($btn_hit, $GUI_ENABLE)
	GUICtrlSetState($btn_stand, $GUI_ENABLE)
	GUICtrlSetState($shoe_card, $GUI_SHOW)
	Return 1
EndFunc   ;==>_Split

;========================================================================
; Set location where cards will show when played
;========================================================================
Func _CardLayOut(ByRef $cards_pic, $x, $y, $width, $height, $adjust)
	Local $i
	For $i = 1 To 5
		$cards_pic[$i] = GUICtrlCreatePic("", $x, $y, $width, $height, $SS_SUNKEN, $WS_EX_CLIENTEDGE)
		GUICtrlSetState($cards_pic[$i], $GUI_HIDE)
		$x += Int($width / 2) - 10
	Next
	$x += $width - 10
	For $i = 6 To 7
		$cards_pic[$i] = GUICtrlCreatePic("", $x, $y + $adjust, $width, $height, $SS_SUNKEN, $WS_EX_CLIENTEDGE)
		GUICtrlSetState($cards_pic[$i], $GUI_HIDE)
		$x += $width + 10
	Next
	For $i = 8 To UBound($cards_pic) - 1
		$cards_pic[$i] = GUICtrlCreatePic("", $x, $y, $width, $height, $SS_SUNKEN, $WS_EX_CLIENTEDGE)
		GUICtrlSetState($cards_pic[$i], $GUI_HIDE)
		$x += Int($width / 2) - 10
	Next
EndFunc   ;==>_CardLayOut

;========================================================================
; Get width and Height of gif(s) used for game
;========================================================================
Func _GetGifPixWidth_Height($s_gif, ByRef $pwidth, ByRef $pheight)
	If FileGetSize($s_gif) > 9 Then
		Local $sizes = FileRead($s_gif, 10)
		$pwidth = Asc(StringMid($sizes, 8, 1)) * 256 + Asc(StringMid($sizes, 7, 1))
		$pheight = Asc(StringMid($sizes, 10, 1)) * 256 + Asc(StringMid($sizes, 9, 1))
	EndIf
EndFunc   ;==>_GetGifPixWidth_Height

;========================================================================
; Function used to get a card from the shoe
;========================================================================
Func _Hit(ByRef $a_Hand, ByRef $Total, ByRef $deck, ByRef $a_cards, ByRef $cards_pic, ByRef $shoe_card, $side, $dealer = 0)
	Local $x = 0, $y, $cards, $i, $Aces
	For $y = 1 To $a_cards[0][0]
		$x += 1
		If Not $a_cards[$y][1] Then ExitLoop
	Next
	GUICtrlSetState($shoe_card, $GUI_SHOW)
	Sleep(100)
	For $y = 1 To UBound($a_Hand) - 1
		If Not StringLen($a_Hand[$y]) Then
			$a_Hand[$y] = $a_cards[$x][0]
			$a_cards[$x][1] = 1
			If $side = "L" Then
				For $i = 1 To 5
					If BitAND(GUICtrlGetState($cards_pic[$i]), $GUI_HIDE) Then
						GUICtrlSetState($shoe_card, $GUI_HIDE)
						GUICtrlSetImage($cards_pic[$i], $Cards_Folder & "\" & $deck[$a_Hand[$y]])
						GUICtrlSetState($cards_pic[$i], $GUI_SHOW)
						ExitLoop
					EndIf
				Next
			Else
				For $i = 8 To UBound($cards_pic) - 1
					If BitAND(GUICtrlGetState($cards_pic[$i]), $GUI_HIDE) Then
						GUICtrlSetState($shoe_card, $GUI_HIDE)
						GUICtrlSetImage($cards_pic[$i], $Cards_Folder & "\" & $deck[$a_Hand[$y]])
						GUICtrlSetState($cards_pic[$i], $GUI_SHOW)
						ExitLoop
					EndIf
				Next
			EndIf
			ExitLoop
		EndIf
	Next
	$Total = 0
	For $i = 1 To UBound($a_Hand) - 1
		If $a_Hand[$i] > 0 Then
			If Not IsArray($cards) Then
				Dim $cards[2]
			Else
				ReDim $cards[UBound($cards) + 1]
			EndIf
			$cards[$i] = Int(StringMid($deck[$a_Hand[$i]], 1, 2))
			If $cards[$i] = 1 Then
				$Aces += 1
			Else
				If $cards[$i] > 10 Then $cards[$i] = 10
				$Total += $cards[$i]
			EndIf
		Else
			ExitLoop
		EndIf
	Next
	If $Aces Then
		Switch $Aces
			Case 1
				If $Total <= 10 Then
					$Total += 11
				Else
					$Total += 1
				EndIf
			Case 2
				If $Total <= 9 Then
					$Total += 12
				Else
					$Total += 2
				EndIf
			Case 3
				If $Total <= 8 Then
					$Total += 13
				Else
					$Total += 3
				EndIf
			Case 4
				If $Total <= 7 Then
					$Total += 14
				Else
					$Total += 4
				EndIf
		EndSwitch
	EndIf
	If $dealer And $Aces And $Total < 18 Then $Total -= 10
	Sleep(100)
	GUICtrlSetState($shoe_card, $GUI_SHOW)
	Return 1
EndFunc   ;==>_Hit

;========================================================================
; Function used to start the hand
;========================================================================
Func _Deal(ByRef $a_UserHand, ByRef $user_cards_pic, ByRef $UserHandTotal, _
		ByRef $a_DealerHand, ByRef $dealer_cards_pic, ByRef $DealerHandTotal, _
		ByRef $a_cards, ByRef $deck, ByRef $shoe_card, ByRef $btn_split)
	Local $u_cards[2], $d_cards[2], $x
	$UserHandTotal = 0
	$DealerHandTotal = 0
	For $x = 1 To UBound($a_UserHand) - 1
		$a_UserHand[$x] = ""
	Next
	For $x = 1 To UBound($a_DealerHand) - 1
		$a_DealerHand[$x] = ""
	Next
	For $x = 1 To UBound($user_cards_pic) - 1
		GUICtrlSetState($user_cards_pic[$x], $GUI_HIDE)
		GUICtrlSetState($dealer_cards_pic[$x], $GUI_HIDE)
	Next
	
	For $x = 1 To $a_cards[0][0]
		If Not $a_cards[$x][1] Then ExitLoop
	Next
	$a_UserHand[1] = $a_cards[$x][0]
	$u_cards[0] = _DisplayCard($a_UserHand, $user_cards_pic, $deck, $shoe_card, "L")
	$a_DealerHand[1] = $a_cards[$x + 1][0]
	$d_cards[0] = _DisplayCard($a_DealerHand, $dealer_cards_pic, $deck, $shoe_card, "L")
	$a_cards[$x][1] = 1
	$a_cards[$x + 1][1] = 1
	$x += 2
	$a_UserHand[2] = $a_cards[$x][0]
	$u_cards[1] = _DisplayCard($a_UserHand, $user_cards_pic, $deck, $shoe_card, "R")
	$a_DealerHand[2] = $a_cards[$x + 1][0]
	$d_cards[1] = _DisplayCard($a_DealerHand, $dealer_cards_pic, $deck, $shoe_card, "R", $card_back_image)
	$a_cards[$x][1] = 1
	$a_cards[$x + 1][1] = 1
	$DealerHandTotal = _AddUpInitDeal($d_cards, 1)
	$UserHandTotal = _AddUpInitDeal($u_cards)
	If StringMid($deck[$a_UserHand[1]], 1, 2) = StringMid($deck[$a_UserHand[2]], 1, 2) Then
		GUICtrlSetState($btn_split, $GUI_ENABLE)
	Else
		GUICtrlSetState($btn_split, $GUI_DISABLE)
	EndIf
	Sleep(100)
	GUICtrlSetState($shoe_card, $GUI_SHOW)
	Return 4
EndFunc   ;==>_Deal

;========================================================================
; Function used to add up the hand when 1st dealt
;========================================================================
Func _AddUpInitDeal(ByRef $cards, $dealer = 0)
	Local $HandTotal = 0
	If $cards[0] = 1 And $cards[1] = 1 Then
		$HandTotal = 2
		If $dealer Then $HandTotal = 12
	ElseIf $cards[0] = 1 Then
		If $cards[1] > 10 Then $cards[1] = 10
		$HandTotal = 11 + $cards[1]
	ElseIf $cards[1] = 1 Then
		If $cards[0] > 10 Then $cards[0] = 10
		$HandTotal = 11 + $cards[0]
	Else
		If $cards[0] > 10 Then $cards[0] = 10
		If $cards[1] > 10 Then $cards[1] = 10
		$HandTotal = $cards[0] + $cards[1]
	EndIf
	Return $HandTotal
EndFunc   ;==>_AddUpInitDeal

;========================================================================
; Display the main cards played
;========================================================================
Func _DisplayCard(ByRef $a_Hand, ByRef $cards_pic, ByRef $deck, ByRef $shoe_card, $side, $image = "")
	Local $c_index = 7, $h_index = 2
	If $side = "L" Then
		$c_index = 6
		$h_index = 1
	EndIf
	GUICtrlSetState($shoe_card, $GUI_SHOW)
	Sleep(100)
	If StringLen($image) Then
		GUICtrlSetImage($cards_pic[$c_index], $image)
	Else
		GUICtrlSetImage($cards_pic[$c_index], $Cards_Folder & "\" & $deck[$a_Hand[$h_index]])
	EndIf
	GUICtrlSetState($cards_pic[$c_index], $GUI_SHOW)
	GUICtrlSetState($shoe_card, $GUI_HIDE)
	Return Int(StringMid($deck[$a_Hand[$h_index]], 1, 2))
EndFunc   ;==>_DisplayCard

;========================================================================
; Shuffel the Deck(s)
;========================================================================
Func _Shuffel(ByRef $user_cards_pic, ByRef $dealer_cards_pic, ByRef $Cards_Remaining, _
		ByRef $a_UserHandL, ByRef $a_UserHandR, ByRef $a_DealerHand, $i_cards = 52, $ClearHands = 0)
	Local $i, $x, $used, $card, $h, $u = 0, $decks = $i_cards / 52
	Local $a_cards[$i_cards + 1][2], $cards_used[1] = [0], $cards[53]
	If $ClearHands Then
		For $x = 1 To UBound($a_UserHandL) - 1
			$a_UserHandL[$x] = ""
			$a_UserHandR[$x] = ""
		Next
		For $x = 1 To UBound($a_DealerHand) - 1
			$a_DealerHand[$x] = ""
		Next
		For $x = 1 To UBound($user_cards_pic) - 1
			GUICtrlSetState($user_cards_pic[$x], $GUI_HIDE)
			GUICtrlSetState($dealer_cards_pic[$x], $GUI_HIDE)
		Next
	EndIf
	If $decks > 1 And $Shuffel_Sound Then SoundPlay($Shuffle_Wav, 1)
	$a_cards[0][0] = $i_cards
	For $h = 1 To UBound($a_UserHandR) - 1
		If $a_UserHandR[$h] > 0 Then
			$u += 1
			$a_cards[$u][0] = $a_UserHandR[$h]
			ReDim $cards_used[UBound($cards_used) + 1]
			$cards_used[0] = $cards_used[0] + 1
			$cards_used[$cards_used[0]] = $a_UserHandR[$h]
		EndIf
	Next
	For $h = 1 To UBound($a_UserHandL) - 1
		If $a_UserHandL[$h] > 0 Then
			$u += 1
			$a_cards[$u][0] = $a_UserHandL[$h]
			ReDim $cards_used[UBound($cards_used) + 1]
			$cards_used[0] = $cards_used[0] + 1
			$cards_used[$cards_used[0]] = $a_UserHandL[$h]
		EndIf
	Next
	For $h = 1 To UBound($a_DealerHand) - 1
		If $a_DealerHand[$h] > 0 Then
			$u += 1
			$a_cards[$u][0] = $a_DealerHand[$h]
			ReDim $cards_used[UBound($cards_used) + 1]
			$cards_used[0] = $cards_used[0] + 1
			$cards_used[$cards_used[0]] = $a_DealerHand[$h]
		EndIf
	Next
	$Cards_Remaining = $i_cards - $u
	For $i = 1 To 52
		$card = Random(1, 52, 1)
		$used = 0
		For $x = 1 To $a_cards[0][0]
			If $a_cards[$x][0] = $card Then
				$cards[$card] = $cards[$card] + 1
				For $h = 1 To $cards_used[0]
					If $cards_used[$h] = $card Then
						$cards_used[$h] = 0
						$used = 1
						ExitLoop
					EndIf
				Next
				If $used Then
					ExitLoop
				ElseIf $cards[$card] >= 1 Then
					$used = 1
					ExitLoop
				EndIf
			EndIf
		Next
		If Not $used Then
			$a_cards[$i][0] = $card
		Else
			$i -= 1
		EndIf
	Next
	If $decks > 1 Then
		Local $a_deck, $y, $c_r = 52, $u_hl[1], $u_hr[1], $z = 53
		For $i = 2 To $decks
			$a_deck = _Shuffel($user_cards_pic, $dealer_cards_pic, $c_r, _
					$u_hl, $u_hr, $a_DealerHand, 52)
			$y = 1
			For $x = $z To $z + 51
				$a_cards[$x][0] = $a_deck[$y][0]
				$y += 1
				$z += 1
			Next
		Next
	EndIf
	Return $a_cards
EndFunc   ;==>_Shuffel

;========================================================================
; Set up the suits for however many decks there are
;========================================================================
Func _InitDeck($i_cards = 52, $num_decks = 1)
	Local $z = 1
	Local $deck[$i_cards + 1], $suit[5] = [4, "c", "h", "s", "d"]
	$deck[0] = $i_cards
	For $i = 1 To $num_decks
		
		For $y = 1 To 4
			Switch $y
				Case 1
					For $x = $z To $z + 12
						$deck[$x] = StringFormat("%02d%s.gif", ($x - $z) + 1, $suit[$y])
					Next
				Case 2
					For $x = $z + 1 To $z + 13
						$deck[$x] = StringFormat("%02d%s.gif", $x - $z, $suit[$y])
					Next
				Case 3
					For $x = $z + 2 To $z + 14
						$deck[$x] = StringFormat("%02d%s.gif", $x - ($z + 1), $suit[$y])
					Next
				Case 4
					For $x = $z + 3 To $z + 15
						$deck[$x] = StringFormat("%02d%s.gif", $x - ($z + 2), $suit[$y])
					Next
			EndSwitch
			$z += 12
		Next
	Next
	Return $deck
EndFunc   ;==>_InitDeck

;========================================================================
; cut down on memory use
;========================================================================
Func _ReduceMemory()
	Local $ai_Return = DllCall("psapi.dll", 'int', 'EmptyWorkingSet', 'long', -1)
	If @error Then Return 1
	Return $ai_Return[0]
EndFunc   ;==>_ReduceMemory

;===============================================================================
; Function Name:    _About()
; Description:      Self describing
; Parameter(s):		$TITLE       - Script Title
;					$MAIN_WINDOW - control ID
; Requirement(s):   None
; Return Value(s):  None
; Author(s):        Gary Frost <custompcs@charter.net>
;===============================================================================

Func _About($TITLE, $MAIN_WINDOW, $Image_Folder)
	Local $CLOSE, $msg, $ABOUT_WINDOW
	Local $Links[1] = ["mailto:custompcs@charter.net"]
	Local $Link_On[1] = ["UDF Maniac"]
	Local $ABOUT_TEXT = $g_szVersion & @CRLF & _
			"Modifications:" & @CRLF & _
			"      10/01/06 - Started program" & @CRLF & _
			"      Last Modified date: 10/09/06" & @CRLF & @CRLF & _
			"Devolopment Team:" & @CRLF & "      UDF Maniac"
	If BitAND(WinGetState($TITLE), 1) Then Return
	$ABOUT_WINDOW = GUICreate($TITLE, 250, 220, -1, -1, BitOR($WS_CAPTION, $DS_MODALFRAME), -1, $MAIN_WINDOW)
	GUISetIcon(".\images\cards2.ico", -1, $ABOUT_WINDOW)
	GUICtrlCreatePic($Image_Folder & "\Blackjack-icon.jpg", 0, 100, 250, 120)
	GUICtrlSetState(-1, $GUI_DISABLE)
	_GuiCtrlHyperLinkCreate ($ABOUT_WINDOW, $ABOUT_TEXT, $Links[0], $Link_On[0], 0, 0, 250, 100, -1, $WS_EX_CLIENTEDGE)
	$CLOSE = GUICtrlCreateButton("Close", 75, 190, 100, 20)
	GUISetState(@SW_DISABLE, $MAIN_WINDOW)
	GUISetState(@SW_SHOW, $ABOUT_WINDOW)
	Do
		$msg = GUIGetMsg()
		Select
			Case $msg = $CLOSE
				ExitLoop
		EndSelect
	Until $msg = $GUI_EVENT_CLOSE
	GUISetState(@SW_ENABLE, $MAIN_WINDOW)
	GUISwitch($MAIN_WINDOW)
	GUIDelete($ABOUT_WINDOW)
	WinSetOnTop($MAIN_WINDOW, "", 1)
	WinSetState($MAIN_WINDOW, "", @SW_SHOW)
EndFunc   ;==>_About