#AutoIt3Wrapper_UseX64=n ; untill new AutoItObject_X64.dll is compiled

#include "AutoItObject.au3"
#include "StructureConstants.au3" ; for $tagSYSTEMTIME
#include <Date.au3> ; for example No3

; Error monitoring
Global $oError = ObjEvent("AutoIt.Error", "_ErrFunc")
Func _ErrFunc()
	ConsoleWrite("! COM Error !  Number: 0x" & Hex($oError.number, 8) & "   ScriptLine: " & $oError.scriptline & " - " & $oError.windescription & @CRLF)
	Return
EndFunc   ;==>_ErrFunc


; Start AutoItObject
_AutoItObject_Startup()

#Region EXAMPLE1
ConsoleWrite(@CRLF & "> EXAMPLE1 < Using pointer to fill object-structure" & @CRLF)
; Make object-structure
Global $oTimeStruct = _AutoItObject_DllStructCreate($tagSYSTEMTIME)
; Call some function
DllCall("kernel32.dll", "none", "GetSystemTime", "ptr", $oTimeStruct())

Global $iYear = $oTimeStruct.Year ; read
ConsoleWrite("Year = " & $iYear & @CRLF) ; print

; Print all:
Global $aArrayOfElements = StringSplit($oTimeStruct.__elements__, ";", 2)
For $sElement In $aArrayOfElements
	ConsoleWrite("- " & $sElement & " = " & Execute('$oTimeStruct.' & $sElement) & @CRLF)
Next

; 'Manually' set new value to "Year" in structure for no particular reason
$oTimeStruct.Year = 2011

$iYear = $oTimeStruct.Year ; read again
ConsoleWrite("new value Year = " & $iYear & @CRLF) ; print

; Call GetSystemTime again
DllCall("kernel32.dll", "none", "GetSystemTime", "ptr", $oTimeStruct())

; Print all again:
$aArrayOfElements = StringSplit($oTimeStruct.__elements__, ";", 2)
For $sElement In $aArrayOfElements
	ConsoleWrite("- " & $sElement & " = " & Execute('$oTimeStruct.' & $sElement) & @CRLF)
Next

; Release
$oTimeStruct = 0
#EndRegion EXAMPLE1



#Region EXAMPLE2
ConsoleWrite(@CRLF & "> EXAMPLE2 < Manual setting and reading structure elements" & @CRLF)
; Make object-structure
Global $oStruct = _AutoItObject_DllStructCreate("wchar Name[13];char Hint[256]")
; Set values
$oStruct.Name = "AutoItObject"
$oStruct.Hint = "Creating and using objects in AutoIt"
; Print read
ConsoleWrite("Name = " & $oStruct.Name & @CRLF)
ConsoleWrite("Hint = " & $oStruct.Hint & @CRLF)
; Release
$oStruct = 0
#EndRegion EXAMPLE2



#Region EXAMPLE3
ConsoleWrite(@CRLF & "> EXAMPLE3 < Passing the whole structure as optional parameter to _AutoItObject_DllStructCreate" & @CRLF)
; Define function
Func _GetSystemTimeObject()
    Return _AutoItObject_DllStructCreate($tagSYSTEMTIME, _Date_Time_GetSystemTime())
EndFunc
; Call it
Global $oSYSTEMTIME = _GetSystemTimeObject()
ConsoleWrite("Year = " & $oSYSTEMTIME.Year & @CRLF)
ConsoleWrite("Month = " & $oSYSTEMTIME.Month & @CRLF)
ConsoleWrite("Dow = " & $oSYSTEMTIME.Dow & @CRLF)
ConsoleWrite("Day = " & $oSYSTEMTIME.Day & @CRLF)
ConsoleWrite("Hour = " & $oSYSTEMTIME.Hour & @CRLF)
ConsoleWrite("Minute = " & $oSYSTEMTIME.Minute & @CRLF)
ConsoleWrite("Second = " & $oSYSTEMTIME.Second & @CRLF)
ConsoleWrite("MSeconds = " & $oSYSTEMTIME.MSeconds & @CRLF)
; Release
$oSYSTEMTIME = 0
#EndRegion EXAMPLE3



#Region EXAMPLE4
ConsoleWrite(@CRLF & "> EXAMPLE4 < Using pointer to make structure in place of the other" & @CRLF)
; Define function
Global $tStructureOriginal = DllStructCreate("dword Something; byte SomethingElse[4]")
; Make object-structure in place of $tStructureOriginal
Global $oStructure = _AutoItObject_DllStructCreate("dword Something; byte SomethingElse[4]", DllStructGetPtr($tStructureOriginal))
; Change data in the original structure
DllStructSetData($tStructureOriginal, "Something", 1234)
DllStructSetData($tStructureOriginal, "SomethingElse", "ABCD")
; Read object structure elements
ConsoleWrite("Something = " & $oStructure.Something & @CRLF)
ConsoleWrite("SomethingElse = " & $oStructure.SomethingElse & @CRLF)
; Release
$oStructure = 0
#EndRegion EXAMPLE4

