#include "AutoitObject.au3"
Func __Element__($data, $NextEl = 0)
	$obj = DllCall($ghAutoItObjectDLL,"idispatch","CreateAutoItObject")
$obj = $obj[0]
	DllCall($ghAutoItObjectDLL,"none","AddProperty","idispatch",$obj,"wstr","next",'dword', 0, 'ptr', 0)
	DllCall($ghAutoItObjectDLL,"none","AddProperty","idispatch",$obj,"wstr","data",'dword', 0, 'ptr', 0)
	$obj.next = $NextEl
	$obj.data = $data


	Return $obj
EndFunc   ;==>__Element__

Func LinkedList()
	Local $obj = _AutoItObject_Create()
	_AutoItObject_AddProperty($obj, "first")
	_AutoItObject_AddProperty($obj, "last")
	_AutoItObject_AddProperty($obj, "size")

	_AutoItObject_AddMethod($obj, "count", "_LinkedList_count")
	_AutoItObject_AddMethod($obj, "add", "_LinkedList_add")
	_AutoItObject_AddMethod($obj, "at", "_LinkedList_at")
	_AutoItObject_AddMethod($obj, "remove", "_LinkedList_remove")

	_AutoItObject_AddEnum($obj, "_LinkedList_EnumNext" ,"_LinkedList_EnumReset")

	Return $obj
EndFunc   ;==>LinkedList

Func _LinkedList_remove($self, $index)
	$current = $self.first
	$previous = 0
	Local $i = 0
	Do
		If $i = $index Then
			If Not IsObj($previous) Then
				$self.first = $current.Next
			Else
				$previous.Next = $current.Next
			EndIf
			$self.size = $self.size - 1
			Return
		EndIf
		$i += 1
		$previous = $current
		$current = $current.Next
	Until $current.Next = 0
	Return SetError(1, 0, 0)
EndFunc   ;==>_LinkedList_remove


Func _LinkedList_add($self, $newdata)
	Local $iSize = $self.size
	Local $oLast = $self.last
	If $iSize = 0 Then
		$self.first = __Element__($newdata)
		$self.last = $self.first
	Else
		$oLast.Next = __Element__($newdata)
		$self.last = $oLast.Next
	EndIf
	$self.size = $iSize + 1
EndFunc   ;==>_LinkedList_add

Func _LinkedList_at($self, $index)
	Local $i = 0
	For $Element In $self
		If $i = $index Then Return $Element
		$i += 1
	Next
	Return SetError(1, 0, 0)
EndFunc   ;==>_LinkedList_at



Func _LinkedList_count($self)
	Return $self.size
EndFunc   ;==>_LinkedList_count

Func _LinkedList_EnumReset(ByRef $self, ByRef $iterator)
	$iterator = 0
EndFunc   ;==>_LinkedList_EnumReset

Func _LinkedList_EnumNext(ByRef $self, ByRef $iterator)
	If Not IsObj($iterator) Then
		$iterator = $self.first
		Return $iterator.data
	EndIf
	If Not IsObj($iterator.Next) Then Return SetError(1, 0, 0)
	$iterator = $iterator.Next
	Return $iterator.data
EndFunc   ;==>_LinkedList_EnumNext


#CS Uncomment to run example!
_AutoItObject_Startup()
$ll = LinkedList()
For $i = 1 To 10
	$ll.add($i)
Next

$ll.remove(4)
$str = ""
For $e In $ll
	$str &= $e & @CRLF
Next
MsgBox(0, $ll.count, $str)
#CE
