#include "AutoitObject.au3"
#include <INet.au3>

Opt("MustDeclareVars", 1)

; Error monitoring
Global $oError = ObjEvent("AutoIt.Error", "_ErrFunc")

_AutoItObject_StartUp()

Global $oSMTP = _SmtpMailObject()
Global $aBody[1] = ["Test message"]

With $oSMTP
	.Server = "some.valid.server.com"
	.FromName = "" ; "Some Name" ;<- empty for testing for _INetSmtpMail() to error-out
	.FromAddress = "Valid.Address@mail.com"
	.ToAddress = "OtherValid.Address@mail.com"
	.Subject = "Subject of the message"
	.Body = $aBody
	.Trace = True
EndWith


; Send mail
ConsoleWrite("+Return value = " & $oSMTP.Send & @CRLF)

; Check error
ConsoleWrite("!Error number = " & $oSMTP.__error__ & @CRLF)

$oSMTP = 0
_AutoItObject_Shutdown()

Func _SmtpMailObject()
    Local $oObj = _AutoItObject_Create()
    _AutoItObject_AddMethod($oObj, "Send", "_SmtpMailObject_InetSmtpMail")
    _AutoItObject_AddProperty($oObj, "Server")
    _AutoItObject_AddProperty($oObj, "FromName")
    _AutoItObject_AddProperty($oObj, "FromAddress")
    _AutoItObject_AddProperty($oObj, "ToAddress")
    _AutoItObject_AddProperty($oObj, "Subject")
    _AutoItObject_AddProperty($oObj, "Body")
    _AutoItObject_AddProperty($oObj, "Helo")
    _AutoItObject_AddProperty($oObj, "First", $ELSCOPE_PUBLIC, " ")
    _AutoItObject_AddProperty($oObj, "Trace", $ELSCOPE_PUBLIC, False)
    Return $oObj
EndFunc   ;==>_SmtpMailObject


Func _SmtpMailObject_InetSmtpMail($oSelf)
	With $oSelf
		Local $iOut = _INetSmtpMail(.Server, .FromName, .FromAddress, .ToAddress, .Subject, .Body, .Helo, .First, .Trace)
	EndWith
	Return SetError(@error, 0, $iOut)
EndFunc


Func _ErrFunc()
    ConsoleWrite("! COM Error !  Number: 0x" & Hex($oError.number, 8) & "   ScriptLine: " & $oError.scriptline & " - " & $oError.windescription & @CRLF)
    Return
EndFunc   ;==>_ErrFunc

