#include "AutoitObject.au3"
Opt("MustDeclareVars", 1)

; Error monitoring
Global $oError = ObjEvent("AutoIt.Error", "_ErrFunc")

; Initialize AutoItObject
_AutoItObject_StartUp()

; Create Object
Global $oObject = _PrintConsoleObject()

; Set some property
$oObject.Message = "There's... something on the wing... some... thing ..."

;Print
$oObject.Print()
$oObject.Print("Harry I took care of it")

; Relese
$oObject = 0



; Define object
Func _PrintConsoleObject()
	Local $oClassObject = _AutoItObject_Class()
	$oClassObject.Create()
	$oClassObject.AddMethod("Print", "_Obj_Print")
	$oClassObject.AddMethod("PrintError", "_Obj_PrintError")
	$oClassObject.AddProperty("Message")
	$oClassObject.AddDestructor("_DestructorForSomeObject1")
	$oClassObject.AddDestructor("_DestructorForSomeObject2")
	$oClassObject.AddDestructor("_DestructorForSomeObject3")
	$oClassObject.AddDestructor("_DestructorForSomeObject4")
	$oClassObject.AddDestructor("_DestructorForSomeObject5")
	$oClassObject.AddDestructor("_DestructorForSomeObject6")
	Return $oClassObject.Object
EndFunc   ;==>_PrintConsoleObject

Func _Obj_Print($oSelf, $sMessage = "")
	If @NumParams = 2 Then
		ConsoleWrite($sMessage & @CRLF)
	Else
		ConsoleWrite($oSelf.Message & @CRLF)
	EndIf
EndFunc   ;==>_Obj_Print

Func _Obj_PrintError($oSelf, $sMessage = "")
	If @NumParams = 2 Then
		ConsoleWriteError("! " & $sMessage & @CRLF)
	Else
		ConsoleWriteError("! " & $oSelf.Message & @CRLF)
	EndIf
EndFunc   ;==>_Obj_PrintError

Func _DestructorForSomeObject1($oSelf)
	ConsoleWrite("!...destructing1..." & @CRLF)
EndFunc   ;==>_DestructorForSomeObject1

Func _DestructorForSomeObject2($oSelf)
	ConsoleWrite("!...destructing2..." & @CRLF)
EndFunc   ;==>_DestructorForSomeObject2

Func _DestructorForSomeObject3($oSelf)
	ConsoleWrite("!...destructing3..." & @CRLF)
EndFunc   ;==>_DestructorForSomeObject3
Func _DestructorForSomeObject4($oSelf)
	ConsoleWrite("!...destructing4..." & @CRLF)
EndFunc   ;==>_DestructorForSomeObject4

Func _DestructorForSomeObject5($oSelf)
	ConsoleWrite("!...destructing5..." & @CRLF)
EndFunc   ;==>_DestructorForSomeObject5

Func _DestructorForSomeObject6($oSelf)
	ConsoleWrite("!...destructing6..." & @CRLF)
EndFunc   ;==>_DestructorForSomeObject6

Func _DestructorForSomeObject7($oSelf)
	ConsoleWrite("!...destructing7..." & @CRLF)
EndFunc   ;==>_DestructorForSomeObject7

Func _ErrFunc()
	ConsoleWrite("! COM Error !  Number: 0x" & Hex($oError.number, 8) & "   ScriptLine: " & $oError.scriptline & " - " & $oError.windescription & @CRLF)
	Return
EndFunc   ;==>_ErrFunc



