;coded by UEZ 2009
;http://en.wikipedia.org/wiki/Asteroids_(computer_game)
#AutoIt3Wrapper_Icon=AUTOITEROIDS.ico
#AutoIt3Wrapper_Compile_Both=n
#AutoIt3Wrapper_Res_Description=AUTOITEROIDS by UEZ 2009
#AutoIt3Wrapper_Res_Fileversion=1.0.1.9
#AutoIt3Wrapper_Res_Field=Build|2016-01-14
#AutoIt3Wrapper_Res_Field=Compile date|%longdate% %time%
#AutoIt3Wrapper_Res_Field=AutoIt Version|%AutoItVer%
#AutoIt3Wrapper_Res_Language=1033
#AutoIt3Wrapper_Res_LegalCopyright=UEZ 2009
#AutoIt3Wrapper_Res_Field=Coded by|UEZ
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/so
#AutoIt3Wrapper_Run_After=del /f /q "%scriptdir%\%scriptfile%_stripped.au3"
#AutoIt3Wrapper_UseUpx=n
#AutoIt3Wrapper_UPX_Parameters=--best --lzma
;~ #AutoIt3Wrapper_UPX_Parameters=--brute --crp-ms=999999 --all-methods --all-filters
;~ #AutoIt3Wrapper_Run_After=..\..\..\ResourceHacker\ResHacker.exe -delete %out%, %out%, ICON, 1,
;~ #AutoIt3Wrapper_Run_After=..\..\..\ResourceHacker\ResHacker.exe -delete %out%, %out%, ICON, 2,
;~ #AutoIt3Wrapper_Run_After=..\..\..\ResourceHacker\ResHacker.exe -delete %out%, %out%, ICON, 3,
;~ #AutoIt3Wrapper_Run_After=..\..\..\ResourceHacker\ResHacker.exe -delete %out%, %out%, MENU, 166,
;~ #AutoIt3Wrapper_Run_After=..\..\..\ResourceHacker\ResHacker.exe -delete %out%, %out%, ICONGROUP, 162,
;~ #AutoIt3Wrapper_Run_After=..\..\..\ResourceHacker\ResHacker.exe -delete %out%, %out%, ICONGROUP, 164,
;~ #AutoIt3Wrapper_Run_After=..\..\..\ResourceHacker\ResHacker.exe -delete %out%, %out%, ICONGROUP, 169,
;~ #AutoIt3Wrapper_Run_After=upx.exe --best --lzma "%out%"
;~ #AutoIt3Wrapper_Run_After=upx.exe --brute --crp-ms=999999 --all-methods --all-filters "%out%"
;~ #AutoIt3Wrapper_AU3Check_Parameters=-d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6

#include <Array.au3>
#include <File.au3>
#include <GUIConstants.au3>
#include <GUIMenu.au3>
#include <GDIplus.au3>
#include <MenuConstants.au3>
#include <Timers.au3>
#include <WindowsConstants.au3>
#include "Includes\Bass.au3"

Opt("MustDeclareVars", 1)
Opt("TrayIconHide", 1)
TraySetState(2)

_Singleton("AUTOITEROIDS", 0)
If @OSArch <> "X64" Then
	If @OSType <> "WIN32_NT" Then
		MsgBox(16, "ERROR!", "AUTOITEROIDS runs only on Windows2000 and higher OS x86! x64 not tested!")
		Exit
	EndIf
EndIf
Sleep(250)
Global $ver = " v1.019 "
Global $build = " Build 2016-01-14 "
Global Const $width = 720 ;collision detection is optimized for 720px
Global Const $height = Round($width * 2 / 3, 0)
Global $hGUI, $hMenu, $id_Credits
Global Const $pi_div_180 = 4 * ATan(1) / 180
Global Const $180_div_pi = 180 / (4 * ATan(1))
Global $fps = 0, $fps_c = 0, $display_FPS = -1
Global $aKeyboardState[256]

#Region ;debug window
;~ Global $iMemo, $hDebugGUI
;~ $hDebugGUI = GUICreate("Debug Window", 400, 700, 0, 0)
;~ $iMemo = GUICtrlCreateEdit("", 2, 2, 396, 674, $WS_VSCROLL)
;~ GUICtrlSetFont($iMemo, 9, 400, 0, "Courier New")
;~ GUICtrlSetBkColor($iMemo, 0xFFFFFF)
;~ GUISetState()
#EndRegion ;debug window

#Region ;file load
Global $font = @ScriptDir & "\Font\Vectorb.ttf"
Global $fontname = "Vector Battle"
If Not FileExists($font) Then
	MsgBox(16, "ERROR!", "Could not find font: " & $font & " !!!")
	Exit
EndIf

If @AutoItX64 Then
	If Not FileExists(@ScriptDir & "\DLL\BASS64.dll") Then
		MsgBox(16, "ERROR!", "Could not find " & @ScriptDir & "\DLL\BASS64.dll!!!")
		Exit
	EndIf
Else
	If Not FileExists(@ScriptDir & "\DLL\BASS.dll") Then
		MsgBox(16, "ERROR!", "Could not find " & @ScriptDir & "\DLL\BASS.dll!!!")
		Exit
	EndIf
EndIf
#EndRegion ;file load

#Region ;read highscore ini file if available, otherwise create file
Global $aHighscore[6][2]
Global $highscore_file = @ScriptDir & "\Highscore.ini"
If Not FileExists($highscore_file) Then Create_Highscore_File()
Read_Highscore_File()
#EndRegion ;read highscore ini file if available, otherwise create file

#Region ;set sound variables
Global $bass_dll
If @AutoItX64 Then
	$bass_dll = _BASS_STARTUP(@ScriptDir & "\DLL\BASS64.dll")
Else
	$bass_dll = _BASS_STARTUP(@ScriptDir & "\DLL\BASS.dll")
EndIf
_BASS_Init($BASS_DEVICE_CPSPEAKERS)

Global $sound_counter, $sound_timer = 1000, $sound_selector = 0
Global Const $fShoot = @ScriptDir & "\Sound\Shoot.wav"
Global Const $hShoot = _BASS_StreamCreateFile(False, $fShoot, 0, 0, 0)
Global Const $fThrust = @ScriptDir & "\Sound\Thrust.wav"
Global Const $hThrust = _BASS_StreamCreateFile(False, $fThrust, 0, 0, 0)
Global Const $fExtra_Live = @ScriptDir & "\Sound\Extra_Live.mp3"
Global Const $hExtra_Live = _BASS_StreamCreateFile(False, $fExtra_Live, 0, 0, 0)
Global Const $fExplosion1 = @ScriptDir & "\Sound\Explosion1.mp3"
Global Const $hExplosion1 = _BASS_StreamCreateFile(False, $fExplosion1, 0, 0, 0)
Global Const $fExplosion2 = @ScriptDir & "\Sound\Explosion2.mp3"
Global Const $hExplosion2 = _BASS_StreamCreateFile(False, $fExplosion2, 0, 0, 0)
Global Const $fExplosion3 = @ScriptDir & "\Sound\Explosion3.mp3"
Global Const $hExplosion3 = _BASS_StreamCreateFile(False, $fExplosion3, 0, 0, 0)
Global $hAlien[2]
Global Const $fAlien0 = @ScriptDir & "\Sound\Alien1.wav"
$hAlien[0] = _BASS_StreamCreateFile(False, $fAlien0, 0, 0, 4)
Global Const $fAlien1 = @ScriptDir & "\Sound\Alien2.wav"
$hAlien[1] = _BASS_StreamCreateFile(False, $fAlien1, 0, 0, 4)
Global $hGame[2]
Global Const $fGame0 = @ScriptDir & "\Sound\Game1.wav"
$hGame[0] = _BASS_StreamCreateFile(False, $fGame0, 0, 0, 0)
Global Const $fGame1 = @ScriptDir & "\Sound\Game2.wav"
$hGame[1] = _BASS_StreamCreateFile(False, $fGame1, 0, 0, 0)
Play($hThrust) ;1st start of audio because sometimes is hangs during start
#EndRegion ;set sound variables

Opt("GUIOnEventMode", 1)

;~ _Credits_Intro()
;~ Exit

#Region ;GUI
Global $x = $width / 2, $y = $height / 2, $i, $a, $cx, $cy
$hGUI = GUICreate("", $width, $height, -1, -1, BitOR($WS_SYSMENU, $WS_CAPTION, $WS_POPUP, $WS_POPUPWINDOW, $WS_BORDER))
$hMenu = _GUICtrlMenu_GetSystemMenu($hGUI) ;thanks to rasim for the menu item code
_GUICtrlMenu_AppendMenu($hMenu, $MF_SEPARATOR, 0, 0)
_GUICtrlMenu_AppendMenu($hMenu, $MF_STRING, $id_Credits, "About AUTOITEROIDS")
GUIRegisterMsg($WM_SYSCOMMAND, "WM_SYSCOMMAND")
GUISetOnEvent($GUI_EVENT_CLOSE, "Close")
GUISetState(@SW_SHOW, $hGUI)
#EndRegion ;GUI

#Region ;GDI+ initialize
_GDIPlus_Startup()

Global Const $ghGDIPDll = $__g_hGDIPDll

Global $aResult = DllCall($ghGDIPDll, "uint", "GdipCreateBitmapFromScan0", "int", $width, "int", $height, "int", 0, "int", $GDIP_PXF16RGB555, "ptr", 0, "int*", 0)
Global $hHBITMAP = _GDIPlus_BitmapCreateHBITMAPFromBitmap($aResult[6])
_GDIPlus_BitmapDispose($aResult[6])

Global $hDC  = _WinAPI_GetDC($hGUI)
Global $hDC_backbuffer  = _WinAPI_CreateCompatibleDC($hDC)
Global $DC_obj = _WinAPI_SelectObject($hDC_backbuffer, $hHBITMAP)

Global $hGraphic = _GDIPlus_GraphicsCreateFromHDC($hDC_backbuffer)
;~ DllCall($ghGDIPDll, "uint", "GdipSetPixelOffsetMode", "handle", $hGraphic, "int", 2)
_GDIPlus_GraphicsSetSmoothingMode($hGraphic, 2)
;~ DllCall($ghGDIPDll, "uint", "GdipSetTextRenderingHint", "handle", $hGraphic, "int", 3)
_GDIPlus_GraphicsSetPixelOffsetMode($hGraphic, 2)
_GDIPlus_GraphicsSetCompositingQuality($hGraphic, 2)

Global Const $pen = _GDIPlus_PenCreate(0xE8F0F0F0, 1)
Global $r = 0xF0, $g = $r, $b = $r
Global Const $pen2 = _GDIPlus_PenCreate("0xD0" & Hex(Int($r), 2) & Hex(Int($b), 2) & Hex(Int($b), 2), 2)
Global Const $brush = _GDIPlus_BrushCreateSolid(0xFF000000)
_GDIPlus_GraphicsClear($hGraphic, 0xFF000000)
#EndRegion ;GDI+ initialize

#Region ;set start screen parameter
Global $dms_timer, $dms = 1, $dms_switch_time = 12500
#EndRegion ;set start screen parameter

#Region ;game settings
Global $game_over_time, $h, $ht
Global $level = 1, $lives = 3, $score = 0, $start_game = 0, $highscore = $aHighscore[1][0], $extra_live_counter = 1
Global $enter_pressed = 0, $game_over = 0, $min_distance = 80, $cd = 0xFFFF, $level_finished_delay, $level_finished_delay_treshold = 2500
Global Const $object_scale = ($width * 1.25) / 720
#EndRegion ;game settings

#Region ;GUI title info
Global $title
GUI_Title_Info_Text()
Global $cc = 0 ;counter for sleep
Global $ii = 1 ;for character
Global $jj = 0 ;for array
Global $kk = UBound($title) - 1
Global $ss = 150 ;sleep time
Global $in = True
Global $effect = Random(1, 2, 1)
#EndRegion ;GUI title info

#Region ;font settings
Global $hBrush, $hCollection, $hFamily, $hFormat, $hFont_info, $hFont_score, $hFont_title, $hFont_start, $hFont_high_score, $hFont_highscore_ini, $hFont_game_over, $hFont_FPS
Global $tLayout_info, $tLayout_score, $tLayout_title, $tLayout_start, $tLayout_high_score, $tLayout_highscore_file, $tLayout_game_over, $tLayout_enter_highscore, $tLayout_enter_ini, $tLayout_FPS
Global $font_x, $font_y, $font_w, $font_h, $aInfo
Global Const $text_info = "AutoIteroids" & $ver & "by UEZ 2009"
Global Const $text_title = "AutoIteroids"
Global Const $text_start = "Push Enter to play"
Global Const $text_game_over = "Game Over"
Global $enter_timer, $enter_timer_treshold = 500 ;for blinking of "Push Enter..." text
Font($font, $fontname)
#EndRegion ;font settings

#Region ;Human_Spaceship definitions
Global $current_rotation = 0, $ship_rot_speed = 12, $thrust_key = 0, $ship_angle = 0, $ship_Thrust = 0.75, $ship_max_Thrust = 16
Global $border_limes = 11 * $object_scale, $ship_rot_x_point = 5 * $object_scale, $ship_rot_y_point = 9 * $object_scale, $time_spacebar = 1000, $jump_time_limes = 750
Global $jet_engine_flimmer = 0, $jet_engine_flimmer_frequence = 4, $ship_exploded = 0, $ship_display_delay = 2500, $ship_display_time, $ship_display_time_get
Global $counter_spacebar, $ship_vector_x, $ship_vector_y, $ship_acc_x, $ship_acc_y, $bc
Global $ship_points[9][2], $ship_points_draw[9][2], $explosion_hss[13][4]
;space ship coordinates (dots)
$ship_points[0][0] = 9 * $object_scale ;radius
$ship_points[1][0] = 5 * $object_scale ;top x
$ship_points[1][1] = 1 * $object_scale ;top y
$ship_points[2][0] = 1 * $object_scale ;left bottom x
$ship_points[2][1] = 19 * $object_scale ;left bottm y
$ship_points[3][0] = 9 * $object_scale ;right bottom x
$ship_points[3][1] = 19 * $object_scale ;right bottom y
$ship_points[4][0] = 2 * $object_scale ;middle line x1
$ship_points[4][1] = 16 * $object_scale ;middle line y1
$ship_points[5][0] = 8 * $object_scale ;middle line x2
$ship_points[5][1] = 16 * $object_scale ;middle line y2
$ship_points[6][0] = 3 * $object_scale ;human ship jet engine x1
$ship_points[6][1] = 16 * $object_scale ;human ship jet engine y1
$ship_points[7][0] = 7 * $object_scale ;human ship jet engine x2
$ship_points[7][1] = 16 * $object_scale ;human ship jet engine y2
$ship_points[8][0] = 5 * $object_scale ;human ship jet engine x3
$ship_points[8][1] = 22 * $object_scale ;human ship jet engine y3
For $i = 0 To UBound($ship_points) - 1 ;copy space ship coordinates for calulation to new array (calculation array)
	$ship_points_draw[$i][0] = $ship_points[$i][0]
	$ship_points_draw[$i][1] = $ship_points[$i][1]
Next
#EndRegion ;Human_Spaceship definitionshoot distance

#Region ;Human_Spaceship shooting settings
Global $shoot_max_distance = ($width + $height) * 2 / 5, $amount_of_shoots = 0, $amount_of_shoots_max = 4, $shoot_speed = 20, $time_shoot = 0, $shoot_time_limes = 80
Global $shoot_coordinates_vx, $shoot_coordinates_vy, $counter_shoot
Global $shoot_coordinates[$amount_of_shoots_max + 1][5] ; x, y, slope x, slope y, vector
#EndRegion ;shooting settings

#Region ;explosion
Global Const $explosion_max_amount = 15, $explosion_max_particle = 10, $explosion_length = 60, $explosion_step = 6
Global $explosion_coordinate[$explosion_max_particle][6 * $explosion_max_amount] ; on/off, x, y, vx, vy, v
#EndRegion ;explosion

#Region ;create asteroids
Global Const $asteroids_max = 12, $asteroids_size_x = 47, $asteroids_size_y = 35
Global $tmp
Global $asteroids_coordinate[$asteroids_max * 7][7] ; x, y, vx, vy, on/off, scale, type
Asteroids_Create(0, 7)
Asteroids_Level(4)
#EndRegion ;create asteroids

#Region ;asteroids points
Global $asteroids_points[14][8], $asteroids2_points[14][2], $asteroids3_points[13][2], $asteroids4_points[12][2]

#Region ;asteroid 1
$asteroids_points[0][0] = 21 * $object_scale ;(48 + 36) / 4 = 21
$asteroids_points[1][0] = 13 * $object_scale
$asteroids_points[1][1] = 1 * $object_scale
$asteroids_points[2][0] = 25 * $object_scale
$asteroids_points[2][1] = 5 * $object_scale
$asteroids_points[3][0] = 37 * $object_scale
$asteroids_points[3][1] = 1 * $object_scale
$asteroids_points[4][0] = 48 * $object_scale
$asteroids_points[4][1] = 10 * $object_scale
$asteroids_points[5][0] = 37 * $object_scale
$asteroids_points[5][1] = 14 * $object_scale
$asteroids_points[6][0] = 48 * $object_scale
$asteroids_points[6][1] = 23 * $object_scale
$asteroids_points[7][0] = 37 * $object_scale
$asteroids_points[7][1] = 36 * $object_scale
$asteroids_points[8][0] = 19 * $object_scale
$asteroids_points[8][1] = 32 * $object_scale
$asteroids_points[9][0] = 13 * $object_scale
$asteroids_points[9][1] = 36 * $object_scale
$asteroids_points[10][0] = 1 * $object_scale
$asteroids_points[10][1] = 27 * $object_scale
$asteroids_points[11][0] = 7 * $object_scale
$asteroids_points[11][1] = 19 * $object_scale
$asteroids_points[12][0] = 1 * $object_scale
$asteroids_points[12][1] = 10 * $object_scale
$asteroids_points[13][0] = 13 * $object_scale
$asteroids_points[13][1] = 1 * $object_scale
#EndRegion

#Region ;asteroid 2
$asteroids_points[1][2] = 14 * $object_scale
$asteroids_points[1][3] = 1 * $object_scale
$asteroids_points[2][2] = 31 * $object_scale
$asteroids_points[2][3] = 1 * $object_scale
$asteroids_points[3][2] = 49 * $object_scale
$asteroids_points[3][3] = 9 * $object_scale
$asteroids_points[4][2] = 49 * $object_scale
$asteroids_points[4][3] = 14 * $object_scale
$asteroids_points[5][2] = 32 * $object_scale
$asteroids_points[5][3] = 18 * $object_scale
$asteroids_points[6][2] = 49 * $object_scale
$asteroids_points[6][3] = 27 * $object_scale
$asteroids_points[7][2] = 37 * $object_scale
$asteroids_points[7][3] = 35 * $object_scale
$asteroids_points[8][2] = 31 * $object_scale
$asteroids_points[8][3] = 31 * $object_scale
$asteroids_points[9][2] = 14 * $object_scale
$asteroids_points[9][3] = 35 * $object_scale
$asteroids_points[10][2] = 1 * $object_scale
$asteroids_points[10][3] = 22 * $object_scale
$asteroids_points[11][2] = 1 * $object_scale
$asteroids_points[11][3] = 9 * $object_scale
$asteroids_points[12][2] = 19 * $object_scale
$asteroids_points[12][3] = 9 * $object_scale
$asteroids_points[13][2] = 14 * $object_scale
$asteroids_points[13][3] = 1 * $object_scale
#EndRegion

#Region ;asteroid 3
$asteroids_points[1][4] = 19 * $object_scale
$asteroids_points[1][5] = 1 * $object_scale
$asteroids_points[2][4] = 37 * $object_scale
$asteroids_points[2][5] = 1 * $object_scale
$asteroids_points[3][4] = 48 * $object_scale
$asteroids_points[3][5] = 14 * $object_scale
$asteroids_points[4][4] = 48 * $object_scale
$asteroids_points[4][5] = 23 * $object_scale
$asteroids_points[5][4] = 37 * $object_scale
$asteroids_points[5][5] = 36 * $object_scale
$asteroids_points[6][4] = 25 * $object_scale
$asteroids_points[6][5] = 36 * $object_scale
$asteroids_points[7][4] = 25 * $object_scale
$asteroids_points[7][5] = 23 * $object_scale
$asteroids_points[8][4] = 13 * $object_scale
$asteroids_points[8][5] = 36 * $object_scale
$asteroids_points[9][4] = 1 * $object_scale
$asteroids_points[9][5] = 23 * $object_scale
$asteroids_points[10][4] = 13 * $object_scale
$asteroids_points[10][5] = 19 * $object_scale
$asteroids_points[11][4] = 1 * $object_scale
$asteroids_points[11][5] = 14 * $object_scale
$asteroids_points[12][4] = 19 * $object_scale
$asteroids_points[12][5] = 1 * $object_scale
$asteroids_points[13][4] = 19 * $object_scale
$asteroids_points[13][5] = 1 * $object_scale
#EndRegion

#Region ;asteroid 4
$asteroids_points[1][6] = 13 * $object_scale
$asteroids_points[1][7] = 1 * $object_scale
$asteroids_points[2][6] = 25 * $object_scale
$asteroids_points[2][7] = 10 * $object_scale
$asteroids_points[3][6] = 36 * $object_scale
$asteroids_points[3][7] = 1 * $object_scale
$asteroids_points[4][6] = 48 * $object_scale
$asteroids_points[4][7] = 10 * $object_scale
$asteroids_points[5][6] = 42 * $object_scale
$asteroids_points[5][7] = 19 * $object_scale
$asteroids_points[6][6] = 48 * $object_scale
$asteroids_points[6][7] = 27 * $object_scale
$asteroids_points[7][6] = 31 * $object_scale
$asteroids_points[7][7] = 36 * $object_scale
$asteroids_points[8][6] = 13 * $object_scale
$asteroids_points[8][7] = 36 * $object_scale
$asteroids_points[9][6] = 1 * $object_scale
$asteroids_points[9][7] = 27 * $object_scale
$asteroids_points[10][6] = 1 * $object_scale
$asteroids_points[10][7] = 10 * $object_scale
$asteroids_points[11][6] = 13 * $object_scale
$asteroids_points[11][7] = 1 * $object_scale
$asteroids_points[12][6] = 13 * $object_scale
$asteroids_points[12][7] = 1 * $object_scale
$asteroids_points[13][6] = 13 * $object_scale
$asteroids_points[13][7] = 1 * $object_scale
#EndRegion

#EndRegion ;asteroids points

#Region ;alien star ship
Global $alien_ship_points[9][2]
Global $alien_ship_coordinate[1][6] ; x, y, vx, vy, on/off, typ - 0 = big / 1 = small
Global $alien_ship_move[2][27] ;coordinate for the alien ship movement
Global $alien_ship_shoot_coordinate[1][6] ; x, y, vx, vy, vector distance, off=0 and on=1
Global $alien_ship_shoot_frequence, $alien_ship_shoot_speed = 25, $alien_ship_shoot_distance
Global $alien_ship_vector_fragmentation = 30, $alien_ship_v = 0, $alien_ship_vector_x = 0, $alien_ship_vector_y = 0, $alien_ship_small_factor = 0.60
Global $alien_ship_mid_x, $alien_ship_mid_y, $alien_ship_shoot_x, $alien_ship_shoot_y, $alien_ship_size_factor, $alien_ship_shoot_direction, $counter_alien
Global $alien_ship_x, $alien_ship_y, $alien_ship_model
Alien_Ship_Init()
Alien_Ship_Shoot_Pos($alien_ship_size_factor) ;randomize alien ship shoot
$alien_ship_points[1][0] = 12
$alien_ship_points[1][1] = 1
$alien_ship_points[2][0] = 20
$alien_ship_points[2][1] = 1
$alien_ship_points[3][0] = 10
$alien_ship_points[3][1] = 6
$alien_ship_points[4][0] = 22
$alien_ship_points[4][1] = 6
$alien_ship_points[5][0] = 1
$alien_ship_points[5][1] = 10
$alien_ship_points[6][0] = 31
$alien_ship_points[6][1] = 10
$alien_ship_points[7][0] = $alien_ship_points[3][0]
$alien_ship_points[7][1] = 15
$alien_ship_points[8][0] = $alien_ship_points[4][0]
$alien_ship_points[8][1] = 15
#EndRegion ;alien star ship

#Region ;cheat section ;-)
Global $el = 0, $gm = 0, $tm
If $CmdLine[0] > 0 Then
	For $tm = 1 To $CmdLine[0]
		If $CmdLine[$tm] = "-el" Then $el = 1 ;endless lives
		If $CmdLine[$tm] = "-gm" Then $gm = 1 ;god mode -> no collision with human spaceship ;-))
	Next
EndIf
#EndRegion ;cheat section ;-)

GUIRegisterMsg($WM_ERASEBKGND, "WM_ERASEBKGND")

Global $ship_angle_i = $ship_angle
AdlibRegister("Display_Gui_Title_Info", 25)
$counter_alien = _Timer_Init()
$sound_counter = _Timer_Init()
$dms_timer = _Timer_Init()
$enter_timer = _Timer_Init()
AdlibRegister("FPS", 1000)
Do
	If WinActive($hGUI) Then
		_GDIPlus_GraphicsFillRect($hGraphic, 0, 0, $width, $height, $brush)
		GUISetCursor(16, 1) ;hide mouse
		$aKeyboardState = _WinAPI_GetKeyboardState()
		If BitAND($aKeyboardState[17], 0xF0) > 0 And $start_game And Not $ship_exploded Then ;ctrl -> shoot
			Human_Spaceship_Shoot_Calc()
		EndIf
		If BitAND($aKeyboardState[69], 0xF0) > 0 And $start_game Then Game_Over() ;if E is pressed than Game Over!
		If BitAND($aKeyboardState[70], 0xF0) > 0 Then $display_FPS *= -1 ;display FPS on right upper corner
		If BitAND($aKeyboardState[37], 0xF0) > 0 And $start_game Then $ship_angle_i -= $ship_rot_speed ;rotate ship left
		If BitAND($aKeyboardState[39], 0xF0) > 0 And $start_game Then $ship_angle_i += $ship_rot_speed ;rotate ship right
		If BitAND($aKeyboardState[32], 0xF0) > 0 And $start_game Then ;space bar -> hyper jump
			If $time_spacebar >= $jump_time_limes Then ;allow only 1 hyper jump per second
				$counter_spacebar = _Timer_Init()
				$x = Random(10, $width - 10, 1)
				$y = Random(10, $height - 10, 1)
				$ship_vector_x = 0
				$ship_vector_y = 0
				$amount_of_shoots = 0
			EndIf
			$time_spacebar = _Timer_Diff($counter_spacebar)
		EndIf
		If BitAND($aKeyboardState[38], 0xF0) > 0 And $start_game Then ;thrust of spaceship
			$thrust_key = 1
			$ship_acc_x = Cos(($ship_angle - 90) * $pi_div_180) * $ship_Thrust ;add new x vector for space ship direction
			$ship_acc_y = Sin(($ship_angle - 90) * $pi_div_180) * $ship_Thrust ;add new y vector for space ship direction
			If Abs($ship_vector_x + $ship_acc_x) < $ship_max_Thrust Then $ship_vector_x += $ship_acc_x ;check whether x vector has reached max. Thrust
			If Abs($ship_vector_y + $ship_acc_y) < $ship_max_Thrust Then $ship_vector_y += $ship_acc_y ;check whether y vector has reached max. Thrust
			$jet_engine_flimmer += 1
			Play($hThrust)
		EndIf
		If BitAND($aKeyboardState[13], 0xF0) > 0 And Not $enter_pressed Then
			$start_game = 1 ;start the game
			$enter_pressed = 1
			$score = 0
			$ship_angle_i = 0
			$ship_angle = 0
			$sound_timer = 1000
			$ship_display_delay = 1000
			Asteroids_Create(0, 1)
			Asteroids_Level($level + 1)
			;reset alien space ship
			Alien_Ship_Reset()
			Human_Spaceship_Shoot_Reset()
			Explosion_Reset()
		EndIf

		If $start_game Then
			If _Timer_Diff($sound_counter) > $sound_timer Then ;play in game sound
				$sound_selector = Not $sound_selector
				Play($hGame[$sound_selector])
				$sound_counter = _Timer_Init()
				If $sound_timer >= 160 Then $sound_timer -= 10
			EndIf
			If Not $ship_exploded Then
				$x += $ship_vector_x ;add x vector to space ship
				$y += $ship_vector_y ;add y vector to space ship
				;check space ship for border collision
				$bc = $border_limes * $object_scale
				If $x < -$bc Then $x = $width + $bc
				If $x > $width + $bc Then $x = -$bc
				If $y < -$bc Then $y = $height + $bc
				If $y > $height + $bc Then $y = -$bc
				Human_Spaceship($x, $y, $ship_angle_i) ;draw space ship
				$ship_vector_x *= 0.9875 ;automatic slow down x vecor of human spaceship although in space is no friction ;-) but in original game is slow down implemented
				$ship_vector_y *= 0.9875 ;automatic slow down y vecor of human spaceship although in space is no friction ;-) but in original game is slow down implemented
				$ship_display_time_get = _Timer_Init()
			Else
				$ship_display_time = _Timer_Diff($ship_display_time_get)
				If $ship_display_time > $ship_display_delay Then
					For $h = 0 To UBound($asteroids_coordinate) - 1 ;check for objects at start point
						If $asteroids_coordinate[$h][4] Then
							$ht = Pixel_Distance($asteroids_coordinate[$h][0] + 24 * $asteroids_coordinate[$h][5], $asteroids_coordinate[$h][1] + 18 * $asteroids_coordinate[$h][5], $width * 0.5, $height * 0.5)
							If $ht < $cd Then $cd = $ht
						EndIf
					Next
					If $alien_ship_move[0][24] Then
						$ht = Pixel_Distance($width * 0.5, $height * 0.5, $alien_ship_x + 15.5 * $alien_ship_size_factor, $alien_ship_y + 7.5 * $alien_ship_size_factor)
						If $ht < $cd Then $cd = $ht
					EndIf
					If $cd >= $min_distance * $object_scale Then ;if any object is closer than $min_distance than wait until all objects have more distance (fairplay)
						$ship_exploded = 0
						$x = $width * 0.5
						$y = $height * 0.5
						$ship_vector_x = 0
						$ship_vector_y = 0
						$ship_angle_i = 0
						$ship_angle = 0
					EndIf
					$cd = 0xFFFF
				EndIf
				Explosion_HSS() ;draw human spaceship explosion
			EndIf
			If $extra_live_counter - Floor($score / 30000) = 0 Then ;every 30000 points extra live
				$lives += 1
				$extra_live_counter += 1
				Play($hExtra_Live)
			EndIf
		EndIf
		Asteroids() ;draw asteroids
		If $start_game Then Human_Spaceship_Shoot()
		Display_Score()
		If Not $start_game Then Display_Info()
		Alien_Ship_Calc_New_Pos()
		Explosion() ;draw explosion of asteroids or alien space ship
		Collision_Check()
		_WinAPI_BitBlt($hDC, 0, 0, $width, $height, $hDC_backbuffer, 0, 0, $SRCCOPY)
		$ship_angle = Mod($ship_angle_i, 360) ;calculate angle to get value from 0-359
	EndIf
	$fps_c += 1
Until Not Sleep(30)

Func FPS()
	$fps = $fps_c
	$fps_c = 0
EndFunc

Func Game_Over()
	$start_game = 0
	$game_over = 1
	_BASS_ChannelStop($hAlien[$alien_ship_model])
	$game_over_time = _Timer_Init()
EndFunc   ;==>Game_Over

Func Collision_Check() ;simple collision check  :-|
	Local $t, $j, $pd, $finished = 0, $txa, $tya, $tra
	Local $tx = 28
	Local $ty = 22
	Local $tr = ($height / ($width * 0.66666667)) * 32 * $object_scale
	For $t = 0 To UBound($asteroids_coordinate) - 1 ;check collision asteroid against alien starship, alien shoot and human starship
		$finished += $asteroids_coordinate[$t][4] ;count amount of active asteroids
		If $asteroids_coordinate[$t][4] Then
			$txa = $tx * $asteroids_coordinate[$t][5]
			$tya = $ty * $asteroids_coordinate[$t][5]
			$tra = $tr * $asteroids_coordinate[$t][5]
			$pd = Pixel_Distance($asteroids_coordinate[$t][0] + $txa, $asteroids_coordinate[$t][1] + $tya, _
					$alien_ship_x + 15.5 * $alien_ship_size_factor, $alien_ship_y + 7.5 * $alien_ship_size_factor)
			If $pd < (9 * $alien_ship_size_factor) + ($tra) And $alien_ship_move[0][24] Then ;check collision asteroid with alien starship
				Alien_Ship_Reset()
				Explosion_Init($alien_ship_x + 23 * $alien_ship_size_factor, $alien_ship_y + 23 * $alien_ship_size_factor)
				Asteroids_Split($t, $asteroids_coordinate[$t][0] + $txa, $asteroids_coordinate[$t][1] + $tya)
				Explosion_Init($asteroids_coordinate[$t][0] + $txa, $asteroids_coordinate[$t][1] + $tya)
			EndIf

			If $alien_ship_move[0][24] Then
				$pd = Pixel_Distance($asteroids_coordinate[$t][0] + $txa, $asteroids_coordinate[$t][1] + $tya, _
						 -45 * $alien_ship_size_factor + $alien_ship_x + $alien_ship_shoot_coordinate[0][0], -25 * $alien_ship_size_factor + $alien_ship_y + $alien_ship_shoot_coordinate[0][1])
				If $pd < $tra Then ;check collision asteroid with alien starship shoot
					Explosion_Init($asteroids_coordinate[$t][0] + $txa, $asteroids_coordinate[$t][1] + $tya)
					Asteroids_Split($t, $asteroids_coordinate[$t][0] + $txa, $asteroids_coordinate[$t][1] + $tya)
					$alien_ship_shoot_coordinate[0][0] = 0xFFFF
					$alien_ship_shoot_coordinate[0][1] = 0xFFFF
					$alien_ship_shoot_coordinate[0][2] = 0
					$alien_ship_shoot_coordinate[0][3] = 0
					$alien_ship_shoot_coordinate[0][4] = 0xFFFF
				EndIf
			EndIf

			If $start_game Then
				$pd = Pixel_Distance($asteroids_coordinate[$t][0] + $txa, $asteroids_coordinate[$t][1] + $tya, $x, $y)
				If $pd < $tra + 1 And Not $gm Then ;check collision asteroid with human starship
					Explosion_Init($asteroids_coordinate[$t][0] + $txa, $asteroids_coordinate[$t][1] + $tya)
					Asteroids_Split($t, $asteroids_coordinate[$t][0] + $txa, $asteroids_coordinate[$t][1] + $tya)
					Add_Points($t)
					Explosion_Init($x, $y)
					Copy_HSS_Coordinates($x, $y)
					$ship_exploded = 1 ;human starship explosion initialize
					$x = 0xFFFF
					$y = 0xFFFF
					If Not $el Then $lives -= 1
					If $lives < 1 Then Game_Over()
				EndIf

				For $j = 0 To UBound($shoot_coordinates) - 1 ;check asteroid with human starship shoot
					If $shoot_coordinates[$j][4] > 0 And $asteroids_coordinate[$t][4] > 0 Then
						$pd = Pixel_Distance($asteroids_coordinate[$t][0] + $txa, $asteroids_coordinate[$t][1] + $tya, $shoot_coordinates[$j][0], $shoot_coordinates[$j][1])
						If $pd < $tra Then
							Explosion_Init($asteroids_coordinate[$t][0] + $txa, $asteroids_coordinate[$t][1] + $tya)
							Asteroids_Split($t, $asteroids_coordinate[$t][0] + $txa, $asteroids_coordinate[$t][1] + $tya)
							Add_Points($t)
							$shoot_coordinates[$j][4] = 0
							$amount_of_shoots -= 1
						EndIf
					EndIf
				Next
			EndIf
		EndIf
	Next

	If $start_game And $alien_ship_move[0][24] Then
		For $t = UBound($shoot_coordinates) - 1 To 0 Step -1 ;check collision between human starship shoot and alien starship
			If $shoot_coordinates[$t][4] > 0 And $start_game Then
				If $alien_ship_move[0][24] Then
					$pd = Pixel_Distance($shoot_coordinates[$t][0], $shoot_coordinates[$t][1], $alien_ship_x + 15 * $alien_ship_size_factor, $alien_ship_y + 8 * $alien_ship_size_factor)
					If $pd < 22 * $alien_ship_size_factor Then
						If $alien_ship_model = 0 Then
							$score += 200
						Else
							$score += 1000
						EndIf
						Alien_Ship_Reset()
						Explosion_Init($alien_ship_x + 15 * $alien_ship_size_factor, $alien_ship_y + 8 * $alien_ship_size_factor)
						$shoot_coordinates[$t][0] = 0xFFFF
						$shoot_coordinates[$t][1] = 0xFFFF
						$shoot_coordinates[$t][4] = 0
						$amount_of_shoots -= 1
					EndIf
				EndIf
			EndIf
		Next

		For $t = UBound($shoot_coordinates) - 1 To 0 Step -1 ;check collision between alien starship shoot and human starship
			$pd = Pixel_Distance($x, $y, -45 * $alien_ship_size_factor + $alien_ship_x + $alien_ship_shoot_coordinate[0][0], -25 * $alien_ship_size_factor + $alien_ship_y + $alien_ship_shoot_coordinate[0][1])
			If $pd < $ship_points[0][0] And Not $gm Then
				If Not $alien_ship_model Then
					$score += 200
				Else
					$score += 1000
				EndIf
				Explosion_Init($x, $y)
				Copy_HSS_Coordinates($x, $y)
				$ship_exploded = 1 ;human starship explosion initialize
				$x = 0xFFFF
				$y = 0xFFFF
				If Not $el Then $lives -= 1
				If $lives < 1 Then Game_Over()
			EndIf
		Next

		$pd = Pixel_Distance($x, $y, $alien_ship_x + 15.5 * $alien_ship_size_factor, $alien_ship_y + 7.5 * $alien_ship_size_factor)
		If $pd < (15 * $alien_ship_size_factor) + $ship_points[0][0] And Not $gm Then ;check collision between alien starship and human starship
			If Not $el Then $lives -= 1
			Explosion_Init($x, $y)
			Copy_HSS_Coordinates($x, $y)
			$ship_exploded = 1
			$x = 0xFFFF
			$y = 0xFFFF
			Explosion_Init($alien_ship_x + 23 * $alien_ship_size_factor, $alien_ship_y + 23 * $alien_ship_size_factor)
			Alien_Ship_Reset()
			$alien_ship_move[0][24] = 0
			If $lives < 1 Then Game_Over()
		EndIf
	EndIf

	If $finished > 0 Then $level_finished_delay = _Timer_Init()
	If Not $finished And Not $start_game Then ;check amount of asteroids
		Asteroids_Create(0, 7)
		Asteroids_Level(5)
	ElseIf Not $finished And $start_game And Not $alien_ship_move[0][24] Then
		If _Timer_Diff($level_finished_delay) > $level_finished_delay_treshold Then ;wait a little bit until new asteroids will be drawn to screen
			Asteroids_Create(0, 7)
			$sound_timer = 1000
			$tmp = Floor($score / 10000)
			If $tmp + 2 <= $asteroids_max Then
				Asteroids_Level($tmp + 2) ;every 10000 points increase amount of asteroids until max. asteroids has been reached
				$level = $tmp + 1
				GUI_Title_Info_Text() ;refresh GUI title text info
			EndIf
		Else
			$counter_alien = _Timer_Init() ;avoid alien spaceship appeareance during idle time
		EndIf
	EndIf
EndFunc   ;==>Collision_Check

Func Add_Points($t)
	Local $tst = Mod($t, 7)
	Switch $tst
		Case 0 ;biggest asteroid was hit
			$score += 20
		Case 1 ;middle sized asteroid was hit
			$score += 50
		Case 2 ;middle sized asteroid was hit
			$score += 50
		Case 3 To 6 ;smallest asteroid was hit
			$score += 100
	EndSwitch
EndFunc   ;==>Add_Points

Func Human_Spaceship($x, $y, $angle) ;draw space ship to screen
	Local $cos = Cos($angle * $pi_div_180)
	Local $sin = Sin($angle * $pi_div_180)
	For $i = 0 To UBound($ship_points) - 1 ;rotate space ship with given angle
		$ship_points_draw[$i][0] = ($ship_points[$i][0] - $ship_rot_x_point) * $cos - ($ship_points[$i][1] - $ship_rot_y_point) * $sin
		$ship_points_draw[$i][1] = ($ship_points[$i][1] - $ship_rot_y_point) * $cos + ($ship_points[$i][0] - $ship_rot_x_point) * $sin
	Next
	;draw space ship
	DllCall($ghGDIPDll, "int", "GdipDrawLine", "handle", $hGraphic, "handle", $pen, "float", $x + $ship_points_draw[1][0], "float", $y + $ship_points_draw[1][1], "float", $x + $ship_points_draw[2][0], "float", $y + $ship_points_draw[2][1])
	DllCall($ghGDIPDll, "int", "GdipDrawLine", "handle", $hGraphic, "handle", $pen, "float", $x + $ship_points_draw[1][0], "float", $y + $ship_points_draw[1][1], "float", $x + $ship_points_draw[3][0], "float", $y + $ship_points_draw[3][1])
	DllCall($ghGDIPDll, "int", "GdipDrawLine", "handle", $hGraphic, "handle", $pen, "float", $x + $ship_points_draw[4][0], "float", $y + $ship_points_draw[4][1], "float", $x + $ship_points_draw[5][0], "float", $y + $ship_points_draw[5][1])
	If $thrust_key Then ;draw also jet engine lines when Thrust was activated
		If Mod($jet_engine_flimmer, $jet_engine_flimmer_frequence) < $jet_engine_flimmer_frequence - 1 Then ;let jet engine flimmer
			DllCall($ghGDIPDll, "int", "GdipDrawLine", "handle", $hGraphic, "handle", $pen, "float", $x + $ship_points_draw[6][0], "float", $y + $ship_points_draw[6][1], "float", $x + $ship_points_draw[8][0], "float", $y + $ship_points_draw[8][1])
			DllCall($ghGDIPDll, "int", "GdipDrawLine", "handle", $hGraphic, "handle", $pen, "float", $x + $ship_points_draw[7][0], "float", $y + $ship_points_draw[7][1], "float", $x + $ship_points_draw[8][0], "float", $y + $ship_points_draw[8][1])
		EndIf
		$thrust_key = 0
	EndIf

EndFunc   ;==>Human_Spaceship

Func Human_Spaceship_Shoot_Reset()
	Local $a
	For $a = 0 To UBound($shoot_coordinates) - 1
		$shoot_coordinates[$a][4] = 0
	Next
	$amount_of_shoots = 0
EndFunc   ;==>Human_Spaceship_Shoot_Reset

Func Human_Spaceship_Shoot_Calc()
	If $amount_of_shoots <= $amount_of_shoots_max - 1 And $amount_of_shoots > -1 And $time_shoot >= $shoot_time_limes Then ;create new shot coordinate
		$counter_shoot = _Timer_Init() ;set time for shoot frequency
		$shoot_coordinates_vx = Cos(($ship_angle - 90) * $pi_div_180) * $shoot_speed
		$shoot_coordinates_vy = Sin(($ship_angle - 90) * $pi_div_180) * $shoot_speed
		$shoot_coordinates[$amount_of_shoots_max - $amount_of_shoots][0] = $x + $ship_points_draw[1][0] - $shoot_coordinates_vx * 0.66666667 ;set start point of shoot x coordinate
		$shoot_coordinates[$amount_of_shoots_max - $amount_of_shoots][1] = $y + $ship_points_draw[1][1] - $shoot_coordinates_vy * 0.66666667 ;set start point of shoot y coordinate
		$shoot_coordinates[$amount_of_shoots_max - $amount_of_shoots][2] = $shoot_coordinates_vx ;set vector x
		$shoot_coordinates[$amount_of_shoots_max - $amount_of_shoots][3] = $shoot_coordinates_vy ;set vector y
		$shoot_coordinates[$amount_of_shoots_max - $amount_of_shoots][4] = 1
		$amount_of_shoots += 1
		Play($hShoot)
	EndIf
	$time_shoot = _Timer_Diff($counter_shoot)
EndFunc   ;==>Human_Spaceship_Shoot_Calc

Func Human_Spaceship_Shoot()
	Local $a, $b = 0
	For $a = 0 To UBound($shoot_coordinates) - 1
		If $shoot_coordinates[$a][4] > 0 Then
			$shoot_coordinates[$a][0] += $shoot_coordinates[$a][2] + $ship_vector_x
			$shoot_coordinates[$a][1] += $shoot_coordinates[$a][3] + $ship_vector_y
			If $shoot_coordinates[$a][0] < -$border_limes Then $shoot_coordinates[$a][0] = $width + $border_limes ;check border collision of shoot x
			If $shoot_coordinates[$a][0] > $width + $border_limes Then $shoot_coordinates[$a][0] = -$border_limes ;check border collision of shoot x
			If $shoot_coordinates[$a][1] < -$border_limes Then $shoot_coordinates[$a][1] = $height + $border_limes ;check border collision of shoot y
			If $shoot_coordinates[$a][1] > $height + $border_limes Then $shoot_coordinates[$a][1] = -$border_limes ;check border collision of shoot y
			$shoot_coordinates[$a][4] += Abs($shoot_coordinates[$a][2]) + Abs($shoot_coordinates[$a][3])
			If $shoot_coordinates[$a][4] > $shoot_max_distance Then
				$amount_of_shoots -= 1
				$shoot_coordinates[$a][4] = 0
				_ArraySort($shoot_coordinates, 0, 0, 0, 4)
			EndIf
			$b += $shoot_coordinates[$a][4]
			If Not $b Then $amount_of_shoots = 0
			_GDIPlus_GraphicsDrawEllipse($hGraphic, $shoot_coordinates[$a][0], $shoot_coordinates[$a][1], 1, 1, $pen)
		EndIf
	Next
EndFunc   ;==>Human_Spaceship_Shoot

Func Asteroids_Split($n, $s_x, $s_y)
	Local $splitter, $scale = 0.50
	$splitter = Mod($n, 7)
	Switch $splitter
		Case 0 ;biggest asteroid was hit -> split asteroid
			Asteroids_Gen_Split_Coordinates($n, $n + 1, $n + 2, $s_x, $s_y, $object_scale * $scale)
		Case 1 ;middle sized asteroid was hit -> split asteroid
			Asteroids_Gen_Split_Coordinates($n, $n + 2, $n + 3, $s_x, $s_y, $object_scale * $scale * $scale)
		Case 2 ;middle sized asteroid was hit -> split asteroid
			Asteroids_Gen_Split_Coordinates($n, $n + 3, $n + 4, $s_x, $s_y, $object_scale * $scale * $scale)
	EndSwitch
	$asteroids_coordinate[$n][4] = 0 ;disable asteroid
EndFunc   ;==>Asteroids_Split

Func Asteroids_Gen_Split_Coordinates($n, $limes_left, $limes_right, $s_x, $s_y, $z)
	Local $u
	For $u = $limes_left To $limes_right
		$asteroids_coordinate[$u][0] = $s_x
		$asteroids_coordinate[$u][1] = $s_y
		$asteroids_coordinate[$u][2] = _Random(-3.5 - ($level * 0.66666667), 3.5 + ($level * 0.66666667), 0) ;the higher the level the faster can be the broken asteroid
		$asteroids_coordinate[$u][3] = _Random(-3.5 - ($level * 0.66666667), 3.5 + ($level * 0.66666667), 0)
		$asteroids_coordinate[$u][4] = 1
		$asteroids_coordinate[$u][5] = $z
		$asteroids_coordinate[$u][6] = $asteroids_coordinate[$n][6]
	Next
EndFunc   ;==>Asteroids_Gen_Split_Coordinates

Func Asteroids_Create($enable, $step)
	For $i = 0 To UBound($asteroids_coordinate) - 1 Step $step
		$tmp = Random(1, 10, 1)
		If Not Mod($tmp, 2) Then ;random x coordinate
			$asteroids_coordinate[$i][0] = Random($width * 0.025, $width * 0.05, 1) ;position on the left side (2/40 from width)
		Else
			$asteroids_coordinate[$i][0] = Random($width * 0.95, $width, 1) ; position on the right side (38/40 from width)
		EndIf
		$asteroids_coordinate[$i][1] = Random($height * 0.025, $height - $height * 0.025, 1) ;random y coordinate from 1/40 to 39/40 of height
		$asteroids_coordinate[$i][2] = _Random(-2.5 - ($level * 0.66666667), 2.5 + ($level * 0.66666667)) ;x vector & ;the higher the level the faster can be the asteroid
		$asteroids_coordinate[$i][3] = _Random(-2.5 - ($level * 0.66666667), 2.5 + ($level * 0.66666667)) ;y vector
		$asteroids_coordinate[$i][4] = $enable ;if 1 then display asteroid
		$asteroids_coordinate[$i][5] = $object_scale
		$asteroids_coordinate[$i][6] = Random(0, 3, 1) ;select asteroid type randomly
	Next
EndFunc   ;==>Asteroids_Create

Func Asteroids_Level($amount_asteroids)
	Local $p
	For $p = 0 To $amount_asteroids
		$asteroids_coordinate[$p * 7][4] = 1
	Next
EndFunc   ;==>Asteroids_Level

Func Asteroids()
	Local $b, $c, $asteroid
	For $c = 0 To UBound($asteroids_coordinate) - 1 ;draw asteroids
		If $asteroids_coordinate[$c][4] Then
			For $b = 1 To UBound($asteroids_points) - 2
				$asteroid = 2 * $asteroids_coordinate[$c][6]
				DllCall($ghGDIPDll, "int", "GdipDrawLine", "handle", $hGraphic, "handle", $pen, _
													  "float", $asteroids_coordinate[$c][0] + $asteroids_points[$b][$asteroid] * $asteroids_coordinate[$c][5], _
													  "float", $asteroids_coordinate[$c][1] + $asteroids_points[$b][$asteroid + 1] * $asteroids_coordinate[$c][5], _
													  "float", $asteroids_coordinate[$c][0] + $asteroids_points[$b + 1][$asteroid] * $asteroids_coordinate[$c][5], _
													  "float", $asteroids_coordinate[$c][1] + $asteroids_points[$b + 1][$asteroid + 1] * $asteroids_coordinate[$c][5])
			Next
			$asteroids_coordinate[$c][0] += $asteroids_coordinate[$c][2]
			$asteroids_coordinate[$c][1] += $asteroids_coordinate[$c][3]
;~ 			_GDIPlus_GraphicsDrawEllipse($hGraphic, $asteroids_coordinate[$c][0], $asteroids_coordinate[$c][1], 2, 2, $pen)
			If $asteroids_coordinate[$c][0] < -$asteroids_size_x * 2 * $asteroids_coordinate[$c][5] Then $asteroids_coordinate[$c][0] = $width + 1 ;check border collision of asteroids1 x
			If $asteroids_coordinate[$c][0] > $width + 1 Then $asteroids_coordinate[$c][0] = -$asteroids_size_x * 2 * $asteroids_coordinate[$c][5] ;check border collision of asteroids1 x
			If $asteroids_coordinate[$c][1] < -$asteroids_size_y * 2 * $asteroids_coordinate[$c][5] Then $asteroids_coordinate[$c][1] = $height + 1;check border collision of asteroids1 y
			If $asteroids_coordinate[$c][1] > $height + 1 Then $asteroids_coordinate[$c][1] = -$asteroids_size_y * 2 * $asteroids_coordinate[$c][5] ;check border collision of asteroids1 y
		EndIf
	Next
EndFunc   ;==>Asteroids

Func Alien_Ship_Reset()
	_BASS_ChannelStop($hAlien[$alien_ship_model])
	$alien_ship_move[0][24] = 0
	$alien_ship_vector_x = 0
	$alien_ship_vector_y = 0
	$alien_ship_v = 0
	$alien_ship_vector_fragmentation = 30
	Alien_Ship_Init()
	$counter_alien = _Timer_Init()
EndFunc   ;==>Alien_Ship_Reset

Func Alien_Ship_Init() ;initialize alien space ship
	Local $e
	;generate route for alien space ship -> $alien_ship_move[0] is from left to right / $alien_ship_move[1] is from right to left
	$alien_ship_move[0][0] = -32
	$alien_ship_move[0][2] = Random($height / 10, $height - $height / 10, 1)
	$alien_ship_move[1][20] = $alien_ship_move[0][0]
	$alien_ship_move[1][22] = $alien_ship_move[0][2]

	$alien_ship_move[0][4] = $width * 2 / 10
	$alien_ship_move[0][6] = Random($height / 10, $height - $height / 10, 1)
	$alien_ship_move[1][16] = $alien_ship_move[0][4]
	$alien_ship_move[1][18] = $alien_ship_move[0][6]

	$alien_ship_move[0][8] = $width * 4 / 10
	$alien_ship_move[0][10] = Random($height / 10, $height - $height / 10, 1)
	$alien_ship_move[1][12] = $alien_ship_move[0][8]
	$alien_ship_move[1][14] = $alien_ship_move[0][10]

	$alien_ship_move[0][12] = $width * 6 / 10
	$alien_ship_move[0][14] = Random($height / 10, $height - $height / 10, 1)
	$alien_ship_move[1][8] = $alien_ship_move[0][12]
	$alien_ship_move[1][10] = $alien_ship_move[0][14]

	$alien_ship_move[0][16] = $width * 8 / 10
	$alien_ship_move[0][18] = Random($height / 10, $height - $height / 10, 1)
	$alien_ship_move[1][4] = $alien_ship_move[0][16]
	$alien_ship_move[1][6] = $alien_ship_move[0][18]

	$alien_ship_move[0][20] = $width + 32
	$alien_ship_move[0][22] = Random($height / 10, $height - $height / 10, 1)
	$alien_ship_move[1][0] = $alien_ship_move[0][20]
	$alien_ship_move[1][2] = $alien_ship_move[0][22]

	For $e = 1 To 20 Step 2
		$alien_ship_move[0][$e] = ($alien_ship_move[0][$e + 3] - $alien_ship_move[0][$e - 1]) / $alien_ship_vector_fragmentation ; calculate direction vector x,y from left to right
	Next
	For $e = 19 To 1 Step -4 ;reverse direction from right to left by negating x,y vectors from left to right
		$alien_ship_move[1][20 - $e] = $alien_ship_move[0][$e - 2] * - 1
		$alien_ship_move[1][22 - $e] = $alien_ship_move[0][$e] * - 1
	Next
	If Mod(Random(0, 3, 1), 1 + Floor(6 / $level)) = 0 Then ; generate alien ship size randomly
		$alien_ship_size_factor = $object_scale * $alien_ship_small_factor ; small alien ship -> the higher the level the higher the occurance of small alien starship
		$alien_ship_model = 1
		$alien_ship_shoot_distance = $width * 30 / $width ;higher distance of smaller alien starship
		$alien_ship_shoot_frequence = 4 ;higher shoot frequence
	Else
		$alien_ship_size_factor = $object_scale ;big size
		$alien_ship_model = 0
		$alien_ship_shoot_distance = $width * 20 / $width ;lower distance of smaller alien starship
		$alien_ship_shoot_frequence = 3
	EndIf
	$alien_ship_shoot_direction = Random(0, 1, 1) ;randomize alien space ship direction -> 0 = fly from left to right, 1 = fly from right to left
EndFunc   ;==>Alien_Ship_Init

Func Alien_Ship_Shoot_Pos($alien_ship_size_factor)
	Local $a, $cr
	$alien_ship_mid_x = 60 * $alien_ship_size_factor
	$alien_ship_mid_y = 32 * $alien_ship_size_factor
	If $start_game = 0 Then
		$a = Random(1, 360, 1) ;just shoot around in demo mode
	Else
		$cr = Mod(Random(1, 4, 1), 4) ;75% chance to shoot in direction of human spaceship
		If $cr > 0 And $alien_ship_model Then ;alien starship will shoot in direction of human spaceship
			$a = Alien_Ship_Shoot_Angle(($alien_ship_x + 7), ($alien_ship_y + 4), $x, $y)
		Else
			$a = Random(1, 360, 1)
		EndIf
	EndIf
	$alien_ship_shoot_x = $alien_ship_mid_x + Cos($a * $pi_div_180) * $alien_ship_shoot_speed
	$alien_ship_shoot_y = $alien_ship_mid_y + Sin($a * $pi_div_180) * $alien_ship_shoot_speed
	$alien_ship_shoot_coordinate[0][0] = $alien_ship_shoot_x
	$alien_ship_shoot_coordinate[0][1] = $alien_ship_shoot_y
	$alien_ship_shoot_coordinate[0][2] = $alien_ship_shoot_x - $alien_ship_mid_x
	$alien_ship_shoot_coordinate[0][3] = $alien_ship_shoot_y - $alien_ship_mid_y
	$alien_ship_shoot_coordinate[0][4] = 0
	$alien_ship_shoot_coordinate[0][5] = 1
	If $start_game Then Play($hShoot)
EndFunc   ;==>Alien_Ship_Shoot_Pos

Func Alien_Ship_Shoot_Angle($ax, $ay, $hx, $hy) ;alien spaceship shoot direction (angle) to human spaceship
	Local $Grad = ($hy <= $ay) * 180 - ATan(($ax - $hx) / ($ay - $hy)) * $180_div_pi + 90
	If $Grad = 360 Then $Grad = 0
	Return $Grad
EndFunc   ;==>Alien_Ship_Shoot_Angle

Func Alien_Ship_Calc_New_Pos()
	If Not $alien_ship_move[0][24] Then
		If _Timer_Diff($counter_alien) > Random(10000, 20000, 1) Then ;appearance of alien starship
			$alien_ship_move[0][24] = 1
			If $start_game Then Play($hAlien[$alien_ship_model])
		EndIf
	EndIf
	If $alien_ship_move[0][24] Then ;display alien space ship
		$alien_ship_vector_x += $alien_ship_move[$alien_ship_shoot_direction][1 + $alien_ship_v]
		$alien_ship_vector_y += $alien_ship_move[$alien_ship_shoot_direction][3 + $alien_ship_v]
		$alien_ship_x = $alien_ship_move[$alien_ship_shoot_direction][$alien_ship_v] - 16 + $alien_ship_vector_x
		$alien_ship_y = $alien_ship_move[$alien_ship_shoot_direction][$alien_ship_v + 2] - 7 + $alien_ship_vector_y
		Alien_Ship_Draw($alien_ship_x, $alien_ship_y, $alien_ship_size_factor)
		If Not $alien_ship_vector_fragmentation Then ;if 0 then section has finished
			$alien_ship_v += 4
			$alien_ship_vector_x = $alien_ship_move[$alien_ship_shoot_direction][1 + $alien_ship_v] ;set new x vector for new section
			$alien_ship_vector_y = $alien_ship_move[$alien_ship_shoot_direction][3 + $alien_ship_v] ;set new y vector for new section
			$alien_ship_vector_fragmentation = 30 ;set the speed of the alien space ship between sections
			If $alien_ship_v = 20 Then ;all sections passed
				$alien_ship_move[0][24] = 0
				$alien_ship_v = 0
				Alien_Ship_Reset()
				$counter_alien = _Timer_Init()
			EndIf
		EndIf
		$alien_ship_vector_fragmentation -= 1
	EndIf
EndFunc   ;==>Alien_Ship_Calc_New_Pos

Func Alien_Ship_Draw($ax, $ay, $scale_factor)
	Local $shoot_x, $shoot_y
	DllCall($ghGDIPDll, "int", "GdipDrawLine", "handle", $hGraphic, "handle", $pen, "float", $ax + $alien_ship_points[1][0] * $scale_factor, "float", $ay + $alien_ship_points[1][1] * $scale_factor, "float", $ax + $alien_ship_points[2][0] * $scale_factor, "float", $ay + $alien_ship_points[2][1] * $scale_factor)
	DllCall($ghGDIPDll, "int", "GdipDrawLine", "handle", $hGraphic, "handle", $pen, "float", $ax + $alien_ship_points[3][0] * $scale_factor, "float", $ay + $alien_ship_points[3][1] * $scale_factor, "float", $ax + $alien_ship_points[4][0] * $scale_factor, "float", $ay + $alien_ship_points[4][1] * $scale_factor)
	DllCall($ghGDIPDll, "int", "GdipDrawLine", "handle", $hGraphic, "handle", $pen, "float", $ax + $alien_ship_points[5][0] * $scale_factor, "float", $ay + $alien_ship_points[5][1] * $scale_factor, "float", $ax + $alien_ship_points[6][0] * $scale_factor, "float", $ay + $alien_ship_points[6][1] * $scale_factor)
	DllCall($ghGDIPDll, "int", "GdipDrawLine", "handle", $hGraphic, "handle", $pen, "float", $ax + $alien_ship_points[7][0] * $scale_factor, "float", $ay + $alien_ship_points[7][1] * $scale_factor, "float", $ax + $alien_ship_points[8][0] * $scale_factor, "float", $ay + $alien_ship_points[8][1] * $scale_factor)
	DllCall($ghGDIPDll, "int", "GdipDrawLine", "handle", $hGraphic, "handle", $pen, "float", $ax + $alien_ship_points[5][0] * $scale_factor, "float", $ay + $alien_ship_points[5][1] * $scale_factor, "float", $ax + $alien_ship_points[7][0] * $scale_factor, "float", $ay + $alien_ship_points[7][1] * $scale_factor)
	DllCall($ghGDIPDll, "int", "GdipDrawLine", "handle", $hGraphic, "handle", $pen, "float", $ax + $alien_ship_points[6][0] * $scale_factor, "float", $ay + $alien_ship_points[6][1] * $scale_factor, "float", $ax + $alien_ship_points[8][0] * $scale_factor, "float", $ay + $alien_ship_points[8][1] * $scale_factor)
	DllCall($ghGDIPDll, "int", "GdipDrawLine", "handle", $hGraphic, "handle", $pen, "float", $ax + $alien_ship_points[5][0] * $scale_factor + 2, "float", $ay + $alien_ship_points[5][1] * $scale_factor, "float", $ax + $alien_ship_points[3][0] * $scale_factor, "float", $ay + $alien_ship_points[3][1] * $scale_factor)
	DllCall($ghGDIPDll, "int", "GdipDrawLine", "handle", $hGraphic, "handle", $pen, "float", $ax + $alien_ship_points[6][0] * $scale_factor - 2, "float", $ay + $alien_ship_points[6][1] * $scale_factor, "float", $ax + $alien_ship_points[4][0] * $scale_factor, "float", $ay + $alien_ship_points[4][1] * $scale_factor)
	DllCall($ghGDIPDll, "int", "GdipDrawLine", "handle", $hGraphic, "handle", $pen, "float", $ax + $alien_ship_points[1][0] * $scale_factor, "float", $ay + $alien_ship_points[1][1] * $scale_factor, "float", $ax + $alien_ship_points[3][0] * $scale_factor, "float", $ay + $alien_ship_points[3][1] * $scale_factor)
	DllCall($ghGDIPDll, "int", "GdipDrawLine", "handle", $hGraphic, "handle", $pen, "float", $ax + $alien_ship_points[2][0] * $scale_factor, "float", $ay + $alien_ship_points[2][1] * $scale_factor, "float", $ax + $alien_ship_points[4][0] * $scale_factor, "float", $ay + $alien_ship_points[4][1] * $scale_factor)

	If $alien_ship_shoot_coordinate[0][4] <= $alien_ship_shoot_distance Then
		$shoot_x = -45 * $scale_factor + $ax + $alien_ship_shoot_coordinate[0][0]
		$shoot_y = -25 * $scale_factor + $ay + $alien_ship_shoot_coordinate[0][1]
		If $shoot_x < -$border_limes Then $alien_ship_shoot_coordinate[0][0] += $width + $border_limes ;check border collision of shoot x
		If $shoot_x > $width + $border_limes Then $alien_ship_shoot_coordinate[0][0] += -$border_limes - $width ;check border collision of shoot x
		If $shoot_y < -$border_limes Then $alien_ship_shoot_coordinate[0][1] += $height + $border_limes ;check border collision of shoot y
		If $shoot_y > $height + $border_limes Then $alien_ship_shoot_coordinate[0][1] += -$border_limes - $height ;check border collision of shoot y
		If $alien_ship_shoot_coordinate[0][5] Then
			_GDIPlus_GraphicsDrawEllipse($hGraphic, -45 * $scale_factor + $ax + $alien_ship_shoot_coordinate[0][0], -25 * $scale_factor + $ay + $alien_ship_shoot_coordinate[0][1], 1, 1, $pen)
			$alien_ship_shoot_coordinate[0][0] += $alien_ship_shoot_coordinate[0][2]
			$alien_ship_shoot_coordinate[0][1] += $alien_ship_shoot_coordinate[0][3]
			$alien_ship_shoot_coordinate[0][4] += $alien_ship_shoot_frequence
		EndIf
	Else
		Alien_Ship_Shoot_Pos($alien_ship_size_factor)
	EndIf
EndFunc   ;==>Alien_Ship_Draw

Func Copy_HSS_Coordinates($x, $y) ;generate human spaceship coordinates for explosion
	Local $hss
	$explosion_hss[1][0] = $x + $ship_points_draw[1][0]
	$explosion_hss[1][1] = $y + $ship_points_draw[1][1]
	$explosion_hss[4][0] = $x + $ship_points_draw[2][0]
	$explosion_hss[4][1] = $y + $ship_points_draw[2][0]
	$explosion_hss[5][0] = $x + $ship_points_draw[1][0]
	$explosion_hss[5][1] = $y + $ship_points_draw[1][1]
	$explosion_hss[8][0] = $x + $ship_points_draw[3][0]
	$explosion_hss[8][1] = $y + $ship_points_draw[3][1]
	$explosion_hss[9][0] = $x + $ship_points_draw[4][0]
	$explosion_hss[9][1] = $y + $ship_points_draw[4][1]
	$explosion_hss[12][0] = $x + $ship_points_draw[5][0]
	$explosion_hss[12][1] = $y + $ship_points_draw[5][1]

	;split left line of human space ship
	$explosion_hss[2][0] = $x + ($explosion_hss[4][0] - $explosion_hss[1][0]) * 0.50
	$explosion_hss[3][0] = $explosion_hss[2][0]
	$explosion_hss[2][1] = $y + ($explosion_hss[4][1] - $explosion_hss[1][1]) * 0.50
	$explosion_hss[3][1] = $explosion_hss[2][1]

	;split right line of human space ship
	$explosion_hss[6][0] = $x + ($explosion_hss[8][0] - $explosion_hss[1][0]) * 0.50
	$explosion_hss[7][0] = $explosion_hss[6][0]
	$explosion_hss[6][1] = $y + ($explosion_hss[8][1] - $explosion_hss[1][1]) * 0.50
	$explosion_hss[7][1] = $explosion_hss[6][1]

	;split middle line of human space ship
	$explosion_hss[10][0] = $x + ($explosion_hss[12][0] - $explosion_hss[9][0]) * 0.50
	$explosion_hss[11][0] = $explosion_hss[10][0]
	$explosion_hss[10][1] = $y + ($explosion_hss[12][1] - $explosion_hss[9][1]) * 0.50
	$explosion_hss[11][1] = $explosion_hss[10][1]

	For $hss = 1 To UBound($explosion_hss) - 2 Step 2
		$explosion_hss[$hss][2] = (1 + $ship_vector_x * 0.125) * _Random(-2.5, 2.5)
		$explosion_hss[$hss + 1][2] = $explosion_hss[$hss][2]
		$explosion_hss[$hss][3] = (1 + $ship_vector_y * 0.125) * _Random(-2.5, 2.5)
		$explosion_hss[$hss + 1][3] = $explosion_hss[$hss][3]
	Next
	$r = 0xFF
	$g = $r
	$b = $r
EndFunc   ;==>Copy_HSS_Coordinates

Func Explosion_HSS() ;draw human spaceship explosion
	Local $hss
	For $hss = 1 To UBound($explosion_hss) - 2 Step 2
		$explosion_hss[$hss][0] += $explosion_hss[$hss][2]
		$explosion_hss[$hss][1] += $explosion_hss[$hss][3]
		$explosion_hss[$hss + 1][0] += $explosion_hss[$hss + 1][2]
		$explosion_hss[$hss + 1][1] += $explosion_hss[$hss + 1][3]
		_GDIPlus_GraphicsDrawLine($hGraphic, $explosion_hss[$hss][0], $explosion_hss[$hss][1], $explosion_hss[$hss + 1][0], $explosion_hss[$hss + 1][1], $pen2)
	Next
	$r *= 0.90
	$g = $r
	$b = $r
	_GDIPlus_PenSetColor($pen2, "0xD0" & Hex(Int($r), 2) & Hex(Int($g), 2) & Hex(Int($b), 2))
EndFunc   ;==>Explosion_HSS

Func Explosion_Init($ex, $ey) ;initialise explosion of object except human star ship
	For $o = 0 To $explosion_step * ($explosion_max_amount - 1) Step $explosion_step ;fill array with coordinate of hit object
		If $explosion_coordinate[0][$o] <> 1 Then
			$explosion_coordinate[0][$o] = 1
			$explosion_coordinate[0][$o + 1] = $ex ;save x coordinate
			$explosion_coordinate[0][$o + 2] = $ey ;save x coordinate
			For $n = 0 To $explosion_max_particle - 1
				$explosion_coordinate[$n][$o + 1] = $explosion_coordinate[0][$o + 1] ;duplicate x start position of all explosion particles
				$explosion_coordinate[$n][$o + 2] = $explosion_coordinate[0][$o + 2] ;duplicate y start position of all explosion particles
				$explosion_coordinate[$n][$o + 3] = _Random(-5, 5, 1) ;create random x vector (explosion particle speed)
				$explosion_coordinate[$n][$o + 4] = _Random(-5, 5, 1) ;create random y vector (explosion particle speed)
				$explosion_coordinate[$n][$o + 5] = Abs($explosion_coordinate[$n][3 + $o]) + Abs($explosion_coordinate[$n][4 + $o]) ;add absolute distance of vectors x and y
			Next
			ExitLoop
		EndIf
	Next
	If $start_game Then Explosion_Sound()
EndFunc   ;==>Explosion_Init

Func Explosion() ;draw explosions coordinates
	Local $q, $k
	For $k = 0 To $explosion_step * ($explosion_max_amount - 1) Step $explosion_step
		If $explosion_coordinate[0][$k] Then ;only draw active explosions
			For $q = 0 To $explosion_max_particle - 1
				$explosion_coordinate[$q][$k + 1] += $explosion_coordinate[$q][$k + 3] ;draw new x coordinate of a particle
				$explosion_coordinate[$q][$k + 2] += $explosion_coordinate[$q][$k + 4] ;draw new y coordinate of a particle
				$explosion_coordinate[$q][$k + 5] += Abs($explosion_coordinate[$q][$k + 3]) + Abs($explosion_coordinate[$q][$k + 4])
				If $explosion_coordinate[$q][$k + 5] <= $explosion_length Then ;draw until max. distance has been reached
					_GDIPlus_GraphicsDrawEllipse($hGraphic, $explosion_coordinate[$q][$k + 1], $explosion_coordinate[$q][$k + 2], 1, 1, $pen)
				Else ;when max. distance has been reached then set x vector and y vector to 0
					$explosion_coordinate[0][$k] = 0
				EndIf
			Next
		EndIf
	Next
EndFunc   ;==>Explosion

Func Explosion_Reset()
	Local $kk
	For $kk = 0 To $explosion_step * ($explosion_max_amount - 1) Step $explosion_step
		$explosion_coordinate[0][$kk] = 0 ;reset explosion
	Next
EndFunc   ;==>Explosion_Reset

Func Explosion_Sound()
	Local $exp
	$exp = Random(1, 3, 1)
	If $exp = 1 Then Play($hExplosion1)
	If $exp = 2 Then Play($hExplosion2)
	If $exp = 3 Then Play($hExplosion3)
EndFunc   ;==>Explosion_Sound

Func Display_Score() ;display points, lives and hiscore
	Local $d, $px = 80, $py = 30, $dist = 9 * $object_scale
	If $start_game Then
		For $d = 1 To $lives
			_GDIPlus_GraphicsDrawLine($hGraphic, ($dist * $d) + $px + $ship_points[1][0], $py + $ship_points[1][1], ($dist * $d) + $px + $ship_points[2][0], $py + $ship_points[2][1], $pen)
			_GDIPlus_GraphicsDrawLine($hGraphic, ($dist * $d) + $px + $ship_points[1][0], $py + $ship_points[1][1], ($dist * $d) + $px + $ship_points[3][0], $py + $ship_points[3][1], $pen)
			_GDIPlus_GraphicsDrawLine($hGraphic, ($dist * $d) + $px + $ship_points[4][0], $py + $ship_points[4][1], ($dist * $d) + $px + $ship_points[5][0], $py + $ship_points[5][1], $pen)
		Next
	EndIf
	_GDIPlus_GraphicsDrawStringEx($hGraphic, $score, $hFont_score, $tLayout_score, $hFormat, $hBrush)
	_GDIPlus_GraphicsDrawStringEx($hGraphic, $highscore, $hFont_high_score, $tLayout_high_score, $hFormat, $hBrush)
	If $display_FPS = 1 Then _GDIPlus_GraphicsDrawStringEx($hGraphic, $fps, $hFont_FPS, $tLayout_FPS, $hFormat, $hBrush)
EndFunc   ;==>Display_Score

Func Display_Info()
	If Not $game_over And Not $start_game Then
		If $dms Then
			Display_Main_Screen()
		Else
			Display_Highscore()
		EndIf
		If _Timer_Diff($dms_timer) > $dms_switch_time Then
			$dms *= -1
			$dms_timer = _Timer_Init()
		EndIf
	ElseIf $game_over Then
		$aInfo = _GDIPlus_GraphicsMeasureString($hGraphic, $text_game_over, $hFont_game_over, $tLayout_game_over, $hFormat)
		Get_String_Size()
		$tLayout_game_over = _GDIPlus_RectFCreate(($width - $font_w) * 0.5, ($height - $font_h) * 0.5, 0, 0)
		_GDIPlus_GraphicsDrawStringEx($hGraphic, $text_game_over, $hFont_game_over, $tLayout_game_over, $hFormat, $hBrush) ;display GAME OVER
		Explosion_HSS()
		If _Timer_Diff($game_over_time) > 5000 Then
			Check_Score()
			$game_over = 0
			;$score = 0
			$enter_pressed = 0
			$lives = 3
		EndIf
	EndIf
EndFunc   ;==>Display_Info

Func Display_Main_Screen()
	$aInfo = _GDIPlus_GraphicsMeasureString($hGraphic, $text_info, $hFont_info, $tLayout_score, $hFormat)
	Get_String_Size()
	$tLayout_info = _GDIPlus_RectFCreate(($width - $font_w) * 0.5, $height - $font_h - 10, 0, 0)
	_GDIPlus_GraphicsDrawStringEx($hGraphic, $text_info, $hFont_info, $tLayout_info, $hFormat, $hBrush) ;display info at the bottom

	$tLayout_title = _GDIPlus_RectFCreate()
	$aInfo = _GDIPlus_GraphicsMeasureString($hGraphic, $text_title, $hFont_title, $tLayout_title, $hFormat)
	Get_String_Size()
	$tLayout_title = _GDIPlus_RectFCreate(($width - $font_w) * 0.5, ($height - $font_h) / 3, 0, 0)
	_GDIPlus_GraphicsDrawStringEx($hGraphic, $text_title, $hFont_title, $tLayout_title, $hFormat, $hBrush) ;display AUTOITEROIDS title

	If _Timer_Diff($enter_timer) <= $enter_timer_treshold Then
		$tLayout_start = _GDIPlus_RectFCreate()
		$aInfo = _GDIPlus_GraphicsMeasureString($hGraphic, $text_start, $hFont_start, $tLayout_start, $hFormat)
		Get_String_Size()
		$tLayout_start = _GDIPlus_RectFCreate(($width - $font_w) * 0.5, ($height - $font_h) * 0.66666667, 0, 0)
		_GDIPlus_GraphicsDrawStringEx($hGraphic, $text_start, $hFont_start, $tLayout_start, $hFormat, $hBrush) ;display PRESS ENTER TO PLAY
	ElseIf _Timer_Diff($enter_timer) > 2 * $enter_timer_treshold Then
		$enter_timer = _Timer_Init()
	EndIf
EndFunc   ;==>Display_Main_Screen

Func Check_Score()
	Local $cs, $mv
	For $cs = 1 To UBound($aHighscore) - 1
		If $score >= $aHighscore[$cs][0] Then
			For $mv = UBound($aHighscore) - 1 To $cs + 1 Step -1 ;move score down
				$aHighscore[$mv][0] = $aHighscore[$mv - 1][0]
				$aHighscore[$mv][1] = $aHighscore[$mv - 1][1]
			Next
			_BASS_ChannelStop($hAlien[$alien_ship_model]) ;stop sound of alien starship
			$aHighscore[$cs][0] = $score ;save score
			$aHighscore[$cs][1] = Highscore_Enter_Initials() ;save initials to highscore
			Create_Highscore_File(Array_To_String($aHighscore)) ;convert to string and write to file
			$dms = -1 ;set parameter to display highscore at main screen
			ExitLoop
		EndIf
	Next
	$dms_timer = _Timer_Init()
EndFunc   ;==>Check_Score

Func Array_To_String($array) ;convert 2D array to a string
	Local $cc, $string
	$string = ""
	For $cc = 1 To UBound($array) - 1
		$string &= $array[$cc][0] & "," & $array[$cc][1] & ","
	Next
	Return StringLeft($string, StringLen($string) - 1)
EndFunc   ;==>Array_To_String

Func Highscore_Enter_Initials()
	Local $text, $1 = "A", $2 = "_", $3 = "_", $ci = 1, $temp, $end = False
	$text = "Congratulations!" & @CRLF & @CRLF & _
			"Your score is one of the five best." & @CRLF & _
			"Please enter your initials!" & @CRLF & _
			"Push rotate to select letter." & @CRLF & _
			"Push hyperspace when letters is correct."
	$tLayout_enter_highscore = _GDIPlus_RectFCreate(0, 0, 0, 0)
	$aInfo = _GDIPlus_GraphicsMeasureString($hGraphic, $text, $hFont_score, $tLayout_enter_highscore, $hFormat)
	Get_String_Size()
	$tLayout_enter_highscore = _GDIPlus_RectFCreate(($width - $font_w) * 0.5, 100, 0, 0)

	$tLayout_enter_ini = _GDIPlus_RectFCreate(0, 0, 0, 0)
	$aInfo = _GDIPlus_GraphicsMeasureString($hGraphic, $1 & $2 & $2, $hFont_highscore_ini, $tLayout_enter_ini, $hFormat)
	Get_String_Size()
	$tLayout_enter_ini = _GDIPlus_RectFCreate(($width - $font_w) * 0.5, $height * 0.66, 0, 0)
	While Not $end
		_GDIPlus_GraphicsClear($hGraphic, 0xFF000000) ;clear backbuffer
		Display_Score()
		_GDIPlus_GraphicsDrawStringEx($hGraphic, $text, $hFont_score, $tLayout_enter_highscore, $hFormat, $hBrush)
		_GDIPlus_GraphicsDrawStringEx($hGraphic, $1 & $2 & $3, $hFont_highscore_ini, $tLayout_enter_ini, $hFormat, $hBrush)
		_WinAPI_BitBlt($hDC, 0, 0, $width, $height, $hDC_backbuffer, 0, 0, $SRCCOPY)
		$aKeyboardState = _WinAPI_GetKeyboardState()
		If BitAND($aKeyboardState[37], 0xF0) > 0 Then ;when left arrow is pressed
			Switch $ci
				Case 1
					$temp = Asc($1)
					$temp -= 1
					If $temp < 32 Then $temp = 96
					$1 = Chr($temp)
				Case 2
					$temp = Asc($2)
					$temp -= 1
					If $temp < 32 Then $temp = 96
					$2 = Chr($temp)
				Case 3
					$temp = Asc($3)
					$temp -= 1
					If $temp < 32 Then $temp = 96
					$3 = Chr($temp)
			EndSwitch
		EndIf

		If BitAND($aKeyboardState[39], 0xF0) > 0 Then ;when right arrow is pressed
			Switch $ci
				Case 1
					$temp = Asc($1)
					$temp += 1
					If $temp > 96 Then $temp = 32
					$1 = Chr($temp)
				Case 2
					$temp = Asc($2)
					$temp += 1
					If $temp > 96 Then $temp = 32
					$2 = Chr($temp)
				Case 3
					$temp = Asc($3)
					$temp += 1
					If $temp > 96 Then $temp = 32
					$3 = Chr($temp)
			EndSwitch
		EndIf

		If BitAND($aKeyboardState[32], 0xF0) > 0 Then ;when space is pressed
			$ci += 1
			If $ci = 2 Then $2 = "A"
			If $ci = 3 Then $3 = "A"
		EndIf
		If $ci = 4 Then $end = True
		Sleep(120)
	WEnd
	Return $1 & $2 & $3
EndFunc   ;==>Highscore_Enter_Initials

Func Display_Highscore()
	Local $hs, $hstep = 0, $hs_text
	$aInfo = _GDIPlus_GraphicsMeasureString($hGraphic, "Highscore", $hFont_score, $tLayout_score, $hFormat)
	Get_String_Size()
	$tLayout_highscore_file = _GDIPlus_RectFCreate(($width - $font_w) * 0.5, ($height - $font_h) / 4 + $hstep, 0, 0)
	_GDIPlus_GraphicsDrawStringEx($hGraphic, "Highscore", $hFont_score, $tLayout_highscore_file, $hFormat, $hBrush)
	$hstep += 32 ;line distance^
	For $hs = 1 To UBound($aHighscore) - 1
		$hs_text = $hs & ". " & StringFormat("%06s ", $aHighscore[$hs][0]) & $aHighscore[$hs][1]
		$aInfo = _GDIPlus_GraphicsMeasureString($hGraphic, $hs_text, $hFont_score, $tLayout_score, $hFormat)
		Get_String_Size()
		$tLayout_highscore_file = _GDIPlus_RectFCreate($width * 0.385, ($height - $font_h) / 3 + $hstep, 0, 0)
		_GDIPlus_GraphicsDrawStringEx($hGraphic, $hs_text, $hFont_score, $tLayout_highscore_file, $hFormat, $hBrush)
		$hstep += $width * 32 / 720 ;distance between lines
	Next
EndFunc   ;==>Display_Highscore

Func Create_Highscore_File($str = "100000,UEZ,75000,UEZ,50000,UEZ,25000,UEZ,5000,UEZ")
	Local $buffer, $hFile
	$buffer = StringToBinary($str) ;standard highscore
	$buffer &= ";" & GenerateChecksum($buffer) ;generate checksum to detect highscore manipulations
	$hFile = FileOpen($highscore_file, 2)
	FileWrite($hFile, $buffer)
	FileClose($hFile)

;~ 	_FileCreate($highscore_file) ;create file
;~ 	_FileWriteToLine($highscore_file, 1, $buffer, 1) ;write to file

	Read_Highscore_File()
EndFunc   ;==>Create_Highscore_File

Func Read_Highscore_File()
	Local $read, $aConvert, $aDecrypt, $decrypt, $xxx, $yyy
	$read = FileReadLine($highscore_file, 1)
	;decrypt
	$aDecrypt = StringSplit($read, ";")
	If @error Then
		MsgBox(16, "ERROR!", "Wrong highscore file format!" & @CRLF & @CRLF & "Generating standard file format", 15)
		FileDelete($highscore_file)
		Create_Highscore_File()
	EndIf
	If GenerateChecksum($aDecrypt[1]) <> $aDecrypt[2] Then
		MsgBox(16, "ERROR!", "Highscore file manipulation detected!" & @CRLF & @CRLF & "Generating standard file format", 15)
		FileDelete($highscore_file)
		Create_Highscore_File()
	EndIf

	$decrypt = BinaryToString($aDecrypt[1])
	If @error Then
		MsgBox(16, "ERROR!", "Unaccepted decrypt error!" & @CRLF & @CRLF & "Terminating!", 15)
		Exit
	EndIf
	$aConvert = StringSplit($decrypt, ",", 2) ;0 based
	$yyy = 1
	For $xxx = 0 To UBound($aConvert) - 2 Step 2 ;fill highscore with values
		$aHighscore[$yyy][0] = $aConvert[$xxx]
		$aHighscore[$yyy][1] = $aConvert[$xxx + 1]
		$yyy += 1
	Next
	$aHighscore[0][0] = UBound($aHighscore) - 1
EndFunc   ;==>Read_Highscore_File

Func Get_String_Size()
	$font_x = DllStructGetData($aInfo[0], 1)
	$font_y = DllStructGetData($aInfo[0], 2)
	$font_w = DllStructGetData($aInfo[0], 3)
	$font_h = DllStructGetData($aInfo[0], 4)
EndFunc   ;==>Get_String_Size

Func _Random($w1, $w2, $w3 = 0, $l1 = 0.5) ;just to avoid 0 as random number
	Local $x = 0
	While $x = 0
		$x = Random($w1, $w2, $w3)
		If $x < $l1 And $x >= 0 Then $x += $l1
		If $x > -$l1 And $x <= 0 Then $x -= $l1
	WEnd
	Return $x
EndFunc   ;==>_Random

Func Font($font, $fontname) ;thanks to Yashied for the code to load non installed fonts to GDI+
	$hBrush = _GDIPlus_BrushCreateSolid(0xFFFFFFFF)
	$hFormat = _GDIPlus_StringFormatCreate()
	$hCollection = DllCall($ghGDIPDll, 'int', 'GdipNewPrivateFontCollection', 'ptr*', 0)
	$hCollection = $hCollection[1]
	DllCall($ghGDIPDll, 'int', 'GdipPrivateAddFontFile', 'ptr', $hCollection, 'wstr', $font)
	$hFamily = DllCall($ghGDIPDll, 'int', 'GdipCreateFontFamilyFromName', 'wstr', $fontname, 'ptr', $hCollection, 'int*', 0)
	$hFamily = $hFamily[3]

	$hFont_score = _GDIPlus_FontCreate($hFamily, $width * 12 / 720)
	$hFont_high_score = _GDIPlus_FontCreate($hFamily, $width * 8 / 720)
	$hFont_highscore_ini = _GDIPlus_FontCreate($hFamily, $width * 32 / 720)
	$hFont_title = _GDIPlus_FontCreate($hFamily, $width * 48 / 720)
	$hFont_info = _GDIPlus_FontCreate($hFamily, $width * 6 / 720)
	$hFont_start = _GDIPlus_FontCreate($hFamily, $width * 16 / 720)
	$hFont_game_over = _GDIPlus_FontCreate($hFamily, $width * 64 / 720)
	$hFont_FPS = _GDIPlus_FontCreate($hFamily, $width * 8 / 720)
	$tLayout_FPS = _GDIPlus_RectFCreate($width - 30, 2, 0 ,0)
	$tLayout_game_over = _GDIPlus_RectFCreate(0, 0, 0, 0)
	$tLayout_score = _GDIPlus_RectFCreate(80, 10, 0, 0)
	$tLayout_high_score = _GDIPlus_RectFCreate(0, 0, 0, 0)
	$tLayout_highscore_file = _GDIPlus_RectFCreate(0, 0, 0, 0)
	$aInfo = _GDIPlus_GraphicsMeasureString($hGraphic, $highscore, $hFont_high_score, $tLayout_high_score, $hFormat)
	Get_String_Size()
	$tLayout_high_score = _GDIPlus_RectFCreate(($width - $font_w) * 0.5, 20, 0, 0)
EndFunc   ;==>Font

Func Play($MusicHandle, $repeat = 0)
	_BASS_ChannelPlay($MusicHandle, $repeat)
EndFunc   ;==>Play

Func Close()
	AdlibUnRegister("FPS")
	GUIRegisterMsg($WM_SYSCOMMAND, "")
	DllCall($ghGDIPDll, 'int', 'GdipDeletePrivateFontCollection', 'ptr*', $hCollection)
	_GDIPlus_FontDispose($hFont_info)
	_GDIPlus_FontDispose($hFont_title)
	_GDIPlus_FontDispose($hFont_score)
	_GDIPlus_FontDispose($hFont_high_score)
	_GDIPlus_FontDispose($hFont_start)
	_GDIPlus_FontDispose($hFont_game_over)
	_GDIPlus_StringFormatDispose($hFormat)
	_GDIPlus_BrushDispose($hBrush)
	_GDIPlus_PenDispose($pen)
	_GDIPlus_PenDispose($pen2)
	_GDIPlus_BrushDispose($brush)

	_WinAPI_SelectObject($hDC_backbuffer, $DC_obj)
	_GDIPlus_GraphicsDispose($hGraphic)
	_WinAPI_DeleteObject($hHBITMAP)
	_WinAPI_ReleaseDC($hGUI, $hDC)

	_GDIPlus_Shutdown()
	_BASS_Free()
	DllClose($bass_dll)
	AdlibUnRegister("Display_Gui_Title_Info")
	GUIDelete($hGUI)
	Exit
EndFunc   ;==>Close

Func WM_SYSCOMMAND($hGUI, $Msg, $wParam, $lParam) ;thanks to rasim
	#forceref $hGUI, $Msg
	Local $idFrom
	$idFrom = BitAND($wParam, 0xFFFF)
	Switch $idFrom
		Case $id_Credits
			_Credits_Intro()
	EndSwitch
	Return $GUI_RUNDEFMSG
EndFunc   ;==>WM_SYSCOMMAND

Func Pixel_Distance($x1, $y1, $x2, $y2) ;Pythagoras theorem
	Local $a, $b
	If $x2 = $x1 And $y2 = $y1 Then Return 0
	$a = $y2 - $y1
	$b = $x2 - $x1
	Return Sqrt($a * $a + $b * $b)
EndFunc   ;==>Pixel_Distance

; Write message to memo - for debugging only
;~ Func MemoWrite($sMessage = "")
;~ 	GUICtrlSetData($iMemo, $sMessage & @CRLF, 1)
;~ EndFunc   ;==>MemoWrite

Func GenerateChecksum($str)
	Local $checksum, $tempArray, $xx
	$checksum = 0
	$tempArray = StringSplit(StringUpper($str), "")
	For $xx = 1 To $tempArray[0]
		Switch $tempArray[$xx]
			Case "A"
				$checksum += (2 * 3) ^ 2
			Case "B"
				$checksum += (3 * 5) ^ 2
			Case "C"
				$checksum += (5 * 7) ^ 2
			Case "D"
				$checksum += (7 * 11) ^ 2
			Case "E"
				$checksum += (11 * 13) ^ 2
			Case "F"
				$checksum += (13 * 17) ^ 2
			Case "0"
				$checksum += (17 * 19) ^ 2
			Case "1"
				$checksum += (19 * 23) ^ 2
			Case "2"
				$checksum += (23 * 29) ^ 2
			Case "3"
				$checksum += (29 * 31) ^ 2
			Case "4"
				$checksum += (31 * 37) ^ 2
			Case "5"
				$checksum += (37 * 41) ^ 2
			Case "6"
				$checksum += (41 * 43) ^ 2
			Case "7"
				$checksum += (43 * 47) ^ 2
			Case "8"
				$checksum += (47 * 53) ^ 2
			Case "9"
				$checksum += (53 * 59) ^ 2
			Case "X"
				$checksum += (59 * 61) ^ 2
		EndSwitch
	Next
	Return $checksum
EndFunc   ;==>GenerateChecksum

Func GUI_Title_Info_Text()
	Dim $title[33] = [	" AUTOITEROIDS" & $ver & $build & "by UEZ 2009  :-)", _
						" Press ENTER to start game", _
						" Press LEFT to turn spaceship left", _
						" Press RIGHT to turn spaceship right", _
						" Press UP to thrust spaceship", _
						" Press SPACE for hyperjump", _
						" Press CTRL to shoot", _
						" Current game level: " & $level, _
						" Credits:", _
						" Main coding by:   UEZ 2009", _
						" Bass UDF:   BrettF", _
						" Bass DLL:   www.un4seen.com", _
						" GDI+ font loader:   Yashied", _
						" Font:   ck! [Freaky Fonts]", _
						" Sound modifications:   Spiff59", _
						" Menu item code:   rasim", _
						" GetKeyboardState code: Eukalyptus", _
						" Coding Language:   AutoIt (www.autoitscript.com)", _
						" And of course", _
						" Atari for the original game concept ;-)", _
						"*`*. ..  .. .*`**`*. ..  .. .*`**`*. ..  .. .*`*. ..  .. .*`*. ..  .. .*`**`*. ..  .. .*`**`*. ..  .. .*`*.", _
						" Current game level: " & $level, _
						" Greetings to: ", _
						" All members from", _
						" www.autoitscript.com  /  www.autoit.de", _
						" Christos - thanks for testing the game :-)", _
						" Richie - thanks for testing the game :-)", _
						" DrSchulz (http://www.drschulz-music.de/) thanks for the good tips ;-)", _
						" and", _
						" Captain Starbuck", _
						"                                                                                                      ", _
						" Current game level: " & $level, _
						" Restarting text..."]
EndFunc   ;==>GUI_Title_Info_Text

Func Display_Gui_Title_Info()
	If $in Then
		If $ii <> StringLen($title[$jj]) + 1 Then
			If $effect Then
				WinSetTitle($hGUI, "", StringLeft($title[$jj], $ii)) ;effect 1a, 1 by 1
			Else
				WinSetTitle($hGUI, "", StringRight($title[$jj], $ii)) ;effect 2a, scroll to right
			EndIf
			$ii += 1
		Else
			If $cc = $ss Then
				$ii = 1
				$in = False
				$cc = 0
				$effect = Random(1, 2, 1)
			Else
				$cc += 1
			EndIf
		EndIf
	Else
		If $ii <> StringLen($title[$jj]) + 1 Then
			If $effect Then
				WinSetTitle($hGUI, "", StringLeft($title[$jj], StringLen($title[$jj]) - $ii)) ;effect 1b, 1 by 1
			Else
				WinSetTitle($hGUI, "", StringRight($title[$jj], StringLen($title[$jj]) - $ii)) ;effect 2b, scroll to left
			EndIf
			$ii += 1
		Else
			$ii = 1
			$in = True
			$effect = Random(1, 2, 1)
			If $jj = $kk Then
				$jj = 0
			Else
				$jj += 1
			EndIf
		EndIf
	EndIf
EndFunc   ;==>Display_Gui_Title_Info

Func _Credits_Intro() ;intro coming soon
	GUIRegisterMsg($WM_ERASEBKGND, "")
	Local $Credits, $Group, $hyperlink, $Label1, $Label2, $Label3, $Label4, $Label5
	Local $credit_msg
	GUISetState(@SW_DISABLE, $hGUI)
	Opt("GUICoordMode", 1)
	Opt("GUIOnEventMode", 0)
	$Credits = GUICreate("ABOUT...", 533, 225, -1, -1, BitOR($WS_SYSMENU, $WS_CAPTION, $WS_POPUP, $WS_POPUPWINDOW, $WS_BORDER, $WS_CLIPSIBLINGS), _
													   BitOR($WS_EX_TOPMOST, $WS_EX_TOOLWINDOW, $WS_EX_WINDOWEDGE), $hGUI)

;~ 	For $v = 0 To 255
;~ 		GUICtrlCreateLabel("", 0, $v, 533, -1, -1)
;~ 		$sColor = "0x" & Hex($v, 2) & Hex(0xF0, 2) & Hex($v, 2)
;~ 		GUICtrlSetBkColor(-1, $sColor)
;~ 	Next
	GUISetBkColor(0x99B4D1)
	$Label5 = GUICtrlCreateLabel("AUTOITEROIDS", 97, 24, 240, 40, -1) ;create shadow
	GUICtrlSetColor(-1, 0x262D34) ;shadow color
	GUICtrlSetFont(-1, 24, 700, 2, "Arial") ;bold and italic
	$Label1 = GUICtrlCreateLabel("AUTOITEROIDS", 92, 24, 240, 40, -1)
	GUICtrlSetBkColor(-1, -2) ;set label tranparent
	GUICtrlSetColor(-1, 0xFFFFFF)
	GUICtrlSetFont(-1, 24, 700, -1, "Arial")
	$Label2 = GUICtrlCreateLabel(	$ver & $build, 336, 40, 128, 17)
	GUICtrlSetColor(-1, 0xFFFFFF)
	$Label3 = GUICtrlCreateLabel(	"Main code: UEZ" & @CRLF & _
									"Bass UDF: BrettF" & @CRLF & _
									"Bass DLL: www.un4seen.com" & @CRLF & _
									"GDI+ font loader code: Yashied" & @CRLF & _
									"Menu item code: rasim"  & @CRLF & _
									"Sound modifications: Spiff59" & @CRLF & _
									"Font: ck! [Freaky Fonts]" & @CRLF & _
									"GetKeyboardState Code: Eukalyptus" & @CRLF & _
									"Atari for the original game concept", 165, 65, 209, 110, 0x50000101)
	GUICtrlSetFont(-1, 8, 800, 0, "Arial")
	GUICtrlSetColor(-1, 0xFFFFFF)
	$Label4 = GUICtrlCreateLabel(	"For more information / updates visit:", 24, 184, 172, 17)
	GUICtrlSetColor(-1, 0xFFFFFF)
	$hyperlink = GUICtrlCreateLabel("http://www.autoitscript.com/forum/index.php?showtopic=95138", 196, 184, 308, 17)
	GUICtrlSetFont(-1, 8, 400, 4, "MS Sans Serif")
	$Group = GUICtrlCreateGroup("", 8, 8, 513, 209, 0x8000)
	GUICtrlSetColor($hyperlink,0x0000FF)
	GUICtrlSetCursor($hyperlink, 0)
	GUICtrlSetTip($hyperlink, "Click link to visit web site!")
	GUISetState(@SW_SHOW, $Credits)
	While 1
		$credit_msg = GUIGetMsg()
		Select
			Case $credit_msg = $GUI_EVENT_CLOSE
				GUIDelete($Credits)
				Opt("GUIOnEventMode", 1)
				GUISetState(@SW_ENABLE, $hGUI)
				WinActivate($hGUI)
				ExitLoop
			Case $credit_msg = $hyperlink
				ShellExecute(GUICtrlRead($hyperlink))
		EndSelect
	  Sleep(20)
	WEnd
	GUIRegisterMsg($WM_ERASEBKGND, "WM_ERASEBKGND")
EndFunc   ;==>_Credits_Intro

; #FUNCTION# ====================================================================================================================
; Name...........: 	_WinAPI_GetKeyboardState
; Description ...: 	Returns the status of the 256 virtual keys
; Syntax.........: 	_WinAPI_GetKeyboardState($iFlag=0)
; Parameters ....: 	$iFlag   - Return Type
;              		0 Returns an array[256]
;					1 Returns a string
; Return values .: 	Success  - Array[256] or String containing status of 256 virtual keys
;              		Failure  - False
; Author ........: 	Eukalyptus
; Modified.......:
; Remarks .......: 	If the high-order bit is 1, the key is down; otherwise, it is up.
;					If the key is a toggle key, for example CAPS LOCK, then the low-order bit is 1
;					when the key is toggled and is 0 if the key is untoggled
; Related .......: 	_IsPressed
; Link ..........;
; Example .......;
; ===============================================================================================================================
Func _WinAPI_GetKeyboardState($iFlag = 0)
	Local $aDllRet, $lpKeyState = DllStructCreate("byte[256]")
	$aDllRet = DllCall("User32.dll", "int", "GetKeyboardState", "ptr", DllStructGetPtr($lpKeyState))
	If @error Then Return SetError(@error, 0, 0)
	If $aDllRet[0] = 0 Then
		Return SetError(1, 0, 0)
	Else
		Switch $iFlag
			Case 0
				Local $aReturn[256]
				For $i = 1 To 256
					$aReturn[$i - 1] = DllStructGetData($lpKeyState, 1, $i)
				Next
				Return $aReturn
			Case Else
				Return DllStructGetData($lpKeyState, 1)
		EndSwitch
	EndIf
EndFunc   ;==>_WinAPI_GetKeyboardState

Func WM_ERASEBKGND()
;~ 	_WinAPI_RedrawWindow($hGUI, 0, 0, 0)
	_WinAPI_BitBlt($hDC, 0, 0, $width, $height, $hDC_backbuffer, 0, 0, $SRCCOPY)
	Return 1
EndFunc