#NoTrayIcon
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_icon=favicon.ico
#AutoIt3Wrapper_outfile=AbsoluteLyricsFinder.exe
#AutoIt3Wrapper_Res_Description=Absolute Lyrics Finder
#AutoIt3Wrapper_Res_Fileversion=1.2.1.1
#AutoIt3Wrapper_Res_Fileversion_AutoIncrement=p
#AutoIt3Wrapper_Res_LegalCopyright=Big_Daddy Scripting
#AutoIt3Wrapper_Res_Language=1033
#AutoIt3Wrapper_Run_AU3Check=n
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
;
#comments-start
	AbsoluteLyricsFinder.au3 v1.2.1.1 Dec. 18, 2007
	Bob Anthony (big_daddy)
#comments-end
#include <IE.au3>
#include <INet.au3>
#include <File.au3>
#include <Winamp.au3>
#include <GuiListBox.au3>
#include <GUIConstantsEx.au3>
#include <GUIStatusBar.au3>

Opt("GUIOnEventMode", True)
#region Global Variables
Global _
		$oWinAmp, $oWinampEvent, $fWinampAttached, _
		$oiTunes, $oiTunesEvent, $fiTunesAttached, $fiTunesUpdate = True, _
		$sSavePath1 = "", $sSavePath2 = "", $sSongTab2 = "", $sSongTab3 = "", _
		$sArtistTab2 = "", $sArtistTab3 = "", _
		$TempDir = @TempDir & "\LyricsFinder\", _
		$sURL = "http://www.absolutelyrics.com/", _
		$iWinPosX = Number(IniRead($TempDir & "settings.ini", "General", "WinPosX", -1)), _
		$iWinPosY = Number(IniRead($TempDir & "settings.ini", "General", "WinPosY", -1)), _
		$iIntegrate = IniRead($TempDir & "settings.ini", "Integration", "player", "0"), _
		$fRealtime = Number(IniRead($TempDir & "settings.ini", "Integration", "realtime", "0")), _
		$sDefPath = IniRead($TempDir & "settings.ini", "General", "DefPath", @MyDocumentsDir & "\My Music\")
#endregion
#region Prereq
SplashTextOn("", "Please wait..." & @CR & @CR & "Absolute Lyrics Finder is being loaded.", 175, 95, -1, -1, 1, "Comic Sans MS")
#comments-start
	Check to see if the images have already been downloaded.
	If not, download them and store them for later use.
#comments-end
DirCreate($TempDir)
If Not FileExists($TempDir & "favicon.ico") Then
	InetGet($sURL & "favicon.ico", $TempDir & "favicon.ico")
EndIf
If Not FileExists($TempDir & "logo.gif") Then
	InetGet($sURL & "logo3.gif", $TempDir & "logo.gif")
EndIf
If Not FileExists($TempDir & "nocover.gif") Then
	InetGet($sURL & "nocover.gif", $TempDir & "nocover.gif")
EndIf
#comments-start
	Register the IE Error Handler to avoid script termination.
	Set the page load timeout to 30 seconds.
#comments-end
_IEErrorHandlerRegister()
_IELoadWaitTimeout(30000)
#comments-start
	Toggle IE Images off to save on load times.
	Create our three hidden browser windows.
	Toggle IE Images back on for any user opened browser windows.
#comments-end
_ToggleImages(False)
$oIE1 = _IECreate("about:blank", 0, 0, 0)
$oIE2 = _IECreate("about:blank", 0, 0, 0)
$oIE3 = _IECreate("about:blank", 0, 0, 0)
_ToggleImages(True)
#endregion
#region GUI
#comments-start
	Turn window themes off for the GUI Controls.
#comments-end
DllCall("uxtheme.dll", "none", "SetThemeAppProperties", "int", 1)
$GUI = GUICreate("Absolute Lyrics Finder  -=Big_Daddy Style=-", 586, 521, $iWinPosX, $iWinPosY)
GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit")
GUISetIcon($TempDir & "favicon.ico")
$Pic1 = GUICtrlCreatePic($TempDir & "logo.gif", 0, 0, 585, 60, BitOR($SS_NOTIFY, $SS_SUNKEN, $WS_GROUP), $WS_EX_CLIENTEDGE)
$Tab1 = GUICtrlCreateTab(5, 70, 574, 423)
#comments-start
	The first tab is for the player integration.
#comments-end
$TabSheet1 = GUICtrlCreateTabItem("Player Integration")
GUICtrlSetState(-1, $GUI_SHOW)
GUICtrlCreateGroup("Album Info", 14, 99, 235, 201)
$Pic5 = GUICtrlCreatePic($TempDir & "nocover.gif", 24, 119, 130, 130, BitOR($SS_NOTIFY, $WS_GROUP))
$Label16 = GUICtrlCreateLabel("Album:", 24, 259, 210, 17)
$Label17 = GUICtrlCreateLabel("Release:", 24, 279, 210, 17)
GUICtrlCreateGroup("", -99, -99, 1, 1)
GUICtrlCreateGroup("Search Criteria", 254, 99, 315, 201)
$Input4 = GUICtrlCreateInput("", 264, 119, 160, 21)
GUICtrlSetState(-1, $GUI_DISABLE)
$Input5 = GUICtrlCreateInput("", 264, 144, 160, 21)
GUICtrlSetState(-1, $GUI_DISABLE)
$Button20 = GUICtrlCreateButton("Grab Lyrics", 264, 174, 100, 25, 0)
GUICtrlSetOnEvent(-1, "_SearchLyricsManual")
GUICtrlSetState(-1, $GUI_DISABLE)
$Button21 = GUICtrlCreateButton("Save Lyrics", 264, 204, 100, 25, 0)
GUICtrlSetState(-1, $GUI_DISABLE)
$Button22 = GUICtrlCreateButton("Save Artwork", 264, 234, 100, 25, 0)
GUICtrlSetState(-1, $GUI_DISABLE)
$Label13 = GUICtrlCreateLabel("Song Progress", 419, 169, 130, 17, $SS_CENTER)
GUICtrlSetFont(-1, 8, 800, 0, "MS Sans Serif")
GUICtrlSetState(-1, $GUI_DISABLE)
$Progress1 = GUICtrlCreateProgress(419, 189, 130, 17, $PBS_SMOOTH)
GUICtrlSetColor(-1, 0xFF9C00)
GUICtrlSetState(-1, $GUI_DISABLE)
$Label14 = GUICtrlCreateLabel("Volume", 419, 214, 130, 17, $SS_CENTER)
GUICtrlSetFont(-1, 8, 800, 0, "MS Sans Serif")
GUICtrlSetState(-1, $GUI_DISABLE)
$Slider1 = GUICtrlCreateSlider(409, 229, 150, 35)
GUICtrlSetState(-1, $GUI_DISABLE)
$Button11 = GUICtrlCreateButton("9", 419, 269, 25, 20, BitOR($BS_CENTER, $BS_VCENTER))
GUICtrlSetFont(-1, 10, 400, 0, "Webdings")
GUICtrlSetState(-1, $GUI_DISABLE)
$Button17 = GUICtrlCreateButton("u", 454, 269, 25, 20, BitOR($BS_CENTER, $BS_VCENTER))
GUICtrlSetFont(-1, 9, 400, 0, "Wingdings 3")
GUICtrlSetState(-1, $GUI_DISABLE)
$Button18 = GUICtrlCreateButton("<", 489, 269, 25, 20, BitOR($BS_CENTER, $BS_VCENTER))
GUICtrlSetFont(-1, 10, 400, 0, "Webdings")
GUICtrlSetState(-1, $GUI_DISABLE)
$Button16 = GUICtrlCreateButton(":", 524, 269, 25, 20, BitOR($BS_CENTER, $BS_VCENTER))
GUICtrlSetFont(-1, 10, 400, 0, "Webdings")
GUICtrlSetState(-1, $GUI_DISABLE)
GUICtrlCreateGroup("", -99, -99, 1, 1)
GUICtrlCreateGroup("Lyrics", 14, 304, 555, 180, $BS_CENTER)
$Edit4 = GUICtrlCreateEdit("", 24, 324, 535, 150)
GUICtrlSetFont(-1, 10, 400, 0, "Verdana")
GUICtrlCreateGroup("", -99, -99, 1, 1)
#comments-start
	The second tab is for the manual searching.
#comments-end
$TabSheet2 = GUICtrlCreateTabItem("Search by MP3")
GUICtrlCreateGroup("Album Info", 14, 99, 235, 201)
$Pic2 = GUICtrlCreatePic($TempDir & "nocover.gif", 24, 119, 130, 130, BitOR($SS_NOTIFY, $WS_GROUP))
$Label1 = GUICtrlCreateLabel("Album:", 24, 259, 210, 17)
$Label2 = GUICtrlCreateLabel("Release:", 24, 279, 210, 17)
GUICtrlCreateGroup("", -99, -99, 1, 1)
GUICtrlCreateGroup("Search Criteria", 254, 99, 315, 201)
$Input1 = GUICtrlCreateInput("Type Artist Here...", 264, 119, 160, 21)
$Input2 = GUICtrlCreateInput("Type Song Here...", 264, 144, 160, 21)
$Button1 = GUICtrlCreateButton("Browse for MP3", 264, 174, 100, 25, 0)
GUICtrlSetOnEvent(-1, "_BrowseMP3")
$Button2 = GUICtrlCreateButton("Grab Lyrics", 264, 204, 100, 25, 0)
GUICtrlSetOnEvent(-1, "_SearchLyricsManual")
$Button3 = GUICtrlCreateButton("Save Lyrics", 264, 234, 100, 25, 0)
GUICtrlSetOnEvent(-1, "_Save")
GUICtrlCreateGroup("", -99, -99, 1, 1)
GUICtrlCreateGroup("Lyrics", 14, 304, 555, 180, $BS_CENTER)
$Edit1 = GUICtrlCreateEdit("", 24, 324, 535, 150)
GUICtrlSetFont(-1, 10, 400, 0, "Verdana")
GUICtrlCreateGroup("", -99, -99, 1, 1)
#comments-start
	The third tab is for the searching by artist.
#comments-end
$TabSheet3 = GUICtrlCreateTabItem("Search by Artist")
$Group4 = GUICtrlCreateGroup("Album Info", 14, 99, 235, 201)
$Pic3 = GUICtrlCreatePic($TempDir & "nocover.gif", 24, 119, 130, 130, BitOR($SS_NOTIFY, $WS_GROUP))
$Label3 = GUICtrlCreateLabel("Album:", 24, 259, 210, 17)
$Label4 = GUICtrlCreateLabel("Release:", 24, 279, 210, 17)
GUICtrlCreateGroup("", -99, -99, 1, 1)
$Group5 = GUICtrlCreateGroup("Search Criteria", 254, 99, 315, 201)
$Combo1 = GUICtrlCreateCombo("Select Artist Letter...", 264, 119, 120, 25)
GUICtrlSetOnEvent(-1, "_ComboChange")
$sText = "#|"
For $i = 65 To 90
	$sText &= Chr($i) & "|"
Next
GUICtrlSetData(-1, $sText, "Select Artist Letter...")
$Button4 = GUICtrlCreateButton("Find Artists", 264, 145, 120, 20, 0)
GUICtrlSetOnEvent(-1, "_FindArtists")
GUICtrlSetState(-1, $GUI_DISABLE)
$Button5 = GUICtrlCreateButton("Find Songs", 264, 169, 120, 20, 0)
GUICtrlSetOnEvent(-1, "_FindArtistSongs")
GUICtrlSetState(-1, $GUI_DISABLE)
$Button6 = GUICtrlCreateButton("Grab Lyrics", 264, 194, 120, 20, 0)
GUICtrlSetOnEvent(-1, "_GrabLyrics")
GUICtrlSetState(-1, $GUI_DISABLE)
$Button7 = GUICtrlCreateButton("Save Lyrics", 264, 219, 120, 20, 0)
GUICtrlSetOnEvent(-1, "_Save")
GUICtrlSetState(-1, $GUI_DISABLE)
$List1 = GUICtrlCreateList("", 399, 119, 155, 120, BitOR($LBS_NOTIFY, $LBS_DISABLENOSCROLL, $WS_VSCROLL, $WS_BORDER))
$Button12 = GUICtrlCreateButton("<<", 399, 234, 35, 20, 0)
GUICtrlSetOnEvent(-1, "_ChangePage")
$Label7 = GUICtrlCreateLabel("---", 434, 237, 85, 17, $SS_CENTER)
GUICtrlSetFont(-1, 8, 800, 0, "MS Sans Serif")
$Button13 = GUICtrlCreateButton(">>", 519, 234, 35, 20, 0)
GUICtrlSetOnEvent(-1, "_ChangePage")
$Label9 = GUICtrlCreateLabel("Artist:", 264, 259, 290, 17)
$Label10 = GUICtrlCreateLabel("Song:", 264, 279, 290, 17)
GUICtrlCreateGroup("", -99, -99, 1, 1)
$Group6 = GUICtrlCreateGroup("Lyrics", 14, 304, 555, 180, $BS_CENTER)
$Edit2 = GUICtrlCreateEdit("", 24, 324, 535, 150)
GUICtrlSetFont(-1, 10, 400, 0, "Verdana")
GUICtrlCreateGroup("", -99, -99, 1, 1)
#comments-start
	The forth tab is for the searching by song.
#comments-end
$TabSheet4 = GUICtrlCreateTabItem("Search by Song")
$Group7 = GUICtrlCreateGroup("Lyrics", 14, 304, 555, 180, $BS_CENTER)
$Edit3 = GUICtrlCreateEdit("", 24, 324, 535, 150)
GUICtrlSetFont(-1, 10, 400, 0, "Verdana")
GUICtrlCreateGroup("", -99, -99, 1, 1)
$Group8 = GUICtrlCreateGroup("Search Criteria", 254, 99, 315, 201)
$Combo2 = GUICtrlCreateCombo("Select Song Letter...", 264, 119, 120, 25)
GUICtrlSetOnEvent(-1, "_ComboChange")
$sText = "#|"
For $i = 65 To 90
	$sText &= Chr($i) & "|"
Next
GUICtrlSetData(-1, $sText, "Select Song Letter...")
$Button8 = GUICtrlCreateButton("Find Songs", 264, 145, 120, 25, 0)
GUICtrlSetOnEvent(-1, "_FindSongs")
GUICtrlSetState(-1, $GUI_DISABLE)
$Button9 = GUICtrlCreateButton("Grab Lyrics", 264, 174, 120, 25, 0)
GUICtrlSetOnEvent(-1, "_GrabLyrics")
GUICtrlSetState(-1, $GUI_DISABLE)
$Button10 = GUICtrlCreateButton("Save Lyrics", 264, 204, 120, 25, 0)
GUICtrlSetOnEvent(-1, "_Save")
GUICtrlSetState(-1, $GUI_DISABLE)
$List2 = GUICtrlCreateList("", 399, 119, 155, 120, BitOR($LBS_NOTIFY, $LBS_DISABLENOSCROLL, $WS_VSCROLL, $WS_BORDER))
GUICtrlSetOnEvent(-1, "_UpdateSongArtist")
$Button14 = GUICtrlCreateButton("<<", 399, 234, 35, 20, 0)
GUICtrlSetOnEvent(-1, "_ChangePage")
$Label8 = GUICtrlCreateLabel("---", 434, 237, 85, 17, $SS_CENTER)
GUICtrlSetFont(-1, 8, 800, 0, "MS Sans Serif")
$Button15 = GUICtrlCreateButton(">>", 519, 234, 35, 20, 0)
GUICtrlSetOnEvent(-1, "_ChangePage")
$Label11 = GUICtrlCreateLabel("Artist:", 264, 259, 290, 17)
$Label12 = GUICtrlCreateLabel("Song:", 264, 279, 290, 17)
GUICtrlCreateGroup("", -99, -99, 1, 1)
$Group9 = GUICtrlCreateGroup("Album Info", 14, 99, 235, 201)
$Pic4 = GUICtrlCreatePic($TempDir & "nocover.gif", 24, 119, 130, 130, BitOR($SS_NOTIFY, $WS_GROUP))
$Label5 = GUICtrlCreateLabel("Album:", 24, 259, 210, 17)
GUICtrlSetState(-1, $GUI_DISABLE)
$Label6 = GUICtrlCreateLabel("Release:", 24, 279, 210, 17)
GUICtrlSetState(-1, $GUI_DISABLE)
GUICtrlCreateGroup("", -99, -99, 1, 1)
#comments-start
	The fifth tab is for settings.
#comments-end
$TabSheet5 = GUICtrlCreateTabItem("Settings")
$Group10 = GUICtrlCreateGroup("General Settings", 14, 99, 320, 200, $BS_CENTER)
$Label15 = GUICtrlCreateLabel("Default Music Folder", 24, 119, 101, 17)
$Input3 = GUICtrlCreateInput($sDefPath, 24, 139, 220, 21, BitOR($ES_AUTOHSCROLL, $ES_READONLY))
$Button19 = GUICtrlCreateButton("Browse", 249, 139, 75, 21, 0)
GUICtrlSetOnEvent(-1, "_Browse")
GUICtrlCreateGroup("", -99, -99, 1, 1)
$Group11 = GUICtrlCreateGroup("Player Integration Settings", 340, 99, 230, 200, $BS_CENTER)
$Radio1 = GUICtrlCreateRadio("Disable Player Integration", 350, 119, 200, 17)
GUICtrlSetOnEvent(-1, "_IntegrateDisable")
$Radio2 = GUICtrlCreateRadio("iTunes Integration", 350, 139, 200, 17)
GUICtrlSetOnEvent(-1, "_IntegrateiTunes")
$Radio3 = GUICtrlCreateRadio("Winamp Integration", 350, 159, 200, 17)
GUICtrlSetOnEvent(-1, "_IntegrateWinamp")
$Checkbox1 = GUICtrlCreateCheckbox("Real-time Searching", 350, 189, 200, 17)
GUICtrlSetState(-1, $GUI_DISABLE)
GUICtrlCreateGroup("", -99, -99, 1, 1)
GUICtrlCreateTabItem("")
$StatusBar = _GUICtrlStatusBar_Create($GUI, 586, "", $SBARS_SIZEGRIP)
_GUICtrlStatusBar_SetMinHeight($StatusBar, 20)
_GUICtrlStatusBar_SetText($StatusBar, " Please enter search criteria.")
GUICtrlSetState($Input1, $GUI_FOCUS)
#comments-start
	Apply saved settings to the GUI before we show it.
#comments-end
_ApplySettings()
SplashOff()
GUISetState(@SW_SHOW)
#endregion
While 1
	Sleep(100)
WEnd
#region Functions-All
#region Functions-Tab2
;===============================================================================
;
; Function Name:   _BrowseMP3
; Description::    Allows the user to browse for an MP3 and pulls artist and song name from file.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _BrowseMP3()

	Local $s_Path, $a_Prop, $s_FileName, $s_FileDir, $s_FilePath, $s_Text

	$s_Path = FileOpenDialog("Browse for .MP3", $sDefPath, "Music Files (*.mp3;*.wav;*.wma;)", 1)

	If $s_Path = "" Then
		_GUICtrlStatusBar_SetText($StatusBar, " There was a problem opening the file.")
		Return
	EndIf
	$sSavePath2 = ""

	_GUICtrlStatusBar_SetText($StatusBar, " Attempting to pull tag information from selected file.")

	_ResetTab($TabSheet1)

	$a_Prop = _GetExtProperty($s_Path, -1)
	If @error Or $a_Prop[10] = "" Or $a_Prop[16] = "" Then
		_GUICtrlStatusBar_SetText($StatusBar, " Unable not pull artist and song name for selected file.")
		Return
	EndIf

	GUICtrlSetData($Input1, $a_Prop[16])
	GUICtrlSetData($Input2, $a_Prop[10])

	$s_FileName = $a_Prop[16] & "-" & $a_Prop[10] & ".txt"
	$s_FileDir = StringTrimRight($s_Path, StringLen($s_Path) - StringInStr($s_Path, "\", 0, -1))
	$sSavePath2 = $s_FileDir
	$s_FilePath = $s_FileDir & $s_FileName

	If FileExists($s_FilePath) Then
		$s_Text = FileRead($s_FilePath)
		GUICtrlSetData($Edit1, $s_Text)
		If FileExists($s_FileDir & "album_cover.jpg") Then
			GUICtrlSetImage($Pic2, $s_FileDir & "album_cover.jpg")
		EndIf
		_GUICtrlStatusBar_SetText($StatusBar, " Lyrics acquired from previous save.")
		Return
	EndIf
	_GUICtrlStatusBar_SetText($StatusBar, " Tag information pulled successfully, ready to find lyrics.")
EndFunc   ;==>_BrowseMP3
#endregion
#region Functions-Tab3
;===============================================================================
;
; Function Name:   _FindArtists
; Description::    Searches for artists for the given letter.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _FindArtists()

	Local $s_Letter

	_GUICtrlStatusBar_SetText($StatusBar, " Please wait while the artists are being gathered...")
	$s_Letter = GUICtrlRead($Combo1)
	If $s_Letter = "#"  Then $s_Letter = "9"
	If StringInStr($s_Letter, "...") Then
		_GUICtrlStatusBar_SetText($StatusBar, " You must first select a letter.")
		Return
	EndIf

	_GUICtrlListBox_ResetContent($List1)
	_ResetTab($TabSheet3)
	GUICtrlSetData($Label9, "Artist: ")
	GUICtrlSetData($Label10, "Song: ")
	GUICtrlSetData($Label7, "---")
	GUICtrlSetState($Button6, $GUI_DISABLE)
	GUICtrlSetState($Button7, $GUI_DISABLE)

	_IENavigate($oIE2, $sURL & "lyrics/artistlist/" & $s_Letter & "/")

	_PopulateList($TabSheet3, 1)
	_GetPageInfo($TabSheet3)
	GUICtrlSetState($Button5, $GUI_ENABLE)
	_GUICtrlStatusBar_SetText($StatusBar, " Select an artist then click 'Find Songs'.")
EndFunc   ;==>_FindArtists

;===============================================================================
;
; Function Name:   _FindArtistSongs
; Description::    Searches for songs by the specified artist.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _FindArtistSongs()

	Local $o_ListItems, $i_Artist, $s_Artist, $o_ListItem, $s_URL

	_GUICtrlStatusBar_SetText($StatusBar, " Please wait while the songs are being gathered...")
	$o_ListItems = _IETagNameGetCollection($oIE2, "li")
	$i_Artist = _GUICtrlListBox_GetCurSel($List1)
	If $i_Artist = $LB_ERR Then
		_GUICtrlStatusBar_SetText($StatusBar, " You must first select an Artist.")
		Return
	EndIf

	GUICtrlSetData($Label7, "---")
	$s_Artist = _GUICtrlListBox_GetText($List1, $i_Artist)
	GUICtrlSetData($Label9, "Artist: " & $s_Artist)

	GUICtrlSetState($Button5, $GUI_DISABLE)
	_GUICtrlListBox_ResetContent($List1)

	$o_ListItem = $o_ListItems($i_Artist)
	$s_URL = _Escape($o_ListItem.firstChild.href)
	;ConsoleWrite($s_URL & @CR)
	_IENavigate($oIE2, $s_URL)

	_PopulateList($TabSheet3)
	_GetPageInfo($TabSheet3)
	GUICtrlSetState($Button6, $GUI_ENABLE)
	_GUICtrlStatusBar_SetText($StatusBar, " Select a song then click 'Grab Lyrics'.")
EndFunc   ;==>_FindArtistSongs
#endregion
#region Functions-Tab4
;===============================================================================
;
; Function Name:   _FindSongs
; Description::    Searches for songs for the given letter.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _FindSongs()

	Local $s_Letter

	_GUICtrlStatusBar_SetText($StatusBar, " Please wait while the songs are being gathered...")
	$s_Letter = GUICtrlRead($Combo2)
	If $s_Letter = "#"  Then $s_Letter = "9"
	If StringInStr($s_Letter, "...") Then
		_GUICtrlStatusBar_SetText($StatusBar, " You must first select a letter.")
		Return
	EndIf

	_GUICtrlListBox_ResetContent($List2)
	_ResetTab($TabSheet4)
	GUICtrlSetData($Label11, "Artist: ")
	GUICtrlSetData($Label12, "Song: ")
	GUICtrlSetData($Label8, "---")
	GUICtrlSetState($Button9, $GUI_DISABLE)
	GUICtrlSetState($Button10, $GUI_DISABLE)

	_IENavigate($oIE3, $sURL & "lyrics/songlist/" & $s_Letter & "/")

	_PopulateList($TabSheet4)
	GUICtrlSetState($Button9, $GUI_ENABLE)
	_GUICtrlStatusBar_SetText($StatusBar, " Select a song then click 'Grab Lyrics'.")
EndFunc   ;==>_FindSongs

;===============================================================================
;
; Function Name:   _UpdateSongArtist
; Description::    Updates the artist and song labels in tab 4 when an item from the list is selected.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _UpdateSongArtist()
	$i_SongArtist = _GUICtrlListBox_GetCurSel($List2)
	If $i_SongArtist = $LB_ERR Then Return
	$s_SongArtist = _GUICtrlListBox_GetText($List2, $i_SongArtist)
	$a_SongArtist = StringSplit($s_SongArtist, " - ", 1)
	GUICtrlSetData($Label11, "Artist: " & $a_SongArtist[2])
	GUICtrlSetData($Label12, "Song: " & $a_SongArtist[1])
EndFunc   ;==>_UpdateSongArtist
#endregion
#region Functions-MultiTab
;===============================================================================
;
; Function Name:   _SearchLyricsManual
; Description::    Manually searches for lyrics based on an artist song combo.
; Parameter(s):    $h_Tab - Tab requesting the search.
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _SearchLyricsManual($h_Tab = "")

	Local $h_CtrlID = "", $s_Artist, $s_Song, $s_BodyText, $o_ListItems, $o_ListItem, $o_Link, _
			$s_Title, $s_Album, $o_Temp, $s_Release, $s_Img, $s_URL, $o_Div, $s_Text, $f_Found = False

	If Not IsDeclared("h_Tab") Then
		$h_CtrlID = @GUI_CtrlId

		Switch $h_CtrlID
			Case $Button2
				$h_Tab = $TabSheet2
			Case $Button20
				$h_Tab = $TabSheet1
			Case Else
				Return
		EndSwitch
	EndIf

	Switch $h_Tab
		Case $TabSheet1
			$h_Label1 = $Label16
			$h_Label2 = $Label17
			$h_Pic = $Pic5
			$h_Input1 = $Input4
			$h_Input2 = $Input5
			$h_Edit = $Edit4
			$h_Tab = $TabSheet1
			$s_Image = "cover1.jpg"
		Case $TabSheet2
			$h_Label1 = $Label1
			$h_Label2 = $Label2
			$h_Pic = $Pic2
			$h_Input1 = $Input1
			$h_Input2 = $Input2
			$h_Edit = $Edit1
			$h_Tab = $TabSheet2
			$s_Image = "cover2.jpg"
		Case Else
			Return
	EndSwitch

	_ResetTab($h_Tab)

	$s_Artist = StringLower(_Escape(GUICtrlRead($h_Input1)))
	$s_Song = GUICtrlRead($h_Input2)

	If $s_Artist = "" Or $s_Artist = "type%20artist%20here..."  Or $s_Song = "" Or $s_Song = "type song here..."  Then
		_GUICtrlStatusBar_SetText($StatusBar, " You must provide both, an artist and song name.")
		Return
	EndIf

	_GUICtrlStatusBar_SetText($StatusBar, " Searching database for artist and song information...")

	; navigate to the artists page
	_IENavigate($oIE1, $sURL & "lyrics/artist/" & $s_Artist)
	$s_BodyText = _IEBodyReadText($oIE1)
	If StringInStr($s_BodyText, "is not found at ABSOLUTELYRICS.COM") Or _
			StringInStr($s_BodyText, "The page cannot be") Then
		_GUICtrlStatusBar_SetText($StatusBar, " Absolutelyrics's database does not yet contain that artist.")
		Return
	EndIf

	$o_ListItems = _IETagNameGetCollection($oIE1, "li")
	If @extended < 1 Then
		_GUICtrlStatusBar_SetText($StatusBar, " There was an error while trying to query the database.")
		Return
	EndIf

	For $o_ListItem In $o_ListItems
		$o_Link = $o_ListItem.firstChild
		$s_Title = $o_Link.outerText
		If $s_Title = $s_Song Then
			$s_Album = $o_ListItem.parentElement.parentElement.innerText
			$o_Temp = $o_ListItem.parentElement.parentElement.previousSibling
			$s_Release = $o_Temp.innerText
			$s_Img = $o_Temp.firstChild.src
			$s_URL = _Escape($o_Link.href)
			$f_Found = True
			ExitLoop
		EndIf
	Next

	If Not $f_Found Then
		_GUICtrlStatusBar_SetText($StatusBar, " Lyric information is not available for this song.")
		Return
	EndIf

	_GUICtrlStatusBar_SetText($StatusBar, " Artist and song information found, looking for lyrics...")
	ConsoleWrite(_INetGetSource($s_URL) & @CR)
	_IENavigate($oIE1, $s_URL)

	; get div tag collection
	$o_Div = _IEGetObjByName($oIE1, "realText")
	If Not IsObj($o_Div) Then
		_GUICtrlStatusBar_SetText($StatusBar, " There was an error while gathering the lyrics text.")
		Return
	EndIf

	; get the innerText of the div (the lyrics)
	$s_Text = $o_Div.innerText

	; download the album photo and set as image
	If InetGet($s_Img, $TempDir & "cover1.jpg", 1) Then
		GUICtrlSetImage($h_Pic, $TempDir & $s_Image)
	EndIf

	; format and display album info
	If $s_Album <> "" Then
		$a_Temp = StringSplit($s_Album, @LF)
		$s_Album = StringReplace($a_Temp[1], @CR, "")
		GUICtrlSetData($h_Label1, $s_Album)
	EndIf
	If $s_Release <> "" Then
		$s_Release = StringReplace(StringReplace($s_Release, @CRLF, ""), " :", ":")
		GUICtrlSetData($h_Label2, $s_Release)
	EndIf

	; display the lyrics
	If $s_Text <> "" Then
		GUICtrlSetData($h_Edit, $s_Text)
	Else
		_GUICtrlStatusBar_SetText($StatusBar, " The lyrics for this song appear to be blank.")
		Return
	EndIf

	_IENavigate($oIE1, "about:blank")
	_GUICtrlStatusBar_SetText($StatusBar, " The operation has completed successfully.")
EndFunc   ;==>_SearchLyricsManual

;===============================================================================
;
; Function Name:   _GrabLyrics
; Description::    Grabs the lyrics for the specified song.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _GrabLyrics()

	Local $h_CtrlID = @GUI_CtrlId, $h_Label1, $h_Label2, $h_Pic, $h_Edit, $h_List, $h_Tab, $s_Image, $o_IE, $s_ReturnURL, $o_ListItems, _
			$i_Song, $s_Song, $o_Link, $s_Album, $o_Temp, $s_Release, $s_Img, $s_URL, $o_Div, $s_Text, $a_Temp, $f_Found = False

	_GUICtrlStatusBar_SetText($StatusBar, " Please wait while the lyrics are being gathered...")

	Switch $h_CtrlID
		Case $Button6
			$h_Label1 = $Label3
			$h_Label2 = $Label4
			$h_Pic = $Pic3
			$h_Edit = $Edit2
			$h_List = $List1
			$h_Tab = $TabSheet3
			$s_Image = "cover3.jpg"
			$o_IE = $oIE2
		Case $Button9
;~ 			$h_Label1 = $Label5
;~ 			$h_Label2 = $Label6
;~ 			$h_Pic = $Pic4
			$h_Edit = $Edit3
			$h_List = $List2
			$h_Tab = $TabSheet4
;~ 			$s_Image = "cover4.jpg"
			$o_IE = $oIE3
	EndSwitch

	_ResetTab($h_Tab)

	$s_ReturnURL = _IEPropertyGet($o_IE, "locationurl")

	$o_ListItems = _IETagNameGetCollection($o_IE, "li")
	If @extended < 1 Then
		_GUICtrlStatusBar_SetText($StatusBar, " There was an error while trying to query the database.")
		Return
	EndIf

	$i_Song = _GUICtrlListBox_GetCurSel($h_List)
	If $i_Song = $LB_ERR Then
		_GUICtrlStatusBar_SetText($StatusBar, " You must first select a Song.")
		Return
	EndIf
	$s_Song = _GUICtrlListBox_GetText($h_List, $i_Song)
	If $h_Tab = $TabSheet3 Then GUICtrlSetData($Label10, "Song: " & $s_Song)

	For $o_ListItem In $o_ListItems
		$o_Link = $o_ListItem.firstChild
		If $o_ListItem.outerText = $s_Song Then
			If $h_Tab = $TabSheet3 Then
				$s_Album = $o_ListItem.parentElement.parentElement.innerText
				$o_Temp = $o_ListItem.parentElement.parentElement.previousSibling
				$s_Release = $o_Temp.innerText
				$s_Img = $o_Temp.firstChild.src
			EndIf
			$s_URL = _Escape($o_Link.href)
			$f_Found = True
		EndIf
	Next

	If Not $f_Found Then
		_GUICtrlStatusBar_SetText($StatusBar, " The selected song was not found in the database.")
		Return
	EndIf

	ConsoleWrite(_INetGetSource($s_URL) & @CR)
	_IENavigate($o_IE, $s_URL)

	; get div tag collection
	$o_Div = _IEGetObjByName($o_IE, "realText")
	If Not IsObj($o_Div) Then
		_GUICtrlStatusBar_SetText($StatusBar, " There was an error while gathering the lyrics text.")
		Return
	EndIf

	; get the innerText of the div (the lyrics)
	$s_Text = $o_Div.innerText

	If $h_Tab = $TabSheet3 Then
		; download the album photo and set as image
		If InetGet($s_Img, $TempDir & $s_Image, 1) Then
			GUICtrlSetImage($h_Pic, $TempDir & $s_Image)
		EndIf

		; format and display album info
		If $s_Album <> "" Then
			$a_Temp = StringSplit($s_Album, @LF)
			$s_Album = StringReplace($a_Temp[1], @CR, "")
			GUICtrlSetData($h_Label1, $s_Album)
		EndIf
		If $s_Release <> "" Then
			$s_Release = StringReplace(StringReplace($s_Release, @CRLF, ""), " :", ":")
			GUICtrlSetData($h_Label2, $s_Release)
		EndIf
	EndIf

	; display the lyrics
	If $s_Text <> "" Then
		GUICtrlSetData($h_Edit, $s_Text)
	Else
		_GUICtrlStatusBar_SetText($StatusBar, " The lyrics for this song appear to be blank.")
		Return
	EndIf

	_IEAction($o_IE, "back")
	_IELoadWait($o_IE)
	If _IEPropertyGet($o_IE, "locationurl") <> $s_ReturnURL Then
		_IENavigate($o_IE, $s_ReturnURL)
	EndIf

	GUICtrlSetState($Button7, $GUI_ENABLE)
	_GUICtrlStatusBar_SetText($StatusBar, " The operation has completed successfully.")
EndFunc   ;==>_GrabLyrics

;===============================================================================
;
; Function Name:   _PopulateList
; Description::    Populates the artist or song list.
; Parameter(s):    $h_Tab 		- Requesting Tab
;				   $f_Artist	- Specifies whether it is an artist or song request
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _PopulateList($h_Tab, $f_Artist = 0)

	Local $o_IE, $h_List, $o_ListItems, $o_Link, $s_Title, $s_URL

	Switch $h_Tab
		Case $TabSheet3
			$o_IE = $oIE2
			$h_List = $List1
		Case $TabSheet4
			$h_List = $List2
			$o_IE = $oIE3
		Case Else
			Return
	EndSwitch

	;_GUICtrlListBox_ResetContent($h_List)
	$o_ListItems = _IETagNameGetCollection($o_IE, "li")

	For $o_ListItem In $o_ListItems
		$o_Link = $o_ListItem.firstChild
		If $o_Link.tagName <> "A"  Then ContinueLoop
		$s_URL = $o_ListItem.firstChild.href
		If $f_Artist Then
			$s_Title = $o_ListItem.firstChild.outerText
			If Not StringInStr($s_URL, "/lyrics/artist/") Then ExitLoop
			$s_Title = StringReplace($s_Title, " lyrics", "")
		Else
			$s_Title = $o_ListItem.outerText
			If Not StringInStr($s_URL, "/lyrics/view/") Then ExitLoop
			;$a_Title = StringSplit($s_Title, " - ", 1)
			;$s_Title = $a_Title[1]
		EndIf

		_GUICtrlListBox_AddString($h_List, $s_Title)
	Next
	_GetPageInfo($h_Tab)
EndFunc   ;==>_PopulateList

;===============================================================================
;
; Function Name:   _GetPageInfo
; Description::    Pulls the current page and the total pages and updates the labels.
; Parameter(s):    $h_Tab 		- Requesting Tab
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _GetPageInfo($h_Tab)

	Local $h_Label, $o_IE, $o_ListItems, $i_Count, $o_LastItem, _
			$o_Table, $s_Text, $a_Text, $a_Matches, $s_Current

	Switch $h_Tab
		Case $TabSheet3
			$h_Label = $Label7
			$o_IE = $oIE2
		Case $TabSheet4
			$h_Label = $Label8
			$o_IE = $oIE3
		Case Else
			Return
	EndSwitch

	$o_ListItems = _IETagNameGetCollection($o_IE, "li")
	$i_Count = @extended
	$o_LastItem = $o_ListItems($i_Count - 1)
	$o_Tables = _IETagNameGetCollection($o_LastItem, "table")
	$i_Count = @extended
	If $i_Count < 1 Then
		GUICtrlSetData($h_Label, "Single Page", "")
	Else
		$s_Text = $o_Tables(0).innerText
		$a_Text = StringSplit($s_Text, " ")
		If IsArray($a_Text) And UBound($a_Text) > 3 Then
			For $i = 2 To UBound($a_Text) - 3
				$a_Matches = StringRegExp($a_Text[$i], "\((\d+)\)", 1)
				If @extended Then
					$s_Current = $a_Matches[0]
					ExitLoop
				EndIf
			Next
			GUICtrlSetData($h_Label, "Page " & $s_Current & " of " & UBound($a_Text) - 4, "")
		Else
			GUICtrlSetData($h_Label, "Single Page", "")
		EndIf
	EndIf
EndFunc   ;==>_GetPageInfo

;===============================================================================
;
; Function Name:   _ChangePage
; Description::    Changes the page in the specified direction.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _ChangePage()

	Local $h_CtrlID = @GUI_CtrlId, $h_Label, $h_List, $s_Search, $h_Tab, $o_IE, _
			$o_ListItems, $i_Count, $o_LastItem, $o_Table, $o_Links, $s_Text, $f_Artist

	Switch $h_CtrlID
		Case $Button12
			$h_Label = $Label7
			$h_List = $List1
			$s_Search = "<Prev"
			$h_Tab = $TabSheet3
			$o_IE = $oIE2
			$f_Artist = 1
		Case $Button13
			$h_Label = $Label7
			$h_List = $List1
			$s_Search = "Next>"
			$h_Tab = $TabSheet3
			$o_IE = $oIE2
			$f_Artist = 1
		Case $Button14
			$h_Label = $Label8
			$h_List = $List2
			$s_Search = "<Prev"
			$h_Tab = $TabSheet4
			$o_IE = $oIE3
			$f_Artist = 0
		Case $Button15
			$h_Label = $Label8
			$h_List = $List2
			$s_Search = "Next>"
			$h_Tab = $TabSheet4
			$o_IE = $oIE3
			$f_Artist = 0
	EndSwitch

	$o_ListItems = _IETagNameGetCollection($o_IE, "li")
	$i_Count = @extended
	If $i_Count < 1 Then Return
	$o_LastItem = $o_ListItems($i_Count - 1)
	$o_Tables = _IETagNameGetCollection($o_LastItem, "table")
	$i_Count = @extended
	If $i_Count < 1 Then Return
	_GUICtrlListBox_ResetContent($h_List)
	$o_Table = $o_Tables(0)
	$o_Links = _IETagNameGetCollection($o_Table, "a")
	For $o_Link In $o_Links
		$s_Text = $o_Link.outerText
		If $s_Text = $s_Search Then
			_IENavigate($o_IE, $o_Link.href)
			ExitLoop
		EndIf
	Next

	_PopulateList($h_Tab, $f_Artist)
EndFunc   ;==>_ChangePage

;===============================================================================
;
; Function Name:   _Save
; Description::    Allows the user to save the current lyrics and album cover.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _Save()

	Local $h_CtrlID = @GUI_CtrlId, $s_Artist, $s_Song, $s_Lyrics, $s_Pic, $s_SavePath = "", $s_SaveDir = ""

	Switch $h_CtrlID
		Case $Button21
			$s_Artist = GUICtrlRead($Input4)
			$s_Song = GUICtrlRead($Input5)
			$s_Lyrics = GUICtrlRead($Edit4)
			$s_Pic = $TempDir & "cover1.jpg"
			$s_SavePath = $sSavePath1
		Case $Button3
			$s_Artist = GUICtrlRead($Input1)
			$s_Song = GUICtrlRead($Input2)
			$s_Lyrics = GUICtrlRead($Edit1)
			$s_Pic = $TempDir & "cover2.jpg"
			$s_SavePath = $sSavePath2
		Case $Button7
			$s_Artist = StringReplace(GUICtrlRead($Label9), "Artist: ", "")
			$s_Song = StringReplace(GUICtrlRead($Label10), "Song: ", "")
			$s_Lyrics = GUICtrlRead($Edit2)
			$s_Pic = $TempDir & "cover3.jpg"
		Case $Button10
			$s_Artist = StringReplace(GUICtrlRead($Label11), "Artist: ", "")
			$s_Song = StringReplace(GUICtrlRead($Label12), "Song: ", "")
			$s_Lyrics = GUICtrlRead($Edit3)
			$s_Pic = $TempDir & "cover4.jpg"
		Case Else
			Return
	EndSwitch

	If $s_SavePath = "" Then
		$s_SavePath = FileSaveDialog("Save Lyrics", $sDefPath, "Text (*txt)", 16, $s_Artist & "-" & $s_Song & ".txt")
	Else
		$s_SavePath = FileSaveDialog("Save Lyrics", $s_SavePath, "Text (*txt)", 16, $s_Artist & "-" & $s_Song & ".txt")
	EndIf
	If $s_SavePath <> "" Then
		_FileCreate($s_SavePath)
		If Not @error Then
			FileWrite($s_SavePath, $s_Lyrics)
		Else
			_GUICtrlStatusBar_SetText($StatusBar, " Unable to create file.")
			Return
		EndIf
	Else
		_GUICtrlStatusBar_SetText($StatusBar, " There was a problem saving the file.")
		Return
	EndIf
	If MsgBox(36, "Album Cover", "Would you also like to save the album cover?") == 6 Then
		$s_SaveDir = StringTrimRight($s_SavePath, StringLen($s_SavePath) - StringInStr($s_SavePath, "\", 0, -1))
		$s_SavePath = FileSaveDialog("Save Album Cover", $s_SaveDir, "Image (*jpg)", 16, "album_cover.jpg")
		If Not @error Then
			FileCopy($s_Pic, $s_SavePath)
		EndIf
	EndIf
	_GUICtrlStatusBar_SetText($StatusBar, " The file was saved successfully.")
EndFunc   ;==>_Save

;===============================================================================
;
; Function Name:   _ComboChange
; Description::    Enables/Disables controls based on combo selections.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _ComboChange()

	Local $h_CtrlID = @GUI_CtrlId

	Switch $h_CtrlID
		Case $Combo1
			If StringInStr(GUICtrlRead($Combo1), "...") Then
				GUICtrlSetState($Button4, $GUI_DISABLE)
			Else
				GUICtrlSetState($Button4, $GUI_ENABLE)
			EndIf
		Case $Combo2
			If StringInStr(GUICtrlRead($Combo2), "...") Then
				GUICtrlSetState($Button8, $GUI_DISABLE)
			Else
				GUICtrlSetState($Button8, $GUI_ENABLE)
			EndIf
		Case Else
			Return
	EndSwitch
EndFunc   ;==>_ComboChange

;===============================================================================
;
; Function Name:   _ResetTab
; Description::    Resets the specified tab back to default values.
; Parameter(s):    $h_Tab - Requesting Tab
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _ResetTab($h_Tab)

	Local $h_Edit, $h_Album, $h_Release, $h_Pic, $h_List

	Switch $h_Tab
		Case $TabSheet1
			$h_Edit = $Edit4
			$h_Album = $Label16
			$h_Release = $Label17
			$h_Pic = $Pic5
			$h_List = ""
		Case $TabSheet2
			$h_Edit = $Edit1
			$h_Album = $Label1
			$h_Release = $Label2
			$h_Pic = $Pic2
			$h_List = ""
		Case $TabSheet3
			$h_Edit = $Edit2
			$h_Album = $Label3
			$h_Release = $Label4
			$h_Pic = $Pic3
			$h_List = $List1
		Case $TabSheet4
			$h_Edit = $Edit3
			$h_Album = $Label5
			$h_Release = $Label6
			$h_Pic = $Pic4
			$h_List = $List2
		Case Else
			Return
	EndSwitch

	;_GUICtrlListBox_ResetContent($h_List)
	GUICtrlSetData($h_Edit, "")
	GUICtrlSetData($h_Album, "Album:")
	GUICtrlSetData($h_Release, "Release:")
	GUICtrlSetImage($h_Pic, $TempDir & "nocover.gif")
EndFunc   ;==>_ResetTab
#endregion
#region Functions-iTunes
;===============================================================================
;
; Function Name:   _IntegrateiTunes
; Description::    Sets the GUI up for iTunes Integration.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _IntegrateiTunes()

	Local $o_Playlist, $o_Item, $s_Artist, $s_Song, $s_FilePath, $s_FileDir, $i_Volume, $i_State

	_IntegrateDisable("Winamp")
	GUISetCursor(15, 1)
	$oiTunes = ObjCreate("iTunes.Application")
	$oiTunesEvent = ObjEvent($oiTunes, "_Event_")
	If IsObj($oiTunes.CurrentTrack) Then
		_Event_OnPlayerPlayEvent()
	EndIf
	$i_Volume = $oiTunes.SoundVolume
	$i_State = $oiTunes.playerState
	If $i_State = 1 Then
		GUICtrlSetData($Button17, ";")
		GUICtrlSetFont($Button17, 11, 400, 0, "Webdings")
	EndIf
	GUICtrlSetOnEvent($Slider1, "_iTunesVolumeSet")
	GUICtrlSetOnEvent($Button11, "_iTunesPlayback")
	GUICtrlSetOnEvent($Button17, "_iTunesPlayback")
	GUICtrlSetOnEvent($Button18, "_iTunesPlayback")
	GUICtrlSetOnEvent($Button16, "_iTunesPlayback")
	GUICtrlSetOnEvent($Button21, "_iTunesSaveLyrics")
	GUICtrlSetOnEvent($Button22, "_iTunesSaveArtwork")
	;GUICtrlSetState($Checkbox1, $GUI_ENABLE)
	GUICtrlSetState($Label13, $GUI_ENABLE)
	GUICtrlSetState($Progress1, $GUI_ENABLE)
	GUICtrlSetState($Label14, $GUI_ENABLE)
	GUICtrlSetState($Slider1, $GUI_ENABLE)
	GUICtrlSetState($Button11, $GUI_ENABLE)
	GUICtrlSetState($Button17, $GUI_ENABLE)
	GUICtrlSetState($Button18, $GUI_ENABLE)
	GUICtrlSetState($Button16, $GUI_ENABLE)
	GUICtrlSetState($Button20, $GUI_ENABLE)
	GUICtrlSetState($Button21, $GUI_ENABLE)
	GUICtrlSetState($Button22, $GUI_ENABLE)
	GUICtrlSetState($Input4, $GUI_ENABLE)
	GUICtrlSetState($Input5, $GUI_ENABLE)
	GUICtrlSetLimit($Slider1, 100, 0)
	GUICtrlSetData($Slider1, $i_Volume)
	AdlibEnable("_iTunesTrackPosition")
	$iIntegrate = "1"
	GUISetCursor()
EndFunc   ;==>_IntegrateiTunes

;===============================================================================
;
; Function Name:   _iTunesVolumeSet
; Description::    Sets the player volume when the GUI slider is adjusted.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _iTunesVolumeSet()
	$oiTunes.SoundVolume = GUICtrlRead($Slider1)
EndFunc   ;==>_iTunesVolumeSet

;===============================================================================
;
; Function Name:   _iTunesPlayback
; Description::    Changes the playback state of iTunes.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _iTunesPlayback()

	Local $h_CtrlID = @GUI_CtrlId, $i_State

	Switch $h_CtrlID
		Case $Button11
			$oiTunes.PreviousTrack
			;_Event_ChangedTrack()
		Case $Button17
			$i_State = $oiTunes.playerState
			Switch $i_State
				Case 0 ;stopped
					$oiTunes.Play
					GUICtrlSetData($Button17, ";")
					GUICtrlSetFont($Button17, 11, 400, 0, "Webdings")
				Case 1 ;playing
					$oiTunes.Pause
					GUICtrlSetData($Button17, "u")
					GUICtrlSetFont($Button17, 9, 400, 0, "Wingdings 3")
			EndSwitch
		Case $Button18
			$oiTunes.Stop
			GUICtrlSetData($Button17, "u")
			GUICtrlSetFont($Button17, 9, 400, 0, "Wingdings 3")
		Case $Button16
			$oiTunes.NextTrack
	EndSwitch
EndFunc   ;==>_iTunesPlayback

;===============================================================================
;
; Function Name:   _iTunesTrackPosition
; Description::    Updates the progress bar based on the current song position.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _iTunesTrackPosition()

	Local $o_Playlist, $o_Item, $i_Length, $i_Position

	If IsObj($oiTunes) Then
		$o_Item = $oiTunes.CurrentTrack
		If IsObj($o_Item) Then
			$i_Length = $o_Item.Duration
			$i_Position = ($oiTunes.PlayerPosition)
			GUICtrlSetData($Progress1, ($i_Position / $i_Length) * 100)
		EndIf
	EndIf
EndFunc   ;==>_iTunesTrackPosition

;===============================================================================
;
; Function Name:   _iTunesSaveLyrics
; Description::    Updates the lyrics stored for the current song in iTunes Database.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _iTunesSaveLyrics()
	$fiTunesUpdate = False
	$s_Lyrics = GUICtrlRead($Edit4)
	$o_Item = $oiTunes.CurrentTrack
	$o_Item.Lyrics = $s_Lyrics
	Sleep(500)
	$fiTunesUpdate = True
EndFunc   ;==>_iTunesSaveLyrics

;===============================================================================
;
; Function Name:   _iTunesSaveArtwork
; Description::    Updates the artwork stored for the current song in iTunes Database.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _iTunesSaveArtwork()
	$fiTunesUpdate = False
	$o_Item = $oiTunes.CurrentTrack
	$o_Item.AddArtworkFromFile($TempDir & "cover1.jpg")
	Sleep(500)
	$fiTunesUpdate = True
EndFunc   ;==>_iTunesSaveArtwork
#endregion
#region Functions-Winamp
;===============================================================================
;
; Function Name:   _IntegrateWinamp
; Description::    Sets the GUI up for Winamp Integration.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _IntegrateWinamp()

	Local $o_Playlist, $o_Item, $s_Artist, $s_Song, $s_FilePath, $s_FileDir, $i_Volume, $i_State

	_IntegrateDisable("iTunes")
	_IEErrorHandlerDeRegister()
	_WinampErrorHandlerRegister()
	GUISetCursor(15, 1)
	$oWinAmp = _WinampCreate()
	If Not @error Then
		$fWinampAttached = @extended
		$oWinampEvent = ObjEvent($oWinAmp, "_Event_")
		$o_Playlist = $oWinAmp.playlist
		$o_Item = $o_PlayList($o_Playlist.position)
		$s_Artist = $o_Item.Artist
		$s_Song = $o_Item.Title
		$s_FilePath = $o_Item.FileName
		$s_FileDir = StringTrimRight($s_FilePath, StringLen($s_FilePath) - StringInStr($s_FilePath, "\", 0, -1))
		$sSavePath1 = $s_FileDir
		$i_Volume = $oWinAmp.Volume
		$i_State = $oWinAmp.PlayState
		If $i_State = 1 Then
			GUICtrlSetData($Button17, ";")
			GUICtrlSetFont($Button17, 11, 400, 0, "Webdings")
		EndIf
		GUICtrlSetOnEvent($Slider1, "_WinampVolumeSet")
		GUICtrlSetOnEvent($Button11, "_WinampPlayback")
		GUICtrlSetOnEvent($Button17, "_WinampPlayback")
		GUICtrlSetOnEvent($Button18, "_WinampPlayback")
		GUICtrlSetOnEvent($Button16, "_WinampPlayback")
		GUICtrlSetOnEvent($Button21, "_Save")
		GUICtrlSetOnEvent($Button22, "_iTunesSaveArtwork")
		GUICtrlSetState($Checkbox1, $GUI_ENABLE)
		GUICtrlSetState($Label13, $GUI_ENABLE)
		GUICtrlSetState($Progress1, $GUI_ENABLE)
		GUICtrlSetState($Label14, $GUI_ENABLE)
		GUICtrlSetState($Slider1, $GUI_ENABLE)
		GUICtrlSetState($Button11, $GUI_ENABLE)
		GUICtrlSetState($Button17, $GUI_ENABLE)
		GUICtrlSetState($Button18, $GUI_ENABLE)
		GUICtrlSetState($Button16, $GUI_ENABLE)
		GUICtrlSetState($Button20, $GUI_ENABLE)
		GUICtrlSetState($Button21, $GUI_ENABLE)
		GUICtrlSetState($Input4, $GUI_ENABLE)
		GUICtrlSetState($Input5, $GUI_ENABLE)
		GUICtrlSetData($Input4, $s_Artist)
		GUICtrlSetData($Input5, $s_Song)
		GUICtrlSetLimit($Slider1, 255, 0)
		GUICtrlSetData($Slider1, $i_Volume)
		AdlibEnable("_WinampTrackPosition")
		$iIntegrate = "2"
	EndIf
	GUISetCursor()
	_WinampErrorHandlerDeRegister()
	_IEErrorHandlerRegister()
EndFunc   ;==>_IntegrateWinamp

;===============================================================================
;
; Function Name:   _WinampVolumeSet
; Description::    Sets the player volume when the GUI slider is adjusted.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _WinampVolumeSet()
	$oWinAmp.Volume = GUICtrlRead($Slider1)
EndFunc   ;==>_WinampVolumeSet

;===============================================================================
;
; Function Name:   _WinampPlayback
; Description::    Changes the playback state of Winamp.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _WinampPlayback()

	Local $h_CtrlID = @GUI_CtrlId, $i_State

	Switch $h_CtrlID
		Case $Button11
			$oWinAmp.Previous
			;_Event_ChangedTrack()
		Case $Button17
			$i_State = $oWinAmp.PlayState
			Switch $i_State
				Case 0, 3 ;stopped/paused
					$oWinAmp.Play
					GUICtrlSetData($Button17, ";")
					GUICtrlSetFont($Button17, 11, 400, 0, "Webdings")
				Case 1 ;playing
					$oWinAmp.Pause
					GUICtrlSetData($Button17, "u")
					GUICtrlSetFont($Button17, 9, 400, 0, "Wingdings 3")
			EndSwitch
		Case $Button18
			$oWinAmp.StopPlayback
			GUICtrlSetData($Button17, "u")
			GUICtrlSetFont($Button17, 9, 400, 0, "Wingdings 3")
		Case $Button16
			$oWinAmp.Skip
	EndSwitch
EndFunc   ;==>_WinampPlayback

;===============================================================================
;
; Function Name:   _WinampTrackPosition
; Description::    Updates the progress bar based on the current song position.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _WinampTrackPosition()

	Local $o_Playlist, $o_Item, $i_Length, $i_Position

	If IsObj($oWinAmp) Then
		$o_Playlist = $oWinAmp.playlist
		$o_Item = $o_PlayList($o_Playlist.position)
		$i_Length = $o_Item.Length
		$i_Position = ($oWinAmp.Position / 1000)
		GUICtrlSetData($Progress1, ($i_Position / $i_Length) * 100)
	EndIf
EndFunc   ;==>_WinampTrackPosition
#endregion
#region Functions-Settings
;===============================================================================
;
; Function Name:   _ApplySettings
; Description::    Applies the users saved settings to the GUI.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _ApplySettings()
	Switch $iIntegrate
		Case "0"
			GUICtrlSetState($Radio1, $GUI_CHECKED)
		Case "1"
			GUICtrlSetState($Radio2, $GUI_CHECKED)
			_IntegrateiTunes()
		Case "2"
			GUICtrlSetState($Radio3, $GUI_CHECKED)
			_IntegrateWinamp()
	EndSwitch

	If $fRealtime = "1"  Then GUICtrlSetState($Checkbox1, $GUI_CHECKED)
EndFunc   ;==>_ApplySettings

;===============================================================================
;
; Function Name:   _ApplySettings
; Description::    Saves the users settings.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _SaveSettings()
	If GUICtrlRead($Checkbox1) = $GUI_CHECKED Then
		$fRealtime = "1"
	Else
		$fRealtime = "0"
	EndIf
	IniWrite($TempDir & "settings.ini", "Integration", "player", $iIntegrate)
	IniWrite($TempDir & "settings.ini", "Integration", "realtime", $fRealtime)
	IniWrite($TempDir & "settings.ini", "General", "DefPath", $sDefPath)
	WinSetState($GUI, "", @SW_RESTORE)
	$aPos = WinGetPos($GUI)
	IniWrite($TempDir & "settings.ini", "General", "WinPosX", $aPos[0])
	IniWrite($TempDir & "settings.ini", "General", "WinPosY", $aPos[1])
EndFunc   ;==>_SaveSettings

;===============================================================================
;
; Function Name:   _Browse
; Description::    Allows user to set thier default music folder.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _Browse()

	Local $s_Path

	$s_Path = FileSelectFolder("Select Music Folder", "", 2, $sDefPath)
	If Not @error Then
		GUICtrlSetData($Input3, $s_Path)
		$sDefPath = $s_Path
	EndIf
EndFunc   ;==>_Browse

;===============================================================================
;
; Function Name:   _IntegrateDisable
; Description::    Disables integration for the specified player.
; Parameter(s):    $s_Player - The player to disable integration
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _IntegrateDisable($s_Player = "")
	AdlibDisable()
	If Not IsDeclared("s_Player") Then $s_Player = ""
	Switch $s_Player
		Case ""
			$iIntegrate = "0"
			_IntegrateDisable("Winamp")
			_IntegrateDisable("iTunes")
		Case "Winamp"
			_ResetTab($TabSheet1)
			GUICtrlSetState($Checkbox1, $GUI_UNCHECKED)
			GUICtrlSetState($Checkbox1, $GUI_DISABLE)
			GUICtrlSetState($Label13, $GUI_DISABLE)
			GUICtrlSetState($Label14, $GUI_DISABLE)
			GUICtrlSetState($Progress1, $GUI_DISABLE)
			GUICtrlSetState($Slider1, $GUI_DISABLE)
			GUICtrlSetState($Button11, $GUI_DISABLE)
			GUICtrlSetState($Button16, $GUI_DISABLE)
			GUICtrlSetState($Button17, $GUI_DISABLE)
			GUICtrlSetState($Button18, $GUI_DISABLE)
			GUICtrlSetState($Button20, $GUI_DISABLE)
			GUICtrlSetState($Button21, $GUI_DISABLE)
			GUICtrlSetState($Input4, $GUI_DISABLE)
			GUICtrlSetState($Input5, $GUI_DISABLE)
			_IEErrorHandlerDeRegister()
			_WinampErrorHandlerRegister()
			$oWinampEvent = 0
			If IsObj($oWinAmp) Then
				If Not $fWinampAttached Then
					_WinampQuit($oWinAmp)
				EndIf
			EndIf
			$oWinAmp = 0
			_WinampErrorHandlerDeRegister()
			_IEErrorHandlerRegister()
		Case "iTunes"
			_ResetTab($TabSheet1)
			GUICtrlSetState($Checkbox1, $GUI_UNCHECKED)
			GUICtrlSetState($Checkbox1, $GUI_DISABLE)
			GUICtrlSetState($Label13, $GUI_DISABLE)
			GUICtrlSetState($Label14, $GUI_DISABLE)
			GUICtrlSetState($Progress1, $GUI_DISABLE)
			GUICtrlSetState($Slider1, $GUI_DISABLE)
			GUICtrlSetState($Button11, $GUI_DISABLE)
			GUICtrlSetState($Button16, $GUI_DISABLE)
			GUICtrlSetState($Button17, $GUI_DISABLE)
			GUICtrlSetState($Button18, $GUI_DISABLE)
			GUICtrlSetState($Button20, $GUI_DISABLE)
			GUICtrlSetState($Button21, $GUI_DISABLE)
			GUICtrlSetState($Button22, $GUI_DISABLE)
			GUICtrlSetState($Input4, $GUI_DISABLE)
			GUICtrlSetState($Input5, $GUI_DISABLE)
			$oiTunes = 0
			$oiTunesEvent = 0
	EndSwitch
EndFunc   ;==>_IntegrateDisable
#endregion
#region Functions-Events
;===============================================================================
;
; Function Name:   _Event_ChangedTrack
; Description::    Is called when Winamp changes tracks, updates GUI track info.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _Event_ChangedTrack()

	Local $o_Playlist, $o_Item, $s_Artist, $s_Song, $s_FilePath, $s_FileDir

	_WinampTrackPosition()
	_ResetTab($TabSheet1)
	$o_Playlist = $oWinAmp.playlist
	$o_Item = $o_PlayList($o_Playlist.position)
	$s_Artist = $o_Item.Artist
	$s_Song = $o_Item.Title
	$s_FilePath = $o_Item.FileName
	$s_FileDir = StringTrimRight($s_FilePath, StringLen($s_FilePath) - StringInStr($s_FilePath, "\", 0, -1))
	GUICtrlSetData($Input4, $s_Artist)
	GUICtrlSetData($Input5, $s_Song)
	$sSavePath1 = $s_FileDir
	If GUICtrlRead($Checkbox1) <> $GUI_CHECKED Then Return
	_SearchLyricsManual($TabSheet1)
EndFunc   ;==>_Event_ChangedTrack

;===============================================================================
;
; Function Name:   _Event_ChangedVolume
; Description::    Is called when Winamp's volume changes, updates GUI volume.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _Event_ChangedVolume()
	GUICtrlSetData($Slider1, $oWinAmp.Volume)
EndFunc   ;==>_Event_ChangedVolume

;===============================================================================
;
; Function Name:   _Event_ChangedStatus
; Description::    Is called when Winamp's playstate changes, updates GUI playstate.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _Event_ChangedStatus()
	$o_Playlist = $oWinAmp.playlist
	$i_State = $oWinAmp.PlayState
	If $i_State = 1 Then
		GUICtrlSetData($Button17, ";")
		GUICtrlSetFont($Button17, 11, 400, 0, "Webdings")
	Else
		GUICtrlSetData($Button17, "u")
		GUICtrlSetFont($Button17, 9, 400, 0, "Wingdings 3")
	EndIf
EndFunc   ;==>_Event_ChangedStatus

;===============================================================================
;
; Function Name:   _Event_OnSoundVolumeChangedEvent
; Description::    Is called when iTunes's volume changes, updates GUI volume.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _Event_OnSoundVolumeChangedEvent()
	GUICtrlSetData($Slider1, $oiTunes.SoundVolume)
EndFunc   ;==>_Event_OnSoundVolumeChangedEvent

;===============================================================================
;
; Function Name:   _Event_OnPlayerPlayEvent
; Description::    Is "supposed" to be called when iTunes changes tracks, updates GUI track info.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _Event_OnPlayerPlayEvent()

	Local $o_Item, $o_Art, $o_Artwork, $s_Artist, $s_Song, $s_Album, $s_Release, $s_FilePath, $s_FileDir

	If Not $fiTunesUpdate Then Return

	FileDelete($TempDir & "cover1.jpg")
	$o_Item = $oiTunes.CurrentTrack
	$o_Artwork = $o_Item.Artwork
	For $o_Art In $o_Artwork
		$o_Art.SaveArtworkToFile($TempDir & "cover1.jpg")
	Next
	$s_Artist = $o_Item.Artist
	$s_Song = $o_Item.Name
	$s_Album = "Album: " & $o_Item.Album
	$s_Release = "Release: " & $o_Item.Year
	$s_Lyrics = $o_Item.Lyrics
	$s_FilePath = $o_Item.Location
	$s_FileDir = StringTrimRight($s_FilePath, StringLen($s_FilePath) - StringInStr($s_FilePath, "\", 0, -1))
	$sSavePath1 = $s_FileDir
	GUICtrlSetData($Input4, $s_Artist)
	GUICtrlSetData($Input5, $s_Song)
	GUICtrlSetData($Label16, $s_Album)
	GUICtrlSetData($Label17, $s_Release)
	If FileExists($TempDir & "cover1.jpg") Then
		GUICtrlSetImage($Pic5, $TempDir & "cover1.jpg")
	Else
		GUICtrlSetImage($Pic5, $TempDir & "nocover.gif")
	EndIf
	If $s_Lyrics = "0"  Then
		GUICtrlSetData($Edit4, "")
	Else
		GUICtrlSetData($Edit4, $s_Lyrics)
	EndIf
	If GUICtrlRead($Checkbox1) <> $GUI_CHECKED Then Return
	_SearchLyricsManual($TabSheet1)
EndFunc   ;==>_Event_OnPlayerPlayEvent

;===============================================================================
;
; Function Name:   _Event_OnPlayerStopEvent
; Description::    If _Event_OnPlayerPlayEvent is not called this will be, manually calls _Event_OnPlayerPlayEvent.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _Event_OnPlayerStopEvent()
	_Event_OnPlayerPlayEvent()
EndFunc   ;==>_Event_OnPlayerStopEvent

;===============================================================================
;
; Function Name:   _Event_OnCOMCallsEnabledEvent
; Description::    Is called when iTunes enables COM Calls, turns ablib on to update track position.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _Event_OnCOMCallsEnabledEvent()
	AdlibEnable("_iTunesTrackPosition")
EndFunc   ;==>_Event_OnCOMCallsEnabledEvent

;===============================================================================
;
; Function Name:   _Event_OnCOMCallsDisabledEvent
; Description::    Is called when iTunes disables COM Calls, turns ablib off to aviod errors.
; Parameter(s):    None
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _Event_OnCOMCallsDisabledEvent()
	AdlibDisable()
EndFunc   ;==>_Event_OnCOMCallsDisabledEvent
#endregion
#region Functions-Utility
;===============================================================================
;
; Function Name:   _ToggleImages
; Description::    Toggles images on/off for IE.
; Parameter(s):    $f_State - Specifies whether images are turned on (Ture) or off (False).
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _ToggleImages($f_State = True)
	If $f_State Then
		$s_Status = "yes"
	Else
		$s_Status = "no"
	EndIf
	RegWrite("HKEY_CURRENT_USER\Software\Microsoft\Internet Explorer\Main", _
			"Display Inline Images", "REG_SZ", $s_Status)
EndFunc   ;==>_ToggleImages

;===============================================================================
;
; Function Name:   _Escape
; Description::    Formats a URL for use with IE.
; Parameter(s):    $s_String - The string to be formatted
; Author(s):       Bob Anthony (big_daddy)
;
;===============================================================================
;
Func _Escape($s_String)

	Local $s_Return = "", $s_Char, $s_NewChar

	For $i = 1 To StringLen($s_String)
		$s_Char = StringMid($s_String, $i, 1)
		If StringRegExp($s_Char, '\w|\.|\/|\:', 0) Then
			$s_NewChar = $s_Char
		Else
			$s_NewChar = "%" & Hex(Asc($s_Char), 2)
		EndIf
		$s_Return = $s_Return & $s_NewChar
	Next
	Return $s_Return
EndFunc   ;==>_Escape

Func _GetExtProperty($sPath, $iProp)

	Local $iExist, $sFile, $sDir, $oShellApp, $oDir, $oFile, $aProperty, $sProperty

	$iExist = FileExists($sPath)
	If $iExist = 0 Then
		SetError(1)
		Return 0
	Else
		$sFile = StringTrimLeft($sPath, StringInStr($sPath, "\", 0, -1))
		$sDir = StringTrimRight($sPath, (StringLen($sPath) - StringInStr($sPath, "\", 0, -1)))
		$oShellApp = ObjCreate("shell.application")
		$oDir = $oShellApp.NameSpace($sDir)
		$oFile = $oDir.Parsename($sFile)
		If $iProp = -1 Then
			Local $aProperty[35]
			For $i = 0 To 34
				$aProperty[$i] = $oDir.GetDetailsOf($oFile, $i)
			Next
			Return $aProperty
		Else
			$sProperty = $oDir.GetDetailsOf($oFile, $iProp)
			If $sProperty = "" Then
				Return 0
			Else
				Return $sProperty
			EndIf
		EndIf
	EndIf
EndFunc   ;==>_GetExtProperty

Func _Exit()
	AdlibDisable()
	#comments-start
		Save the users current setting.
	#comments-end
	_SaveSettings()
	#comments-start
		Close the browser windows we opened.
	#comments-end
	If IsObj($oIE1) Then _IEQuit($oIE1)
	If IsObj($oIE2) Then _IEQuit($oIE2)
	If IsObj($oIE3) Then _IEQuit($oIE3)
	#comments-start
		Check to see if a Winamp object was created and if we opened winamp with our script.
		If true then we deregister the IE Error Handler and register the Winamp Error Handler.
		We can now safely close Winamp without any errors.
	#comments-end
	If IsObj($oWinAmp) And Not $fWinampAttached Then
		_IEErrorHandlerDeRegister()
		_WinampErrorHandlerRegister()
		_WinampQuit($oWinAmp)
	EndIf
	Exit
EndFunc   ;==>_Exit
#endregion