

#include <_ButtonHover.au3>
#include <File.au3>

; required
; $XButton_Location = @ScriptDir & "\Buttons\Style_1"

$XButton_Location = FileReadLine(@ScriptDir & "\Buttons\BDefault.txt", 1)
If Not FileExists($XButton_Location) Then $XButton_Location = FileSelectFolder("Button Folders", @ScriptDir & "\Buttons", 2)

$color = ""
If StringInStr($XButton_Location, "15") Then $color = 0xFFFFFF

$Main_GUI = GUICreate("_ButtonHover Demo")
$List = GUICtrlCreateList("", 40, 80, 100, 100)
GUICtrlCreateLabel($XButton_Location, 20, 20, 400, 20)

$Button_1 = _HoverButton ("Small", 180, 80, 70, 15, $color)
$Button_2 = _HoverButton ("Medium", 180, 120, 90, 30, $color)
$Button_3 = _HoverButton ("Long", 180, 180, 190, 30, $color)
$Button_4 = _HoverButton ("Large", 180, 240, 190, 60, $color)

$Button_5 = GUICtrlCreateButton("Select", 50, 200, 80, 25)
GUICtrlSetTip($Button_5, "Select a Button Style")
GUISetState()

$FileList = _FileListToArray(@ScriptDir & "\Buttons", "*.*", 2)
If (Not IsArray($FileList)) Or (@error = 1) Then
	MsgBox(0, "", "No Files\Folders Found.", 5)
Else
	For $x = 1 To UBound($FileList) - 1
		If StringInStr($FileList[$x], "more") Then ContinueLoop
		$result = StringInStr($FileList[$x], "\", 1, -1)
		$final = StringTrimRight($FileList[$x], $result)
		GUICtrlSetData($List, $final, 1)
	Next
EndIf


While 1
	; required
	_CheckHoverAndPressed ($Main_GUI)

	$msg = GUIGetMsg()
	Select
		
		Case $msg = $Button_1
			MsgBox(64, "test", " You pressed Small   ", 3)
		Case $msg = $Button_2
			MsgBox(64, "test", " You pressed Medium- long   ", 3)
		Case $msg = $Button_3
			MsgBox(64, "test", " You pressed Long   ", 3)
		Case $msg = $Button_4
			MsgBox(64, "test", " You pressed Large   ", 3)
		Case $msg = $Button_5
			Buttoner()
		Case $msg = -3
			Exit
		
	EndSelect

WEnd

Func Buttoner()
	$New_Btn = GUICtrlRead($List)
	If $New_Btn = "" Then Return
	FileDelete(@ScriptDir & "\Buttons\BDefault.txt")
	FileWrite(@ScriptDir & "\Buttons\BDefault.txt", @ScriptDir & "\Buttons\" & $New_Btn)
	Run(FileGetShortName(@AutoItExe) & " " & FileGetShortName(@ScriptFullPath))
	Exit
EndFunc   ;==>Buttoner


