;---------------------------------------------------------------------------------------
; EXAMPLE
; Checks permissions.
; The folllowing return values are valid:
; 0:	Default permissions.
;		User can only see his own Active Directory data
; 128:	Extended permissions
;		User can see all data of users of his own depeartment
; 255:	Admin permissions
;		Access with no limitations
;---------------------------------------------------------------------------------------
Func _Check_Access($sFormTitle)

	Local $sDepartment = _AD_GetObjectAttribute(@UserName, "department")
	If $sDepartment = "" Then
		MsgBox($MB_ICONERROR, $sFormTitle, "Your permissions can't be verified." & @CRLF & "Property 'department' is not set in AD for your user!")
		Exit
	EndIf
	Local $iAccess = 0 ; Default permissions
	; User is a member of the IT department => admin permissions
	If StringLeft($sDepartment, 2) = "IT" Then
		$iAccess = 255
	Else
		; User is a member of a special AD group => extended permissions
		If _AD_IsMemberOf("informatik_beauftragte") Then $iAccess = 128
	EndIf
	Return $iAccess

EndFunc   ;==>_Check_Access

;---------------------------------------------------------------------------------------
; EXAMPLE
; ADCU: To be called when a user function has been defined for the main GUI in the ini file.
;---------------------------------------------------------------------------------------
Func _ADCU_Main_UserFunction()
	MsgBox(0, "Info", "Main User Function")
EndFunc   ;==>_ADCU_Main_UserFunction

;---------------------------------------------------------------------------------------
; EXAMPLE
; ADCU: To be called when a user function has been defined for the ListView in the ini file.
;---------------------------------------------------------------------------------------
Func _ADCU_LV_UserFunction($sSelected)
	MsgBox(0, "Info", "Listview User Function" & @CRLF & $sSelected)
EndFunc   ;==>_ADCU_LV_UserFunction

;---------------------------------------------------------------------------------------
; EXAMPLE
; ADCU: To be called for every record before it is written to $aDisplayXXX array
;---------------------------------------------------------------------------------------
Func _ADCU_LV_DataFunction($sPane, ByRef $aProperties, ByRef $aList, $iIndex)
	Local $aTemp
	; Add OU to the list of properties
	ReDim $aProperties[UBound($aProperties, 1) + 1][UBound($aProperties, 2)]
	$aProperties[0][0] = $aProperties[0][0] + 1
	$aProperties[$aProperties[0][0]][0] = "ou"
	$aProperties[$aProperties[0][0]][1] = _AD_GetObjectOU($aList[$iIndex], "Name")
	; Replace the FQDN for property "managedby" with the displayname of the suer
	For $i = 1 To $aProperties[0][0]
		If $aProperties[$i][0] = "managedby" Then
			$aTemp = _AD_GetObjectProperties($aProperties[$i][1], "DisplayName")
			If @error = 0 And $aTemp[0][0] > 0 Then $aProperties[$i][1] = $aTemp[1][1]
		EndIf
	Next
EndFunc   ;==>_ADCU_LV_DataFunction

;---------------------------------------------------------------------------------------
; EXAMPLE
; ADCU: To be called when a user function has been defined for detail view in the ini file.
;---------------------------------------------------------------------------------------
Func _ADCU_Detail_UserFunction()
	MsgBox(0, "Info", "Detail User Function")
EndFunc   ;==>_ADCU_Detail_UserFunction

;---------------------------------------------------------------------------------------
; EXAMPLE
; ADCG: To be called when a user function has been defined for the main GUI in the ini file.
;---------------------------------------------------------------------------------------
Func _ADCG_Main_UserFunction()
EndFunc   ;==>_ADCG_Main_UserFunction

;---------------------------------------------------------------------------------------
; EXAMPLE
; ADCG: To be called when a user function has been defined for the ListView in the ini file.
;---------------------------------------------------------------------------------------
Func _ADCG_LV_UserFunction($sSelected)
EndFunc   ;==>_ADCG_LV_UserFunction

;---------------------------------------------------------------------------------------
; EXAMPLE
; ADCG: To be called for every record before it is written to $aDisplayXXX array
;---------------------------------------------------------------------------------------
Func _ADCG_LV_DataFunction($sPane, ByRef $aProperties, ByRef $aList, $iIndex)
EndFunc   ;==>_ADCU_LV_DataFunction

;---------------------------------------------------------------------------------------
; EXAMPLE
; ADCG: To be called when a user function has been defined for detail view in the ini file.
;---------------------------------------------------------------------------------------
Func _ADCG_Detail_UserFunction()
EndFunc   ;==>_ADCU_Detail_UserFunction
