#include-once

Func _Tool_Move_Start($oSelf, $iX, $iY)
	$oSelf.lastX = $iX
	$oSelf.lastY = $iY
	$oSelf.extra1 = $oCurrentThread.thread.currentLayer.x
	$oSelf.extra2 = $oCurrentThread.thread.currentLayer.y

	$oSelf.extra3 = $iX
	$oSelf.extra4 = $iY

	$sel = _Util_IsolateSelection()

	$oSelf.extra5 = $sel[0]
	$oSelf.extra6 = $sel[1]

	$oSelf.extra7 = _Angle($oCurrentThread.thread.currentLayer.width/2, $oCurrentThread.thread.currentLayer.height/2, $iX, $iY)
	$oSelf.extra8 = _GDIPlus_RegionClone($oCurrentThread.thread.selection)
EndFunc

Func _Tool_Move_Draw($oSelf, $iX, $iY)
	$dX = $iX-$oSelf.lastX
	$dY = $iY-$oSelf.lastY


	$tBmp = _GDIPlus_BitmapCreateFromScan0($oCurrentThread.thread.currentLayer.width, $oCurrentThread.thread.currentLayer.height)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)

	_GDIPlus_GraphicsDrawImageRect($tGpx, $oSelf.extra5, 0, 0, $oCurrentThread.thread.currentLayer.width, $oCurrentThread.thread.currentLayer.height)

	Switch $iTransformToolMode
		Case 0
			_GDIPlus_RegionTranslate($oCurrentThread.thread.selection, $iX-$oSelf.extra3, $iY-$oSelf.extra4)

			_GDIPlus_GraphicsDrawImageRect($tGpx, $oSelf.extra6, $dX, $dY, $oCurrentThread.thread.currentLayer.width, $oCurrentThread.thread.currentLayer.height)
		Case 1
			$iAngle = _Degree(_Angle($oCurrentThread.thread.currentLayer.width/2, $oCurrentThread.thread.currentLayer.height/2, $iX, $iY)-$oSelf.extra7)
			If _IsPressed("10") Then
				$iAngle = Round($iAngle/45)*45
			EndIf

			_GDIPlus_RegionDispose($oCurrentThread.thread.selection)
			$oCurrentThread.thread.selection = _GDIPlus_RegionClone($oSelf.extra8)

			$tMx = _GDIPlus_MatrixCreate()
			_GDIPlus_MatrixTranslate($tMx, -$oCurrentThread.thread.currentLayer.width/2, -$oCurrentThread.thread.currentLayer.height/2)
			_GDIPlus_RegionTransform($oCurrentThread.thread.selection, $tMx)
			_GDIPlus_MatrixDispose($tMx)

			$tMx = _GDIPlus_MatrixCreate()
			_GDIPlus_MatrixRotate($tMx, $iAngle)
			_GDIPlus_RegionTransform($oCurrentThread.thread.selection, $tMx)
			_GDIPlus_MatrixDispose($tMx)

			$tMx = _GDIPlus_MatrixCreate()
			_GDIPlus_MatrixTranslate($tMx, $oCurrentThread.thread.currentLayer.width/2, $oCurrentThread.thread.currentLayer.height/2)
			_GDIPlus_RegionTransform($oCurrentThread.thread.selection, $tMx)
			_GDIPlus_MatrixDispose($tMx)

			_DrawRotated($tGpx, $oSelf.extra6, $oCurrentThread.thread.currentLayer.width/2, $oCurrentThread.thread.currentLayer.height/2, 0, 0, $iAngle)
	EndSwitch

	_GDIPlus_GraphicsDispose($tGpx)
	_GDIPlus_BitmapDispose($oCurrentThread.thread.currentLayer.bmp)
	$oCurrentThread.thread.currentLayer.bmp = $tBmp

	$oSelf.extra3 = $iX
	$oSelf.extra4 = $iY
EndFunc

Func _Tool_Move_End($oSelf, $iX, $iY)
EndFunc

Func _Tool_Move_DrawHUD($oSelf, $hGpx, $iX, $iY)
	$tPen = _GDIPlus_PenCreate(0xAAFFFFFF, 3)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX-10, $iY, $iX-4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX+10, $iY, $iX+4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY-10, $iX, $iY-4, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY+10, $iX, $iY+4, $tPen)
	_GDIPlus_PenDispose($tPen)

	$tPen = _GDIPlus_PenCreate(0xAA000000)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX-10, $iY, $iX-4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX+10, $iY, $iX+4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY-10, $iX, $iY-4, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY+10, $iX, $iY+4, $tPen)
	_GDIPlus_PenDispose($tPen)

	If $iTransformToolMode = 1 And _IsPressed(1) Then
		$x = $iX
		$y = $iY
		_Util_ConvertClientToBitmap($x, $y)

		$iStart = _Degree($oSelf.extra7)
		$iSweep = _Degree(_Angle($oCurrentThread.thread.currentLayer.width/2, $oCurrentThread.thread.currentLayer.height/2, $x, $y)-$oSelf.extra7)

		$x = $oCurrentThread.thread.currentLayer.width/2
		$y = $oCurrentThread.thread.currentLayer.height/2
		_Util_ConvertBitmapToClient($x, $y)

		$tBrush = _GDIPlus_BrushCreateSolid(0x44000000)
		_GDIPlus_GraphicsFillEllipse($hGpx, $x-40, $y-40, 80, 80, $tBrush)
		_GDIPlus_BrushDispose($tBrush)

		$tBrush = _GDIPlus_BrushCreateSolid(0x55FF0000)
		_GDIPlus_GraphicsFillPie($hGpx, $x-40, $y-40, 80, 80, $iStart, $iSweep, $tBrush)
		_GDIPlus_BrushDispose($tBrush)

		If _IsPressed("10") Then
			$iSweep = Round($iSweep/45)*45

			$tBrush = _GDIPlus_BrushCreateSolid(0x55FFFFFF)
			_GDIPlus_GraphicsFillPie($hGpx, $x-40, $y-40, 80, 80, $iStart, $iSweep, $tBrush)
			_GDIPlus_BrushDispose($tBrush)
		EndIf

		$tPen = _GDIPlus_PenCreate(0xAAFFFFFF)
		_GDIPlus_GraphicsDrawEllipse($hGpx, $x-40, $y-40, 80, 80, $tPen)
		_GDIPlus_GraphicsDrawPie($hGpx, $x-40, $y-40, 80, 80, $iStart, $iSweep, $tPen)
		_GDIPlus_PenDispose($tPen)
	EndIf
EndFunc

Func _Tool_Move_ShowUI($oSelf)
	Return 0
EndFunc

Func _Tool_Move_CanBypassLock($oSelf, $iLockMode)
	Switch $iLockMode
		Case $V4_LL_NONE, $V4_LL_COLOR
			If $iTransformToolMode = 1 And $iLockMode = $V4_LL_COLOR Then Return 0
			Return 1
		Case Else
			Return 0
	EndSwitch
EndFunc
