#include-once

Func _Blend($hBmp, $iColor, $iMode)
	Local $tCm = 0
	Local $rgb = _ColorGetRGB(_SetAlpha($iColor, 0))
	$rgb[0] /= 255
	$rgb[1] /= 255
	$rgb[2] /= 255

	Switch $iMode
		Case $V4_BM_NORMAL
			$tCm = _GDIPlus_ColorMatrixCreate()
		Case $V4_BM_ADD, $V4_BM_HARDMIX
			$tCm = _GDIPlus_ColorMatrixCreateTranslate($rgb[0], $rgb[1], $rgb[2])
		Case $V4_BM_SUBTRACT
			$tCm = _GDIPlus_ColorMatrixCreateTranslate(-$rgb[0], -$rgb[1], -$rgb[2])
		Case $V4_BM_MULTIPLY
			$tCm = _GDIPlus_ColorMatrixCreateScale($rgb[0], $rgb[1], $rgb[2])
		Case $V4_BM_DIVIDE
			$tCm = _GDIPlus_ColorMatrixCreateScale(1/$rgb[0], 1/$rgb[1], 1/$rgb[2])
		Case $V4_BM_LINEARBURN
			$tCm = _GDIPlus_ColorMatrixCreateTranslate($rgb[0], $rgb[1], $rgb[2])
			_GDIPlus_ColorMatrixTranslate($tCm, -1, -1, -1)
		Case $V4_BM_LINEARLIGHT
			If _Max(_Max($rgb[0], $rgb[1]), $rgb[2]) < 0.5 Then
				$tCm = _GDIPlus_ColorMatrixCreateScale(2, 2, 2)
				_GDIPlus_ColorMatrixTranslate($tCm, $rgb[0], $rgb[1], $rgb[2])
				_GDIPlus_ColorMatrixTranslate($tCm, -1, -1, -1)
			Else
				$tCm = _GDIPlus_ColorMatrixCreateTranslate(-0.5, -0.5, -0.5)
				_GDIPlus_ColorMatrixScale($tCm, 2, 2, 2)
				_GDIPlus_ColorMatrixTranslate($tCm, $rgb[0], $rgb[1], $rgb[2])
			EndIf
	EndSwitch

	Switch $iMode
		Case $V4_BM_SCREEN
			$tCm = _GDIPlus_ColorMatrixCreateNegative()
			$tEff = _GDIPlus_EffectCreateColorMatrix($tCm)
			_GDIPlus_BitmapApplyEffect($hBmp, $tEff)
			_GDIPlus_EffectDispose($tEff)

			$tCm = _GDIPlus_ColorMatrixCreateScale(1-$rgb[0], 1-$rgb[1], 1-$rgb[2])
			$tEff = _GDIPlus_EffectCreateColorMatrix($tCm)
			_GDIPlus_BitmapApplyEffect($hBmp, $tEff)
			_GDIPlus_EffectDispose($tEff)

			$tCm = _GDIPlus_ColorMatrixCreateNegative()
			$tEff = _GDIPlus_EffectCreateColorMatrix($tCm)
			_GDIPlus_BitmapApplyEffect($hBmp, $tEff)
			_GDIPlus_EffectDispose($tEff)
		Case $V4_BM_HARDLIGHT
			If _Max(_Max($rgb[0], $rgb[1]), $rgb[2]) < 0.5 Then
				$tCm = _GDIPlus_ColorMatrixCreateScale($rgb[0], $rgb[1], $rgb[2])
				_GDIPlus_ColorMatrixScale($tCm, 2, 2, 2)
				$tEff = _GDIPlus_EffectCreateColorMatrix($tCm)
				_GDIPlus_BitmapApplyEffect($hBmp, $tEff)
				_GDIPlus_EffectDispose($tEff)
			Else
				$tCm = _GDIPlus_ColorMatrixCreateNegative()
				$tEff = _GDIPlus_EffectCreateColorMatrix($tCm)
				_GDIPlus_BitmapApplyEffect($hBmp, $tEff)
				_GDIPlus_EffectDispose($tEff)

				$tCm = _GDIPlus_ColorMatrixCreateScale(1-$rgb[0], 1-$rgb[1], 1-$rgb[2])
				_GDIPlus_ColorMatrixScale($tCm, 2, 2, 2)
				$tEff = _GDIPlus_EffectCreateColorMatrix($tCm)
				_GDIPlus_BitmapApplyEffect($hBmp, $tEff)
				_GDIPlus_EffectDispose($tEff)

				$tCm = _GDIPlus_ColorMatrixCreateNegative()
				$tEff = _GDIPlus_EffectCreateColorMatrix($tCm)
				_GDIPlus_BitmapApplyEffect($hBmp, $tEff)
				_GDIPlus_EffectDispose($tEff)
			EndIf
		Case $V4_BM_HARDMIX
			$tEff = _GDIPlus_EffectCreateColorMatrix($tCm)
			_GDIPlus_BitmapApplyEffect($hBmp, $tEff)
			_GDIPlus_EffectDispose($tEff)

			Local $aLUT[256][4]
			For $i = 0 To 255
				$aLUT[$i][0] = $i
				For $j = 1 To 3
					$aLUT[$i][$j] = Int($i/255)*255
				Next
			Next

			$tEff = _GDIPlus_EffectCreateColorLUT($aLUT)
			_GDIPlus_BitmapApplyEffect($hBmp, $tEff)
			_GDIPlus_EffectDispose($tEff)
		Case Else
			$tEff = _GDIPlus_EffectCreateColorMatrix($tCm)
			_GDIPlus_BitmapApplyEffect($hBmp, $tEff)
			_GDIPlus_EffectDispose($tEff)
	EndSwitch
EndFunc

Func _Blend_Event()
	If Not $isOpen Then Return 0
	$iMode = $V4_BM_NORMAL

	Switch @GUI_CtrlId
		Case $cidBlendAdd
			$iMode = $V4_BM_ADD
		Case $cidBlendSub
			$iMode = $V4_BM_SUBTRACT
		Case $cidBlendMul
			$iMode = $V4_BM_MULTIPLY
		Case $cidBlendDiv
			$iMode = $V4_BM_DIVIDE
		Case $cidBlendLinearBurn
			$iMode = $V4_BM_LINEARBURN
		Case $cidBlendScreen
			$iMode = $V4_BM_SCREEN
		Case $cidBlendLinearLight
			$iMode = $V4_BM_LINEARLIGHT
		Case $cidBlendHardMix
			$iMode = $V4_BM_HARDMIX
		Case $cidBlendHardLight
			$iMode = $V4_BM_HARDLIGHT
	EndSwitch

	_Blend($oCurrentThread.thread.currentLayer.bmp, $iForeground, $iMode)

	$oCurrentThread.historyAdd()
	_RenderDrawingArea()
EndFunc
