#include-once

#include "Interference\Interference.au3"

Global $aExperimentalFunctions[1] = [0]

$farr = _FileListToArray(@ScriptDir&"\Data\Experimental", "*")

If Not @error Then
	For $i = 1 To $farr[0]
		_ArrayAdd($aExperimentalFunctions, _CreateExperimentalFunc($farr[$i]))
		$aExperimentalFunctions[0] += 1
	Next
EndIf

For $i = 1 To $aExperimentalFunctions[0]
	If Number(($aExperimentalFunctions[$i]).enabled) = 1 Then Call(($aExperimentalFunctions[$i]).startup, $aExperimentalFunctions[$i])
Next

Func _CreateExperimentalFunc($sId)
	$obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "id", $ELSCOPE_PUBLIC, $sId)
	_AutoItObject_AddProperty($obj, "name", $ELSCOPE_PUBLIC, IniRead(@ScriptDir&"\Data\Experimental\"&$sId, "vPaintExperimental", "Name", $sId))
	_AutoItObject_AddProperty($obj, "startup", $ELSCOPE_PUBLIC, IniRead(@ScriptDir&"\Data\Experimental\"&$sId, "vPaintExperimental", "StartupFunc", "_"&$sId&"_Startup"))

	_AutoItObject_AddProperty($obj, "enabled", $ELSCOPE_PUBLIC, RegRead("HKLM\SOFTWARE\vPaint\"&$APPVERSION&"\Experimental\"&$sId, ""))

	Return $obj
EndFunc

Func _IsExperimentEnabled($sId)
	For $i = 1 To $aExperimentalFunctions[0]
		If ($aExperimentalFunctions[$i]).id = $sId Then Return Number(($aExperimentalFunctions[$i]).enabled)
	Next
EndFunc

Func _ExperimentalNIY($oExperiment)
	_MsgBox("Not implemented yet", "This function ("&$oExperiment.id&") is not implemented yet.")
EndFunc
