#include-once
#include "Interference_Events.au3"

Global $__g_hInterferenceDll = 0

; Return States
Global Enum $IF_SUCCESS = 0, _
			$IF_ERROR

; Blend Modes
Global Enum $IF_NORMAL = 0, _
			$IF_DARKEN, _
			$IF_MULTIPLY, _
			$IF_COLORBURN, _
			$IF_LINEARBURN, _
			$IF_LIGHTEN, _
			$IF_SCREEN, _
			$IF_COLORDODGE, _
			$IF_LINEARDODGE, _
			$IF_OVERLAY, _
			$IF_SOFTLIGHT, _
			$IF_VIVIDLIGHT, _
			$IF_LINEARLIGHT, _
			$IF_PINLIGHT, _
			$IF_HARDMIX, _
			$IF_DIFFERENCE, _
			$IF_EXCLUSION, _
			$IF_SUBTRACT, _
			$IF_DIVIDE

; Anaglyph Modes
Global Enum $IF_NONE = 0, _
			$IF_REDCYAN, _
			$IF_REDBLUE, _
			$IF_ORANGESKYBLUE

; Halftone Diffusion Modes
Global Enum $IF_NODIFFUSION = 0

; Grayscale Mode
Global const $IF_MEAN = 1

; Convolution3x3
Global Const $tagIFConvolution3x3 = "float mx[9];float scale;float bias;"

Func _Interference_Startup($oExperiment)
   $__g_hInterferenceDll = DllOpen(@ScriptDir&"\Data\Libraries\Interference.dll")

   Return True
EndFunc

Func _Interference_Shutdown()
   DllClose($__g_hInterferenceDll)
EndFunc

Func _Interference_Test($hBmp)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBData, "Scan0")

	Local $vRet = DllCall($__g_hInterferenceDll, "int:cdecl", "IFTest", "ptr", $iScan0, "int", $iW, "int", $iH)[0]

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

	Return $vRet
EndFunc

Func _Interference_BlendColor($hBmp, $iColor, $iBlendMode)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBData, "Scan0")

	Local $vRet = DllCall($__g_hInterferenceDll, "int:cdecl", "IFBlendColor", "ptr", $iScan0, "int", $iColor, "int", $iW, "int", $iH, "int", $iBlendMode)[0]

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

	Return $vRet
EndFunc

Func _Interference_Blend($hBmp1, $hBmp2, $iBlendMode, $fBmp2Opacity = 1, $iRouteFlags = 0x00010203)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp1)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp1)
	Local $tBData1 = _GDIPlus_BitmapLockBits($hBmp1, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0_1 = DllStructGetData($tBData1, "Scan0")
	Local $tBData2 = _GDIPlus_BitmapLockBits($hBmp2, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0_2 = DllStructGetData($tBData2, "Scan0")

	Local $vRet = DllCall($__g_hInterferenceDll, "int:cdecl", "IFBlend", "ptr", $iScan0_1, "ptr", $iScan0_2, "int", $iW, "int", $iH, "int", $iBlendMode, "float", $fBmp2Opacity, "int", $iRouteFlags)[0]

	_GDIPlus_BitmapUnlockBits($hBmp1, $tBData1)
	_GDIPlus_BitmapUnlockBits($hBmp2, $tBData2)

	Return $vRet
EndFunc

Func _Interference_ReplaceColor($hBmp, $iSearch, $iReplace)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBData, "Scan0")

	Local $vRet = DllCall($__g_hInterferenceDll, "int:cdecl", "IFReplace", "ptr", $iScan0, "int", $iW, "int", $iH, "int", $iSearch, "int", $iReplace)[0]

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

	Return $vRet
EndFunc

Func _Interference_ApplyMask($hBmp, $hMask)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData1 = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0_1 = DllStructGetData($tBData1, "Scan0")
	Local $tBData2 = _GDIPlus_BitmapLockBits($hMask, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0_2 = DllStructGetData($tBData2, "Scan0")

	Local $vRet = DllCall($__g_hInterferenceDll, "int:cdecl", "IFMask", "ptr", $iScan0_1, "ptr", $iScan0_2, "int", $iW, "int", $iH)[0]

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData1)
	_GDIPlus_BitmapUnlockBits($hMask, $tBData2)

	Return $vRet
EndFunc

Func _Interference_Premultiply($hBmp)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBData, "Scan0")

	Local $vRet = DllCall($__g_hInterferenceDll, "int:cdecl", "IFPremultiply", "ptr", $iScan0, "int", $iW, "int", $iH)[0]

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

	Return $vRet
EndFunc

Func _Interference_Unpremultiply($hBmp)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBData, "Scan0")

	Local $vRet = DllCall($__g_hInterferenceDll, "int:cdecl", "IFUnPremultiply", "ptr", $iScan0, "int", $iW, "int", $iH)[0]

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

	Return $vRet
EndFunc

Func _Interference_GenerateXOR($hBmp)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBData, "Scan0")

	Local $vRet = DllCall($__g_hInterferenceDll, "int:cdecl", "IFGenerateXOR", "ptr", $iScan0, "int", $iW, "int", $iH)[0]

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

	Return $vRet
EndFunc

Func _Interference_GenerateSTriangle($hBmp)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBData, "Scan0")

	Local $vRet = DllCall($__g_hInterferenceDll, "int:cdecl", "IFGenerateSTriangle", "ptr", $iScan0, "int", $iW, "int", $iH)[0]

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

	Return $vRet
EndFunc

Func _Interference_Anaglyph($hBmp1, $hBmp2, $iAnaglyphMode)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp1)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp1)
	Local $tBData1 = _GDIPlus_BitmapLockBits($hBmp1, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0_1 = DllStructGetData($tBData1, "Scan0")
	Local $tBData2 = _GDIPlus_BitmapLockBits($hBmp2, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0_2 = DllStructGetData($tBData2, "Scan0")

	Local $vRet = DllCall($__g_hInterferenceDll, "int:cdecl", "IFAnaglyph", "ptr", $iScan0_1, "ptr", $iScan0_2, "int", $iW, "int", $iH, "int", $iAnaglyphMode)
	ConsoleWrite(@error)
	$vRet = $vRet[0]

	_GDIPlus_BitmapUnlockBits($hBmp1, $tBData1)
	_GDIPlus_BitmapUnlockBits($hBmp2, $tBData2)

	Return $vRet
EndFunc

Func _Interference_Posterize($hBmp, $iColors)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBData, "Scan0")

	Local $vRet = DllCall($__g_hInterferenceDll, "int:cdecl", "IFPosterize", "ptr", $iScan0, "int", $iW, "int", $iH, "int", $iColors-1)[0]

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

	Return $vRet
EndFunc

Func _Interference_Halftone($hBmp, $fThreshold, $iHalftoneMode)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBData, "Scan0")

	Local $vRet = DllCall($__g_hInterferenceDll, "int:cdecl", "IFHalftone", "ptr", $iScan0, "int", $iW, "int", $iH, "float", $fThreshold, "int", $iHalftoneMode)[0]

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

	Return $vRet
EndFunc

Func _Interference_Grayscale($hBmp, $iGrayscaleMode)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBData, "Scan0")

	Local $vRet = DllCall($__g_hInterferenceDll, "int:cdecl", "IFGrayscale", "ptr", $iScan0, "int", $iW, "int", $iH, "int", $iGrayscaleMode)[0]

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

	Return $vRet
EndFunc

Func _Interference_GenerateGrayscaleNoise($hBmp)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBData, "Scan0")

	Local $vRet = DllCall($__g_hInterferenceDll, "int:cdecl", "IFGrayscaleNoise", "ptr", $iScan0, "int", $iW, "int", $iH)[0]

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

	Return $vRet
EndFunc

Func _Interference_GenerateColorNoise($hBmp)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBData, "Scan0")

	Local $vRet = DllCall($__g_hInterferenceDll, "int:cdecl", "IFColorNoise", "ptr", $iScan0, "int", $iW, "int", $iH)[0]

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

	Return $vRet
EndFunc

Func _Interference_ConvertToPolar($hBmp)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBData, "Scan0")

	Local $aCall = DllCall($__g_hInterferenceDll, "int:cdecl", "IFConvertToPolar", "ptr", $iScan0, "int", $iW, "int", $iH, "ptr", 0)
	DllStructSetData($tBData, "Scan0", $aCall[4])

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

	Return $aCall[0]
EndFunc

Func _Interference_CreateConvolution3x3($ul = 0, $u = 0, $ur = 0, $l = 0, $c = 1, $r = 0, $bl = 0, $b = 0, $br = 0, $sc = 1, $bias = 0)
	Local $tCm = DllStructCreate($tagIFConvolution3x3)

	DllStructSetData($tCm, "mx", $ul, 1)
	DllStructSetData($tCm, "mx", $u, 1)
	DllStructSetData($tCm, "mx", $ur, 1)
	DllStructSetData($tCm, "mx", $l, 1)
	DllStructSetData($tCm, "mx", $c, 1)
	DllStructSetData($tCm, "mx", $r, 1)
	DllStructSetData($tCm, "mx", $bl, 1)
	DllStructSetData($tCm, "mx", $b, 1)
	DllStructSetData($tCm, "mx", $br, 1)

	DllStructSetData($tCm, "scale", $sc)
	DllStructSetData($tCm, "bias", $bias)

	Return $tCm
EndFunc

Func _Interference_Convolve3x3($hBmp, $ul = 0, $u = 0, $ur = 0, $l = 0, $c = 1, $r = 0, $bl = 0, $b = 0, $br = 0, $sc = 1, $bias = 0)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBData, "Scan0")

	Local $aCall = DllCall($__g_hInterferenceDll, "int:cdecl", "_Z13IFConvolve3x3Piiifffffffffif", "ptr", $iScan0, "int", $iW, "int", $iH, "float", $ul, "float", $u, "float", $ur, "float", $l, "float", $c, "float", $r, "float", $bl, "float", $b, "float", $br, "int", $sc, "float", $bias)

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

	Return $aCall[0]
EndFunc

Func _Interference_Convolve($hBmp, $pMatrix, $mW = 3, $mH = 3, $sc = 1, $bias = 0)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBData, "Scan0")

	Local $aCall = DllCall($__g_hInterferenceDll, "int:cdecl", "IFConvolve", "ptr", $iScan0, "int", $iW, "int", $iH, "ptr", $pMatrix, "int", $mW, "int", $mH, "int", $sc, "float", $bias)

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

	Return $aCall[0]
EndFunc
;IFHistogramStretch

Func _Interference_HistogramStretch($hBmp)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBData, "Scan0")

	Local $aCall = DllCall($__g_hInterferenceDll, "int:cdecl", "IFHistogramStretch", "ptr", $iScan0, "int", $iW, "int", $iH)

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

	Return $aCall[0]
EndFunc

Func _Interference_Contrast($hBmp, $fPower = 1)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBData, "Scan0")

	Local $aCall = DllCall($__g_hInterferenceDll, "int:cdecl", "IFContrast", "ptr", $iScan0, "int", $iW, "int", $iH, "double", $fPower)

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

	Return $aCall[0]
EndFunc

Func _Interference_ChromaticAberration($hBmp, $iPower = 10, $fFalloff = 1)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBData, "Scan0")

	Local $aCall = DllCall($__g_hInterferenceDll, "int:cdecl", "IFChromaticAberration", "ptr", $iScan0, "int", $iW, "int", $iH, "int", $iPower, "float", $fFalloff)

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

	Return $aCall[0]
EndFunc

Func _Interference_Maximum($hBmp, $iRadius = 3)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBData, "Scan0")

	Local $aCall = DllCall($__g_hInterferenceDll, "int:cdecl", "IFMaximum", "ptr", $iScan0, "int", $iW, "int", $iH, "int", $iRadius)

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

	Return $aCall[0]
EndFunc

Func _Interference_Minimum($hBmp, $iRadius = 3)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBData, "Scan0")

	Local $aCall = DllCall($__g_hInterferenceDll, "int:cdecl", "IFMinimum", "ptr", $iScan0, "int", $iW, "int", $iH, "int", $iRadius)

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

	Return $aCall[0]
EndFunc

Func _Interference_ApplyShader($hBmp, $hCallback)
	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBData, "Scan0")

	Local $pCallback = DllCallbackGetPtr($hCallback)

	Local $aCall = DllCall($__g_hInterferenceDll, "int:cdecl", "IFProcessShader", "ptr", $iScan0, "int", $iW, "int", $iH, "ptr", $pCallback)

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

	Return $aCall[0]
EndFunc

Func _Interference_ApplyColorCube($hBmp, $aColors)
	Local $tCube = DllStructCreate("int data[8]")

	For $i = 0 To 7
		$tCube.data($i)
	Next

	Local $iW = _GDIPlus_ImageGetWidth($hBmp)
	Local $iH = _GDIPlus_ImageGetHeight($hBmp)
	Local $tBData = _GDIPlus_BitmapLockBits($hBmp, 0, 0, $iW, $iH, BitOR($GDIP_ILMWRITE, $GDIP_ILMREAD), $GDIP_PXF32ARGB)
	Local $iScan0 = DllStructGetData($tBData, "Scan0")

	Local $aCall = DllCall($__g_hInterferenceDll, "int:cdecl", "IFApplyColorCube", "ptr", $iScan0, "int", $iW, "int", $iH, "ptr", DllStructGetPtr($tCube))

	_GDIPlus_BitmapUnlockBits($hBmp, $tBData)

	Return $aCall[0]
EndFunc
