#include-once

Func _Angle($x1, $y1, $x2, $y2)
	$x = $x2-$x1
	$y = $y2-$y1
	$d = Sqrt($x^2+$y^2)
	$ang = ASin($y/$d)
	If $x < 0 And $y > 0 Then
		$ang = _Radian(90)+(_Radian(90)-Abs($ang))
	ElseIf $x < 0 And $y < 0 Then
		$ang = _Radian(-180)+Abs($ang)
	ElseIf $x < 0 And $y = 0 Then
		$ang = _Radian(180)
	EndIf
	Return $ang
EndFunc

Func _DrawRotatedFX($hGpx, $hImg, $iDrawX, $iDrawY, $iOriginX = 0, $iOriginY = 0, $iAngle = 0, $fScale = 1, $hEff = 0)
	$iW = _GDIPlus_ImageGetWidth($hImg)*$fScale
	$iH = _GDIPlus_ImageGetHeight($hImg)*$fScale

	$X1 = -$iW/2-$iOriginX
	$Y1 = -$iH/2-$iOriginY
	$X2 = $iW/2-$iOriginX
	$Y2 = -$iH/2-$iOriginY
	$X3 = -$iW/2-$iOriginX
	$Y3 = $iH/2-$iOriginY

	_RotatePoint($X1, $Y1, $iAngle)
	_RotatePoint($X2, $Y2, $iAngle)
	_RotatePoint($X3, $Y3, $iAngle)

	$X1 += $iDrawX
	$Y1 += $iDrawY
	$X2 += $iDrawX
	$Y2 += $iDrawY
	$X3 += $iDrawX
	$Y3 += $iDrawY

	$tImg = _GDIPlus_BitmapCreateApplyEffect($hImg, $hEff)
	_GDIPlus_DrawImagePoints($hGpx, $tImg, $X1, $Y1, $X2, $Y2, $X3, $Y3)
	_GDIPlus_BitmapDispose($tImg)
EndFunc

Func _DrawRotated($hGpx, $hImg, $iDrawX, $iDrawY, $iOriginX = 0, $iOriginY = 0, $iAngle = 0, $fScale = 1)
	$iW = _GDIPlus_ImageGetWidth($hImg)*$fScale
	$iH = _GDIPlus_ImageGetHeight($hImg)*$fScale

	$X1 = -$iW/2-$iOriginX
	$Y1 = -$iH/2-$iOriginY
	$X2 = $iW/2-$iOriginX
	$Y2 = -$iH/2-$iOriginY
	$X3 = -$iW/2-$iOriginX
	$Y3 = $iH/2-$iOriginY

	_RotatePoint($X1, $Y1, $iAngle)
	_RotatePoint($X2, $Y2, $iAngle)
	_RotatePoint($X3, $Y3, $iAngle)

	$X1 += $iDrawX
	$Y1 += $iDrawY
	$X2 += $iDrawX
	$Y2 += $iDrawY
	$X3 += $iDrawX
	$Y3 += $iDrawY

	_GDIPlus_DrawImagePoints($hGpx, $hImg, $X1, $Y1, $X2, $Y2, $X3, $Y3)
EndFunc

Func _RotatePoint(ByRef $iX, ByRef $iY, $iAngle = 0)
	$d = Sqrt($iX^2+$iY^2)
	$ang = _Angle(0, 0, $iX, $iY)
	$ang += _Radian($iAngle)

	$iX = $d * Cos($ang)
	$iY = $d * Sin($ang)
EndFunc
