#include-once

Func _POV_CreateBoxObject($oCoord1, $oCoord2, $oTex = 0)
	Local $obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "coord1", $ELSCOPE_PUBLIC, $oCoord1)
	_AutoItObject_AddProperty($obj, "coord2", $ELSCOPE_PUBLIC, $oCoord2)
	_AutoItObject_AddProperty($obj, "tex", $ELSCOPE_PUBLIC, $oTex)

	_AutoItObject_AddMethod($obj, "Clone", "_POV_CloneBoxObject")
	_AutoItObject_AddMethod($obj, "GenCode", "_POV_GenerateBoxObjectCode")

	Return $obj
EndFunc

Func _POV_CloneBoxObject($oSelf)
	Local $oTex = 0

	If IsObj($oSelf.tex) Then $oTex = $oSelf.tex.Clone()

	Return _POV_CreateBoxObject($oSelf.coord1.Clone(), $oSelf.clone2.Clone(), $oTex)
EndFunc

Func _POV_GenerateBoxObjectCode($oSelf)
	Local $sCode

	$sCode = "box {"&@CRLF

	$sCode &= "<"&$oSelf.coord1.v1&", "&$oSelf.coord1.v2&", "&$oSelf.coord1.v3&">"&@CRLF
	$sCode &= "<"&$oSelf.coord2.v1&", "&$oSelf.coord2.v2&", "&$oSelf.coord2.v3&">"&@CRLF

	If IsObj($oSelf.tex) Then $sCode &= $oSelf.tex.GenCode()

	$sCode &= "}"&@CRLF

	Return $sCode
EndFunc

Func _POV_CreateConeObject($oCoord1, $oCoord2, $fRadius1, $fRadius2 = 0, $oTex = 0)
	Local $obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "coord1", $ELSCOPE_PUBLIC, $oCoord1)
	_AutoItObject_AddProperty($obj, "coord2", $ELSCOPE_PUBLIC, $oCoord2)
	_AutoItObject_AddProperty($obj, "radius1", $ELSCOPE_PUBLIC, $fRadius1)
	_AutoItObject_AddProperty($obj, "radius2", $ELSCOPE_PUBLIC, $fRadius2)
	_AutoItObject_AddProperty($obj, "tex", $ELSCOPE_PUBLIC, $oTex)

	_AutoItObject_AddMethod($obj, "Clone", "_POV_CloneConeObject")
	_AutoItObject_AddMethod($obj, "GenCode", "_POV_GenerateConeObjectCode")

	Return $obj
EndFunc

Func _POV_CloneConeObject($oSelf)
	Local $oTex = 0

	If IsObj($oSelf.tex) Then $oTex = $oSelf.tex.Clone()

	Return _POV_CreateBoxObject($oSelf.coord1.Clone(), $oSelf.clone2.Clone(), $oSelf.radius1, $oSelf.radius2, $oTex)
EndFunc

Func _POV_GenerateConeObjectCode($oSelf)
	Local $sCode

	$sCode = "cone {"&@CRLF

	$sCode &= "<"&$oSelf.coord1.v1&", "&$oSelf.coord1.v2&", "&$oSelf.coord1.v3&">"&@CRLF
	$sCode &= $oSelf.radius1&@CRLF
	$sCode &= "<"&$oSelf.coord2.v1&", "&$oSelf.coord2.v2&", "&$oSelf.coord2.v3&">"&@CRLF
	$sCode &= $oSelf.radius2&@CRLF

	If IsObj($oSelf.tex) Then $sCode &= $oSelf.tex.GenCode()

	$sCode &= "}"&@CRLF

	Return $sCode
EndFunc
