#include-once

Func _POV_CreateSolidPigment($oColor)
	Local $obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "color", $ELSCOPE_PUBLIC, $oColor)

	_AutoItObject_AddMethod($obj, "Clone", "_POV_CloneSolidPigment")
	_AutoItObject_AddMethod($obj, "GenCode", "_POV_GenerateSolidPigmentCode")

	Return $obj
EndFunc

Func _POV_CloneSolidPigment($oSelf)
	Return _POV_CreateSolidPigment($oSelf.color.Clone())
EndFunc

Func _POV_GenerateSolidPigmentCode($oSelf)
	Local $sCode

	$sCode = "pigment {"&@CRLF

	$sCode &= "color <"
	$sCode &= $oSelf.color.v1&", "&$oSelf.color.v2&", "&$oSelf.color.v3
	$sCode &= ">"&@CRLF

	$sCode &= "}"&@CRLF

	Return $sCode
EndFunc
