#include-once

Func _POV_CreateTexture($oPigment, $oFinish = LinkedList(), $fIOR = 1)
	Local $obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "pigment", $ELSCOPE_PUBLIC, $oPigment)
	_AutoItObject_AddProperty($obj, "finish", $ELSCOPE_PUBLIC, $oFinish)
	_AutoItObject_AddProperty($obj, "ior", $ELSCOPE_PUBLIC, $fIOR)

	_AutoItObject_AddMethod($obj, "Clone", "_POV_CloneTexture")
	_AutoItObject_AddMethod($obj, "GenCode", "_POV_GenerateTextureCode")

	Return $obj
EndFunc

Func _POV_CloneTexture($oSelf)
	Local $oFinish = LinkedList()

	For $i = 1 To $oSelf.finish.count
		$oFinish.add(($oSelf.finish.at($i-1)).Clone())
	Next

	Return _POV_CreateTexture($oSelf.pigment.Clone(), $oFinish, $oSelf.ior)
EndFunc

Func _POV_GenerateTextureCode($oSelf)
	Local $sCode

	$sCode = "texture {"&@CRLF

	$sCode &= $oSelf.pigment.GenCode()

	If $oSelf.finish.count > 0 Then
		$sCode &= "finish {"&@CRLF

		For $oFinish In $oSelf.finish
			$sCode &= $oFinish.GenCode()&@CRLF
		Next

		$sCode &= "}"&@CRLF
	EndIf

	If $oSelf.ior <> 1 Then
		$sCode &= "interior { ior "&$oSelf.ior&" }"&@CRLF
	EndIf

	$sCode &= "}"&@CRLF

	Return $sCode
EndFunc
