#include-once

#Region Constants

Global Enum $V4_LIBRARY_AUTODETECT = 0, _
			$V4_LIBRARY_GDIPLUS, _
			$V4_LIBRARY_DIRECT2D

Global Enum $V4_FACTORYTYPE_SINGLETHREAD = 0, _
			$V4_FACTORYTYPE_MULTITHREAD

#EndRegion

#Region Settings

;~ V4SETTING_GRAPHICLIBRARY
;~ Sets graphic library used to draw and render images.
;~ If it's set to $V4_LIBRARY_AUTODETECT, then vPaint will
;~ check, if we can use Direct2D. If not, GDI+ will be used.
;~ Even if D2D is available, some tools and filters may still
;~ use GDI+.
Global $v4Setting_GraphicLibraryBase = $V4_LIBRARY_AUTODETECT
Global $v4Setting_GraphicLibrary = $v4Setting_GraphicLibraryBase

;~ V4SETTING_D2D_FACTORYTYPE
;~ (Direct2D only)
;~ Sets how many threads should Direct2D use. Multi-threaded mode
;~ will increase performance on multi-core configurations.
Global $v4Setting_D2D_FactoryType = $V4_FACTORYTYPE_MULTITHREAD

#cs
	REMARK #14: Segoe UI?! What is that? [scintilla4evr]

	A small history lesson:
	Version		| Branding Font			| UI Font
	------------------------------------------------------------
	1.x			| Segoe UI				| Segoe UI
	2-3.x		| Helvetica Neue		| Segoe UI
	3.9.0-4		| Roboto				| Segoe UI
	3.9.5		| Roboto				| Your choice (default:
				|						|			Open Sans)

	Since version 3.9.5, vPaint uses Open Sans as its UI font.

#ce
;~ V4SETTING_UI_FONTFAMILY
;~ Font used in the user interface.
Global $v4Setting_UI_FontFamily = "Open Sans"

#EndRegion

; Quick function for accesing localized strings
Func _Loc($XPath)
	_AXml_XPathNode($hLanguageXML, $sLanguageZone&$XPath)
	Return _AXml_GetText($hLanguageXML)
EndFunc
