#include-once
#include "Settings.au3"

Global $APPVERSION = "4.0 (Alpha #3)", $APPBRANCH = "development"
Global $APPVERSION_FULLSTRING = "4.0-3.9.12"
Global $APPNAME = "vPaint"
Global $APPSUBNAME = ""

Global $isEasterEgg = _IsPressed("11", $DLL_USER32)

_AutoItObject_Startup(True, @ScriptDir&"\Data\Libraries\AutoItObject.dll")
_GDIPlus_Startup(@ScriptDir&"\Data\Libraries\gdiplus.dll")
ConsoleWrite($__hDLL__FX__)

#cs
	REMARK #5: Oh, Direct2D... [scintilla4evr]

	vPaint is using GDI+ to manipulate images and everyone
	knows that. But GDI+ is too slow because it using CPU to
	process data. But other apps also like the taste of CPU.
	So let's move some image operations to GPU. But, with
	GDI+ it's next to impossible. We have to use another
	library. OpenGL - not many functions to easily manipulate
	images. Direct3D - vPaint is not a game. Then we have
	Direct2D. Looks like a perfect choice - fast, hardware
	accelerated, multi-threaded, interoperable with GDI and
	GDI+.

#ce
If $v4Setting_GraphicLibrary = $V4_LIBRARY_AUTODETECT Then
	Global $oD2DFactory = _D2D1_CreateFactoryObject($v4Setting_D2D_FactoryType)
	$oDWFactory = _DWrite_CreateFactoryObject()
	Global $oWICFactory = _WIC_CreateImagingFactoryObject()

	$v4Setting_GraphicLibrary = $V4_LIBRARY_DIRECT2D
	If Not IsObj($oD2DFactory) Or Not IsObj($oDWFactory) Or Not IsObj($oWICFactory) Then
		$v4Setting_GraphicLibrary = $V4_LIBRARY_GDIPLUS
	EndIf
ElseIf $v4Setting_GraphicLibrary = $V4_LIBRARY_DIRECT2D Then
	Global $oD2DFactory = _D2D1_CreateFactoryObject($v4Setting_D2D_FactoryType)
EndIf

Global $v4Setting_GraphicLibrary = $V4_LIBRARY_GDIPLUS

Global $aImgCtrls[1] = [0], $isClosing = 0
Global $aThreads[1] = [0], $iCurrentThread = 0
Global $oCurrentThread = 0, $isOpen = 0
Global $sCurrentFile = 0
Global $hTransparency
Global $aLastXY[2]
Global $iCurrentEvent = $V4_ST_IDLE
Global $aTabs[1] = [0]

Global $isWorkingOnHistory = 0

Global $TEMPORARYDIR = @ScriptDir&"\Data\Temp"
DirCreate($TEMPORARYDIR)

#cs
	REMARK #6: Hello, World! [scintilla4evr]

	After a year since the release of 3.8, we finally have
	version 4.0!

#ce
Global $TITLEBAR = "vPaint 4"
If $v4Setting_GraphicLibrary = $V4_LIBRARY_DIRECT2D Then $TITLEBAR &= " (Direct2D)"

Global $aTools = [_CreateTool("_Tool_Move"), _CreateTool("_Tool_Select"), _CreateTool("_Tool_Brush", 1), _CreateTool("_Tool_Eyedropper", 1), _CreateTool("_Tool_Gradient"), _CreateTool("_Tool_Crop"), _CreateTool("_Tool_Path"), _CreateTool("_Tool_Eraser")]
Global $iCurrentTool = 2
Global $oCurrentTool = $aTools[$iCurrentTool]
Global $isShowingToolUI = 0, $hCurrentToolUI
Global $cidSelectedTool

Global $iSelectCombineMode = 0, $iSelectToolMode = 0
Global $iTransformToolMode = 0
Global $iBrushWidth = 16, $iBrushToolMode = 0
Global $iBrushScatter = 0, $iBrushRandomizeAlpha = 0
Global $iEraserWidth = 16, $iEraserMode = 0
Global $iFillMode = 0
Global $aGradientPoints[3][2] = [[2, 0], [0xFF000000, 0], [0, 1]]

Global $sNotificationHeader = ""
Global $sNotificationContent = ""
Global $iNotificationType = $V4_NT_INFORMATION

Global $hOverlayUI = 0

Global $iSnapToGrid = 0

Global $iForeground = 0xFF000000, $iBackground = 0xFFFFFFFF

Global $iCurrentViewMode = 0
Global $iViewportRenderEnabled = 0

Global $oBlankNodeList = LinkedList()

#cs
	REMARK #13: Lucky Thirteen Times 96 DPI

	What is the common attribute of new iMac and, for example
	Surface Pro 3? High-DPI display. DPI values even larger than
	192 DPI. Guess how does vPaint look on displays like this?
	So, this little piece of code will calculate the scale factor
	for vPaint's user interface. It will. Believe me.

#ce
Global $iSystemDPI = 96
Global $iUIScaleFactor = _Max(Int($iSystemDPI/96), 1)
ConsoleWrite($iUIScaleFactor)

Global $hViewportShadow = _GDIPlus_ImageLoadFromFile(@ScriptDir&"\Data\AppUI\ViewportShadow.png")
Global $hTransparency = _Util_CreateTransparencyGrid()

Global $hLayerImageList =  _GUIImageList_Create(32, 32, 5)

Global $iLayerIcon_Visible = _GUIImageList_AddIcon($hLayerImageList, @ScriptDir&"\Data\AppUI\visible.ico", 0, 1)
Global $iLayerIcon_Hidden = _GUIImageList_AddIcon($hLayerImageList, @ScriptDir&"\Data\AppUI\hidden.ico", 0, 1)

Global $iLayerIcon_NoLock = _GUIImageList_AddIcon($hLayerImageList, @ScriptDir&"\Data\AppUI\nolock.ico", 0, 1)
Global $iLayerIcon_LockPos = _GUIImageList_AddIcon($hLayerImageList, @ScriptDir&"\Data\AppUI\lock_pos.ico", 0, 1)
Global $iLayerIcon_LockColor = _GUIImageList_AddIcon($hLayerImageList, @ScriptDir&"\Data\AppUI\lock_color.ico", 0, 1)
Global $iLayerIcon_LockAll = _GUIImageList_AddIcon($hLayerImageList, @ScriptDir&"\Data\AppUI\lock_all.ico", 0, 1)

Global $iLayerIcon_3DObject = _GUIImageList_AddIcon($hLayerImageList, @ScriptDir&"\Data\AppUI\3dobject.ico", 0, 1)

Global $hModeComboImageList = _GUIImageList_Create(24, 24, 5)

Global $aFontFiles = _FileListToArray(@ScriptDir&"\Data\Fonts", "*", $FLTA_FILES, True)

Global $aAsyncJobs[0]

Global $hLanguageXML = _AXml_LoadFile(@ScriptDir&"\Data\Locale\English.xml", 1)
Global $sLanguageZone = ""

#cs
	REMARK #IDONTCOUNTANYMORE: Shhhh!

	For a short time, vPaint was integrated with POV-Ray to render
	3D scenes. But, because of file saving problems, I postponed
	this feature until the official release of vPaint 4. Then,
	I'll consider bringing it back.

#ce
; _CreateAsync(_Pov_CheckIsAllRendered, _Pov_RefreshLayers) Shhhh!


For $i = 1 To $aFontFiles[0]
	ConsoleWrite($aFontFiles[$i]&@CRLF)
	_WinAPI_AddFontResourceEx($aFontFiles[$i], $FR_PRIVATE)
Next

Func _LoadToHBMP($sFile)
	$tBmp = _GDIPlus_ImageLoadFromFile($sFile)
	$tHBMP = _GDIPlus_BitmapCreateHBITMAPFromBitmap($tBmp)
	_GDIPlus_BitmapDispose($tBmp)

	Return $tHBMP
EndFunc

Func _GetIconPath($sCat, $sName, $sColor = "black", $sSize = "mdpi", $iDpi = 24)
	Return @ScriptDir&"\Icons\"&$sCat&"\drawable-"&$sSize&"\ic_"&$sName&"_"&$sColor&"_"&$iDpi&"dp.png"
EndFunc

Func _Exit()
	$isClosing = 1
	GUIDelete($hMainUI)

	For $i = 1 To $aThreads[0]
		$obj = $aThreads[$i]
		$obj.dispose()
	Next

	_GUIImageList_Destroy($hLayerImageList)
	_GUIImageList_Destroy($hModeComboImageList)

	_Interference_Shutdown()

	_API_Unregister()

	_GDIPlus_BitmapDispose($hTransparency)
	_GDIPlus_ImageDispose($hViewportShadow)

	_GDIPlus_Shutdown()
	_AutoItObject_Shutdown()

	DirRemove($TEMPORARYDIR, 1) ; delete temporary dir

	For $i = 1 To $aFontFiles[0]
		_WinAPI_RemoveFontResourceEx($aFontFiles[$i])
	Next

	Exit
EndFunc
