#include-once

Func _ColorPicker($sColor = "", $iStartColor = 0)
	$iOpt = Opt("GUIOnEventMode", 0)

	Local $aHSL1 = _ColorConvertRGBtoHSL(_ColorGetRGB($iStartColor))
	Local $aHSL = [$aHSL1[0], 240, 120]

	Local $iColor = $iStartColor, $bPressed = False

	$hColorPickerUI = GUICreate("Color Picker" & (($sColor <> "") ? (": "&$sColor) : ""), 480, 356, -1, -1, -1, -1, $hMainUI)
	GUISetBkColor(0xF0F0F0)

	GUICtrlCreateLabel("", 10*$iUIScaleFactor, 40*$iUIScaleFactor, 460*$iUIScaleFactor, 306*$iUIScaleFactor)
	GUICtrlSetBkColor(-1, 0xE0E0E0)
	GUICtrlSetState(-1, $GUI_DISABLE)

	$iNextMenuBtnX = 10*$iUIScaleFactor
	$cidTab1 = _Tiles_CreateButton("Picker", $iNextMenuBtnX, 10*$iUIScaleFactor, Default, 30*$iUIScaleFactor, 0xFFE0E0E0, 0xFFD0D0D0, 0xFF444444, $v4Setting_UI_FontFamily, 11*$iUIScaleFactor, 30*$iUIScaleFactor)
	$iNextMenuBtnX += @extended

	$cidTab2 = _Tiles_CreateButton("Swatches", $iNextMenuBtnX, 10*$iUIScaleFactor, Default, 30*$iUIScaleFactor, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF444444, $v4Setting_UI_FontFamily, 11*$iUIScaleFactor, 30*$iUIScaleFactor)
	$iNextMenuBtnX += @extended

	$cidTabCtrl = GUICtrlCreateTab(-100, -100)
	$cidTab1_c = GUICtrlCreateTabItem("picker")

	$cidColorSquare = GUICtrlCreateLabel("", 20, 50, 256, 256, $SS_BITMAP)
	GUICtrlSetBkColor(-1, 0)

	$cidHueSlider = GUICtrlCreateSlider(20, 306, 256, 30)
	GUICtrlSetLimit(-1, 240, 0)
	GUICtrlSetBkColor(-1, 0xF0F0F0)

	$cidCurrentColor = GUICtrlCreateLabel("", 290, 50, 70, 30, $WS_BORDER)
	GUICtrlSetBkColor(-1, $iColor)

	$cidLastColor = GUICtrlCreateLabel("", 359, 50, 70, 30, $WS_BORDER)
	GUICtrlSetBkColor(-1, $iStartColor)

	; RGB
	GUICtrlCreateLabel("Red:", 290, 92, 60, 20)
	GUICtrlSetFont(-1, 11, -1, -1, "Segoe UI")
	$cidR = GUICtrlCreateInput((_ColorGetRGB($iColor))[0], 350, 90, 80, 25)
	GUICtrlSetFont(-1, 11, -1, -1, "Segoe UI")

	GUICtrlCreateLabel("Green:", 290, 132, 60, 20)
	GUICtrlSetFont(-1, 11, -1, -1, "Segoe UI")
	$cidG = GUICtrlCreateInput((_ColorGetRGB($iColor))[1], 350, 130, 80, 25)
	GUICtrlSetFont(-1, 11, -1, -1, "Segoe UI")

	GUICtrlCreateLabel("Blue:", 290, 172, 60, 20)
	GUICtrlSetFont(-1, 11, -1, -1, "Segoe UI")
	$cidB = GUICtrlCreateInput((_ColorGetRGB($iColor))[2], 350, 170, 80, 25)
	GUICtrlSetFont(-1, 11, -1, -1, "Segoe UI")

	; XYZ
	GUICtrlCreateLabel("X:", 290, 222, 60, 20)
	GUICtrlSetFont(-1, 11, -1, -1, "Segoe UI")
	$cidX = GUICtrlCreateInput(Int((_ColorConvertRGBToXYZ(_ColorGetRGB($iColor)))[0]), 350, 220, 80, 25)
	GUICtrlSetFont(-1, 11, -1, -1, "Segoe UI")

	GUICtrlCreateLabel("Y:", 290, 262, 60, 20)
	GUICtrlSetFont(-1, 11, -1, -1, "Segoe UI")
	$cidY = GUICtrlCreateInput(Int((_ColorConvertRGBToXYZ(_ColorGetRGB($iColor)))[1]), 350, 260, 80, 25)
	GUICtrlSetFont(-1, 11, -1, -1, "Segoe UI")

	GUICtrlCreateLabel("Z:", 290, 302, 60, 20)
	GUICtrlSetFont(-1, 11, -1, -1, "Segoe UI")
	$cidZ = GUICtrlCreateInput(Int((_ColorConvertRGBToXYZ(_ColorGetRGB($iColor)))[2]), 350, 300, 80, 25)
	GUICtrlSetFont(-1, 11, -1, -1, "Segoe UI")

	$cidTab2_c = GUICtrlCreateTabItem("swatches")

	GUISetState()

	$oScene = _MoGraph_SceneCreate()

	$aRGB = _ColorConvertHSLtoRGB($aHSL)

	$hBrush = _MoGraph_LineBrushCreate(0, 0, 256, 0, 255, 255, 255, 255, $aRGB[0], $aRGB[1], $aRGB[2])
	$oRect1 = _MoGraph_ShapeCreateRectangle(0, 0, 256, 256, $hBrush)
	_MoGraph_SceneAddObject($oScene, $oRect1)

	$oRect2 = _MoGraph_ShapeCreateRectangle(0, 0, 256, 256, _MoGraph_LineBrushCreate(0, 0, 0, 256, 0, 0, 0, 0, 0, 0, 0, 255))
	_MoGraph_SceneAddObject($oScene, $oRect2)

	$oSettings = _MoGraph_GUIControlRendererCreateSettings($cidColorSquare)
	$oRenderer = _MoGraph_GUIControlRendererCreate($oScene, $oSettings)
	_MoGraph_RendererRenderFrame($oRenderer)

	While 1
		$cInfo = GUIGetCursorInfo($hColorPickerUI)
		If _IsPressed(1) And IsArray($cInfo) And $cInfo[4] = $cidColorSquare Then
			If Not $bPressed Then
				$aPos = WinGetPos(GUICtrlGetHandle($cidColorSquare))
				_MouseTrap($aPos[0], $aPos[1], $aPos[0]+256, $aPos[1]+256)
				$bPressed = True
			EndIf

			$iColor = PixelGetColor(MouseGetPos(0), MouseGetPos(1))
			GUICtrlSetBkColor($cidCurrentColor, $iColor)

			GUICtrlSetData($cidR, (_ColorGetRGB($iColor))[0])
			GUICtrlSetData($cidG, (_ColorGetRGB($iColor))[1])
			GUICtrlSetData($cidB, (_ColorGetRGB($iColor))[2])

			GUICtrlSetData($cidX, Int((_ColorConvertRGBToXYZ(_ColorGetRGB($iColor)))[0]))
			GUICtrlSetData($cidY, Int((_ColorConvertRGBToXYZ(_ColorGetRGB($iColor)))[1]))
			GUICtrlSetData($cidZ, Int((_ColorConvertRGBToXYZ(_ColorGetRGB($iColor)))[2]))
		ElseIf $bPressed Then
			_MouseTrap()
			$bPressed = False
		EndIf

		If GUICtrlRead($cidHueSlider) <> $aHSL[0] Then
			$aHSL[0] = GUICtrlRead($cidHueSlider)
			$aRGB = _ColorConvertHSLtoRGB($aHSL)
			$hBrush.red2.value = $aRGB[0]
			$hBrush.green2.value = $aRGB[1]
			$hBrush.blue2.value = $aRGB[2]
			_MoGraph_RendererRenderFrame($oRenderer)
		EndIf

		Switch GUIGetMsg()
			Case -3
				ExitLoop
			Case $cidR, $cidG, $cidB
				$aRGB = _ColorGetRGB($iColor)
				$aRGB[0] = GUICtrlRead($cidR)
				$aRGB[1] = GUICtrlRead($cidG)
				$aRGB[2] = GUICtrlRead($cidB)
				$iColor = _ColorSetRGB($aRGB)
				GUICtrlSetBkColor($cidCurrentColor, $iColor)

				$aHSL = _ColorConvertRGBtoHSL($aRGB)
				$aHSL[1] = 240
				$aHSL[2] = 120
				GUICtrlSetData($cidHueSlider, $aHSL[0])

				$aRGB = _ColorConvertHSLtoRGB($aHSL)
				$hBrush.red2.value = $aRGB[0]
				$hBrush.green2.value = $aRGB[1]
				$hBrush.blue2.value = $aRGB[2]
				_MoGraph_RendererRenderFrame($oRenderer)
			Case $cidX, $cidY, $cidZ
				$aRGB = _ColorGetRGB($iColor)
				$aXYZ = _ColorConvertRGBToXYZ($aRGB)
				$aXYZ[0] = GUICtrlRead($cidX)
				$aXYZ[1] = GUICtrlRead($cidY)
				$aXYZ[2] = GUICtrlRead($cidZ)
				$aRGB = _ColorConvertXYZToRGB($aXYZ)
				$iColor = _ColorSetRGB($aRGB)
				GUICtrlSetBkColor($cidCurrentColor, $iColor)

				$aHSL = _ColorConvertRGBtoHSL($aRGB)
				$aHSL[1] = 240
				$aHSL[2] = 120
				GUICtrlSetData($cidHueSlider, $aHSL[0])

				$aRGB = _ColorConvertHSLtoRGB($aHSL)
				$hBrush.red2.value = $aRGB[0]
				$hBrush.green2.value = $aRGB[1]
				$hBrush.blue2.value = $aRGB[2]
				_MoGraph_RendererRenderFrame($oRenderer)
		EndSwitch
	WEnd

	GUIDelete($hColorPickerUI)

	Opt("GUIOnEventMode", $iOpt)

	Return $iColor
EndFunc

Func _SetAlpha($iARGB, $iAlpha)
	Return BitOR(BitAND($iARGB, 0xFFFFFF), BitShift($iAlpha, -24))
EndFunc

Func _GetARGBParts($iARGB)
	Local $arr[4]

	$arr[0] = BitOR(BitShift($iARGB, 24), 0xFF)
	$arr[1] = BitOR(BitShift($iARGB, 16), 0xFF)
	$arr[2] = BitOR(BitShift($iARGB, 8), 0xFF)
	$arr[3] = BitOR($iARGB, 0xFF)

	Return $arr
EndFunc

Func _GetARGB($arr)
	Return BitOR(BitShift($arr[0], -24), BitShift($arr[1], -16), BitShift($arr[2], -8), $arr[3])
EndFunc

Func _GetCOLORREF($iRGB)
	Return _ColorSetCOLORREF(_ColorGetRGB($iRGB))
EndFunc

Func _TemperatureToRGB($iTemp)
	Local $red, $green, $blue
	Local $arr[4] = [255, 0, 0, 0]
	$iTemp /= 100

	If $iTemp <= 66 Then
		$red = 255
	Else
		$red = $iTemp - 60
		$red = 329.698727446 * ($red ^ -0.1332047592)
		If $red < 0 Then $red = 0
		If $red > 255 Then $red = 255
	EndIf

	If $iTemp <= 66 Then
		$green = $iTemp
		$green = 99.4708025861 * Log($green) - 161.1195681661
		If $green < 0 Then $green = 0
		If $green > 255 Then $green = 255
	Else
		$green = $iTemp - 60
		$green = 288.1221695283 * ($green ^ -0.0755148492)
		If $green < 0 Then $green = 0
		If $green > 255 Then $green = 255
	EndIf

	If $iTemp >= 66 Then
		$blue = 255
	Else
		If $iTemp <= 19 Then
			$blue = 0
		Else
			$blue = $iTemp - 10
			$blue = 138.5177312231 * Log($blue) - 305.0447927307
			If $blue < 0 Then $blue = 0
			If $blue > 255 Then $blue = 255
		EndIf
	EndIf

	$arr[1] = $red
	$arr[2] = $green
	$arr[3] = $blue

	Return _GetARGB($arr)
EndFunc
