#include-once

Global Enum $COMP_TYPE_BLUR = 0x300, _
			$COMP_TYPE_GLITCH

#cs
	NODE DEFINITION
	GAUSSIAN BLUR
	Blurs the image using GDI+ Gaussian filter.

	INPUTS:
	Image [GDI+ Bitmap]
	Radius [Numeric, optional]

	OUTPUTS:
	Image [GDI+ Bitmap]

#ce
Func _CompAdd_GaussianBlur($iX = 0, $iY = 0, $oTMgm = $oCurrentThread)
	Local $oNode = _Node_CreateNode("Gaussian Blur", "_CompProc_GaussianBlur", $COMP_TYPE_BLUR, $iX, $iY)
	$oNode.input.add(_Node_CreateIOItem("Image", $NODE_VTYPE_BITMAP, 0, 0))
	$oNode.input.add(_Node_CreateIOItem("Radius", $NODE_VTYPE_NUMBER, 0, 0))
	$oNode.output.add(_Node_CreateIOItem("Image", $NODE_VTYPE_BITMAP, 0, 0))
	$oNode.calcSize()

	$oTMgm.compList.add($oNode)

	Return $oNode
EndFunc

Func _CompProc_GaussianBlur($oSelf, $iWantedOutput, $aInputs)
	If $aInputs[1] = -1234 Then $aInputs[1] = 10

	$hEffect = _GDIPlus_EffectCreateBlur($aInputs[1])
	_GDIPlus_BitmapApplyEffect($aInputs[0], $hEffect)
	_GDIPlus_EffectDispose($hEffect)

	Return $aInputs[0]
EndFunc

#cs
	NODE DEFINITION
	GLITCH
	Applies the glitch effect.

	INPUTS:
	Image [GDI+ Bitmap]
	Radius [Numeric, optional]

	OUTPUTS:
	Image [GDI+ Bitmap]

#ce
Func _CompAdd_Glitch($iX = 0, $iY = 0, $oTMgm = $oCurrentThread)
	Local $oNode = _Node_CreateNode("Glitch", "_CompProc_Glitch", $COMP_TYPE_GLITCH, $iX, $iY)
	$oNode.input.add(_Node_CreateIOItem("Image", $NODE_VTYPE_BITMAP, 0, 0))
	$oNode.input.add(_Node_CreateIOItem("Step", $NODE_VTYPE_NUMBER, 0, 0))
	$oNode.input.add(_Node_CreateIOItem("Amount", $NODE_VTYPE_NUMBER, 0, 0))
	$oNode.output.add(_Node_CreateIOItem("Image", $NODE_VTYPE_BITMAP, 0, 0))
	$oNode.calcSize()

	$oTMgm.compList.add($oNode)

	Return $oNode
EndFunc

Func _CompProc_Glitch($oSelf, $iWantedOutput, $aInputs)
	If $aInputs[1] = -1234 Then $aInputs[1] = 10
	If $aInputs[2] = -1234 Then $aInputs[2] = 10

	_Glitch($aInputs[1], $aInputs[2], $aInputs[0])

	Return $aInputs[0]
EndFunc

#cs
	NODE DEFINITION
	RIPPLE
	Applies the ripple effect.

	INPUTS:
	Image [GDI+ Bitmap]
	Size [Numeric, optional]
	Bias [Numeric, optional]
	Step [Numeric, optional]

	OUTPUTS:
	Image [GDI+ Bitmap]

#ce
Func _CompAdd_Ripple($iX = 0, $iY = 0, $oTMgm = $oCurrentThread)
	Local $oNode = _Node_CreateNode("Ripple", "_CompProc_Ripple", $COMP_TYPE_GLITCH, $iX, $iY)
	$oNode.input.add(_Node_CreateIOItem("Image", $NODE_VTYPE_BITMAP, 0, 0))
	$oNode.input.add(_Node_CreateIOItem("Size", $NODE_VTYPE_NUMBER, 0, 0))
	$oNode.input.add(_Node_CreateIOItem("Bias", $NODE_VTYPE_NUMBER, 0, 0))
	$oNode.input.add(_Node_CreateIOItem("Step", $NODE_VTYPE_NUMBER, 0, 0))
	$oNode.output.add(_Node_CreateIOItem("Image", $NODE_VTYPE_BITMAP, 0, 0))
	$oNode.calcSize()

	$oTMgm.compList.add($oNode)

	Return $oNode
EndFunc

Func _CompProc_Ripple($oSelf, $iWantedOutput, $aInputs)
	If $aInputs[1] = -1234 Then $aInputs[1] = 10
	If $aInputs[2] = -1234 Then $aInputs[2] = 0
	If $aInputs[3] = -1234 Then $aInputs[3] = 1

	_Ripple($aInputs[1], $aInputs[2], $aInputs[3], $aInputs[0])

	Return $aInputs[0]
EndFunc

#cs
	NODE DEFINITION
	INTERLACE
	Applies the interlace effect.

	INPUTS:
	Image [GDI+ Bitmap]
	Height [Numeric, optional]

	OUTPUTS:
	Image [GDI+ Bitmap]

#ce
Func _CompAdd_Interlace($iX = 0, $iY = 0, $oTMgm = $oCurrentThread)
	Local $oNode = _Node_CreateNode("Interlace", "_CompProc_Interlace", $COMP_TYPE_GLITCH, $iX, $iY)
	$oNode.input.add(_Node_CreateIOItem("Image", $NODE_VTYPE_BITMAP, 0, 0))
	$oNode.input.add(_Node_CreateIOItem("Height", $NODE_VTYPE_NUMBER, 0, 0))
	$oNode.output.add(_Node_CreateIOItem("Image", $NODE_VTYPE_BITMAP, 0, 0))
	$oNode.calcSize()

	$oTMgm.compList.add($oNode)

	Return $oNode
EndFunc

Func _CompProc_Interlace($oSelf, $iWantedOutput, $aInputs)
	If $aInputs[1] = -1234 Then $aInputs[1] = 2

	_Interlace($aInputs[1], $aInputs[0])

	Return $aInputs[0]
EndFunc
