#include-once

Func _Tool_Crop_Start($oSelf, $iX, $iY)
	$oSelf.lastX = $iX
	$oSelf.lastY = $iY
EndFunc

Func _Tool_Crop_Draw($oSelf, $iX, $iY)
EndFunc

Func _Tool_Crop_End($oSelf, $iX, $iY)
	$x = _Min($iX, $oSelf.lastX)
	$y = _Min($iY, $oSelf.lastY)

	$w = Abs($iX-$oSelf.lastX)
	$h = Abs($iY-$oSelf.lastY)

	For $layer In $oCurrentThread.thread.layers
		$tBmp = _GDIPlus_BitmapCreateFromScan0($w, $h)
		$tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)

		_GDIPlus_GraphicsDrawImageRectRect($tGpx, $layer.bmp, $x, $y, $w, $h, 0, 0, $w, $h)

		_GDIPlus_GraphicsDispose($tGpx)
		_GDIPlus_BitmapDispose($layer.bmp)
		$layer.bmp = $tBmp

		$layer.width = $w
		$layer.height = $h
	Next

	For $sel In $oCurrentThread.thread.selections
		_GDIPlus_RegionTranslate($sel.rgn, -$x, -$y)
	Next

	For $path In $oCurrentThread.thread.paths
		For $point In $path.points
			$point.baseX -= $x
			$point.baseY -= $y
			$point.arm1X -= $x
			$point.arm1Y -= $y
			$point.arm2X -= $x
			$point.arm2Y -= $y
		Next
	Next

	$oCurrentThread.thread.width = $w
	$oCurrentThread.thread.height = $h

	$oCurrentThread.viewDx = 0
	$oCurrentThread.viewDy = 0
EndFunc

Func _Tool_Crop_DrawHUD($oSelf, $hGpx, $iX, $iY)
	$tPen = _GDIPlus_PenCreate(0xAAFFFFFF, 3)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX-10, $iY, $iX-4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX+10, $iY, $iX+4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY-10, $iX, $iY-4, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY+10, $iX, $iY+4, $tPen)
	_GDIPlus_PenDispose($tPen)

	$tPen = _GDIPlus_PenCreate(0xAA000000)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX-10, $iY, $iX-4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX+10, $iY, $iX+4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY-10, $iX, $iY-4, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY+10, $iX, $iY+4, $tPen)
	_GDIPlus_PenDispose($tPen)
EndFunc

Func _Tool_Crop_CanBypassLock($oSelf, $iLockMode)
	Switch $iLockMode
		Case $V4_LL_NONE
			Return 1
		Case Else
			Return 0
	EndSwitch
EndFunc

Func _Tool_Crop_ShowUI($oSelf)
	Return 0
EndFunc
