#include-once

Func _Tool_Select_Start($oSelf, $iX, $iY)
	$oSelf.lastX = $iX
	$oSelf.lastY = $iY
	$oSelf.extra1 = _GDIPlus_RegionClone($oCurrentThread.thread.selection)
	$oSelf.extra2 = _GDIPlus_RegionClone($oCurrentThread.thread.selection)

	$oSelf.extra3 = 0
	$tHRGN = _GDIPlus_RegionGetHRgn($oCurrentThread.thread.selection)
	$tRect = _WinAPI_CreateRect($iX-1, $iY-1, $iX+1, $iY+1)
	If _WinAPI_RectInRegion($tHRGN, $tRect) And $iSelectCombineMode = 0 Then $oSelf.extra3 = 1
	_WinAPI_DeleteObject($tHRGN)

	$oSelf.extra4 = _GDIPlus_PathCreate()
EndFunc

Func _Tool_Select_Draw($oSelf, $iX, $iY)
	If $oSelf.extra3 = 1 Then
		_GDIPlus_RegionTranslate($oCurrentThread.thread.selection, $iX-$oSelf.lastX, $iY-$oSelf.lastY)

		$oSelf.lastX = $iX
		$oSelf.lastY = $iY
	Else
		_GDIPlus_RegionDispose($oSelf.extra2)
		$oSelf.extra2 = _GDIPlus_RegionClone($oSelf.extra1)

		Switch $iSelectToolMode
			Case 0
				$tRgn = _GDIPlus_RegionCreateFromRect(_Min($oSelf.lastX, $iX), _Min($oSelf.lastY, $iY), Abs($iX-$oSelf.lastX), Abs($iY-$oSelf.lastY))
			Case 1
				_GDIPlus_PathAddLine($oSelf.extra4, $iX, $iY, $iX, $iY)
				$tRgn = _GDIPlus_RegionCreateFromPath($oSelf.extra4)
		EndSwitch
		If $iSelectToolMode <> 2 Then
			_GDIPlus_RegionCombineRegion($oSelf.extra2, $tRgn, $iSelectCombineMode)
			_GDIPlus_RegionDispose($tRgn)
		EndIf

		_Util_SetNewSelection(_GDIPlus_RegionClone($oSelf.extra2))
	EndIf
EndFunc

Func _Tool_Select_End($oSelf, $iX, $iY)
	If (Abs($iX-$oSelf.lastX) = 0 Or Abs($iY-$oSelf.lastY) = 0) And $oSelf.extra3 = 0 Then
		If $iSelectToolMode = 2 Then
			$tRgn = _Util_StartMagicWand($oCurrentThread.thread.currentLayer.bmp, $iX, $iY)
			_GDIPlus_RegionCombineRegion($tRgn, $oSelf.extra1, $iSelectCombineMode)
			_Util_SetNewSelection($tRgn)
		Else
			_Util_SetNewSelection(_GDIPlus_RegionCreate())
		EndIf
	ElseIf $oSelf.extra3 = 0 Then
		Switch $iSelectToolMode
			Case 0
				$tRgn = _GDIPlus_RegionCreateFromRect(_Min($oSelf.lastX, $iX), _Min($oSelf.lastY, $iY), Abs($iX-$oSelf.lastX), Abs($iY-$oSelf.lastY))
			Case 1
				$tRgn = _GDIPlus_RegionCreateFromPath($oSelf.extra4)
			Case 2
				$tRgn = _Util_StartMagicWand($oCurrentThread.thread.currentLayer.bmp, $iX, $iY)
		EndSwitch
		_GDIPlus_RegionCombineRegion($oSelf.extra1, $tRgn, $iSelectCombineMode)
		_GDIPlus_RegionDispose($tRgn)
		_GDIPlus_RegionDispose($oSelf.extra1)
		_GDIPlus_RegionDispose($oSelf.extra2)
		_GDIPlus_PathDispose($oSelf.extra4)
	EndIf
EndFunc

Func _Tool_Select_DrawHUD($oSelf, $hGpx, $iX, $iY)
	$tPen = _GDIPlus_PenCreate(0xAAFFFFFF, 3)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX-10, $iY, $iX-4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX+10, $iY, $iX+4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY-10, $iX, $iY-4, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY+10, $iX, $iY+4, $tPen)
	_GDIPlus_PenDispose($tPen)

	$tPen = _GDIPlus_PenCreate(0xAA000000)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX-10, $iY, $iX-4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX+10, $iY, $iX+4, $iY, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY-10, $iX, $iY-4, $tPen)
	_GDIPlus_GraphicsDrawLine($hGpx, $iX, $iY+10, $iX, $iY+4, $tPen)
	_GDIPlus_PenDispose($tPen)
EndFunc

Func _Tool_Select_ShowUI($oSelf)
	$hSelectUI = GUICreate("", 400, 40, 0, 30*$iUIScaleFactor, $WS_CHILD+$WS_VISIBLE, -1, $hMainUI)

	Global $cidSelect_ShapeMode0 = _Tiles_CreateButton('"', 0, 0, 40, 40, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF111111, "vPaint UI Glyphs", 24)
	GUICtrlSetOnEvent(-1, "_Tool_Select_SetShape")
	GUICtrlSetTip(-1, "Rectangular")

	Global $cidSelect_ShapeMode1 = _Tiles_CreateButton('3', 40, 0, 40, 40, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF111111, "vPaint UI Glyphs", 24)
	GUICtrlSetOnEvent(-1, "_Tool_Select_SetShape")
	GUICtrlSetTip(-1, "Lasso")

	Global $cidSelect_ShapeMode2 = _Tiles_CreateButton('P', 80, 0, 40, 40, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF111111, "vPaint UI Glyphs", 24)
	GUICtrlSetOnEvent(-1, "_Tool_Select_SetShape")
	GUICtrlSetTip(-1, "Magic Wand")

	Global $cidSelect_CombineMode0 = _Tiles_CreateButton("4", 140, 0, 40, 40, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF111111, "vPaint UI Glyphs", 24)
	GUICtrlSetOnEvent(-1, "_Tool_Select_SetMode")
	GUICtrlSetTip(-1, "Replace")

	Global $cidSelect_CombineMode1 = _Tiles_CreateButton("8", 180, 0, 40, 40, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF111111, "vPaint UI Glyphs", 24)
	GUICtrlSetOnEvent(-1, "_Tool_Select_SetMode")
	GUICtrlSetTip(-1, "Intersect")

	Global $cidSelect_CombineMode2 = _Tiles_CreateButton("6", 220, 0, 40, 40, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF111111, "vPaint UI Glyphs", 24)
	GUICtrlSetOnEvent(-1, "_Tool_Select_SetMode")
	GUICtrlSetTip(-1, "Union")

	Global $cidSelect_CombineMode3 = _Tiles_CreateButton("7", 260, 0, 40, 40, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF111111, "vPaint UI Glyphs", 24)
	GUICtrlSetOnEvent(-1, "_Tool_Select_SetMode")
	GUICtrlSetTip(-1, "XOR (Difference)")

	Global $cidSelect_CombineMode4 = _Tiles_CreateButton("5", 300, 0, 40, 40, 0xFFF0F0F0, 0xFFE0E0E0, 0xFF111111, "vPaint UI Glyphs", 24)
	GUICtrlSetOnEvent(-1, "_Tool_Select_SetMode")
	GUICtrlSetTip(-1, "Subtract")

	GUISwitch($hMainUI)

	_Tiles_ButtonSetBkColor(Eval("cidSelect_ShapeMode"&$iSelectToolMode), 0xFFF0F0F0, 0xFFE0E0E0)
	_Tiles_ButtonSetTextColor(Eval("cidSelect_ShapeMode"&$iSelectToolMode), 0xFF111111)

	_Tiles_ButtonSetBkColor(Eval("cidSelect_CombineMode"&$iSelectCombineMode), 0xFFE0E0E0, 0xFFD0D0D0)
	_Tiles_ButtonSetTextColor(Eval("cidSelect_CombineMode"&$iSelectCombineMode), 0xFF000000)

	Return $hSelectUI
EndFunc

Func _Tool_Select_SetShape()
	_Tiles_ButtonSetBkColor(Eval("cidSelect_ShapeMode"&$iSelectToolMode), 0xFFF0F0F0, 0xFFE0E0E0)
	_Tiles_ButtonSetTextColor(Eval("cidSelect_ShapeMode"&$iSelectToolMode), 0xFF111111)

	Switch @GUI_CtrlId
		Case $cidSelect_ShapeMode0
			$iSelectToolMode = 0
		Case $cidSelect_ShapeMode1
			$iSelectToolMode = 1
		Case $cidSelect_ShapeMode2
			$iSelectToolMode = 2
	EndSwitch

	_Tiles_ButtonSetBkColor(Eval("cidSelect_ShapeMode"&$iSelectToolMode), 0xFFE0E0E0, 0xFFD0D0D0)
	_Tiles_ButtonSetTextColor(Eval("cidSelect_ShapeMode"&$iSelectToolMode), 0xFF000000)
EndFunc

Func _Tool_Select_SetMode()
	_Tiles_ButtonSetBkColor(Eval("cidSelect_CombineMode"&$iSelectCombineMode), 0xFFF0F0F0, 0xFFE0E0E0)
	_Tiles_ButtonSetTextColor(Eval("cidSelect_CombineMode"&$iSelectCombineMode), 0xFF111111)

	Switch @GUI_CtrlId
		Case $cidSelect_CombineMode0
			$iSelectCombineMode = 0
		Case $cidSelect_CombineMode1
			$iSelectCombineMode = 1
		Case $cidSelect_CombineMode2
			$iSelectCombineMode = 2
		Case $cidSelect_CombineMode3
			$iSelectCombineMode = 3
		Case $cidSelect_CombineMode4
			$iSelectCombineMode = 4
	EndSwitch

	_Tiles_ButtonSetBkColor(Eval("cidSelect_CombineMode"&$iSelectCombineMode), 0xFFE0E0E0, 0xFFD0D0D0)
	_Tiles_ButtonSetTextColor(Eval("cidSelect_CombineMode"&$iSelectCombineMode), 0xFF000000)
EndFunc

Func _Tool_Select_CanBypassLock($oSelf, $iLockMode)
	Return 1
EndFunc
