#include-once

; Barney's Must-Use Effect Compositions
#include "Barney\Barney.au3"

; Blend
#include "Blend\Blend.au3"

; Blur
#include "Blur\Blur.au3"

; Color
#include "ChromaKey\ChromaKey.au3"

; Convolve
#include "Convolve\Convolve.au3"

; Distort
#include "Glitch\Glitch.au3"
#include "Ripple\Ripple.au3"
#include "Whirl\Whirl.au3"
#include "Wind\Wind.au3"

; Stylize
#include "Interlace\Interlace.au3"
#include "Pixelize\Pixelize.au3"
#include "Tiles\Tiles.au3"

; Anaglyph
#include "Anaglyph\Anaglyph.au3"

; UEZ's BitmapApplyFilter effects
#include "UEZ.au3"

#cs
	REMARK #3: Everyting At Once [scintilla4evr]

	Before version 3.9.5 (Source Release #4) we had 3 different
	filters for distorting the image. But, as they were using
	the same parameters, I merged them in the main UI.

#ce
Func _Distort_Event()
	If Not $isOpen Then Return 0

	$iOpt = Opt("GUIOnEventMode", 0)

	$hDistortUI = GUICreate("Distort", 314, 211, -1, -1, -1, -1, $hMainUI)

	GUICtrlCreateLabel("Type", 8, 8, 36, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidType = GUICtrlCreateCombo("", 8, 32, 297, 25, BitOR($CBS_DROPDOWNLIST,$CBS_AUTOHSCROLL))
	GUICtrlSetData(-1, "Glitch|Ripple|Wind", "Glitch")
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")

	GUICtrlCreateLabel("Amount:", 8, 80, 60, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidAmount = GUICtrlCreateSlider(8, 104, 297, 33)
	GUICtrlSetLimit(-1, 50, 1)
	GUICtrlSetData(-1, 10)

	$cidCancel = GUICtrlCreateButton("Cancel", 216, 168, 89, 33)
	$cidOK = GUICtrlCreateButton("OK", 120, 168, 89, 33)

	$cidAddAsLayer = GUICtrlCreateCheckbox("Add as layer", 8, 168, 100, 33)

	GUISetState()

	While 1
		Switch GUIGetMsg()
			Case -3, $cidCancel
				ExitLoop
			Case $cidOK
				$hBmp = $oCurrentThread.thread.currentLayer.bmp

				Switch GUICtrlRead($cidType)
					Case "Glitch"
						_Glitch(10, GUICtrlRead($cidAmount), $hBmp)
					Case "Ripple"
						_Ripple(GUICtrlRead($cidAmount), 0, 1, $hBmp)
					Case "Wind"
						_Wind(GUICtrlRead($cidAmount))
				EndSwitch

				$oCurrentThread.thread.currentLayer.bmp = $hBmp

				$oCurrentThread.historyAdd()
				ExitLoop
		EndSwitch
	WEnd

	GUIDelete($hDistortUI)
	GUISwitch($hMainUI)

	_RenderDrawingArea()

	Opt("GUIOnEventMode", $iOpt)
EndFunc
