#include-once

Func _Interlace($iStep, ByRef $hBmp)
	$tBmp = _GDIPlus_BitmapCreateFromScan0($oCurrentThread.thread.currentLayer.width, $oCurrentThread.thread.currentLayer.height)
	$tGpx = _GDIPlus_ImageGetGraphicsContext($tBmp)

	_ProgressOn("Applying effect...", "Row 0 of "&Int($oCurrentThread.thread.currentLayer.height/($iStep*2)))

	For $y = 0 To $oCurrentThread.thread.currentLayer.height Step $iStep*2
		_GDIPlus_GraphicsDrawImageRectRect($tGpx, $hBmp, 0, $y, $oCurrentThread.thread.currentLayer.width, $iStep, 0, $y, $oCurrentThread.thread.currentLayer.width, $iStep)

		_ProgressSet("Applying effect...", "Row "&Int($y/$iStep+1)&" of "&Int($oCurrentThread.thread.currentLayer.height/$iStep), 100*Int($y/$iStep+1)/Int($oCurrentThread.thread.currentLayer.height/$iStep))
	Next

	_ProgressOff()

	_GDIPlus_GraphicsDispose($tGpx)
	_GDIPlus_BitmapDispose($hBmp)
	$hBmp = $tBmp
EndFunc

Func _Interlace_Event()
	If Not $isOpen Then Return 0

	$iOpt = Opt("GUIOnEventMode", 0)

	$hInterlaceUI = GUICreate("Interlace", 314, 154, -1, -1, -1, -1, $hMainUI)

	GUICtrlCreateLabel("Row height:", 8, 8, 82, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidHeight = GUICtrlCreateSlider(8, 32, 297, 33)
	GUICtrlSetLimit(-1, 40, 1)
	GUICtrlSetData(-1, 3)

	$cidCancel = GUICtrlCreateButton("Cancel", 216, 112, 89, 33)
	$cidOK = GUICtrlCreateButton("OK", 120, 112, 89, 33)

	GUISetState()

	While 1
		Switch GUIGetMsg()
			Case -3, $cidCancel
				ExitLoop
			Case $cidOK
				$hBmp = $oCurrentThread.thread.currentLayer.bmp
				_Interlace(GUICtrlRead($cidHeight), $hBmp)
				$oCurrentThread.thread.currentLayer.bmp = $hBmp

				$oCurrentThread.historyAdd()
				ExitLoop
		EndSwitch
	WEnd

	GUIDelete($hInterlaceUI)
	GUISwitch($hMainUI)

	_RenderDrawingArea()

	Opt("GUIOnEventMode", $iOpt)
EndFunc
