#include-once

#cs

	FILE SUPPORT UDF
	Adobe .CUBE files

	Based on the Cube LUT Specification Version 1.0

	Adobe, and IRIDAS, are either registered trademarks
	or trademarks of Adobe Systems Incorporated in the
	United States and/or other countries. All other
	trademarks are the property of their respective
	owners.

#ce

Func _CUBE_Get3DSize($sFile)
	Local $i

	For $i = 1 To _FileCountLines($sFile)
		$sLine = StringStripWS(FileReadLine($sFile, $i), 7)

		If StringRegExp($sLine, "LUT_3D_SIZE ([0-9]+)") Then
			$aRegexp = StringRegExp($sLine, "LUT_3D_SIZE ([0-9]+)", 1)
			Return Int($aRegexp[0])
		EndIf
	Next

	Return 0
EndFunc

Func _CUBE_GetTitle($sFile)
	Local $i

	For $i = 1 To _FileCountLines($sFile)
		$sLine = StringStripWS(FileReadLine($sFile, $i), 7)

		If StringRegExp($sLine, 'TITLE "(.*)"') Then
			$aRegexp = StringRegExp($sLine, 'TITLE "(.*)"', 1)
			Return $aRegexp[0]
		EndIf
	Next

	Return 0
EndFunc

Func _CUBE_Read3DArray($sFile, ByRef $aOut, $iSize)
	Local $x, $y, $z
	Local $i = 0
	Local $sLine

	For $z = 0 To ($iSize-1)
		For $y = 0 To ($iSize-1)
			For $x = 0 To ($iSize-1)
				Local $aColor[3] = [0, 0, 0]

				$i += 1
				$sLine = StringStripWS(FileReadLine($sFile, $i), 7)

				If Not StringRegExp($sLine, "([0-9\.]+) ([0-9\.]+) ([0-9\.]+)") Or StringInStr($sLine, "DOMAIN") Then
					Do
						$i += 1
						$sLine = StringStripWS(FileReadLine($sFile, $i), 7)
					Until StringRegExp($sLine, "([0-9\.]+) ([0-9\.]+) ([0-9\.]+)") And Not StringInStr($sLine, "DOMAIN")
				EndIf

				$aRegexp = StringRegExp($sLine, "([0-9\.]+) ([0-9\.]+) ([0-9\.]+)", 1)

				$aColor[0] = $aRegexp[2]
				$aColor[1] = $aRegexp[1]
				$aColor[2] = $aRegexp[0]

				$aLUT[$x][$y][$z] = $aColor
			Next
		Next
	Next

	Return 0
EndFunc
