#include-once

Func _ShowBorderSelectUI()
	If Not $isOpen Then Return

	$iOpt = Opt("GUIOnEventMode", 0)

	$hBorderSelectUI = GUICreate("Select borders", 298, 137, -1, -1, -1, -1, $hMainUI)

	GUICtrlCreateLabel("Border width (in pixels):", 8, 8, 161, 24)
	GUICtrlSetFont(-1, 11, 400, 0, "Segoe UI")

	$cidInput = GUICtrlCreateInput("10", 8, 40, 281, 29, BitOR($GUI_SS_DEFAULT_INPUT, $ES_NUMBER))
	GUICtrlSetFont(-1, 12, 400, 0, "Segoe UI")

	$cidOK = GUICtrlCreateButton("OK", 104, 96, 89, 33)

	$cidCancel = GUICtrlCreateButton("Cancel", 200, 96, 89, 33)

	GUISetState()

	While 1
		Switch GUIGetMsg()
			Case -3, $cidCancel
				ExitLoop
			Case $cidOK
				_BorderSelect(GUICtrlRead($cidInput))
				ExitLoop
		EndSwitch
	WEnd

	GUIDelete($hBorderSelectUI)
	_RenderDrawingArea(0, 0, 1)

	Opt("GUIOnEventMode", $iOpt)
EndFunc

Func _BorderSelect($iWidth)
	$tPath = _GDIPlus_PathCreate()

	_GDIPlus_PathAddRectangle($tPath, 0, 0, $oCurrentThread.thread.width, $oCurrentThread.thread.height)
	_GDIPlus_PathAddRectangle($tPath, $iWidth, $iWidth, $oCurrentThread.thread.width-$iWidth*2, $oCurrentThread.thread.height-$iWidth*2)

	_GDIPlus_RegionCombinePath($oCurrentThread.thread.selection, $tPath, $iSelectCombineMode)

	_GDIPlus_PathDispose($tPath)

	$oCurrentThread.historyAdd()
EndFunc
