#include-once

Func _CreatePathLayer($iIndex)
	$obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "type", $ELSCOPE_PUBLIC, $V4_LT_PATH)
	_AutoItObject_AddProperty($obj, "name", $ELSCOPE_PUBLIC, ($oCurrentThread.thread.paths.at($iIndex)).name)
	_AutoItObject_AddProperty($obj, "opacity", $ELSCOPE_PUBLIC, 100)
	_AutoItObject_AddProperty($obj, "blendMode", $ELSCOPE_PUBLIC, $IF_NORMAL) ; see Base/Experimental/Interference/Interference.au3 for more

	_AutoItObject_AddProperty($obj, "enableRouting", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "routeFlags", $ELSCOPE_PUBLIC, 0x00010203)

	_AutoItObject_AddProperty($obj, "pathIndex", $ELSCOPE_PUBLIC, $iIndex)
	_AutoItObject_AddProperty($obj, "outlineColor", $ELSCOPE_PUBLIC, $iForeground)
	_AutoItObject_AddProperty($obj, "penWidth", $ELSCOPE_PUBLIC, 4)

	_AutoItObject_AddProperty($obj, "startCap", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "endCap", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "dashCap", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "dashStyle", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "isVisible", $ELSCOPE_PUBLIC, 1)
	_AutoItObject_AddProperty($obj, "lockMode", $ELSCOPE_PUBLIC, $V4_LL_NONE)

	_AutoItObject_AddProperty($obj, "canDraw", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "isSmart", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "ref", $ELSCOPE_PUBLIC, 1)

	_AutoItObject_AddProperty($obj, "x", $ELSCOPE_PUBLIC, 0)
	_AutoItObject_AddProperty($obj, "y", $ELSCOPE_PUBLIC, 0)

	_AutoItObject_AddProperty($obj, "width", $ELSCOPE_PUBLIC, $oCurrentThread.thread.width)
	_AutoItObject_AddProperty($obj, "height", $ELSCOPE_PUBLIC, $oCurrentThread.thread.height)

	_AutoItObject_AddProperty($obj, "bmp", $ELSCOPE_PUBLIC, _GDIPlus_BitmapCreateFromScan0($oCurrentThread.thread.width, $oCurrentThread.thread.height))

	_AutoItObject_AddMethod($obj, "clone", "_PathLayer_Clone")
	_AutoItObject_AddMethod($obj, "render", "_PathLayer_Render")
	_AutoItObject_AddMethod($obj, "dispose", "_PathLayer_Dispose")

	_AutoItObject_AddDestructor($obj, "_PathLayer_Dispose")

	Return $obj
EndFunc

Func _PathLayer_Render($oSelf, $iQuality = 0)
	Local $hBmp, $hGpx, $hPath

	$hBmp = _GDIPlus_BitmapCreateFromScan0($oCurrentThread.thread.width, $oCurrentThread.thread.height)
	$hGpx = _GDIPlus_ImageGetGraphicsContext($hBmp)
	_GDIPlus_GraphicsSetSmoothingMode($hGpx, 5)
	_GDIPlus_GraphicsSetPixelOffsetMode($hGpx, $GDIP_PIXELOFFSETMODE_HIGHQUALITY)

	$hPath = ($oCurrentThread.thread.paths.at($oSelf.pathIndex)).createGdipPath()
	$hPen = _GDIPlus_PenCreate($oSelf.outlineColor, $oSelf.penWidth)
	_GDIPlus_PenSetLineCap($hPen, $oSelf.startCap, $oSelf.endCap, $oSelf.dashCap)
	_GDIPlus_PenSetDashStyle($hPen, $oSelf.dashStyle)
	_GDIPlus_GraphicsDrawPath($hGpx, $hPath, $hPen)
	_GDIPlus_PenDispose($hPen)
	_GDIPlus_PathDispose($hPath)

	_GDIPlus_GraphicsDispose($hGpx)
	_GDIPlus_BitmapDispose($oSelf.bmp)
	$oSelf.bmp = $hBmp
EndFunc

Func _PathLayer_Clone($oSelf)
	$layer = _CreatePathLayer($oSelf.pathIndex)

	$layer.name = $oSelf.name
	$layer.opacity = $oSelf.opacity
	$layer.blendMode = $oSelf.blendMode
	$layer.enableRouting = $oSelf.enableRouting
	$layer.routeFlags = $oSelf.routeFlags
	$layer.isVisible = $oSelf.isVisible
	$layer.lockMode = $oSelf.lockMode
	$layer.canDraw = $oSelf.canDraw
	$layer.isSmart = $oSelf.isSmart
	$layer.outlineColor = $oSelf.outlineColor

	Return $layer
EndFunc

Func _PathLayer_Dispose(ByRef $oSelf)
	$oSelf = 0
EndFunc
