#include-once

Func _POV_CreatePointLight($oPos, $oColor)
	Local $obj = _AutoItObject_Create()

	_AutoItObject_AddProperty($obj, "pos", $ELSCOPE_PUBLIC, $oPos)
	_AutoItObject_AddProperty($obj, "color", $ELSCOPE_PUBLIC, $oColor)

	_AutoItObject_AddMethod($obj, "Clone", "_POV_ClonePointLight")
	_AutoItObject_AddMethod($obj, "GenCode", "_POV_GeneratePointLightCode")

	Return $obj
EndFunc

Func _POV_ClonePointLight($oSelf)
	Return _POV_CreatePerspectiveCamera($oSelf.pos.Clone(), $oSelf.color.Clone())
EndFunc

Func _POV_GeneratePointLightCode($oSelf)
	Local $sCode

	$sCode = "light_source {"&@CRLF

	$sCode &= "<"&$oSelf.pos.v1&", "&$oSelf.pos.v2&", "&$oSelf.pos.v3&">"&@CRLF
	$sCode &= "color rgb <"&$oSelf.color.v1&", "&$oSelf.color.v2&", "&$oSelf.color.v3&">"&@CRLF

	$sCode &= "}"&@CRLF

	Return $sCode
EndFunc
